#ifndef GGAFDXCORE_GGAFDX8DIRECTIONUTIL_H_
#define GGAFDXCORE_GGAFDX8DIRECTIONUTIL_H_
#include "GgafDxCommonHeader.h"

//-1,0,1 33i@  zvf̂ߐ10iɕϊ}N(-4`+4)
#define DIR8(X,Y) ((3*(X)) + (Y))
#define DIR8_NULL (999)


namespace GgafDxCore {

/**
 * [eBeB .
 * @version 1.00
 * @since 2015/09/16
 * @author Masatoshi Tsuge
 */
class GgafDx8DirectionUtil {
private:
    struct FaceVec {
        float vx;
        float vy;
    };

    struct FaceSgn {
        int sgn_x;
        int sgn_y;
    };

    /** ʔԍ(ԍ)ƃxNg̃e[u */
    static const FaceVec _vec[3*3];
    /** ʔԍ(ԍ)Ɗe̐̃e[u */
    static const FaceSgn _sgn[3*3];
    static const angle _angle[3*3];
public:
    static const FaceVec* _dir2vec;

    static const FaceSgn* _dir2sgn;

    static const angle* _dir2angle;

    /** p */
    static bool is_init;

    static void init();

    /**
     * S̕xNgA߂̔ԍ( DIR8(X,Y) )ɕϊ .
     * @param prm_vx xNgXvf
     * @param prm_vy xNgYvf
     * @return ߂̔ԍ( DIR8(X,Y) )Aor DIR8_NULL
     */
    static dir8 cnvVec2DirNo(float prm_vx, float prm_vy);

    /**
     * xNgA߂̂Wɕϊꍇ́AXYZevf̐̕擾 .
     * @param prm_vx xNgXvf
     * @param prm_vy xNgYvf
     * @param out_sgn_x Xvf̐ (-1 or 0 or 1)
     * @param out_sgn_y Yvf̐ (-1 or 0 or 1)
     */
    static void cnvVec2Sgn(float prm_vx, float prm_vy,
                           int& out_sgn_x, int& out_sgn_y);

    /**
     * ԍ( DIR8(X,Y) )AxNgiKς݁j擾 .
     * @param prm_dir_no ԍ( DIR8(X,Y) )
     * @param out_vx xNgXvf
     * @param out_vy xNgYvf
     */
    static void cnvDirNo2Vec(dir8 prm_dir_no, float& out_vx, float& out_vy);

    /**
     * ԍ( DIR8(X,Y) )AXYZevf̐̕擾 .
     * @param prm_dir_no ԍ( DIR8(X,Y) )ADIR_NNN ` DIR_PPP
     * @param out_sgn_x Xvf̐ (-1 or 0 or 1)
     * @param out_sgn_y Yvf̐ (-1 or 0 or 1)
     */
    static void cnvDirNo2Sgn(dir8 prm_dir_no, int& out_sgn_x, int& out_sgn_y);

    /**
     * ԍ( DIR8(X,Y) )ARzRŷQAOl擾 .
     * @param prm_dir_no ԍ( DIR8(X,Y) )
     * @param out_rz
     * @param out_ry
     */
    static angle cnvDirNo2RzRy(dir8 prm_dir_no);

    static dir8 cnvAng2DirNo(angle prm_angle);

    static void cnvAng2Sgn(angle prm_angle, int& out_sgn_x, int& out_sgn_y);
};

}
#endif /*GGAFDXCORE_GGAFDX8DIRECTIONUTIL_H_*/
