#ifndef GGAFDXCORE_GGAFDX26DIRECTIONUTIL_H_
#define GGAFDXCORE_GGAFDX26DIRECTIONUTIL_H_
#include "GgafDxCommonHeader.h"

//-1,0,1 33i@  zvf̂ߐ10iɕϊ}N(-13`+13)
#define DIR26(X,Y,Z) (((3*3)*(X)) + (3*(Y)) + (Z))
#define DIR26_NULL (999)

namespace GgafDxCore {

/**
 * Εʑ̖̂ʁiQUj[eBeB .
 * @version 1.00
 * @since 2014/12/11
 * @author Masatoshi Tsuge
 */
class GgafDx26DirectionUtil {
private:
    struct FaceVec {
        float vx;
        float vy;
        float vz;
    };

    struct FaceSgn {
        int sgn_x;
        int sgn_y;
        int sgn_z;
    };

    struct RzRy {
        angle rz;
        angle ry;
    };

    /** ʔԍ(ԍ)ƃxNg̃e[u */
    static const FaceVec _vec[3*3*3];
    /** ʔԍ(ԍ)Ɗe̐̃e[u */
    static const FaceSgn _sgn[3*3*3];
    /** ʔԍ(ԍ)RzRy */
    static const RzRy _rzry[3*3*3];
public:
    static const FaceVec* _dir2vec;

    static const FaceSgn* _dir2sgn;

    static const RzRy* _face2rzry;

    /** p */
    static bool is_init;

    static void init();

    /**
     * S̕xNgA߂̎Εʑ̖̂ʔԍ(QUԍ)ɕϊ .
     * @param prm_vx xNgXvf
     * @param prm_vy xNgYvf
     * @param prm_vz xNgZvf
     * @return ߂̎Εʑ̖̂ʔԍ(QUԍ)ADIR_NNN ` DIR_PPP or FACE_XXX
     */
    static dir26 cnvVec2DirNo(float prm_vx, float prm_vy, float prm_vz);

    /**
     * xNgA߂̂QUɕϊꍇ́AXYZevf̐̕擾 .
     * @param prm_vx xNgXvf
     * @param prm_vy xNgYvf
     * @param prm_vz xNgZvf
     * @param out_sgn_x Xvf̐ (-1 or 0 or 1)
     * @param out_sgn_y Yvf̐ (-1 or 0 or 1)
     * @param out_sgn_z Zvf̐ (-1 or 0 or 1)
     */
    static void cnvVec2Sgn(float prm_vx, float prm_vy, float prm_vz,
                           int& out_sgn_x, int& out_sgn_y, int& out_sgn_z);

    /**
     * Εʑ̖̂ʔԍ(QUԍ)AxNgiKς݁j擾 .
     * @param prm_dir_no Εʑ̖̂ʔԍ(QUԍ)ADIR_NNN ` DIR_PPP
     * @param out_vx xNgXvf
     * @param out_vy xNgYvf
     * @param out_vz xNgZvf
     */
    static void cnvDirNo2Vec(dir26 prm_dir_no, float& out_vx, float& out_vy, float& out_vz);

    /**
     * Εʑ̖̂ʔԍ(QUԍ)AXYZevf̐̕擾 .
     * @param prm_dir_no Εʑ̖̂ʔԍ(QUԍ)ADIR_NNN ` DIR_PPP
     * @param out_sgn_x Xvf̐ (-1 or 0 or 1)
     * @param out_sgn_y Yvf̐ (-1 or 0 or 1)
     * @param out_sgn_z Zvf̐ (-1 or 0 or 1)
     */
    static void cnvDirNo2Sgn(dir26 prm_dir_no, int& out_sgn_x, int& out_sgn_y, int& out_sgn_z);

    /**
     * Εʑ̖̂ʔԍ(QUԍ)ARzRŷQAOl擾 .
     * @param prm_dir_no Εʑ̖̂ʔԍ(QUԍ)ADIR_NNN ` DIR_PPP
     * @param out_rz
     * @param out_ry
     */
    static void cnvDirNo2RzRy(dir26 prm_dir_no, angle& out_rz, angle& out_ry);


};

}
#endif /*GGAFDXCORE_GGAFDX26DIRECTIONUTIL_H_*/
