#ifndef GGAFDXCORE_GGAFDXTEXTURE_H_
#define GGAFDXCORE_GGAFDXTEXTURE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <string>
#include <d3dx9.h>
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif


namespace GgafDxCore {

/**
 * eNX`NX.
 * DirectX̃eNX`C^[tF[X̃bp[łB<BR>
 * @version 1.00
 * @since 2009/03/09
 * @author Masatoshi Tsuge
 */
class GgafDxTexture : public GgafCore::GgafObject {
    friend class GgafDxTextureManager;

    static std::string getTextureFileName(std::string prm_file);

public:
    /** f`̎ʖB(50܂) */
    char* _texture_name;
    /** eNX`̕(px) */
    UINT _tex_width;
    /** eNX`̍(px) */
    UINT _tex_height;
    D3DXIMAGE_INFO* _pD3DXIMAGE_INFO;
    LPDIRECT3DBASETEXTURE9 _pIDirect3DBaseTexture9;

public:
    /**
     * RXgN^<BR>
     * @param prm_texture_name f`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    explicit GgafDxTexture(const char* prm_texture_name);

    void restore();

    void release();

    char* getName() {
        return _texture_name;
    }

    /**
     * fXgN^<BR>
     * deletêGgafDxTextureManagerł<BR>
     */
    virtual ~GgafDxTexture(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXEFFECT_H_*/
