#ifndef GGAFDXCORE_GGAFDXBGM_H_
#define GGAFDXCORE_GGAFDXBGM_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include <string>

namespace GgafDxCore {

/**
 * Bgm(OggtH[}bg)NX .
 */
class GgafDxBgm : public GgafCore::GgafObject {
    static std::string getOggFileName(std::string prm_file);

public:
    char* _bgm_key;
//    /** [r]BGM  BMP */
//    int _bpm;
//    /** [r]BGM  ^Cg */
//    std::string _title;
    /** [r]BGM  oggt@C(pX) */
    std::string _ogg_file_name;
    /** [r]PCMPlayer */
    IkdLib::PCMPlayer* _pPcmPlayer;
    IkdLib::OggVorbisFile* _pOggResource;
    IkdLib::OggDecoder* _pOggDecoder;

public:
    /**
     * RXgN^ .
     * vpeBt@C玟̃L[̒l擾܂B
     * @ prm_bgm_key+"_OGG"      EEE lFBGMƂȂ oggt@C
     * A prm_bgm_key+"_BPM"      EEE lFݖgp
     * B prm_bgm_key+"_TITLE"    EEE lFݖgp
     * ɁA@̂̒lBGMƂȂ oggt@C vpeBt@C
     * DIR_OGG[0] ̐ݒlzTăI[vAĐs܂B
     * @param prm_bgm_key vpeBt@Ckey
     *                    _OGG, _BPM, _TITLE ̃vtBbNXw
     * @return
     */
    explicit GgafDxBgm(const char* prm_bgm_key);

    /**
     * BGMĐ .
     * {[ɂāAŃ}X^{[̍lB
     * AvP[V́A{̉ʂCɂʏĐꍇ́A
     * {[100Őݒ肷鎖B
     * @param prm_volume 0`100
     * @param prm_pan  -1.0 ` 0 ` 1.0 E
     * @param prm_is_looping true:[vĐ
     */
    virtual void play(int prm_volume, float prm_pan, bool prm_is_looping);

    /**
     * BGMĐ .
     * {[ɂāAŃ}X^{[̍lB
     * AvP[V́A{̉ʂCɂʏĐꍇ́A
     * {[100Őݒ肷鎖B
     * @param prm_is_looping true:[vĐ
     */
    virtual void play(bool prm_is_looping);

    /**
     * ꎞ~ .
     * Đ pause() ƁATEhobt@~邪A
     * TEhobt@̓o͍sꖳB<BR>
     * ꎞ~ pause() ĂȂB<BR>
     * ~ pause() ĂȂB<BR>
     */
    virtual void pause();

    /**
     * ꎞ~ .
     * ꎞ~ unpause() ƁATEhobt@ĐB
     * [v̐ݒ͈pB<BR>
     * Đ unpause() ĂȂB<BR>
     * ~ unpause() ĂȂB<BR>
     */
    virtual void unpause();

    /**
     * BGM̒~ .
     * ǂ̗lȏԂłATEhobt@~ATEhobt@̓osB
     */
    virtual void stop();

    /**
     * BGM̃{[ݒ .
     * Ń}X^{[̍lB
     * AvP[V́A{̉ʂCɂʏĐꍇ́A
     * {[1000Őݒ肷鎖B
     * @param volume 0`1000
     */
    virtual void setVolume(int volume);

    /**
     * BGM̃pݒ .
     * @param pan  -1.0 ` 0 ` 1.0 E
     */
    virtual void setPan(float pan);

    /**
     * ĐXbh~ATEhobt@ .
     */
    virtual void clear();

    /**
     * ĐǂԂ
     * @return
     */
    virtual bool isPlaying();

    virtual ~GgafDxBgm();
};

}
#endif /*GGAFDXCORE_GGAFDXBGM_H_*/
