#ifndef GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_
#define GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/sound/GgafDxBgmPerformer.h"

namespace GgafDxCore {

/**
 * BGMtxNX .
 * V[IuWFNgɁAێ鎖ɂāA
 * BGMtF[hCAtF[hAEg@\tB
 * GgafDxScene::processSettlementBehavior() ŁA{NX
 * behave() \bhR[dlB<BR>
 * GgafDxBgmPerformer 番
 * @version 1.00
 * @since 2012/03/22
 * @author Masatoshi Tsuge
 */
class GgafDxBgmPerformerForScene : public GgafDxBgmPerformer {
public:
    /** [r]BGMƊ֘AtV[ */
    GgafDxScene* _pDxScene;
    /** [r]tF[h^[Qbg{[̔z(Y̓`l) */
    double* _pa_target_volume;
    /** [r]{[Zl̔z(Y̓`l) */
    double* _pa_inc_volume;
    /** [r]݃tF[hۂ̔z(Y̓`l) */
    bool* _pa_is_fade;
    /** [r]tF[h~̂ǂ̔z(Y̓`l) */
    bool* _pa_is_fadeout_stop;
    /** [r/w]ftHg̃tF[hCEtF[hAEg̔₷t[ */
    frame _default_fade;

public:
    /**
     * RXgN^
     * @param prm_pDxScene V[
     */
    GgafDxBgmPerformerForScene(GgafDxScene* prm_pDxScene);

    /**
     * BGMݒ肷B
     * @param prm_channel BGM`lԍ(0 ` )
     * @param prm_bgm_name vpeBt@C_OGG, _BPM, _TITLE ̃vtBbNXƂȂĂkey
     */
    virtual void ready(int prm_channel, const char* prm_bgm_name) override;

    /**
     * BGM̐U镑 .
     * Ƀ{[ωAtF[hCEAEgʂB
     */
    void behave();

    /**
     * tBGMɃtF[hʂsB
     * @param prm_channel              BGM`lԍ(0 ` )
     * @param prm_frame           tF[hɔ₷t[
     * @param prm_target_volume   BڕW{[(0 ` 100)
     */
    void fade(int prm_channel, frame prm_frame, int prm_target_volume);

    /**
     * tBGMɃtF[hCʂsB
     * tF[hCԂ setDefaultFadeFrames() w̃t[B
     * @param prm_channel  BGM`lԍ(0 ` )
     */
    void fadein(int prm_channel);

    /**
     * tBGMɃtF[hCʂsB
     * @param prm_channel  BGM`lԍ(0 ` )
     * @param prm_frame tF[hCt[
     */
    void fadein_f(int prm_channel, frame prm_frame);

    /**
     * BGMAtF[hCɂĐJnB
     * tF[hCԂ setDefaultFadeFrames() w̃t[B
     * @param prm_channel BGM`lԍ(0 ` )
     */
    void play_fadein(int prm_channel);

    /**
     * BGMAtF[hCɂĐJnB
     * @param prm_channel  BGM`lԍ(0 ` )
     * @param prm_frame tF[hCt[
     */
    void play_fadein_f(int prm_channel, frame prm_frame);

    /**
     * tBGMɃtF[hAEgʂsB
     * tF[hAEgԂ setDefaultFadeFrames() w̃t[B
     * @param prm_channel BGM`lԍ(0 ` )
     */
    void fadeout(int prm_channel);

    /**
     * tBGMɃtF[hAEgʂsB
     * @param prm_channel BGM`lԍ(0 ` )
     * @param prm_frame tF[hAEgt[
     */
    void fadeout_f(int prm_channel, frame prm_frame);

    /**
     * tBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * tF[hAEgԂ setDefaultFadeFrames() w̃t[B
     * @param prm_channel BGM`lԍ(0 ` )
     */
    void fadeout_stop(int prm_channel);

    /**
     * tBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * @param prm_channel BGM`lԍ(0 ` )
     * @param prm_frame tF[hAEgt[
     */
    void fadeout_stop_f(int prm_channel, frame prm_frame);

    /**
     * BGM̉tJn(tF[hʖ)B
     * @param prm_channel       BGM`lԍ(0 ` )
     * @param prm_volume   {[(0`100)
     * @param prm_is_loop  [v邩ǂitrue:[vĐ^false:[vĐȂj
     */
    void play(int prm_channel, int prm_volume, bool prm_is_loop) override;

    /**
     * BGM̉tJn(tF[hʖA[vĐ)B
     * @param prm_channel       BGM`lԍ(0 ` )
     * @param prm_volume   {[(0`100)
     */
    void play(int prm_channel, int prm_volume) override {
        play(prm_channel, prm_volume, true);
    }

    /**
     * BGM̉tJn(tF[hʖA[vĐA{[100)B
     * @param prm_channel       BGM`lԍ(0 ` )
     */
    void play(int prm_channel) override {
        play(prm_channel, GGAF_MAX_VOLUME);
    }

    /**
     * SBGM`l̉tBGMɃtF[hAEgʂsAtF[hAEg㉉t~B
     * tF[hAEgԂ setDefaultFadeFrames() w̃t[B
     */
    void fadeout_stop();

    /**
     * SBGM`l̃tF[hCtF[hAEg̃ftHgt[Ԃݒ .
     * ݒl360t[B
     * @param prm_default_fade tF[hɔ₷t[
     */
    void setDefaultFadeFrames(frame prm_default_fade) {
        _default_fade = prm_default_fade;
    }

    virtual ~GgafDxBgmPerformerForScene();
};

}
#endif /*GGAFDXCORE_GGAFDXBGMPERFORMERFORSCENE_H_*/
