#ifndef GGAFDXCORE_GGAFDXFRAMEDBOARDMODEL_H_
#define GGAFDXCORE_GGAFDXFRAMEDBOARDMODEL_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"

namespace GgafDxCore {

/**
 * GgafDxFramedBoardActorpfNX.
 * @version 1.00
 * @since 2017/08/21
 * @author Masatoshi Tsuge
 */
class GgafDxFramedBoardModel : public GgafDxModel {
    friend class GgafDxModelManager;
    friend class GgafDxFramedBoardActor;

public:
    struct INDEXPARAM {
        UINT MaterialNo;
        INT BaseVertexIndex;
        UINT MinIndex;
        UINT NumVertices;
        UINT StartIndex;
        UINT PrimitiveCount;
    };

    /** _\ */
    struct VERTEX {
        float x, y, z;    // _W
        float index;      // psizeł͂ȂĂ͂ȂĒ_ԍ𖄂ߍށBVF[_[ŉZbgڂ𔻒f邽߂ɎgpB
        float tu, tv;     // _̃eNX`W
    };

    /** _obt@̊eZbg */
    LPDIRECT3DVERTEXBUFFER9 _pVertexBuffer;
    /** CfbNXobt@ */
    LPDIRECT3DINDEXBUFFER9 _pIndexBuffer;
    /** _FVF */
    static DWORD FVF;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    INDEXPARAM _indexParam;

    float _model_width_px;
    float _model_height_px;
    int _row_texture_split;
    int _col_texture_split;

    float _model_frame_width_px;
    float _model_frame_height_px;
    int _row_frame_texture_split;
    int _col_frame_texture_split;


public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".x"ǉƒ`Xt@CɂȂB
     */
    GgafDxFramedBoardModel(const char* prm_model_name);

    virtual HRESULT draw(GgafDxFigureActor* prm_pActor_target, int prm_draw_set_num = 1, void* prm_pPrm = nullptr) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    /**
     * fXgN^<BR>
     */
    virtual ~GgafDxFramedBoardModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXBOARDSETMODEL_H_*/
