#ifndef GGAFDXCORE_GGAFDXMESHACTOR_H_
#define GGAFDXCORE_GGAFDXMESHACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxFigureActor.h"
#include "jp/ggaf/dxcore/actor/interface/GgafDxIBumpMapActor.h"

namespace GgafDxCore {

/**
 * bVAN^[.
 * GgafDxFigureActor pAƎXt@C`̃bV\@\<BR>
 * ǉAN^[łB<BR>
 * @version 1.00
 * @since 2009/02/26
 * @author Masatoshi Tsuge
 */
class GgafDxMeshActor : public GgafDxFigureActor, public GgafDxIBumpMapActor {

public:
    /** [r]f */
    GgafDxMeshModel* const _pMeshModel;
    /** [r]GtFNg */
    GgafDxMeshEffect* const _pMeshEffect;

    float _far_rate;

public:
    /**
     * RXgN^
     * @param prm_name f́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`B ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     */
    GgafDxMeshActor(const char* prm_name,
                    const char* prm_model_id,
                    const char* prm_effect_id,
                    const char* prm_technique,
                    GgafCore::GgafStatus* prm_pStat,
                    GgafDxChecker* prm_pChecker );

    /**
     * ʌppRXgN^
     * @param prm_name AN^[́iCӁj
     * @param prm_model_id f`
     * @param prm_model_type f^Cv
     * @param prm_effect_id GtFNg`
     * @param prm_effect_type GtFNg^Cv
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    GgafDxMeshActor(const char* prm_name,
                    const char* prm_model_id,
                    const char* prm_model_type,
                    const char* prm_effect_id,
                    const char* prm_effect_type,
                    const char* prm_technique,
                    GgafCore::GgafStatus* prm_pStat,
                    GgafDxChecker* prm_pChecker);

    virtual void processDraw() override;

    /**
     * ̍Wł\ .
     * @param prm_b
     */
    void drawAnyFar(bool prm_b) {
        if (prm_b) {
            _far_rate = 0.999f;
        } else {
            _far_rate = -1.0f;
        }
    }

    void effectBumpMapping(const char* prm_cubemap_tex, frame prm_frame = MAX_FRAME);

    virtual ~GgafDxMeshActor(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMESHACTOR_H_*/
