#ifndef GGAFDXCORE_GGAFDXMASSMORPHMESHACTOR_H_
#define GGAFDXCORE_GGAFDXMASSMORPHMESHACTOR_H_
#include "GgafDxCommonHeader.h"
#include "jp/ggaf/dxcore/actor/GgafDxFigureActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpher.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxMorpherAssistantA.hpp"
#include "jp/ggaf/dxcore/model/GgafDxMassMeshModel.h"

#define MAX_MASS_MORPH_TARGET_NUM 4

namespace GgafDxCore {

/**
 * [tbVAN^[.
 * GgafDxFigureActor pAXt@C`̃bV\@\y<BR>
 * [tAj[V@\AN^[<BR>
 * @version 1.00
 * @since 2009/05/08
 * @author Masatoshi Tsuge
 */
class GgafDxMassMorphMeshActor : public GgafDxFigureActor {

private:
    /** [tBOxIuWFNg */
    GgafDxMorpher<GgafDxMassMorphMeshActor>* const _pMorpher;

public:
    /** [r][t^[Qbg(f̃Rs[l) */
    int _morph_target_num;
    /** [r]f */
    GgafDxMassMorphMeshModel* const _pMassMorphMeshModel;
    /** [r]GtFNg */
    GgafDxMassMorphMeshEffect* const _pMassMorphMeshEffect;
    /** [r/w][t^[Qbg̏d(0.0 ` 1.0) */
    float _weight[MAX_MASS_MORPH_TARGET_NUM+1]; //[0]͖gpA[1]`[MAX_MASS_MORPH_TARGET_NUM][t^[Qbg̏d

public:
    /**
     * RXgN^ .
     * @param prm_name AN^[́ifobOOŕ\AȂłǂj
     * @param prm_model_id f`A ".x" Xt@CɂȂ邱ƁB
     * @param prm_effect_id GtFNg`B ".fx" ăGtFNgt@CɂȂ邱ƁB
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    GgafDxMassMorphMeshActor(const char* prm_name,
                             const char* prm_model_id,
                             const char* prm_effect_id,
                             const char* prm_technique,
                             GgafCore::GgafStatus* prm_pStat,
                             GgafDxChecker* prm_pChecker );

    /**
     * ʌppRXgN^
     * @param prm_name AN^[́iCӁj
     * @param prm_model_id f`
     * @param prm_model_type f^Cv
     * @param prm_effect_id GtFNg`
     * @param prm_effect_type GtFNg^Cv
     * @param prm_technique GtFNg̃eNjbN
     * @param prm_pStat gpXe[^XIuWFNg(gpȂ nullptrł悢)
     * @param prm_pChecker gp`FbJ[IuWFNgi`FbJ[gpnullptrł悢j
     * @return
     */
    GgafDxMassMorphMeshActor(const char* prm_name,
                             const char* prm_model_id,
                             const char* prm_model_type,
                             const char* prm_effect_id,
                             const char* prm_effect_type,
                             const char* prm_technique,
                             GgafCore::GgafStatus* prm_pStat,
                             GgafDxChecker* prm_pChecker);

    /**
     * [t^[QbgbV擾
     * @return [t^[QbgbV
     */
    int getMorphTergetNum();

    /**
     * [t^[Qbg̏d݂𒼐ڎw .
     * @param prm_target_mesh_no [t^[QbgbVNO(1 `)
     * @param prm_weight d d0.0`1.0Bȏ\
     */
    void setMorphWeight(int prm_target_mesh_no, float prm_weight);

    /**
     * S[t^[Qbg̏d݂𒼐ڎw
     * @param prm_target_mesh_no d0.0`1.0Bȏ\
     */
    void setMorphWeight(float prm_weight);

    float getMorphWeight(int prm_target_mesh_no);

    void addMorphWeight(int prm_target_mesh_no, float prm_add_weight);

    inline GgafDxMorpher<GgafDxMassMorphMeshActor>* getMorpher() {
        return _pMorpher;
    }

    /**
     * GtFNg̃eNjbN̕ύX .
     * ̃eNjbNɃ^[Qbgt^Đݒ肵܂B
     * @param prm_technique eNjbN
     */
    virtual void changeEffectTechnique(const char* prm_technique) override;

    virtual ~GgafDxMassMorphMeshActor (); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXMASSMORPHMESHACTOR_H_*/
