#include "jp/ggaf/core/GgafFactory.h"

#include "jp/ggaf/core/GgafGod.h"
#include "jp/ggaf/core/GgafOrder.h"
#include "jp/ggaf/core/GgafGarbageBox.h"
#include "jp/ggaf/core/actor/GgafActor.h"
#include "jp/ggaf/core/scene/GgafScene.h"
#include "jp/ggaf/core/GgafProperties.h"


using namespace GgafCore;

//
GgafOrder* GgafFactory::ROOT_ORDER = nullptr;
GgafOrder* GgafFactory::CREATING_ORDER = nullptr;
#ifdef _MSC_VER
volatile bool GgafFactory::_is_working_flg   = true;
volatile bool GgafFactory::_have_to_rest_flg = false;
volatile bool GgafFactory::_is_resting_flg   = false;
volatile bool GgafFactory::_was_finished_flg = false;
#else
volatile std::atomic<bool> GgafFactory::_is_working_flg(true);
volatile std::atomic<bool> GgafFactory::_have_to_rest_flg(false);
volatile std::atomic<bool> GgafFactory::_is_resting_flg(false);
volatile std::atomic<bool> GgafFactory::_was_finished_flg(false);
#endif

GgafMainActor* GgafFactory::obtainActor(uint64_t prm_order_no, GgafObject* prm_pReceiver) {
    return (GgafMainActor*)GgafFactory::obtain(prm_order_no, prm_pReceiver);
}

GgafMainScene* GgafFactory::obtainScene(uint64_t prm_order_no, GgafObject* prm_pReceiver) {
    return (GgafMainScene*)GgafFactory::obtain(prm_order_no, prm_pReceiver);
}


//̃\bh̓CXbhsB
void GgafFactory::order(uint64_t prm_order_no,
                        GgafObject* (*prm_pFunc)(void*, void*, void*),
                        GgafObject* prm_pOrderer,
                        GgafObject* prm_pReceiver,
                        void* prm_pArg1,
                        void* prm_pArg2,
                        void* prm_pArg3) {

    _TRACE2_("q:("<<prm_pOrderer<<") ʃXbh̍HꂳA [" << prm_order_no << "-"<<prm_pReceiver<<"]ƂĂ`B");
    //ɒĂȂ`FbN
    GgafOrder* pOrder = GgafFactory::ROOT_ORDER;
    while (pOrder) {
        if (pOrder->_order_no == prm_order_no &&  pOrder->_pReceiver == prm_pReceiver) {
            _TRACE_("x GgafFactory::order ƁA[" << prm_order_no << "-"<<prm_pReceiver<<"]́AQdĂ܂IA܂BӐ}Ă܂H");
            return;
        }
        if (pOrder->_is_last_order_flg) {
            break;
        }
        pOrder = pOrder->_pOrder_next;
    }
    //͖ł悤Ȃ̂Ő擪ɃXgbN
    GgafOrder* pOrder_new;
    pOrder_new = NEW GgafOrder(prm_order_no);
    pOrder_new->_pObject_creation=nullptr;
    pOrder_new->_pFunc = prm_pFunc;
    pOrder_new->_pOrderer = prm_pOrderer;
    pOrder_new->_pReceiver = prm_pReceiver;
    pOrder_new->_time_of_order = timeGetTime();
    pOrder_new->_pArg1 = prm_pArg1;
    pOrder_new->_pArg2 = prm_pArg2;
    pOrder_new->_pArg3 = prm_pArg3;
    pOrder_new->_progress = 0;
    if (GgafFactory::ROOT_ORDER == nullptr) {
        _TRACE2_("q:("<<prm_pOrderer<<") AH͋łˁBAłˁHB");
        pOrder_new->_is_first_order_flg = true;
        pOrder_new->_is_last_order_flg = true;
        pOrder_new->_pOrder_next = pOrder_new;
        pOrder_new->_pOrder_prev = pOrder_new;
        GgafFactory::ROOT_ORDER = pOrder_new;
        GgafFactory::CREATING_ORDER = pOrder_new;
    } else {
        _TRACE2_("q:("<<prm_pOrderer<<") ܂Ă܂ˁAX܂B");
        pOrder_new->_is_first_order_flg = false;
        pOrder_new->_is_last_order_flg = true;
        GgafOrder* pOrder_last;
        pOrder_last = GgafFactory::ROOT_ORDER->_pOrder_prev;
        pOrder_last->_is_last_order_flg = false;
        pOrder_last->_pOrder_next = pOrder_new;
        pOrder_new->_pOrder_prev = pOrder_last;
        pOrder_new->_pOrder_next = GgafFactory::ROOT_ORDER;
        GgafFactory::ROOT_ORDER->_pOrder_prev = pOrder_new;
    }
}

int GgafFactory::chkProgress(uint64_t prm_order_no) {
    GgafOrder* pOrder;
    pOrder = GgafFactory::ROOT_ORDER;
    if (pOrder == nullptr) {
        return -1;
    }
    while (GgafFactory::_is_working_flg) {
        if (pOrder->_order_no == prm_order_no) {
            return pOrder->_progress;
        } else {
            if (pOrder->_is_last_order_flg) {
                return -1;
            } else {
                pOrder = pOrder->_pOrder_next;
            }
        }
    }
    return -2;
}

void* GgafFactory::obtain(uint64_t prm_order_no, GgafObject* prm_pReceiver) {
    _TRACE2_("l:"<< (prm_pReceiver ? prm_pReceiver->toString() : "nullptr") <<"("<<prm_pReceiver<<") ܂ǁA["<<prm_order_no<<"-"<<prm_pReceiver<<"]ɗ܂ƁB");
    GgafOrder* pOrder;
    GgafOrder* pOrder_my_next;
    GgafOrder* pOrder_my_prev;
    DWORD waittime = 0;
    pOrder = GgafFactory::ROOT_ORDER;
    void* objectCreation;

    if (pOrder == nullptr) {
        //G[IAG[bZ[WB
        _TRACE_(FUNC_NAME<<" G[I");
        GgafFactory::debuginfo();
        throwGgafCriticalException("Error! prm_order_no="<<prm_order_no<<" XgnullptrőSĐς݂Ă܂B\n"<<
                                   "orederobtain̑ΉĂ܂B\n"<<
                                   "l(obtainĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<")");
    }

    //obtainC[v
    while (GgafFactory::_is_working_flg) {
        if (pOrder->_order_no == prm_order_no && (pOrder->_pReceiver == nullptr || pOrder->_pReceiver == prm_pReceiver) ) {
            while (GgafFactory::_is_working_flg) {
                if (pOrder->_progress < 2) {
                    _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") ˂H꒷A["<<prm_order_no<<"-"<<prm_pReceiver<<"]̐܂`HA5~b҂悤BpOrder->_progress="<<(pOrder->_progress));
#ifdef _DEBUG
                    //fobO̓^CAEg
#else

                    if (waittime > 1000*600) { //10
                        _TRACE_(FUNC_NAME<<" ^CAEgG[I");
                        GgafFactory::debuginfo();
                        //^CAEgG[IAG[bZ[WB
                        throwGgafCriticalException("Error! ["<<pOrder->getDebuginfo()<<"]̐҂ԃ^CAEgA擾ł܂B\n"<<
                                                   "炩̗RŃCXbh~Ă\傫łB"<<
                                                   "l(obtainĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<")");
                    } else {
                    }
#endif
                    END_SYNCHRONIZED1; // <----- rI
                    Sleep(5);
                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    waittime += 5;
                    if (pOrder->_progress == 1) {
                        //ς
                        _TRACE_N_("A");
                        continue; //҂
                    } else if (pOrder->_progress == 0) {
                        //H
                        pOrder = GgafFactory::ROOT_ORDER; //xŏTB
                        _TRACE_N_("҂āA");
                        break;
                    } else if (pOrder->_progress == 2) {
                        //
                        pOrder = GgafFactory::ROOT_ORDER; //xŏTB
                        _TRACE_N_("I");
                        break;
                    }
                } else {

#ifdef MY_DEBUG
                    if (waittime > 0) {
                        _TRACE_N_("EEE܂܂B");
                    }
#endif
                    _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") `A["<<prm_order_no<<"-"<<prm_pReceiver<<"]͐łˁBɁI");
                    if (pOrder->_is_first_order_flg && pOrder->_is_last_order_flg) {
                        //Ō̈ obtain
                        objectCreation = pOrder->_pObject_creation;
                        pOrder->_pObject_creation = nullptr;
                        GGAF_DELETE(pOrder);
                        pOrder = nullptr;
                        GgafFactory::ROOT_ORDER = nullptr;
                        GgafFactory::CREATING_ORDER = nullptr;
                        _TRACE2_("l:"<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") AƂłH͋łˁBɂɂȂHA˂H");
                        return (void*)objectCreation;
                    } else {
                        //ԂobtainAqB
                        pOrder_my_next = pOrder->_pOrder_next;
                        pOrder_my_prev = pOrder->_pOrder_prev;
                        pOrder_my_prev->_pOrder_next = pOrder_my_next;
                        pOrder_my_next->_pOrder_prev = pOrder_my_prev;
                        if (pOrder->_is_last_order_flg) {
                            pOrder_my_prev->_is_last_order_flg = true;
                        }
                        if (pOrder->_is_first_order_flg) {
                            GgafFactory::ROOT_ORDER = pOrder_my_next;
                            pOrder_my_next->_is_first_order_flg = true;
                        }
                        if (GgafFactory::CREATING_ORDER == pOrder) {
                            GgafFactory::CREATING_ORDER = pOrder_my_next;
                        }
                        objectCreation = pOrder->_pObject_creation;
                        pOrder->_pObject_creation = nullptr;
                        GGAF_DELETE(pOrder);
                        pOrder = nullptr;

                        return (void*)objectCreation;
                    }
                }
            }
        } else {
            if (pOrder->_is_last_order_flg) {
                _TRACE_(FUNC_NAME<<" ̌`ՂA擾oȂG[I");
                GgafFactory::debuginfo();
                //̌`ՂA擾oȂG[IAG[bZ[WB
                throwGgafCriticalException("H꒷ST܂ǁAȒ("<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"ւ ԍ:"<<prm_order_no<<"-"<<prm_pReceiver<<")́A܂B\n "<<
                                           "oreder()  GgafFactory::obtain() ̑ΉĂ܂Boreder()RA͓ GgafFactory::obtain() QȏサĂ܂񂩁HB\n"<<
                                           "Fl(obtainĂь)="<<(prm_pReceiver ? prm_pReceiver->toString() : "nullptr")<<"("<<prm_pReceiver<<") łB\n" <<
                                           "iȂ݂ɁAݍH̍ŏII[_[́Aԍ("<<pOrder->_order_no<<"-"<<pOrder->_pReceiver<<")ŁA(orderĂь)=("<<pOrder->_pOrderer<<") łj");
            } else {
                pOrder = pOrder->_pOrder_next;
            }
        }
    }
    if (GgafGod::_pException_factory) {
        throw *(GgafGod::_pException_factory);
    }
    return nullptr;
}

void GgafFactory::beginRest() {
    _TRACE_(FUNC_NAME<<" _HAxeȂ");
    GgafFactory::_have_to_rest_flg = true;
}

bool GgafFactory::isResting() {
    if (GgafFactory::_is_resting_flg) {
        _TRACE_(FUNC_NAME<<" Hx~");
    } else {
        _TRACE_(FUNC_NAME<<" Hғ");
    }
    return GgafFactory::_is_resting_flg;
}

void GgafFactory::finishRest() {
    _TRACE_(FUNC_NAME<<" _HAxe͂܂BI");
    GgafFactory::_have_to_rest_flg = false;
}

//HɂߍłSẴCX^Xj
//_(GgafGod)AvIɎs\B
void GgafFactory::clean() {
    _TRACE2_("_ H|Jn");
    GgafOrder* pOrder = GgafFactory::ROOT_ORDER;
    if (pOrder == nullptr) {
        _TRACE2_("_ HɉII");
        return;
    }
    uint64_t cnt = 0;
    while (GgafFactory::_is_working_flg || GgafFactory::_was_finished_flg == false) {
        Sleep(10);
        _TRACE_(FUNC_NAME<<" _ Hꂪ܂Ă܂EEE");
        cnt++;
        if (cnt > 100*60*5) {
            _TRACE_(FUNC_NAME<<" _ Hꂪ܂Ă܂EEE҂Ă܂B");
            break;
        }
    }

    GgafFactory::debuginfo();

    while (true) {
        if (pOrder->_is_last_order_flg) {
            _TRACE2_("_ i폜["<<pOrder->getDebuginfo()<<"]AŌ̃XgbN");
            GGAF_DELETE(pOrder);
            pOrder = nullptr;
            GgafFactory::ROOT_ORDER = nullptr;
            GgafFactory::CREATING_ORDER = nullptr;
            break;
        } else {
            _TRACE2_("_ i폜["<<pOrder->getDebuginfo()<<"]");
            GgafOrder* pOrder_my_next = pOrder->_pOrder_next;
            GGAF_DELETE(pOrder);
            pOrder = pOrder_my_next;
        }
    }
    _TRACE2_("_ H|");
    return;
}

void GgafFactory::removeOrder(GgafObject* prm_pReceiver) {
    GgafOrder* pOrder = GgafFactory::ROOT_ORDER;
    while (pOrder) {
        if (pOrder->_pReceiver == prm_pReceiver) {
            if (pOrder->_is_last_order_flg && pOrder->_is_first_order_flg) {
                //Ō̈
                GGAF_DELETE(pOrder);
                GgafFactory::ROOT_ORDER = nullptr;
                GgafFactory::CREATING_ORDER = nullptr;
                break; //I
            } else {
                //Ԃ̏ꍇA|C^qB
                GgafOrder* pOrder_t_next = pOrder->_pOrder_next;
                GgafOrder* pOrder_t_prev = pOrder->_pOrder_prev;
                pOrder_t_prev->_pOrder_next = pOrder_t_next;
                pOrder_t_next->_pOrder_prev = pOrder_t_prev;

                if (pOrder->_is_last_order_flg) {
                    pOrder_t_prev->_is_last_order_flg = true;
                }
                if (pOrder->_is_first_order_flg) {
                    GgafFactory::ROOT_ORDER = pOrder_t_next;
                    pOrder_t_next->_is_first_order_flg = true;
                }
                if (GgafFactory::CREATING_ORDER == pOrder) {
                    GgafFactory::CREATING_ORDER = pOrder_t_next;
                }
                _TRACE_(FUNC_NAME<<" l("<<prm_pReceiver<<")Sׁ̈A폜܂B" << pOrder->getDebuginfo() << "");
                GGAF_DELETE(pOrder);
                pOrder = pOrder_t_next;
                continue;
            }
        } else {
            if (pOrder->_is_last_order_flg) {
                break; //I
            } else {
                pOrder = pOrder->_pOrder_next;
                continue;
            }
        }
    }
}

void GgafFactory::debuginfo() {
    _TRACE_(FUNC_NAME<<" fobO ݂̍H̏");
    try {
        GgafOrder* p = GgafFactory::ROOT_ORDER;
        if (p) {
            while(p) {
                _TRACE_("E" << p->getDebuginfo() );
                p = p->_pOrder_next;
                if (p == GgafFactory::ROOT_ORDER) {
                    break;
                }
            }
        } else {
            _TRACE_("EI[_[܂I");
        }
    } catch (...) {
        _TRACE_(FUNC_NAME<<" ȂƂƂł傤B݂̍H̏Ԃ̕\s\łB");
    }
    _TRACE_(FUNC_NAME<<" ȏ");
}

unsigned __stdcall GgafFactory::work(void* prm_arg) {
    //_CrtSetBreakAlloc(65854);
    try {
        GgafObject* (*func)(void*, void*, void*) = nullptr;
        GgafObject* pObject = nullptr;
        Sleep(1000); //god ̃CX^X܂łق̂Ƒ҂Kv邩Ȃ

        //i܂Hꃋ[vI
        while (GgafFactory::_is_working_flg) {
            if (GgafFactory::_have_to_rest_flg) {
                GgafFactory::_is_resting_flg = true;
                Sleep(100);
                continue;
            } else {
                GgafFactory::_is_resting_flg = false;
            }

BEGIN_SYNCHRONIZED1; // ----->rJn
            GgafOrder* pOrder_creating = GgafFactory::CREATING_ORDER;
            if (pOrder_creating) {
                if (pOrder_creating->_progress == 0) { //Ȃ܂
                    _TRACE2_("H꒷ 悵A["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]͖(_progress == "<<pOrder_creating->_progress<<")ȁB䂦ɍ܂I");
                    pOrder_creating->_progress = 1; //Xe[^X𐻑
                    pOrder_creating->_time_of_create_begin = timeGetTime();
                    func = pOrder_creating->_pFunc;
                    void* arg1 = pOrder_creating->_pArg1;
                    void* arg2 = pOrder_creating->_pArg2;
                    void* arg3 = pOrder_creating->_pArg3;
                    _TRACE2_("H꒷ JnI["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]");
                    Sleep(2);
                    END_SYNCHRONIZED1; // <----- rI

                    pObject = (*func)(arg1, arg2, arg3); //i̐I

                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    Sleep(2);
                    _TRACE2_("H꒷ Ii["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"] (^_^)v");
                    if (GgafFactory::CREATING_ORDER == nullptr) {
                        //GgafFactory::CREATING_ORDER  nullptr ɂȂĂ܂ĂꍇLZB
                        _TRACE2_("H꒷ K[IB̂ɃLZEEEBj܂BpObjectdelete!");
                        GGAF_DELETE(pObject);
END_SYNCHRONIZED1; // <----- rI
                        continue;
                    } else if (GgafFactory::CREATING_ORDER == pOrder_creating) {
                        //ȃP[X
                        pOrder_creating->_pObject_creation = pObject; //io^
                        pOrder_creating->_progress = 2; //Xe[^X𐻑ς݂
                        pOrder_creating->_time_of_create_finish = timeGetTime();
                        _TRACE2_("H꒷ ̕i["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]AIɒuƂ܂B");
                    }  else if (GgafFactory::CREATING_ORDER != pOrder_creating) {
                        _TRACE2_("H꒷ xA̕i["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]ĂԂɁA"<<
                                 "CREATING_ORDER Aʂ̒["<<GgafFactory::CREATING_ORDER->_order_no<<"-"<<GgafFactory::CREATING_ORDER->_pReceiver<<"]wĂ܂IĂ邩܂IIɌɖ߂܂IvI");
                        GgafFactory::CREATING_ORDER = pOrder_creating; //|C^߂
                        pOrder_creating->_pObject_creation = pObject; //io^
                        pOrder_creating->_progress = 2; //Xe[^X𐻑ς݂
                        pOrder_creating->_time_of_create_finish = timeGetTime();
                        _TRACE2_("H꒷ ̕i["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]AIɒuƂ܂EEEB");
                    }
                } else {
                    _TRACE2_("H꒷ ["<<pOrder_creating->_order_no<<"-"<<pOrder_creating->_pReceiver<<"]́AĒIɒuĂ邵EEE(_progress == "<<pOrder_creating->_progress<<")B");
                }
            }
            if (GgafFactory::ROOT_ORDER == nullptr) {
                //ҋ@
                _TRACE2_("H꒷ Hɂ͉`܂BȂłIIEEEȂ̂HBiҋ@j");
END_SYNCHRONIZED1; // <----- rI
                if (GgafGod::_pGod->_fps >= PROPERTY::FPS_TO_CLEAN_GARBAGE_BOX) {
                    _TRACE2_("H꒷ قǖZȂ̂ŁAS~̃S~oƂB");
                    GgafGarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                    GgafGarbageBox::_cnt_cleaned = 0;
                }
            } else {
                if (GgafFactory::ROOT_ORDER != nullptr && GgafFactory::ROOT_ORDER->_pOrder_prev->_progress == 0) {
                    _TRACE2_("H꒷ EEE̒CzBŏIڕW̒["<<GgafFactory::ROOT_ORDER->_pOrder_prev->_order_no<<"/l="<<GgafFactory::ROOT_ORDER->_pOrder_prev->_pReceiver<<"]Ȃ̂HB");
                    GgafFactory::CREATING_ORDER = GgafFactory::CREATING_ORDER->_pOrder_next;
END_SYNCHRONIZED1; // <----- rI
                } else {
                    _TRACE2_("H꒷ āA͖BIɐς̂񂪂܂Ă̂𑁂ɗIBiҋ@j");
END_SYNCHRONIZED1; // <----- rI
                    if (GgafGod::_pGod->_fps >= PROPERTY::FPS_TO_CLEAN_GARBAGE_BOX) {
                        _TRACE2_("H꒷ قǖZȂȂ̂ŁAS~̃S~oƂB");
                        GgafGarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                        GgafGarbageBox::_cnt_cleaned = 0;
                    }
                }
            }
            Sleep(2);
        } // <-- while (GgafFactory::_is_working_flg)
        _TRACE2_("H꒷ H͂ɂēX܂łB悤ȂA܂܂傤B");
        GgafFactory::_was_finished_flg = true;
    } catch (GgafCriticalException& e) {
        GgafFactory::debuginfo();
        _TRACE_("HO ƂƂ݂܂G"<<e.getMsg());
        GgafFactory::_is_working_flg = false;
        GgafFactory::_was_finished_flg = true;
        GgafGod::_pException_factory = NEW GgafCriticalException(e.getMsg());
        return 1;
    }
    return 0;
}

