#ifndef GGAFCORE_GGAFRESOURCECONNECTION_H_
#define GGAFCORE_GGAFRESOURCECONNECTION_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"
#include "jp/ggaf/core/exception/GgafCriticalException.h"
#include "jp/ggaf/core/util/GgafResourceManager.hpp"
#include "windows.h"
#ifdef __GNUG__
    #undef __in
    #undef __out
#endif

#ifndef _MSC_VER
    #include <atomic>
#endif

namespace GgafCore {

/**
 * ڑNX .
 * (Resource)𖳑ʂɐs킸AQƂĎg܂킵B new ̂ǂӎȂB<BR>
 * ȂƂɎgNXBȒPɂCOMIuWFNg̊ȈՔłƂƂ납B<BR>
 * GgafResourceManager : (Resource) : GgafResourceConnection  = 1 : N : N
 * ̊֌WŁAŃZbgłBGgafResourceConnection ͌ (Resource)̃bp[NXłB
 * GgafResourceConnectionNX̃CX^XA}l[W[NX(GgafResourceManagerNX)
 * 擾(getConnection \bh)邱ƂƂ܂B<BR>
 * }l[W[ւ̐ڑ GgafResourceManager<T>::getConnection ŁuڑJEgv+1A
 * {NXclose()ŁuڑJEgv-1܂B<BR>
 * close() ĂяoƁAŁuڑJEgvɂ{ɉۂ𔻒f܂B<BR>
 * ڑJEg0ɂȂꍇA(Resource)͉܂B
 * T ɂ͎̌^w肵ĂB<BR>
 * ӁFXbhZ[t̕ۏ؂͓ɂQXbh܂ŁBRXbhȏ͐삵܂B<BR>
 * ӁFŏIclose()̉ŁAfXgN^ĂяoׂɁAT ̃NXwb_ include YꂸɁII<BR>
 * @tparam T ̌^ǐ^̃|C^^ŊǗBj
 * @version 1.00
 * @since 2008/01/28
 * @author Masatoshi Tsuge
 */
template<class T>
class GgafResourceConnection : public GgafObject {
    friend class GgafResourceManager<T>;

private:
    /** ʖ(50܂) */
    char* _idstr;
    /** ݂̎}lW[̎ɐڑĂ|C^ */
    int _num_connection;
    /** g܂킷ւ̃|C^ */
    T* _pResource;
    /** ߂Ă̐ڑ */
    void* _p_first_connector;


#ifdef _MSC_VER
    //TODO:VC++2005ȍ~(x86)  volatile ́AoAʂiƎvjB
    //gcc(x86)́AAg~bNۏ؂͖ std::atomic gBVC++ atomic ܂ł͂Ƃ肠EEEB
    /** closetrue̔rtO */
    static volatile bool _is_closing_resource;
#else
    /** closetrue̔rtO */
    static volatile std::atomic<bool> _is_closing_resource;
#endif

protected:
    /** [r]}lW[ */
    GgafResourceManager<T>* _pManager;
    /** [r]GgafResourceConnectionւ̃|C^BI[nullptr */
    GgafResourceConnection<T>* _pNext;

protected:
    /**
     * RXgN^<BR>
     * protected ł闝ŔA}lW[(GgafResourceManager<T>) 邽߁B<BR>
     * @param prm_idstr ʖ(29܂)
     * @param prm_pResource g܂킷
     */
    GgafResourceConnection(const char* prm_idstr, T* prm_pResource);

    /**
     * fXgN^<BR>
     * protected ł闝ŔAnew  delete ̋BJ close() gp<BR>
     */
    virtual ~GgafResourceConnection() {
    }

    /**
     * ̎ۂ̉B
     * delete  Release ȂǁA̎ɉۂ̉ĉB
     * @param prm_pResource
     */
    virtual void processReleaseResource(T* prm_pResource)= 0;

public:
    /**
     * ʖԂ .
     * @return ʖ
     */
    char* getIdStr() const ;

    /**
     * XgAĂ鎟̎ڑIuWFNgԂ .
     * I[łꍇ nullptr ԂB
     * @return ̎ڑIuWFNg ́Anullptr
     */
    GgafResourceConnection<T>* getNext() const;

    /**
     * RlNV̎擾 .
     * ڑJE^͑܂<BR>
     * @return ւ̃|C^
     */
    inline T* peek() const {
        return _pResource;
    }

    /**
     * ̃|C^̃IuWFNgA߂ẴRlNVIuWFNgǂׂB .
     * @param prm_this ׂIuWFNgBthisnĉB
     * @return true:߂connect(=resource new jIuWFNgłB/false:ł͂ȂB
     */
    bool chkFirstConnectionIs(void* prm_this) const;

    /**
     * (Resource)ւ̐ڑ擾 .
     * @return (Resource)ւ̐ڑ
     */
    int getNumConnection() const;

    /**
     * ڑ .
     * ƂĂ}l[W̐ڑJE^1炷łB<BR>
     * AAڑJE^ 0 ɂȂ΁AprocessReleaseResourceĂяoA{ɉ܂B<BR>
     * COMŌƂ Release() ɂB
     * @return ڑ́AڑJE^
     */
    int close();

};

///////////////////////////////////  /////
#ifdef _MSC_VER
template<class T>
volatile bool GgafResourceConnection<T>::_is_closing_resource = false;
#else
template<class T>
volatile std::atomic<bool> GgafResourceConnection<T>::_is_closing_resource(false);
#endif

template<class T>
char* GgafResourceConnection<T>::getIdStr() const {
    return _idstr;
}

template<class T>
GgafResourceConnection<T>* GgafResourceConnection<T>::getNext() const {
    return _pNext;
}

template<class T>
GgafResourceConnection<T>::GgafResourceConnection(const char* prm_idstr, T* prm_pResource) : GgafObject() {
    _TRACE3_("prm_idstr="<<prm_idstr);
    _pResource = prm_pResource;
    _pNext = nullptr;
    _pManager = nullptr;
    _num_connection = 0;
    _p_first_connector = nullptr;

    int len = strlen(prm_idstr);
    _idstr = NEW char[len+1];
    strcpy(_idstr, prm_idstr);

}

template<class T>
int GgafResourceConnection<T>::getNumConnection() const {
    return _num_connection;
}

template<class T>
bool GgafResourceConnection<T>::chkFirstConnectionIs(void* prm_this) const {
    if (_p_first_connector == prm_this) {
        return true;
    } else {
        return false;
    }
}


template<class T>
int GgafResourceConnection<T>::close() {
    //close() ͕XbhteB
    if ( _is_closing_resource || GgafResourceManager<T>::_is_connecting_resource) {
        _TRACE_("x GgafResourceConnection<T>::close() ʂ̃Xbhconnect()  close() Bҋ@܂EEEEӐ}IȂΗǂłB[" << _pManager->_manager_name << "(" << _idstr << ")" << "]B");
    }

    for(int i = 0; _is_closing_resource || GgafResourceManager<T>::_is_connecting_resource; i++) {
        Sleep(10);
        if (i > 100*60) {
            throwGgafCriticalException("[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << " \n"<<
                                       " connect()  close() ɂ炸Aclose()悤Ƃă^CAEgɂȂ܂Bconnect`colse ̃XbhP{ɂĉB");
        }
        if (i % 100 == 0) {
            _TRACE_("x GgafResourceConnection<T>::close() ʂ̃Xbhconnect()  close() ɁAclose()vߑҋ@B[" << _pManager->_manager_name << "(" << _idstr << ")" << "]B҂="<<i);
        }
    }
    _is_closing_resource = true;

    if (_num_connection <= 0) {
        _TRACE3_(" [" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << "  xɃRlNV͖ɂ炸Aclose() 悤ƂĂ܂B");
        _TRACE3_("sȂ킸return܂AӐ}IłȂꍇ͉ł傤B[N̉\BׂI");
        return _num_connection;
    }

    GgafResourceConnection<T>* pCurrent = _pManager->_pConn_first;
    GgafResourceConnection<T>* pPrev = nullptr;
    while (pCurrent) {
        if (pCurrent == this) {
            //ꍇ
            int rnum = _num_connection;
            _TRACE3_("[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << "  ̂ŊJn");
            if (rnum == 1) {//Ō̐ڑꍇ
                //ɍsh߂ł̂ŁAێXg痣EsȂ
                if (pCurrent->_pNext == nullptr) {
                    //
                    if (pPrev == nullptr) {
                        //Ő擪iŌ̈j
                        _pManager->_pConn_first = nullptr;
                    } else {
                        //Ő擪łȂ
                        pPrev->_pNext = nullptr;
                    }
                } else {
                    //łȂ
                    if (pPrev == nullptr) {
                        //擪
                        _pManager->_pConn_first = pCurrent->_pNext; //擪ɂ炷
                    } else {
                        //ł擪łȂiԁj
                        pPrev->_pNext = pCurrent->_pNext; //ׂq
                    }
                }
                _TRACE3_("[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << "  Ō̎QƂ̂߉܂B");
                _num_connection = 0;
            } else if (rnum > 0) {
                _TRACE3_("[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << "  ܂cĂ܂");
                _num_connection--;
            } else if (rnum < 0) {
                //RR͒ʂȂEEE
                _TRACE_(FUNC_NAME<<"[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection << "  "<<
                        "IAǂȂ˂BAz[(>_<)BƂ肠X[B");
                _num_connection = 0; //Ƃ肠
            }
            break;
        } else {
            //ꍇ
            pPrev = pCurrent;
            pCurrent = pCurrent->_pNext;
        }
    }

    if (_num_connection == 0) {
        T* r = pCurrent->peek();
        if (r) {
            _TRACE_(FUNC_NAME<<"[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection <<" processReleaseResource() Begin.");
            pCurrent->processReleaseResource(r); //{̉
            _TRACE_(FUNC_NAME<<"[" << _pManager->_manager_name << "(" << _idstr << ")" << "]<-" << _num_connection <<" processReleaseResource() Done.");
        }

        if (GgafResourceManager<T>::_is_waiting_to_connect) {
            //ʃXbhŊconnet()҂ԂɓĂΊJȂB
            //́Aꎟ̏u new 邱Ƃm肵Ă̂ŁAʂdelete sȂ悤ɂƂӐ}B
            //ނ낱̂悤ɂȂƁAu|C^ԂɂȂ̂ŁAconnet()ŏɂĂ͗Ă܂iƎvjB
            _is_closing_resource = false;
            return 0;
        } else {
            //ʃXbhconnet()҂Ԃ̂ŁASĊJƂ悤B
            _is_closing_resource = false; //this|C^gpĂȂ̂ő\
            _TRACE_(FUNC_NAME<<"[" << _pManager->_manager_name << "(" << _idstr << ")" << "] Now, delete this !!!");
            delete[] _idstr;
            delete this;     //ȂƂołˁIB
//            if (GgafResourceManager<T>::_is_waiting_to_connect) {
//                //ɗāAconnet()҂ɕςĂA߂B
//                //݂̔rSł͂Ȃƍl̂́Â̏܂
//                //TODO:SΉɂ́Aconnect()p@\˂΂ȂʁB
//                _TRACE_("xGgafResourceConnection<T>::close() delete this  connect() 悤Ƃ܂Bvł傤BEEE͂ǂ悤̂łI");
//            }
//            _is_closing_resource = false; //this|C^gpĂȂ̂ő\
            return 0;
        }
    } else {
        _is_closing_resource = false;
        return _num_connection;
    }
}

}

#endif /*GGAFCORE_GGAFRESOURCECONNECTION_H_*/
