#ifndef GGAFCORE_GGAFLINEAROCTREE_H_
#define GGAFCORE_GGAFLINEAROCTREE_H_
#include "GgafCommonHeader.h"
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/core/util/GgafTreeSpace.hpp"
#include "jp/ggaf/core/util/GgafTreeElem.hpp"

namespace GgafCore {

/**
 * `؃NX .
 * `؂Ƃ́A؋ԕ@̊eԂA̔z(`)ɕׂԂӖ܂B
 * {NXł̗p̂悤ɒ߂鎖ƂB
 * ̐}RgAAŕ\łȂ߁A4؂̐}Ɍt̐邪B{NX̋@\͗̂̔؂łB
 * <pre><code>
 *  +-----------+
 *  |           |
 *  |           |
 *  |     0     |
 *  |           |   Lv0 
 *  |           |
 *  |           |
 *  +-----------+
 *
 *  +-----+-----+
 *  |     |     |
 *  |  0  |  1  |
 *  |     |     |
 *  +-----+-----+   Lv1 
 *  |     |     |
 *  |  2  |  3  |
 *  |     |     |
 *  +-----+-----+
 *
 *  +--+--+--+--+
 *  | 0| 1| 4| 5|
 *  +--+--+--+--+
 *  | 2| 3| 6| 7|
 *  +--+--+--+--+   Lv2 
 *  | 8| 9|12|13|
 *  +--+--+--+--+
 *  |10|11|14|15|
 *  +--+--+--+--+
 * </code></pre>
 * <BR>
 * <B>p`</B>
 * <BR>
 * <B>[g</B><BR>
 * Ẑ悤ȏԂŔԍU@ԂwtB
 * 4؂ł͕ʂ4AEAAȄŐUu@v̎B<BR>
 * 8؂ł͗̋ԁíj8AZ*2ŔԍUu@v̎wB<BR>
 * <BR>
 * <B>ԃx</B><BR>
 * L}̉EɏĂAeԂ̃xwB<BR>
 * <BR>
 * <B>[gʂԍAԔԍ</B><BR>
 * L}̊eLevelԂɐUĂ镪Ԃ̔ԍ̂ƂwƂB<BR>
 * L}̗łLv1Ԃ̃[gʂԍ 0`3ALv2Ԃ̃[gʂԍ0`15 Ƃ悤ɎgB<BR>
 * ۂ͔؂ŗ̂Ȃ̂ŁBLv1ԃ[gʂԍ0`7ALv2ԃ[gʂԍ0`63 ɂȂB<BR>
 * <BR>
 * <B>qԁAeԁBiqxAexj</B><BR>
 * ԃx +1 qԁAԃx -1 eԂƌĂԂƂɂB<BR>
 * <BR>
 * <B>[gʒu</B><BR>
 * Ԃ4AAEAAE
 * ꂼ 0 1 2 3 (8؂ł 0`7)ƕ\ꍇA
 *  0 1 2 3 ̎[gʒuƌĂԂƂƂB<BR>
 * <BR>
 * <B>(z)vfԍ</B><BR>
 * ԔԍɑΉ`z̃CfbNXwB<BR>
 * ̓Iɂ _paOctant ̗vfԍB<BR>
 * <BR>
 *
 *  <B>yPz</B><BR>
 *  Lv2 Ԃ [gʒu 2 ̋ԂƂ
 *  <pre><code>
 *  +--+--+
 *  | 8| 9|
 *  +--+--+
 *  |10|11|
 *  +--+--+
 *  </code></pre>
 *  wƂƂB<BR>
 *
 *  <B>yQz</B><BR>
 *  uLv1Ԃ̋Ԕԍ3̎qԂ̃[gʒu2vƕ\ꍇ́A
 *  Lv1̋Ԕԍ3̎qԁLv2ԂS̉E
 *  <pre><code>
 *  +--+--+
 *  |12|13|
 *  +--+--+
 *  |14|15|
 *  +--+--+
 *  </code></pre>
 *  ̂ƂwÃ[gʒu2Ȃ̂ŁALv2ԃ[gʂԍ<B>14</B>wĂ邱ƂƂB<BR>
 *  y̑gpz<BR>
 *  ELv1 Ԃ̃[gʒu 1  Lv2 Ԃ̋Ԕԍ 4 5 6 7 ɓB<BR>
 *  ELv2 Ԕԍ 13 ́AeԂ̃[gʒu 3 ɑ݂B<BR>
 *  Ƃ悤ɕ\肷iƒ`jB<BR>
 * <BR>
 * yӎz<BR>
 * {vÓA<BR>
 * u~i܂؂j[ǂƃRv http://marupeke296.com/index.html<BR>
 * TCgRec u15 8؋ԕœKIv http://marupeke296.com/COL_3D_No15_Octree.html<BR>
 * ̋LQlɁiƂwǂ̂܂܁j쐬Ă܂B<BR>
 * ڂ؂̔ɉ₷Ɋӂ܂B<BR>
 * <BR>
 * @version 1.00
 * @since 2009/11/23
 * @author Masatoshi Tsuge
 */
class GgafLinearOctree : public GgafObject {

private:
    /**
     * LevelԂ̔؃[g̒ʂԔԍ擾 .
     * LevelƂ <BR>
     * uƌʂ͓levelԂłv<BR>
     * ƂӖB{\bḧ͔CӂLevelԂ󂯓B<BR>
     * Ă邱Ƃ<BR>
     * Eꂼ3bitƂɊԊuJ<BR>
     * E2̌ʂ1rbgA2̌ʂ2rbg  炵 OR <BR>
     * ȏB<BR>
     * <BR>
     * }ƁA܂
     * <pre><code>
     * 000000000000000000000000abcdefgh ,
     * 000000000000000000000000ijklmnop ,
     * 000000000000000000000000qrstuvwx
     * 
     * 00000000 00a 00b 00c 00d 00e 00f 00g 00h  --> X
     * 00000000 0i0 0j0 0k0 0l0 0m0 0n0 0o0 0p0  --> Y
     * 00000000 q00 r00 s00 t00 u00 v00 w00 x00  --> Z
     * āAOR(̌)߂lɂȂBӖ́A
     * 00000000 qia rjb skc tld ume vnf wog xph
     *                                      ^^^-->&B(xph)       = Level̋Ԃ̃[gʂԔԍ 0`7
     *                                  ^^^^^^^-->&B(wogxph)    = Level̐eԂ̃[gʂԔԍ 0`63
     *                              ^^^^^^^^^^^-->&B(vnfwogxph) = Level̐e̐eԂ̃[gʂԔԍ 0`511
     *                          ^^^ ^^^ ^^^ ^^^
     *                           |   |   |   |
     *                           |   |   |   &B(xph) = Level̋Ԃ̃[g̈ʒu 0`7
     *             ............  |   |   `---&B(wog) = Level̐eԂ̃[g̈ʒu  0`7
     *                           |   `-------&B(vnf) = Level̐e̐e̋Ԃ̃[g̈ʒu 0`7
     * </code></pre>
     * @param x_space_index ̃xԂxWԃCfbNX ( 0`255 Ƃ)
     * @param y_space_index ̃xԂyWԃCfbNX ( 0`255 Ƃ)
     * @param z_space_index ̃xԂzWԃCfbNX ( 0`255 Ƃ)
     * @return LevellԂ(x_index, y_index, z_index)ŎԂɑΉ
     *         ؃[g̒ʂԔԍ(őLevel8ŁA0`23068671)
     */
    static inline uint32_t getMortonOrderNumFromXYZindex( uint32_t x_space_index, uint32_t y_space_index, uint32_t z_space_index ) {
        return GgafLinearOctree::separateEveryThirdBit(x_space_index)    |
               GgafLinearOctree::separateEveryThirdBit(y_space_index)<<1 |
               GgafLinearOctree::separateEveryThirdBit(z_space_index)<<2;
    }


    /**
     * 3bitƂɊԊuJ .
     * <pre><code>
     * 000000000000000000000000abcdefgh  
     * 0000000000a00b00c00d00e00f00g00h  ɂ܂
     * ASY
     * n          = 0000 0000 0000 0000 0000 0000 abcd efgh ̂Ƃ
     * n<<8       = 0000 0000 0000 0000 abcd efgh 0000 0000
     * n|n<<8     = 0000 0000 0000 0000 abcd efgh abcd efgh
     * 0x0000f00f = 0000 0000 0000 0000 1111 0000 0000 1111 ł̂
     * (n|n<<8) & 0x0000f00f =
     *              0000 0000 0000 0000 abcd 0000 0000 efgh ƂȂB
     * ̌ʂ܂ n ɑ
     * n          = 0000 0000 0000 0000 abcd 0000 0000 efgh
     * ȉl
     * n<<4       = 0000 0000 0000 abcd 0000 0000 efgh 0000
     * n|n<<4     = 0000 0000 0000 abcd abcd 0000 efgh efgh
     * 0x000c30c3 = 0000 0000 0000 1100 0011 0000 1100 0011
     * n  (n|n<<4) & 0x000c30c3 =
     *              0000 0000 0000 ab00 00cd 0000 ef00 00gh
     * n<<2       = 0000 0000 00ab 0000 cd00 00ef 0000 gh00
     * n|n(n<<2)  = 0000 0000 00ab ab00 cdcd 00ef ef00 ghgh
     * 0x00249249 = 0000 0000 0010 0100 1001 0010 0100 1001
     * n  (n|n<<2) & 0x00249249 =
     *              0000 0000 00a0 0b00 c00d 00e0 0f00 g00h
     * </code></pre>
     * @param n 0`255܂ł̐l
     * @return 3bitƂɊԊu󂯂ꂽl
     */
    static inline uint32_t separateEveryThirdBit(uint32_t n) {
        n = ( n | n<<8 ) & 0x0000f00f;
        n = ( n | n<<4 ) & 0x000c30c3;
        n = ( n | n<<2 ) & 0x00249249;
        return n;
    }

public:
    /** [r]؂̋Ԃ꒼ɕׂ`z */
    GgafTreeSpace<3u>* _paOctant; //_paOctant[0]  ROOTԂւ̃|C^
    /** [r]؂̋Ԃɓo^svf̐擪vf */
    GgafTreeElem<3u>* _pRegElemFirst;
    /** [r]rootԂ̑Ίp̒_ƂȂxW̏ */
    int _root_x1;
    /** [r]rootԂ̑Ίp̒_ƂȂyW̏ */
    int _root_y1;
    /** [r]rootԂ̑Ίp̒_ƂȂzW̏ */
    int _root_z1;
    /** [r]rootԂ̑Ίp̒_ƂȂxW傫 */
    int _root_x2;
    /** [r]rootԂ̑Ίp̒_ƂȂyW傫 */
    int _root_y2;
    /** [r]rootԂ̑Ίp̒_ƂȂzW傫 */
    int _root_z2;
    /** [r]ŏ(=ō̋)1ԂX̋ */
    int _top_level_dx;
    /** [r]ŏ(=ō̋)1ԂY̋ */
    int _top_level_dy;
    /** [r]ŏ(=ō̋)1ԂZ̋ */
    int _top_level_dz;

    double _r_top_level_dx;
    double _r_top_level_dy;
    double _r_top_level_dz;

    /** [r]8̗ݏ̒l\ߌvZĕێĂz */
    uint32_t* _pa_8pow;
    /** [r]SԐ */
    uint32_t _num_space;
    /** [r]őԃx */
    int _top_space_level; //[gԂLevel=0

public:
    /**
     * `؋Ԃ\z.
     * @param prm_level \zԃx
     */
    GgafLinearOctree(int prm_level);

    /**
     * ԃx0͈̎͂XV.
     * ύX\B
     * @param x1 \zOg̋ԍW
     * @param y1 V
     * @param z1 V
     * @param x2 V
     * @param y2 V
     * @param z2 V
     */
    virtual void setRootOctant(int x1, int y1, int z1,
                               int x2, int y2, int z2);

    /**
     * vf𔪕؋Ԃɓo^
     * Ԕԍ͈͊OɂȂꍇ͖B
     * @param prm_pElem vf
     * @param tx1 vfΏۃIuWFNg̊Og̍W
     * @param ty1 V
     * @param tz1 V
     * @param tx2 V
     * @param ty2 V
     * @param tz2 V
     */
    void registerElem(GgafTreeElem<3u>* const prm_pElem,
                      int tx1, int ty1, int tz1,
                      int tx2, int ty2, int tz2);

    /**
     * ؋Ԃɓo^ĂSvfiԂɂj.
     * {\bhNAȂ΁A<BR>
     * registerElem() <BR>
     * ɂ蔪؂֍ēxvfo^\ƂȂB
     */
    void clearAllElem();

    /**
     * fobOpBؓo^󋵏óixW܂łΉĂȂj .
     */
    void putTree();

    virtual ~GgafLinearOctree();
};

}
#endif /*GGAFCORE_GGAFLINEAROCTREE_H_*/

