#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"

#include <math.h>
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantB.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantC.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxKuroko::GgafDxKuroko(GgafDxGeometricActor* prm_pActor) : GgafObject(),
_pActor(prm_pActor) {

    _pAsstA = nullptr;
    _pAsstB = nullptr;
    _pAsstC = nullptr;

    _actor_ang_face[0] = &(prm_pActor->_rx);
    _actor_ang_face[1] = &(prm_pActor->_ry);
    _actor_ang_face[2] = &(prm_pActor->_rz);

    for (int ax = 0; ax < 3; ax++) { // i=0:XA1:YA2:Z \
        //ʕp̊pxiʕp̑j= 0 angle/fream
        _angvelo_face[ax] = 0; //1t[ɉZ鐳ʕp̊pBftHg͐ʕp̊pA܂UB
        //ʕp̊px  360,000 angle/fream
        _top_angvelo_face[ax] = D360ANG; //_angvelo_face[n] ̑̏BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊px  -360,000 angle/fream
        _bottom_angvelo_face[ax] = D360ANG * -1; //_angvelo_face[n] ̑̉BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊pxipx̑j  0 angle/fream^2
        _angacce_face[ax] = 0; //_angvelo_face[n] ̑BftHg͐ʕp̊px

        _angjerk_face[ax] = 0;
        //ڕWʕpւ̎tO = 
        _is_targeting_ang_face[ax] = false;
        //ڕWʕpւ̎~tO = 
        _ang_face_targeting_stop_flg[ax] = false;
        //ڕW̐ʕp
        _target_ang_face[ax] = 0; //ڕWʕpւ̎tO = Ȁꍇ͖Ӗ
        //ڕW̐ʕp~@\LɂȂ]
        _ang_face_stop_allow_way[ax] = TURN_BOTH;
        //ڕW̐ʕp~@\LɂȂpxi]ʁj
        _ang_face_stop_allow_angvelo[ax] = D360ANG;
    }

    //////////////////////////////////////////////////////
    //L̈ړpPʃxNg
    _vX = 1.0f;
    _vY = _vZ = 0.0f;
    //ړpZ]
    _ang_rz_mv = 0;
    //ړpY]
    _ang_ry_mv = 0;
    //ړx
    _velo_mv = 0;
    //ړx = 256 px/fream
    _top_velo_mv = INT_MAX; //_velo_mv  256000(=256px) ړʂłĂAIɍW 256px ɗ}B
    //ړx = 0   px/fream
    _bottom_velo_mv = INT_MIN; //_velo_mv  -256000(-256px) ړʂĂAIɍW -256000px ɗ}B
    //ړxiړx̑j = 0 px/fream^2
    _acc_mv = 0; //_velo_mv ̑BftHg͉

    //_jerkMv = 0;
    //ړpiZ]j̊px = 0 angle/fream
    _angvelo_rz_mv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiZ]j̊px = +360,000 angle/fream
    _top_angvelo_rz_mv = D360ANG; //_angvelo_rz_mv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = -360,000 angle/fream
    _bottom_angvelo_rz_mv = D360ANG * -1; //_angvelo_rz_mv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = 0 angle/fream^2
    _angacce_rz_mv = 0; //_angvelo_rz_mv ̑BftHg͈ړp̊px

    _angjerk_rz_mv = 0;
    //ڕWړpiZ]jւ̎tO = 
    _is_targeting_ang_rz_mv = false;
    //ڕWړpiZ]jւ̎~tO = 
    _ang_rz_mv_targeting_stop_flg = false;

    //ڕẄړpiZ]j
    _target_ang_rz_mv = 0;
    //ڕẄړpiZ]j~@\LɂȂ]
    _ang_rz_mv_stop_allow_way = TURN_BOTH;
    //ڕẄړpiZ]j~@\LɂȂړppx(px)
    _ang_rz_mv_stop_allow_angvelo = D360ANG;
    //ړpiZ]jɔZʕp̓@\tO  
    _relate_RzFaceAng_with_RzMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    //ړpiY]j̊px = 0 angle/fream
    _angvelo_ry_mv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiY]j̊px = +360,000 angle/fream
    _top_angvelo_ry_mv = D360ANG; //_angvelo_ry_mv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = -360,000 angle/fream
    _bottom_angvelo_ry_mv = D360ANG * -1; //_angvelo_ry_mv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = 0 angle/fream^2
    _angacce_ry_mv = 0; //_angvelo_ry_mv ̑BftHg͈ړp̊px

    _angjerk_ry_mv = 0;
    //ڕWړpiY]jւ̎tO = 
    _is_targeting_ang_ry_mv = false;
    //ڕWړpiY]jւ̎~tO = 
    _ang_ry_mv_targeting_stop_flg = false;
    //ڕẄړpiY]j
    _target_ang_ry_mv = 0;
    //ڕẄړpiY]j~@\LɂȂ]
    _ang_ry_mv_stop_allow_way = TURN_BOTH;
    //ڕẄړpiY]j~@\LɂȂړppx(px)
    _ang_ry_mv_stop_allow_angvelo = D360ANG;
    //ړpiY]jɔZʕp̓@\tO  
    _relate_RyFaceAng_with_RyMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    _taget_face_ang_alltime_flg = false;
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_tx = 0;
    _taget_face_ang_alltime_ty = 0;
    _taget_face_ang_alltime_tz = 0;
    _taget_face_ang_alltime_angVelo = 0;
    _taget_face_ang_alltime_angAcce = 0;
    _taget_face_ang_alltime_way = TURN_CLOSE_TO;
    _taget_face_ang_alltime_optimize_ang = true;

}
GgafDxKurokoAssistantA* GgafDxKuroko::asstA() {
    return _pAsstA ? _pAsstA : _pAsstA = NEW GgafDxKurokoAssistantA(this);
}
GgafDxKurokoAssistantB* GgafDxKuroko::asstB() {
    return _pAsstB ? _pAsstB : _pAsstB = NEW GgafDxKurokoAssistantB(this);
}
GgafDxKurokoAssistantC* GgafDxKuroko::asstC() {
    return _pAsstC ? _pAsstC : _pAsstC = NEW GgafDxKurokoAssistantC(this);
}
void GgafDxKuroko::behave() {
    if (_pAsstA) {
        _pAsstA->behave();
    }
    if (_pAsstB) {
        _pAsstB->behave();
    }
    if (_pAsstC) {
        _pAsstC->behave();
    }

    //ʕp
    for (axis ax = 0; ax < 3; ax++) {

        _angvelo_face[ax] += _angacce_face[ax];
        if (_angvelo_face[ax] > _top_angvelo_face[ax]) {
            _angvelo_face[ax] = _top_angvelo_face[ax];
        } else if (_angvelo_face[ax] < _bottom_angvelo_face[ax]) {
            _angvelo_face[ax] = _bottom_angvelo_face[ax];
        }

        if (_is_targeting_ang_face[ax]) { //^[Qbgꍇ

            if (_angvelo_face[ax] > 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance(ax, _target_ang_face[ax], TURN_COUNTERCLOCKWISE);
                if (_angvelo_face[ax] > angDistance && _ang_face_stop_allow_way[ax] != TURN_CLOCKWISE &&
                        _ang_face_stop_allow_angvelo[ax] >= _angvelo_face[ax]) {
                    _angvelo_face[ax] = angDistance;
                    if (_ang_face_targeting_stop_flg[ax]) {
                        _is_targeting_ang_face[ax] = false; //tO߂ďI
                        _ang_face_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else if (_angvelo_face[ax] < 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance(ax, _target_ang_face[ax], TURN_CLOCKWISE);
                if (_angvelo_face[ax] < angDistance && _ang_face_stop_allow_way[ax] != TURN_COUNTERCLOCKWISE
                        && -1 * _ang_face_stop_allow_angvelo[ax] <= _angvelo_face[ax]) { //ڕWs߂Ă܂EEEȓ
                    _angvelo_face[ax] = angDistance;
                    if (_ang_face_targeting_stop_flg[ax]) {
                        _is_targeting_ang_face[ax] = false; //tO߂ďI
                        _ang_face_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else {
                //_angvelo_face[ax] == 0
                angle angDistance = getFaceAngDistance(ax, _target_ang_face[ax], TURN_CLOSE_TO);
                if (angDistance == 0) {
                    if (_ang_face_targeting_stop_flg[ax]) {
                        _is_targeting_ang_face[ax] = false; //tO߂ďI
                        _ang_face_targeting_stop_flg[ax] = false;
                    }
                }
            }

            //Actorɔf
            (*(_actor_ang_face[ax])) = UTIL::simplifyAng((*(_actor_ang_face[ax])) + _angvelo_face[ax]);
            if (_is_targeting_ang_face[ax] == false) {
                //ڕWɓB̏
                //_top_angvelo_face[ax] = D360ANG; //ʕp̊px  360,000 angle/fream
                //_bottom_angvelo_face[ax] = D360ANG * -1; //ʕp̊px  -360,000 angle/fream
                //ڕWɓBA~sȂ
                _angacce_face[ax] = 0; //]pApxO
                setFaceAngVelo(ax, 0); //]pApxO
            }

        } else {
            //^[Qbgꍇ
            //Actorɔf
            (*(_actor_ang_face[ax])) = UTIL::simplifyAng((*(_actor_ang_face[ax])) +  _angvelo_face[ax]);
        }

    }


    ///////////////////////////////////////////////////Mover

    //_acc_mv += _jerkMv;
    //ړx̏
    _velo_mv += _acc_mv;
    if (_velo_mv > _top_velo_mv) {
        _velo_mv = _top_velo_mv;
    } else if (_velo_mv < _bottom_velo_mv) {
        _velo_mv = _bottom_velo_mv;
    }

    ///////////
    //ڕWړpiZ]jAO~@\gp̏ꍇ
    if (_is_targeting_ang_rz_mv) {

        _angvelo_rz_mv += _angacce_rz_mv;
        setRzMvAngVelo(_angvelo_rz_mv);

        if (_angvelo_rz_mv > 0) { //v̏ꍇ
            angle angDistance = getRzMvAngDistance(_target_ang_rz_mv, TURN_COUNTERCLOCKWISE);
            if (_angvelo_rz_mv > angDistance && _ang_rz_mv_stop_allow_way != TURN_CLOCKWISE
                    && _ang_rz_mv_stop_allow_angvelo >= _angvelo_rz_mv) { //ڕWs߂Ă܂EEEȓ
                addRzMvAng(angDistance);
                if (_ang_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_rz_mv = false; //tO߂ďI
                    _ang_rz_mv_targeting_stop_flg = false;
                }
            } else {
                addRzMvAng(_angvelo_rz_mv);
            }
        } else if (_angvelo_rz_mv < 0) { //v̏ꍇ

            angle angDistance = getRzMvAngDistance(_target_ang_rz_mv, TURN_CLOCKWISE);
            if (_angvelo_rz_mv < angDistance && _ang_rz_mv_stop_allow_way != TURN_COUNTERCLOCKWISE
                    && -1*_ang_rz_mv_stop_allow_angvelo <= _angvelo_rz_mv) {
                addRzMvAng(angDistance);
                if (_ang_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_rz_mv = false; //tO߂ďI
                    _ang_rz_mv_targeting_stop_flg = false;
                }
            } else {
                addRzMvAng(_angvelo_rz_mv);
            }
        } else {
            angle angDistance = getRzMvAngDistance(_target_ang_rz_mv, TURN_CLOSE_TO);
            if (angDistance == 0) {
                addRzMvAng(angDistance);
                if (_ang_rz_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_rz_mv = false; //tO߂ďI
                    _ang_rz_mv_targeting_stop_flg = false;
                }
            }
        }
        if (_is_targeting_ang_rz_mv == false) {
            //_top_angvelo_rz_mv = D360ANG; //ړpiZ]j̊px  360,000 angle/fream
            //_bottom_angvelo_rz_mv = D360ANG * -1; //ړpiZ]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacce_rz_mv = 0; //ZړpApxO
            setRzMvAngVelo(0); //ZړpApxO
        }

    } else {
        //if (_angacce_rz_mv != 0) {

        _angacce_rz_mv += _angjerk_rz_mv;
        //t[̈ړpiZ]j̏
        _angvelo_rz_mv += _angacce_rz_mv;
        if (_angvelo_rz_mv != 0) {
            addRzMvAng(_angvelo_rz_mv);
        }
        //}
    }
    ////////////////
    //ڕWړpiY]jAO~@\gp̏ꍇ
    if (_is_targeting_ang_ry_mv) {

        _angvelo_ry_mv += _angacce_ry_mv;
        setRyMvAngVelo(_angvelo_ry_mv);

        if (_angvelo_ry_mv > 0) { //݂͔v̏ꍇ
            angle angDistance = getRyMvAngDistance(_target_ang_ry_mv, TURN_COUNTERCLOCKWISE);
            if (_angvelo_ry_mv > angDistance &&
                _ang_ry_mv_stop_allow_way != TURN_CLOCKWISE &&
                _ang_ry_mv_stop_allow_angvelo >= _angvelo_ry_mv)
            { //ڕWs߂Ă܂EEEȓ
                addRyMvAng(angDistance);
                if (_ang_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_ry_mv = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angvelo_ry_mv);
            }
        } else if (_angvelo_ry_mv < 0) { //݂͎v̏ꍇ

            angle angDistance = getRyMvAngDistance(_target_ang_ry_mv, TURN_CLOCKWISE);
            if (_angvelo_ry_mv < angDistance &&
                _ang_ry_mv_stop_allow_way != TURN_COUNTERCLOCKWISE &&
                -1*_ang_ry_mv_stop_allow_angvelo <= _angvelo_ry_mv)
            {
                addRyMvAng(angDistance);
                if (_ang_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_ry_mv = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angvelo_ry_mv);
            }
        } else { //_angvelo_ry_mv==0
            angle angDistance = getRyMvAngDistance(_target_ang_ry_mv, TURN_CLOSE_TO);
            if (angDistance == 0) {
                addRyMvAng(angDistance);
                if (_ang_ry_mv_targeting_stop_flg) { //~w肠Ȃ
                    _is_targeting_ang_ry_mv = false; //tO߂ďI
                    _ang_ry_mv_targeting_stop_flg = false;
                }
            }
        }
        if (_is_targeting_ang_ry_mv == false) {
            //_top_angvelo_ry_mv = D360ANG; //ړpiY]j̊px  360,000 angle/fream
            //_bottom_angvelo_ry_mv = D360ANG*-1; //ړpiY]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacce_ry_mv = 0; //YړpApxO
            setRyMvAngVelo(0); //YړpApxO
        }

    } else {
        //if (_angacce_ry_mv != 0) {
        _angacce_ry_mv += _angjerk_ry_mv;
        //t[̈ړpiY]j̏
        _angvelo_ry_mv += _angacce_ry_mv;
        if(_angvelo_ry_mv != 0) {
            addRyMvAng(_angvelo_ry_mv);
        }
        //}
    }

    ///////////////
    if (_taget_face_ang_alltime_flg && _is_targeting_ang_face[AXIS_Z] == false && _is_targeting_ang_face[AXIS_Y] == false) {
        if (_taget_face_ang_alltime_pActor) {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        } else {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor->_x,
                    _taget_face_ang_alltime_pActor->_y,
                    _taget_face_ang_alltime_pActor->_z,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        }

    }
    //Actorɔf
    _pActor->_x += (coord)(_vX * _velo_mv);
    _pActor->_y += (coord)(_vY * _velo_mv);
    _pActor->_z += (coord)(_vZ * _velo_mv);
}

void GgafDxKuroko::setFaceAngVelo(axis prm_axis, angvelo prm_angvelo) {
    if (prm_angvelo > _top_angvelo_face[prm_axis]) {
        _angvelo_face[prm_axis] = _top_angvelo_face[prm_axis];
    } else if (prm_angvelo < _bottom_angvelo_face[prm_axis]) {
        _angvelo_face[prm_axis] = _bottom_angvelo_face[prm_axis];
    } else {
        _angvelo_face[prm_axis] = prm_angvelo;
    }
}

void GgafDxKuroko::setFaceAngVelo(angvelo prm_axis_x_angvelo,
                                  angvelo prm_axis_y_angvelo,
                                  angvelo prm_axis_z_angvelo) {
    setFaceAngVelo(AXIS_X, prm_axis_x_angvelo);
    setFaceAngVelo(AXIS_Y, prm_axis_y_angvelo);
    setFaceAngVelo(AXIS_Z, prm_axis_z_angvelo);
}

void GgafDxKuroko::forceFaceAngVeloRange(axis prm_axis,
                                         angvelo prm_angvelo01,
                                         angvelo prm_angvelo02) {
    if (prm_angvelo01 < prm_angvelo02) {
        _top_angvelo_face[prm_axis] = prm_angvelo02;
        _bottom_angvelo_face[prm_axis] = prm_angvelo01;
    } else {
        _top_angvelo_face[prm_axis] = prm_angvelo01;
        _bottom_angvelo_face[prm_axis] = prm_angvelo02;
    }
    setFaceAngVelo(prm_axis, _angvelo_face[prm_axis]); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setFaceAngAcce(axis prm_axis, angacce prm_angacce) {
    _angacce_face[prm_axis] = prm_angacce;
}

void GgafDxKuroko::setStopTargetFaceAngTwd(axis prm_axis,
                                           coord prm_tx,
                                           coord prm_ty,
                                           int prm_way_allow,
                                           angvelo prm_angvelo_allow) {
    setStopTargetFaceAng(
      prm_axis,
      UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)),
      prm_way_allow,
      prm_angvelo_allow
    );
}

void GgafDxKuroko::setStopTargetFaceAng(axis prm_axis,
                                        angle prm_ang_target,
                                        int prm_way_allow,
                                        angvelo prm_angvelo_allow) {
    _is_targeting_ang_face[prm_axis] = true;
    _ang_face_targeting_stop_flg[prm_axis] = true;
    _target_ang_face[prm_axis] = UTIL::simplifyAng(prm_ang_target);
    _ang_face_stop_allow_way[prm_axis] = prm_way_allow;
    _ang_face_stop_allow_angvelo[prm_axis] = prm_angvelo_allow;
}

angle GgafDxKuroko::getFaceAngDistance(axis prm_axis, coord prm_tx, coord prm_ty, int prm_way) {
    return getFaceAngDistance(
               prm_axis,
               UTIL::getAngle2D(prm_tx-(_pActor->_x), prm_ty-(_pActor->_y)),
               prm_way);
}

angle GgafDxKuroko::getFaceAngDistance(axis prm_axis, angle prm_ang_target, int prm_way) {
    return UTIL::getAngDiff( (*(_actor_ang_face[prm_axis])),  prm_ang_target, prm_way);
}

void GgafDxKuroko::forceMvVeloRange(velo prm_velo) {
    forceMvVeloRange(-prm_velo, prm_velo);
}

void GgafDxKuroko::forceMvVeloRange(velo prm_velo_mv01, velo prm_velo_mv02) {
    if (prm_velo_mv01 < prm_velo_mv02) {
        _top_velo_mv = prm_velo_mv02;
        _bottom_velo_mv = prm_velo_mv01;
    } else {
        _top_velo_mv = prm_velo_mv01;
        _bottom_velo_mv = prm_velo_mv02;
    }
    setMvVelo(_velo_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setMvVelo(velo prm_velo_mv) {
    if (prm_velo_mv > _top_velo_mv) {
        _velo_mv = _top_velo_mv;
    } else if (prm_velo_mv < _bottom_velo_mv) {
        _velo_mv = _bottom_velo_mv;
    } else {
        _velo_mv = prm_velo_mv;
    }
}

void GgafDxKuroko::addMvVelo(velo prm_velo_mv_Offset) {
    setMvVelo(_velo_mv + prm_velo_mv_Offset);
}

void GgafDxKuroko::setMvAcce(int prm_acceMove) {
    _acc_mv = prm_acceMove;
}

frame GgafDxKuroko::setMvAcceToStop(coord prm_target_distance) {
    double acc = UTIL::getAcceToStop(prm_target_distance, _velo_mv);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    return (frame)((2.0*prm_target_distance) / _velo_mv); //gpt[
}

frame GgafDxKuroko::setFaceAngAcceToStop(axis prm_axis, angle prm_target_angle_distance) {
    double acc = UTIL::getAcceToStop(prm_target_angle_distance, _angvelo_face[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    return (frame)((2.0*prm_target_angle_distance) / _angvelo_face[prm_axis]); //gpt[
}

frame GgafDxKuroko::setMvAcceByD(coord prm_target_distance, velo prm_target_velo) {
    double acc = UTIL::getAcceByVd(_velo_mv, prm_target_velo, prm_target_distance);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    return (frame)((1.0*prm_target_velo - _velo_mv) / acc); //gpt[
}
frame GgafDxKuroko::setFaceAngAcceByD(axis prm_axis, angle prm_target_angle_distance, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByVd(prm_target_angvelo, prm_target_angle_distance, _angvelo_face[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    return (frame)((1.0*prm_target_angvelo - _angvelo_face[prm_axis]) / acc); //gpt[
}
    // y⑫z
    // V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇ́AD(ڕW)LŖȂB
    // ł
    // V0 < 0     Vt > 0  ꍇA邢  V0 > 0     Vt < 0   ꍇ́AǂȂ邩H
    //
    //    x(v)
    //     ^        a:x
    //     |        D:ړiڕWBxɒB܂łɔ₷j
    //     |       V0:_̑x
    //     |       Vt:ڕWBx
    //     |       Te:ڕWBxɒB̎ԁit[j
    //  V0 |
    //     |_
    //     |  _  Xa
    //     | D1 _
    //     |      _ Tc     Te
    //   --+--------_------+---> (t)
    //   0 |          _ D2 |
    //     |            _  |
    //   Vt|.............._|
    //     |
    //
    //    D Ŝ̈ړƂ
    //    D = D1 - D2 , v = 0  t  Tc Ƃ
    //
    //    D1 = (1/2) V0 Tc
    //    D2 = (1/2) -Vt (Te - Tc)
    //    D = D1 - D2 
    //    D = (1/2) V0 Tc -  { (1/2) -Vt (Te - Tc) }
    //      = (V0 Tc + Vt Te - Vt Tc) / 2    EEE@
    //
    //     v = a t + V0 ɂ v = 0  t = Tc ł̂
    //    0 = a Tc + V0
    //    Tc = -V0 / a
    //     @ ֑
    //    D = (V0 (-V0 / a) + Vt Te - Vt (-V0 / a)) / 2 EEEA
    //    ܂ a = (Vt - V0) / Te ł̂
    //    Te = (Vt - V0) / a  A ֑
    //    
    //    D = (V0 (-V0 / a) + Vt ((Vt - V0) / a) - Vt (-V0 / a)) / 2
    //
    //    a ɂĉ
    //
    //    D = ( -(V0^2) / a  + (Vt (Vt - V0)) / a + (Vt V0) / a) / 2
    //    a D = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2
    //    a = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2D
    //    a = (-(V0^2) + Vt^2 - Vt V0 + Vt V0) / 2D
    //    a = (Vt^2 - V0^2) / 2D
    //
    //     a = (Vt^2 - V0^2) / 2D ƂȂ̂
    //    V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇƓł

coord GgafDxKuroko::setMvAcceByT(frame prm_target_frames, velo prm_target_velo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _velo_mv, prm_target_velo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _acc_mv = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_velo_mv + prm_target_velo) * prm_target_frames) / 2 ;
}
angle GgafDxKuroko::setFaceAngAcceByT(axis prm_axis, frame prm_target_frames, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _angvelo_face[prm_axis], prm_target_angvelo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacce_face[prm_axis] = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_angvelo_face[prm_axis] + prm_target_angvelo) * prm_target_frames) / 2 ;
}

void GgafDxKuroko::setRzMvAng(angle prm_ang) {
    if (prm_ang !=  _ang_rz_mv) {
        _ang_rz_mv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_ang_rz_mv, _ang_ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _ang_rz_mv;
    }
}

void GgafDxKuroko::addRzMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_bottom_angvelo_rz_mv > prm_angDistance) {
        angOffset = _bottom_angvelo_rz_mv;
    } else if (prm_angDistance > _top_angvelo_rz_mv) {
        angOffset = _top_angvelo_rz_mv;
    }
    setRzMvAng(_ang_rz_mv + angOffset);
}

void GgafDxKuroko::setRzMvAngVelo(angvelo prm_angvelo_rz_mv) {
    if (prm_angvelo_rz_mv > _top_angvelo_rz_mv) {
        _angvelo_rz_mv = _top_angvelo_rz_mv;
    } else if (prm_angvelo_rz_mv < _bottom_angvelo_rz_mv) {
        _angvelo_rz_mv = _bottom_angvelo_rz_mv;
    } else {
        _angvelo_rz_mv = prm_angvelo_rz_mv;
    }
}

void GgafDxKuroko::setRzMvAngAcce(angacce prm_angacce_rz_mv) {
    _angacce_rz_mv = prm_angacce_rz_mv;
}

void GgafDxKuroko::forceRzMvAngVeloRange(angvelo prm_angvelo_rz_mv01,
                                         angvelo prm_angvelo_rz_mv02) {
    if (prm_angvelo_rz_mv01 < prm_angvelo_rz_mv02) {
        _top_angvelo_rz_mv = prm_angvelo_rz_mv02;
        _bottom_angvelo_rz_mv = prm_angvelo_rz_mv01;
    } else {
        _top_angvelo_rz_mv = prm_angvelo_rz_mv01;
        _bottom_angvelo_rz_mv = prm_angvelo_rz_mv02;
    }
    setRzMvAngVelo(_angvelo_rz_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setStopTargetRzMvAng(angle prm_target_ang_rz_mv,
                                         int prm_way_allow,
                                         angvelo prm_angvelo_allow) {
    _is_targeting_ang_rz_mv = true;
    _ang_rz_mv_targeting_stop_flg = true;
    _target_ang_rz_mv = UTIL::simplifyAng(prm_target_ang_rz_mv);
    _ang_rz_mv_stop_allow_way = prm_way_allow;
    _ang_rz_mv_stop_allow_angvelo = prm_angvelo_allow;
}

angle GgafDxKuroko::getRzMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRzMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)), prm_way);
}

angle GgafDxKuroko::getRzMvAngDistance(angle prm_target_ang_rz_mv, int prm_way) {
    return UTIL::getAngDiff(_ang_rz_mv, prm_target_ang_rz_mv, prm_way);
}


//void GgafDxKuroko::setRyMvAngTwd(coord prm_tx, coord prm_ty) {
//    setRyMvAng(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)));
//}

void GgafDxKuroko::setRyMvAng(angle prm_ang) {
    if (prm_ang != _ang_ry_mv) {
        _ang_ry_mv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_ang_rz_mv, _ang_ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ang_ry_mv;
    }
}

void GgafDxKuroko::addRyMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_bottom_angvelo_ry_mv > prm_angDistance) {
        angOffset = _bottom_angvelo_ry_mv;
    } else if (prm_angDistance > _top_angvelo_ry_mv) {
        angOffset = _top_angvelo_ry_mv;
    }
    setRyMvAng(_ang_ry_mv + angOffset);
}

void GgafDxKuroko::setRyMvAngVelo(angvelo prm_angvelo_ry_mv) {
    if (prm_angvelo_ry_mv > _top_angvelo_ry_mv) {
        _angvelo_ry_mv = _top_angvelo_ry_mv;
    } else if (prm_angvelo_ry_mv < _bottom_angvelo_ry_mv) {
        _angvelo_ry_mv = _bottom_angvelo_ry_mv;
    } else {
        _angvelo_ry_mv = prm_angvelo_ry_mv;
    }
}

void GgafDxKuroko::setRyMvAngAcce(angacce prm_angacce_ry_mv) {
    _angacce_ry_mv = prm_angacce_ry_mv;
}

void GgafDxKuroko::forceRyMvAngVeloRange(angvelo prm_angvelo_ry_mv01,
                                         angvelo prm_angvelo_ry_mv02) {
    if (prm_angvelo_ry_mv01 < prm_angvelo_ry_mv02) {
        _top_angvelo_ry_mv = prm_angvelo_ry_mv02;
        _bottom_angvelo_ry_mv = prm_angvelo_ry_mv01;
    } else {
        _top_angvelo_ry_mv = prm_angvelo_ry_mv01;
        _bottom_angvelo_ry_mv = prm_angvelo_ry_mv02;
    }
    setRyMvAngVelo(_angvelo_ry_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::forceRzRyMvAngVeloRange(angvelo prm_angvelo_rzry_mv01, angvelo prm_angvelo_rzry_mv02) {
    if (prm_angvelo_rzry_mv01 < prm_angvelo_rzry_mv02) {
        _top_angvelo_rz_mv = prm_angvelo_rzry_mv02;
        _bottom_angvelo_rz_mv = prm_angvelo_rzry_mv01;
        _top_angvelo_ry_mv = prm_angvelo_rzry_mv02;
        _bottom_angvelo_ry_mv = prm_angvelo_rzry_mv01;
    } else {
        _top_angvelo_rz_mv = prm_angvelo_rzry_mv01;
        _bottom_angvelo_rz_mv = prm_angvelo_rzry_mv02;
        _top_angvelo_ry_mv = prm_angvelo_rzry_mv01;
        _bottom_angvelo_ry_mv = prm_angvelo_rzry_mv02;
    }
    setRzMvAngVelo(_angvelo_rz_mv); //Đݒ肵Ĕ͈͓ɕ␳
    setRyMvAngVelo(_angvelo_ry_mv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setRzRyMvAngAcce(angacce prm_angacce_rz_mv, angacce prm_angacce_ry_mv) {
    _angacce_rz_mv = prm_angacce_rz_mv;
    _angacce_ry_mv = prm_angacce_ry_mv;
}

void GgafDxKuroko::setRzRyMvAngVelo(angvelo prm_angvelo_rz_mv, angvelo prm_angvelo_ry_mv) {
    if (prm_angvelo_rz_mv > _top_angvelo_rz_mv) {
        _angvelo_rz_mv = _top_angvelo_rz_mv;
    } else if (prm_angvelo_rz_mv < _bottom_angvelo_rz_mv) {
        _angvelo_rz_mv = _bottom_angvelo_rz_mv;
    } else {
        _angvelo_rz_mv = prm_angvelo_rz_mv;
    }
    if (prm_angvelo_ry_mv > _top_angvelo_ry_mv) {
        _angvelo_ry_mv = _top_angvelo_ry_mv;
    } else if (prm_angvelo_ry_mv < _bottom_angvelo_ry_mv) {
        _angvelo_ry_mv = _bottom_angvelo_ry_mv;
    } else {
        _angvelo_ry_mv = prm_angvelo_ry_mv;
    }
}

void GgafDxKuroko::setStopTargetRyMvAng(angle prm_target_ang_ry_mv,
                                        int prm_way_allow,
                                        angvelo prm_angvelo_allow) {
    _is_targeting_ang_ry_mv = true;
    _ang_ry_mv_targeting_stop_flg = true;
    _target_ang_ry_mv = UTIL::simplifyAng(prm_target_ang_ry_mv);
    _ang_ry_mv_stop_allow_way = prm_way_allow;
    _ang_ry_mv_stop_allow_angvelo = prm_angvelo_allow;
}

angle GgafDxKuroko::getRyMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRyMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)),
                                        prm_way);
}

angle GgafDxKuroko::getRyMvAngDistance(angle prm_target_ang_ry_mv, int prm_way) {
    return UTIL::getAngDiff(_ang_ry_mv, prm_target_ang_ry_mv, prm_way);
}

void GgafDxKuroko::getRzRyMvAngDistanceTwd(angle prm_target_ang_rz, angle prm_target_ang_ry, int prm_way,
                                           angle& out_d_ang_rz, angle& out_d_ang_ry) {
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        //ڕWɓB邽߂ɂ́AɂQp^[B
        //ꂼꋅʏ̂Q_̋ȈՋߎlixD̂߁jŔrA߂Ǝvق̗pB
        angle d1_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_CLOSE_TO); //Rz̍
        angle d1_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_CLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_CLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) { //߂̗p
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) {
        angle d1_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 >= d2) { //艓̗p
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_COUNTERCLOCKWISE);
        angle d1_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_COUNTERCLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_COUNTERCLOCKWISE);
        angle d2_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_COUNTERCLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_CLOCKWISE);
        angle d1_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_CLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getRzMvAngDistance(prm_target_ang_rz, TURN_CLOCKWISE);
        angle d2_angRy = getRyMvAngDistance(prm_target_ang_ry, TURN_CLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else {
        //
        throwGgafCriticalException("GgafDxKuroko::getRzRyMvAngDistanceTwd() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKuroko::getRzRyFaceAngDistanceTwd(angle prm_target_ang_rz, angle prm_target_ang_ry,int prm_way,
                                               angle& out_d_ang_rz, angle& out_d_ang_ry) {
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_CLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_CLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_CLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }

    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 >= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_COUNTERCLOCKWISE);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_COUNTERCLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_COUNTERCLOCKWISE);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_COUNTERCLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_CLOCKWISE);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_CLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_ang_rz, prm_target_ang_ry);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_ang_rz, TURN_CLOCKWISE);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_ang_ry, TURN_CLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_ang_rz = d1_angRz;
            out_d_ang_ry = d1_angRy;
        } else {
            out_d_ang_rz = d2_angRz;
            out_d_ang_ry = d2_angRy;
        }
    } else {
        //
        throwGgafCriticalException("GgafDxKuroko::getRzRyMvAngDistanceTwd() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKuroko::setRzRyMvAng(angle prm_ang_rz, angle prm_ang_ry) {
    if (prm_ang_rz != _ang_rz_mv || prm_ang_ry !=_ang_ry_mv ) {
        _ang_rz_mv = UTIL::simplifyAng(prm_ang_rz);
        _ang_ry_mv = UTIL::simplifyAng(prm_ang_ry);
        UTIL::convRzRyToVector(_ang_rz_mv, _ang_ry_mv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _ang_rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ang_ry_mv;
    }
}

void GgafDxKuroko::setRzRyMvAng_by_RyRz(angle prm_ang_ryRz_Ry, angle prm_ang_ryRz_Rz) {
    angle RyRz_Ry = UTIL::simplifyAng(prm_ang_ryRz_Ry);
    angle RyRz_Rz = UTIL::simplifyAng(prm_ang_ryRz_Rz);
    float out_vY, out_vZ;
    UTIL::convRzRyToVector(RyRz_Ry, D360ANG-RyRz_Rz, _vX, out_vY, out_vZ);
    _vY = -1.0f*out_vZ;
    _vZ = out_vY;
    UTIL::convVectorToRzRy(_vX, _vZ, _vY, _ang_rz_mv, _ang_ry_mv);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _ang_rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ang_ry_mv;
    }
}


void GgafDxKuroko::setMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           _vX, _vY, _vZ,
                           _ang_rz_mv, _ang_ry_mv );
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _ang_rz_mv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _ang_ry_mv;
    }
}

void GgafDxKuroko::reverseMvAng() {
    _vX = -_vX;
    _vY = -_vY;
    _vZ = -_vZ;
    _ang_rz_mv = UTIL::simplifyAng(_ang_rz_mv-D180ANG);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _ang_rz_mv;
    }
}

void GgafDxKuroko::setStopTargetMvAngTwd(GgafDxGeometricActor* prm_pActor_Target) {
    setStopTargetMvAngTwd(
        prm_pActor_Target->_x,
        prm_pActor_Target->_y,
        prm_pActor_Target->_z
    );
}

void GgafDxKuroko::setStopTargetMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    angle angRz_Target;
    angle angRy_Target;
    float dummy1, dummy2, dummy3;

    UTIL::convVectorToRzRy(
                   prm_tx - _pActor->_x,
                   prm_ty - _pActor->_y,
                   prm_tz - _pActor->_z,
                   dummy1,
                   dummy2,
                   dummy3,
                   angRz_Target,
                   angRy_Target
                 );
    setStopTargetRzMvAng(angRz_Target);
    setStopTargetRyMvAng(angRy_Target);
}

void GgafDxKuroko::turnRzRyFaceAngTo(angle prm_ang_rz_target, angle prm_ang_ry_target,
                                     angvelo prm_angvelo, angacce prm_angacce,
                                     int prm_way, bool prm_optimize_ang) {
    angle out_d_ang_rz;
    angle out_d_ang_ry;
    if (prm_optimize_ang) {
        getRzRyFaceAngDistanceTwd(prm_ang_rz_target, prm_ang_ry_target,prm_way,
                                   out_d_ang_rz, out_d_ang_ry);
    } else {
        out_d_ang_rz = getFaceAngDistance(AXIS_Z, prm_ang_rz_target, prm_way);
        out_d_ang_ry = getFaceAngDistance(AXIS_Y, prm_ang_ry_target, prm_way);
    }
    double drz = ABS(out_d_ang_rz);
    double dry = ABS(out_d_ang_ry);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_ang_rz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angvelo);
            setFaceAngAcce(AXIS_Z, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angvelo);
            setFaceAngAcce(AXIS_Z, -prm_angacce);
        }
        if (out_d_ang_ry > 0) {
            setFaceAngVelo(AXIS_Y, prm_angvelo*drr);
            setFaceAngAcce(AXIS_Y, prm_angacce*drr);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angvelo*drr);
            setFaceAngAcce(AXIS_Y, -prm_angacce*drr);
        }
    } else if (drz < dry) {
        double drr = drz / dry ;
        if (out_d_ang_rz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angvelo*drr);
            setFaceAngAcce(AXIS_Z, prm_angacce*drr);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angvelo*drr);
            setFaceAngAcce(AXIS_Z, -prm_angacce*drr);
        }
        if (out_d_ang_ry > 0) {
            setFaceAngVelo(AXIS_Y, prm_angvelo);
            setFaceAngAcce(AXIS_Y, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angvelo);
            setFaceAngAcce(AXIS_Y, -prm_angacce);
        }
    } else {
        if (out_d_ang_rz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angvelo);
            setFaceAngAcce(AXIS_Z, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angvelo);
            setFaceAngAcce(AXIS_Z, -prm_angacce);
        }
        if (out_d_ang_ry > 0) {
            setFaceAngVelo(AXIS_Y, prm_angvelo);
            setFaceAngAcce(AXIS_Y, prm_angacce);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angvelo);
            setFaceAngAcce(AXIS_Y, -prm_angacce);
        }
    }

    setStopTargetFaceAng(AXIS_Z, prm_ang_rz_target);
    setStopTargetFaceAng(AXIS_Y, prm_ang_ry_target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::turnFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                   angvelo prm_angvelo, angacce prm_angacce,
                                   int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           out_angRz_Target,
                           out_angRy_Target);

    turnRzRyFaceAngTo(out_angRz_Target, out_angRy_Target,
                      prm_angvelo, prm_angacce,
                      prm_way, prm_optimize_ang);
}


void GgafDxKuroko::turnFaceAng(axis prm_axis,
                               angle prm_angular_distance,
                               angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_angular_distance);
    setFaceAngVelo(prm_axis, ABS(prm_angvelo)*s);
    setFaceAngAcce(prm_axis, ABS(prm_angacce)*s);
    setStopTargetFaceAng(prm_axis, (*(_actor_ang_face[prm_axis])) + prm_angular_distance);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}


void GgafDxKuroko::turnRzFaceAngTo(angle prm_ang_rz_target,
                                    angvelo prm_angvelo, angacce prm_angacce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_Z, prm_ang_rz_target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Z, prm_angvelo);
        setFaceAngAcce(AXIS_Z, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_Z, -prm_angvelo);
        setFaceAngAcce(AXIS_Z, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_Z, prm_ang_rz_target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::turnRyFaceAngTo(angle prm_ang_ry_target,
                                   angvelo prm_angvelo, angacce prm_angacce,
                                   int prm_way) {
    if (getFaceAngDistance(AXIS_Y, prm_ang_ry_target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Y, prm_angvelo);
        setFaceAngAcce(AXIS_Y, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_Y, -prm_angvelo);
        setFaceAngAcce(AXIS_Y, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_Y, prm_ang_ry_target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::spinRxFaceAngTo(angle prm_ang_rx_Target,
                                   angvelo prm_angvelo, angacce prm_angacce,
                                   int prm_way) {
    if (getFaceAngDistance(AXIS_X, prm_ang_rx_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_X, prm_angvelo);
        setFaceAngAcce(AXIS_X, prm_angacce);
    } else {
        setFaceAngVelo(AXIS_X, -prm_angvelo);
        setFaceAngAcce(AXIS_X, -prm_angacce);
    }
    setStopTargetFaceAng(AXIS_X, prm_ang_rx_Target);
}

void GgafDxKuroko::turnRzRyMvAngTo(angle prm_ang_rz_target, angle prm_ang_ry_target,
                                   angvelo prm_angvelo, angacce prm_angacce,
                                   int prm_way, bool prm_optimize_ang) {
    angle out_d_ang_rz;
    angle out_d_ang_ry;
    if (prm_optimize_ang) {
        getRzRyMvAngDistanceTwd(prm_ang_rz_target, prm_ang_ry_target,prm_way,
                                out_d_ang_rz, out_d_ang_ry);
    } else {
        out_d_ang_rz = getRzMvAngDistance(prm_ang_rz_target, prm_way);
        out_d_ang_ry = getRyMvAngDistance(prm_ang_ry_target, prm_way);
    }

    //Rz, Ry AڕWAO֓ɓB悤Ɋpx𒲐
    double drz = ABS(out_d_ang_rz);
    double dry = ABS(out_d_ang_ry);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_ang_rz > 0) {
            setRzMvAngVelo(prm_angvelo);
            setRzMvAngAcce(prm_angacce);
        } else {
            setRzMvAngVelo(-prm_angvelo);
            setRzMvAngAcce(-prm_angacce);
        }
        if (out_d_ang_ry > 0) {
            setRyMvAngVelo(prm_angvelo*drr);
            setRyMvAngAcce(prm_angacce*drr);
        } else {
            setRyMvAngVelo(-prm_angvelo*drr);
            setRyMvAngAcce(-prm_angacce*drr);
        }
    } else if (drz < dry) {
        double drr = drz / dry;
        if (out_d_ang_rz > 0) {
            setRzMvAngVelo(prm_angvelo*drr);
            setRzMvAngAcce(prm_angacce*drr);
        } else {
            setRzMvAngVelo(-prm_angvelo*drr);
            setRzMvAngAcce(-prm_angacce*drr);
        }
        if (out_d_ang_ry > 0) {
            setRyMvAngVelo(prm_angvelo);
            setRyMvAngAcce(prm_angacce);
        } else {
            setRyMvAngVelo(-prm_angvelo);
            setRyMvAngAcce(-prm_angacce);
        }
    } else {
        if (out_d_ang_rz > 0) {
            setRzMvAngVelo(prm_angvelo);
            setRzMvAngAcce(prm_angacce);
        } else {
            setRzMvAngVelo(-prm_angvelo);
            setRzMvAngAcce(-prm_angacce);
        }
        if (out_d_ang_ry > 0) {
            setRyMvAngVelo(prm_angvelo);
            setRyMvAngAcce(prm_angacce);
        } else {
            setRyMvAngVelo(-prm_angvelo);
            setRyMvAngAcce(-prm_angacce);
        }
    }

    setStopTargetRzMvAng(prm_ang_rz_target);
    setStopTargetRyMvAng(prm_ang_ry_target);

}


void GgafDxKuroko::turnMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                angvelo prm_angvelo, angacce prm_angacce,
                                int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           out_angRz_Target,
                           out_angRy_Target);
    turnRzRyMvAngTo(out_angRz_Target, out_angRy_Target,
                    prm_angvelo, prm_angacce,
                    prm_way, prm_optimize_ang);
}
void GgafDxKuroko::turnRzMvAng(angle prm_angular_distance,
                               angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_angular_distance);
    setRzMvAngVelo(ABS(prm_angvelo) * s);
    setRzMvAngAcce(ABS(prm_angacce) * s);
    setStopTargetRzMvAng(_ang_rz_mv+prm_angular_distance);
}

void GgafDxKuroko::turnRyMvAng(angle prm_angular_distance,
                               angvelo prm_angvelo, angacce prm_angacce) {
    int s = SGN(prm_angular_distance);
    setRyMvAngVelo(ABS(prm_angvelo) * s);
    setRyMvAngAcce(ABS(prm_angacce) * s);
    setStopTargetRyMvAng(_ang_ry_mv+prm_angular_distance);
}

void GgafDxKuroko::turnRzMvAngTo(angle prm_ang_rz_target,
                                 angvelo prm_angvelo, angacce prm_angacce,
                                 int prm_way) {
    if (getRzMvAngDistance(prm_ang_rz_target, prm_way) > 0) {
        setRzMvAngVelo(prm_angvelo);
        setRzMvAngAcce(prm_angacce);
    } else {
        setRzMvAngVelo(-prm_angvelo);
        setRzMvAngAcce(-prm_angacce);
    }
    setStopTargetRzMvAng(prm_ang_rz_target);
}

void GgafDxKuroko::turnRyMvAngTo(angle prm_ang_ry_target,
                                 angvelo prm_angvelo, angacce prm_angacce,
                                 int prm_way) {
    if (getRyMvAngDistance(prm_ang_ry_target, prm_way) > 0) {
        setRyMvAngVelo(prm_angvelo);
        setRyMvAngAcce(prm_angacce);
    } else {
        setRyMvAngVelo(-prm_angvelo);
        setRyMvAngAcce(-prm_angacce);
    }
    setStopTargetRyMvAng(prm_ang_ry_target);
}

void GgafDxKuroko::takeoverMvFrom(GgafDxKuroko* const prm_pKuroko) {
    // L̈ړpPʃxNg
    _vX = prm_pKuroko->_vX;
    _vY = prm_pKuroko->_vY;
    _vZ = prm_pKuroko->_vZ;
    // ړpZ]p
    _ang_rz_mv = prm_pKuroko->_ang_rz_mv;
    // ړpY]p
    _ang_ry_mv = prm_pKuroko->_ang_ry_mv;
    // ړx
    _velo_mv = prm_pKuroko->_velo_mv;
    // ړx
    _top_velo_mv = prm_pKuroko->_top_velo_mv;
    // ړx
    _bottom_velo_mv = prm_pKuroko->_bottom_velo_mv;
    // ړx
    _acc_mv = prm_pKuroko->_acc_mv;
    // ړx
    //_jerkMv = prm_pKuroko->_jerkMv;
}

void GgafDxKuroko::stopTurnMvAng() {
    _is_targeting_ang_rz_mv = false;
    _ang_rz_mv_targeting_stop_flg = false;
    _is_targeting_ang_ry_mv = false;
    _ang_ry_mv_targeting_stop_flg = false;
    if (_pAsstC) {
        _pAsstC->stopTurnMvAng();
    }
}

void GgafDxKuroko::stopTurnFaceAng() {
    _is_targeting_ang_face[AXIS_X] = false;
    _is_targeting_ang_face[AXIS_Y] = false;
    _is_targeting_ang_face[AXIS_Z] = false;
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
    if (_pAsstB) {
        _pAsstB->stopTurnFaceAng();
    }
}

bool GgafDxKuroko::isTurningFaceAng() {
    if (_is_targeting_ang_face[AXIS_X] ||
        _is_targeting_ang_face[AXIS_Y] ||
        _is_targeting_ang_face[AXIS_Z] ) {
        return true;
    } else {
        if (_pAsstB) {
            return _pAsstB->isTurningFaceAng();
        } else {
            return false;
        }
        return false;
    }
}

bool GgafDxKuroko::isTurningMvAng() {
    if (_is_targeting_ang_rz_mv || _is_targeting_ang_ry_mv) {
        return true;
    } else {
        if (_pAsstC) {
            return _pAsstC->isTurningMvAng();
        } else {
            return false;
        }
    }
}

void GgafDxKuroko::stopMv() {
   setMvAcce(0);
   setMvVelo(0);
   if (_pAsstA) {
       _pAsstA->stopSlidingMv();
   }
}

GgafDxKuroko::~GgafDxKuroko() {
    GGAF_DELETE_NULLABLE(_pAsstA);
    GGAF_DELETE_NULLABLE(_pAsstB);
    GGAF_DELETE_NULLABLE(_pAsstC);
}


// yY^z{NX̍lƃRg̒P̕\
//
// Qނ̕
// uL̕vƂtBȂ߁ÂQނ̒P`BuړpijvƁuʕpijvB
// uړpv̓L̐iŝ݂\B́uړxvƔāAL͍Wړ邱ƂƂB
// uʕpv̓ĽiOĵ݂\鎖ƂB
// LN^ʂ̏㕔牺ֈړĂALN^͉Ƃ͌炸@ɌĂقꍇB
// ܂́AEɃLāAɈړƂBꂼQ̕ݒ肪KvB
//
// ړp̂Qނ̕\@
// LiޕA܂uړpv́̕A_Pʋ̕\ʂɌĐLтxNg (_vX, _vY, _vZ) ŕ\@ƁA
// Q]AOl (_ang_rz_mv, _ang_ry_mv) ŕ\@̂QޗpӂBNH[^jÎ͍Ƃ떳B
// _ang_rz_mv  Z]pA _ang_ry_mv  Y]p ӖĂB
// ͕xNgAܓxƌoxAipƃAW}Xj̊֌WɌāAΉ悤ƂB
// ӂ邱Ƃ́AY]pox ͏ɐ藧AZ]pܓx ́AZ]p  Y]p̏ԂłꍇɌ萬藧B
// {NXł́AuZ]  Y]̏ԂłZ]pEY]pvȗāAPɁuZ]pEY]pvƕ\鎖ƂB
// ꂼuړpiZjvuړpiYjvƕ\鎖B
//
// \[XR[h́Aϐ⃁\bh
// uRzMvvƂ\ĹuړpiZjvӖĂB
// uRyMvvƂ\ĹuړpiYjvӖĂB
// uRzRyMvvƂ\́uZ]  Y]̏Ԃ̈ړpv\ĂB
//
// Z]pAY]pƂ0xAxNg(1, 0, 0) ̕ƒ`B
// Z]p̐̑́AZ̐̕ĔvB
// Y]p̐̑́AY̐̕ĔvBƂB
//
// ƂŐwIɁupv́AxNgiXYZ̒ljŕ\邱ƂƎvB
// ̖{NXł́A悭ĝ͂Q\̕ŁA\bh _ang_rz_mv  _ang_ry_mv 𑀍삷̂SƂȂĂB
// ͌ǓŒPʕxNg߂Ă̂AW]vZA^ _ang_rz_mv  _ang_ry_mv ł񂴂sĂA
// ŌɂPPʃxNg߂BƂ̂ł͂ƍl߁Â悤Ȑ݌vɂȂB
// TODO:œK̗]nԎcĂnYB܂B
// (_ang_rz_mv, _ang_ry_mv)\bhɂ葀삵āAet[̍Ō̓ŕxNg(_vX, _vY, _vZ) 𓯊ĂB
// (_vX, _vY, _vZ)o[\bhg킸ڑ삷ƁA(_ang_rz_mv, _ang_ry_mv)Ƃ̓̂ŒӁB
// {NX̃\bhgpł́AȂƂ͋NȂB
//
// ړx:Velo or MvVelo
// Ĺuړxv(_velo_mv)ێĂBړ@͊ȒPŁA{Iɖt[uړpvɁuړxvB
// Ẃuړpv(_vX, _vY, _vZ)Ɂuړxv(_velo_mv)|ZĂB
// Pt[̍W݂͌̍W (_vX*_velo_mv, _vY*_velo_mv, _vZ*_velo_mv) ړꏊłB
// ̃xNgɖ{Cu̒Pʋ(Q[̒Pƍl鐮{lj悶B
// āA(_vX*_velo_mv*LEN_UNIT, _vY*_velo_mv*LEN_UNIT, _vZ*_velo_mv*LEN_UNIT)Pt[̍WB

// ʕp:AngFace
// L̃[JWŌĂpijuʕpvƌĂԂƂɂB
//uʕpv́A[hϊs̎]Ɠ]@łB
// [hϊs̎]Ƃ́AX]pAY]pAZ]p̂ƂŁAꂼA
// _angFace[AXIS_X], _angFace[AXIS_Y], _angFace[AXIS_Z] ƈvB
// {Cuł́AxNg(1, 0, 0) ĹuOvƐݒ肵ĂB
// Xt@CȂǂ̃Lf́AԂŐXɌĂ邱ƂOƂB܂Afúv́i0, 1, 0)ƂB
// [hϊs̉]s̊|鏇Ԃ́A{I uX]s > Z]s > Y]s > ړs v ƂB
// (  X > Y > Z ̏ł͂ȂIj
// āAX]p͊]悤ƂALĂ͕ς炸AcZ]pƁAY]pŃLĂ肷邱ƂƂB
// X]p̓L̃XsÂQpiZ]pEY]pjŃĹuOvp肷ƂꍇA
// uʕpvقǂ́uړpvƓ悤ɁAZ]pY]piܓxƌox)̂Q̃AOl
// (_angFace[AXIS_Z], _angFace[AXIS_Y])ŕ\łB
// ܂AuOv Z]pEY]p0xƂAႦ΁uv(Z]p,Y]p)=(0x,180x) ƕ\BB
// PɁuZ]pvȂǂƏƁAuړpvZ]pȂ̂AuʕpvZ]pȂ̂BɂȂ邽߁A
// uʕp(Z)vuʕp(Y)vƏƂƂBiuʕp(X)v邪A̓Xs\ւ̉e͂Ȃj
// Œӂ́AP̃LĂpɑ΂āAɂQʂ̃ANZX@ƂƁBႦ΁A
// uO(1, 0, 0)Đ^Ev  (ʕp(Z), ʕp(Y))=(0, 90x) or (180x,270x) Ƃŕ\łB
// iʕp(Y)͍nŴY̐Ĕvj
//  uOv (0x,0x) Ƃ (180x,180x) Ƃ\ł邵Au^v  (0x,180x) Ƃ (180x,0x) Ƃ\łB
// Ă͓Ap(L̏)قȂBpقȂƂ܂L͒ӂ邱ƁB
// RAuړpvłAQʂ̃ANZX@̂A͎p̂ŌڂŕȂB
// pxvZƂɉeoꍇ̂ŒӂKvB


// O@\
// Ă uړpiZjvuړpiYjvAꂼuʕp(Z)vuʕp(Y)v փRs[ĂƁA
// ړpƁALN^̌̓ȒPɎ邶ȂI
// uO@\vƂ́Auړpvݒ肷ƁAɔĎIɁuʕpvݒ肷鎖ƂB
// ̓Iɂ́Aȉ̂悤Ƀt[ɁAAOl㏑Rs[ijB͍Zi炩ɕ`jĂB
//  EړpiZj  ʕp(Z)
//  EړpiYj  ʕp(Y)
// uʕpvݒĂuړpvωȂit͊֘AȂĵŒӁB

// px:AngVelo
// uړpiZjvuړpiYjvAuʕp(Z)vuʕp(Y)vɂ́Aꂼ́upxv݂ĂB
// Ⴆ90xEɌꍇALȂJNƌςĂ͔߂̂ŁAt[pxpZ悤ɂāA
// 炩Ɍς悤ɂB
// upxv͐̒ӂKvB̏ꍇ͔vȀꍇ͎vɂȂB
// ]ꍇA^[QbgƂȂpxւ̓BAv[`͐]̂Qʂ肾A
// \5ʂ̍lŎwł悤݌vB
// 1.uɔvōsv TURN_ANTICLOSE_TO
// 2.uɎvōsv TURN_CLOCKWISE
// 3.u߂p̎ōsvTURN_CLOSE_TO
// 4.uȊp̎ōsvTURN_ANTICLOSE_TO
// 5.u݉Ă̂܂܂ōsv
// łBꂼpr̂ŁAIvVȂǂŁAIł悤ɂȁBłB



//̑ǋLA
//EړxAړppxA]ppxɂ́AꂼxݒłI
//E]́A{ Z > X > Y ̎]Ԃɂ̂ʓÎ悤B܂O̊TOZŉł킯AȂقǂ킩₷B
//  ݂ X > Z > Y ́AZOXłB
//  Ƃ2D̉XN[V[eBO낤ƎvĂA X > Z Ő݌vsĂ̂ł邪AǂȂB
//  ܂A3DV[eBOɂƂ͎łvĂ݂ȂEEE

// ړ: VxMv VyMv VzMv
// L̈ړ̌nƂ͂܂ʂɁAƗ XAYAZɕsȈړw肪łB
// uXړxvuYړxvuZړxvݒ肷ƁAt[(_x,_y,_z)ɂꂼ̈ړ
// ZB
// i̋@\ GgafDxAxesMover ɏW񂳂ƗNXƂȂ܂Ij

//2010/02/19ǋL
// ܂ɁuRyRzvƂ\݂iuRzRyvƈقȂjÁuY]  Z]̏Ԃ̈ړpv\Ă̂ŒӁB
//   ܂AuړpiZjv]̏Ԃ̈Ⴂ𖾊mɂ邽
//   uRzRyRzvuRyRzRzvƏ肵ĂƂBiPɁuRzv̏ꍇ́uRzRyRzvӖĂj

//ǋL
//E炩ړ\ɁI

//TODO:
//xixj̒ǉ
//Cӎ]iNH[^jIj
//NX̔剻  sړx
//yzZ߂
