#ifndef GGAFDXCORE_GGAFDXPOINTSPRITEMODEL_H_
#define GGAFDXCORE_GGAFDXPOINTSPRITEMODEL_H_
#include "jp/ggaf/dxcore/model/GgafDxModel.h"

namespace GgafDxCore {

/**
 * GgafDxPointSpriteActorpfNX.
 * @version 1.00
 * @since 2008/02/22
 * @author Masatoshi Tsuge
 */
class GgafDxPointSpriteModel : public GgafDxModel {
    friend class GgafDxModelManager;

public:
    struct VERTEX {
        float x, y, z;    // _W
        float psize;      // |CgTCY
        DWORD color;      // _̐F
        float tu, tv;     // eNX`W
    };

    /** _obt@ */
    LPDIRECT3DVERTEXBUFFER9 _pIDirect3DVertexBuffer9;
    /** _z */
    VERTEX* _paVtxBuffer_org;
    /** _(=XvCg) */
    int _vertices_num;
    /** _FVF */
    static DWORD FVF;
    /** `̒_ṽTCY */
    UINT _size_vertices;
    /** 1_̃TCY */
    UINT _size_vertex_unit;
    /** IuWFNĝPӂ̃TCY(px) */
    float _fSquareSize;
    /** eNX`̂Pӂ̒(px) */
    float _fTexSize;
    /** eNX`(PŕBQłSp^[ARłXp^[) */
    int _texture_split_rowcol;

public:
    /**
     * RXgN^<BR>
     * @param prm_model_name XvCg`̎ʖB".psprx"ǉƒ`Xt@CɂȂB
     */
    GgafDxPointSpriteModel(char* prm_model_name);

    virtual HRESULT draw(GgafDxDrawableActor* prm_pActor_Target, int prm_draw_set_num = 1) override;

    virtual void restore() override;

    virtual void onDeviceLost() override;

    void release() override;

    void changeVertexAlpha(int prm_vertex_alpha);

    /**
     * fXgN^<BR>
     */
    virtual ~GgafDxPointSpriteModel(); //fXgN^
};

}
#endif /*GGAFDXCORE_GGAFDXPOINTSPRITEMODEL_H_*/
