#ifndef GGAFDXCORE_GGAFDXSTRINGSPRITEACTOR_H_
#define GGAFDXCORE_GGAFDXSTRINGSPRITEACTOR_H_
#include "jp/ggaf/dxcore/actor/GgafDxSpriteSetActor.h"

namespace GgafDxCore {

/**
 * \NX .
 * GgafDxSpriteSetActor pAZbgeNX`[
 * \@\ǉAN^[łB<BR>
 * ̂悤ȃeNX`ł邱ƂOBiۂ̉摜͌rłj<BR>
 * <code><pre>
 * 
 * @Ihf
 * 
 * ij{C|D^
 * 
 * OPQRSTUV
 * 
 * WXFGH
 * 
 * `abcdef
 * 
 * ghijklmn
 * 
 * opqrstuv
 * 
 * wxym_nOQ
 * 
 * </pre></code>
 * \ƌĂUV؂ւĘA\邾B
 * TODO:GgafDxStringBoardActorƋʉEEE
 * @version 1.00
 * @since 2009/04/09
 * @author Masatoshi Tsuge
 */
class GgafDxStringSpriteActor : public GgafDxSpriteSetActor {

public:
    /** [r/w]p^[ԍ0Ƃ镶 */
    int _chr_ptn_zero;
    /** [r]`敶 */
    int* _draw_string;
    /** [r]obt@(256Œ) */
    int* _buf;
    /** [r] */
    int _len;
    /** [r/w]x[X̂P(px) */
    pixcoord _chr_width_px;
    /** [r/w]x[X̂P(px) */
    pixcoord _chr_height_px;
    /** [r/w]eԊu(px) */
    pixcoord _aWidthPx[256];
    /** [r]obt@̍sPʂ̕(px) */
    pixcoord _aWidth_line_px[256];
    /** [r]obt@s */
    int _nn;

public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_model ZbgeNX`̃f`ID
     * @return
     */
    GgafDxStringSpriteActor(const char* prm_name, const char* prm_model, GgafCore::GgafStatus* prm_pStat);

    virtual void onCreateModel() override;

    virtual void processDraw() override;

    virtual bool processHitChkLogic(GgafCore::GgafActor* prm_pOtherActor) {
        return false;
    }

    virtual void onHit(GgafCore::GgafActor* prm_pOtherActor) {
    }
    /**
     * `敶XVݒ .
     * @param X XW
     * @param Y YW
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, char* prm_str);

    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param Z ZW
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param Z ZW
     * @param prm_str `敶
     */
    virtual void update(coord X, coord Y, coord Z, char* prm_str);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     */
    virtual void update(const char* prm_str);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     */
    virtual void update(char* prm_str);

    /**
     * `敶XVݒ .
     * @param X XW
     * @param Y YW
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);

    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param Z ZW
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, coord Z, const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param X XW
     * @param Y YW
     * @param Z ZW
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(coord X, coord Y, coord Z, char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(const char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);
    /**
     * `敶XVݒ  .
     * @param prm_str `敶
     * @param prm_align ALIGN_LEFT:XW͕̍[^ALIGN_CENTER:XW͕̒̕_^ALIGN_RIGHT:XW͕̉E[
     * @param prm_valign VALIGN_TOP:YW͕̍̏Ӂ^VALIGN_MIDDLE:YW͕̍̐^񒆁^VALIGN_BOTTOM:YW͕̍̒
     */
    virtual void update(char* prm_str,
                        GgafDxAlign prm_align,
                        GgafDxValign prm_valign);

    inline void getDrawString(char* out_paCh) {
        int len = _len;
        for (int i = 0; i < len; i++) {
            out_paCh[i] = _draw_string[i];
        }
        out_paCh[len] = '\0';
    }

    virtual ~GgafDxStringSpriteActor();

};

}
#endif /*GGAFDXCORE_GGAFDXSTRINGSPRITEACTOR_H_*/
