#include "stdafx.h"
#include "EffectTurbo002.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EffectTurbo002::EffectTurbo002(const char* prm_name) :
        DefaultSpriteActor(prm_name, "Turbo002", nullptr) {
    _class_name = "EffectTurbo002";
    pScaler_ = NEW GgafDxScaler(this);
    inactivate();
    effectBlendOne(); //Z
    setHitAble(false); //蔻薳
}

void EffectTurbo002::initialize() {
    GgafDxUvFlipper* pUvFlipper = getUvFlipper();
    pUvFlipper->setFlipPtnRange(0, 0);   //Aj͈͂O`PT
    pUvFlipper->exec(FLIP_ORDER_LOOP, 2); //Aj

}

void EffectTurbo002::onActive() {
    getUvFlipper()->setActivePtnToTop();
    setAlpha(0.4);
    pScaler_->forceRange(100000, 1000); //XP[OE͈
    setScale(1000);
    pScaler_->transitionLinerUntil(100000, 60);//XP[OE60F₵1000ɏk
    setRyFaceAng(D90ANG);
    getKuroko()->setFaceAngVelo(AXIS_Z, 2000);
}

void EffectTurbo002::processBehavior() {
    addAlpha(-(1.0/60.0));
    getUvFlipper()->behave();
    getKuroko()->behave();
    pScaler_->behave();
}

void EffectTurbo002::processJudgement() {
    if (!pScaler_->isTransitioning()) {
        inactivate();
    }
}

void EffectTurbo002::onInactive() {
}

EffectTurbo002::~EffectTurbo002() {
    GGAF_DELETE(pScaler_);
}
