#ifndef GGAFLIB_FORMATIONTABLESCENE_H_
#define GGAFLIB_FORMATIONTABLESCENE_H_
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"

namespace GgafLib {

/**
 * 񂵓Gґe[uǗV[ .
 * 񂵓GґƂ͋̓IɁA<BR>
 * Eґł΁A̕ґoB<BR>
 * EґłƂA莞ԂŎ̕ґoB<BR>
 * Ƃ悤ȃe[ûƁB<BR>
 * (̓Goe[û悤ȊŁEE)<BR>
 * <b>gp@</b><BR>
 * <pre><code>
 * ESceneprocessBehavior()Ŏ̃R[hƂƁB
 *
 *     FormationTableScene* ftbl = NEW FormationTableScene("TableScene_9");
 *     addSubLast(ftbl);               //qV[Ƃēo^
 *     ftbl->setMaxPerformFrame(280);  //ґe[uS̃t[ݒ
 *     ftbl->addToTable(((FormationAllas001a*)obtainActorFromFactory(21047100)), 100);   //ґaB ґb  ґa SłꍇoBSłȂƂA100t[oB
 *     ftbl->addToTable(((FormationAllas001b*)obtainActorFromFactory(21057100)), 100);   //ґbB ґc  ґb SłꍇoBSłȂƂA100t[oB
 *     ftbl->addToTable(((FormationAllas001c*)obtainActorFromFactory(21067100)), 100);   //ґcB ґd  ґc SłꍇoBSłȂƂA100t[oB
 *     ftbl->addToTable(((FormationAllas001d*)obtainActorFromFactory(21077100)), 100);   //ґdB ґe  ґd SłꍇoBSłȂƂA100t[oB
 *     ftbl->addToTable(((FormationAllas001e*)obtainActorFromFactory(21087100)));        //ґeB̓G߁At[ݒ̈Ӗ͖ȂB
 *
 * E͉}̂悤ȎӖB
 *                                                             :
 *  eV[   --------------------+---------------------------+---------------------------->
 *  et[                     n                        n+280
 *                                                             :
 *  jȂꍇ                                     :
 *    qV[(FormationTableScene)+---------+---------+-------+-+---
 *    qt[                   0        100       200   280: 300
 *                                                             :
 *                                 | a       | b       | c     : | d        ґdȍ~͏oȂB
 *                                  <--100--> <--100--> <--100--> <--100--->  ґd̏o^C~O300ƂȂA
 *                                                             :              280܂łɊԂɍĂȂߏoȂ
 *  ґa𑁊j(75t[Ōj)ꍇ          :
 *    qV[(FormationTableScene)+------+---------+---------++---
 *    qt[                   0     75        175      275:280
 *                                                             :
 *                                 |a     | b       | c       |: d      ґd͏oB
 *                                  <-75-> <--100--> <--100--> <--100---> ґd̏o^C~O275ƂȂA
 *                                                             :          280܂łɊԂɍĂ̂ŏoB
 *                                                             :          ɕґd5t[ȓŏłꂽꍇ́Aґeo\B
 *  </code></pre>
 * @version 1.00
 * @since 2010/08/19
 * @author Masatoshi Tsuge
 */
class FormationTableScene : public DefaultScene {

private:
    /**
     * Goe[uvfNX .
     * ґAN^[Aő҂t[(_max_delay_offset) ̏Rei
     */
    class TblElem {
    public:
        /** ґAN^[ */
        GgafCore::GgafFormation* _pFormationActor;
        /** ґAN^[uꂽƂĂA̓Go܂ł̃t[ */
        frame _max_delay_offset;

        /**
         * vfRXgN^ .
         * @param prm_pFormationActor ґAN^[
         * @param prm_max_delay_offset ̓Go܂ł̃t[(ȗ0)
         * @return
         */
        TblElem(GgafCore::GgafFormation* prm_pFormationActor, frame prm_max_delay_offset = 0) {
            _pFormationActor = prm_pFormationActor;
            _max_delay_offset = prm_max_delay_offset;
        }
        virtual ~TblElem() {
            //_pActor̓V[ƂȂ邽߉͕sv
        }
    };

public:
    /** 񂵓Goe[uŜ̋et[ */
    frame _max_perform_frame;
    /** e[ǔ݂̓G(AN^[)oẴt[ */
    frame _frame_of_current_part_began;
    /** Goe[u(TblElemIuWFNg̘AXg) */
    GgafCore::GgafLinkedListRing<TblElem> _table;

public:
    /**
     * RXgN^ .
     * @param prm_name V[
     * @return
     */
    FormationTableScene(const char* prm_name);

    /**
     * e[uɓGґvfǉ .
     * vfǉAGґAN^[͔񊈓(inactivateImmed())ɂ܂B<BR>
     * vfǉĂ activate() ́AȂłB<BR>
     * @param prm_pFormationActor GґAN^[
     * @param prm_max_delay_offset ̓Go܂ł́Aő҂t[
     * @return
     */
    virtual GgafCore::GgafGroupHead* addToTable(GgafCore::GgafFormation* prm_pFormationActor, frame prm_max_delay_offset = 0);

    /**
     * 񂵓Goe[uŜ̋et[ݒ肷B
     * ݒsȂꍇA0xffffffff ݒ肳ĂB
     * @param prm_max_perform_frame
     */
    virtual void setMaxPerformFrame(frame prm_max_perform_frame) {
        _max_perform_frame = prm_max_perform_frame;
    }

    virtual void initialize() override {
    }

    virtual void onActive() override;

    /**
     * e[uɂāAG(AN^[)activate()Ă܂B
     */
    virtual void processBehavior() override;

    virtual void processJudgement() override {
    }

    virtual void processDraw() override {
    }

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {
    }

    virtual ~FormationTableScene();
};

}
#endif /*GGAFLIB_FORMATIONTABLESCENE_H_*/
