#include "stdafx.h"
#include "jp/ggaf/dxcore/util/GgafDxAllocHierarchy.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxAllocHierarchy::GgafDxAllocHierarchy() {
}

// fXgN^
GgafDxAllocHierarchy::~GgafDxAllocHierarchy() {
    // o^ꂽIuWFNgSč폜
    std::list<DeleterBase*>::iterator it = m_DelList.begin();
    for (; it != m_DelList.end(); it++) {
        DeleterBase* p = (*it);
        delete p;
    }

    std::list<IUnknown*>::iterator comit = m_ReleaseList.begin();
    for (; comit != m_ReleaseList.end(); comit++) {
        if (*comit) {
            (*comit)->Release();
        }
    }
}

// t[\̂𐶐
D3DXFRAME* GgafDxAllocHierarchy::createNewFrame() {
    D3DXFRAME * tmp = NEW D3DXFRAME;
    ZeroMemory(tmp, sizeof(D3DXFRAME));
    addDelList( NEW Deleter<D3DXFRAME>(tmp) );
    return tmp;
}

// bVRei\̂𐶐
D3DXMESHCONTAINER *GgafDxAllocHierarchy::createNewMeshContainer() {
    D3DXMESHCONTAINER * tmp = NEW D3DXMESHCONTAINER;
    ZeroMemory(tmp, sizeof(D3DXMESHCONTAINER));
    addDelList( NEW Deleter<D3DXMESHCONTAINER>(tmp) );
    return tmp;
}

// Xgɓo^
void GgafDxAllocHierarchy::addDelList(DeleterBase* ptr, bool isAry) {
    m_DelList.push_back(ptr);
}

// [XXgɓo^
void GgafDxAllocHierarchy::addReleaseList(IUnknown *comptr) {
    comptr->AddRef();
    m_ReleaseList.push_back(comptr);
}

// Rs[֐
LPSTR GgafDxAllocHierarchy::copyStr(LPCSTR name) {
    if (!name)
        return nullptr;   // nullptr͕JEgłȂ
    LPSTR
    Str = NEW
    char[strlen(name)+1];
    Str = strcpy(Str, name);
    addDelList( NEW Deleter<char>( Str, true ) );
    return Str;
}

// bVf[^o^
void GgafDxAllocHierarchy::registerMeshData(CONST D3DXMESHDATA *pSrc, D3DXMESHDATA *pDest)
{
    pDest->Type = pSrc->Type;   // bV^Cv
    pDest->pMesh = pSrc->pMesh;// bViunionȂ̂łǂłꏏj
    addReleaseList( pDest->pMesh );// ReleaseXg֓o^
}

// }eAo^
void GgafDxAllocHierarchy::registerMaterial(CONST D3DXMATERIAL *pSrc, DWORD num, D3DXMATERIAL **ppDest)
{
    // }eAz̐
    *ppDest = NEW D3DXMATERIAL[ num ];
    addDelList( NEW Deleter<D3DXMATERIAL>( *ppDest, true ) );

    DWORD i;
    for(i=0; i<num; i++) {
        (*ppDest)[i].MatD3D = pSrc[i].MatD3D;   // }eAo^
        (*ppDest)[i].pTextureFilename = copyStr( pSrc[i].pTextureFilename );// eNX`o^
    }
}

// GtFNgo^
void GgafDxAllocHierarchy::registerEffect(CONST D3DXEFFECTINSTANCE *pSrc, D3DXEFFECTINSTANCE **ppDest)
{
    *ppDest = NEW D3DXEFFECTINSTANCE;
    addDelList( NEW Deleter<D3DXEFFECTINSTANCE>(*ppDest) );
    (*ppDest)->pEffectFilename = copyStr(pSrc->pEffectFilename);     // GtFNg
    (*ppDest)->NumDefaults = pSrc->NumDefaults;// GtFNgftHg
    (*ppDest)->pDefaults = NEW D3DXEFFECTDEFAULT[pSrc->NumDefaults];// GtFNgftHgz񐶐
    addDelList( NEW Deleter<D3DXEFFECTDEFAULT>( (*ppDest)->pDefaults, true ) );

    // GtFNgftHg̓o^
    D3DXEFFECTDEFAULT *pEDSrc = pSrc->pDefaults;// Rs[
    D3DXEFFECTDEFAULT *pEDDest = (*ppDest)->pDefaults;// Rs[
    unsigned int i=0;
    for(i = 0; i < pSrc->NumDefaults; i++) {
        pEDDest[i].pParamName = copyStr(pEDSrc[i].pParamName);              // p[^
        DWORD NumBytes = pEDDest[i].NumBytes = pEDSrc[i].NumBytes;// p[^TCY
        pEDDest[i].Type = pEDSrc[i].Type;// p[^^Cv
        if(pEDSrc[i].Type <= D3DXEDT_DWORD) {
            pEDDest[i].pValue = (void*)( NEW BYTE[ NumBytes ] );              // p[^z񐶐
            memcpy( pEDDest[i].pValue, pEDSrc[i].pValue, NumBytes );
            addDelList( NEW Deleter<BYTE>( (BYTE*)(pEDDest[i].pValue), true ) );
        }
    }
}

// אڃ|So^
void GgafDxAllocHierarchy::registerAdjacency(CONST DWORD *Src, DWORD polynum, DWORD **Dest)
{
    *Dest = NEW DWORD[ polynum * 3 ];   // z񐶐
    memcpy( *Dest, Src, polynum * 3 * sizeof(DWORD));// Rs[
    addDelList( NEW Deleter<DWORD>( *Dest, true ) );
}

// XLo^
void GgafDxAllocHierarchy::registerSkin( CONST LPD3DXSKININFO Src, LPD3DXSKININFO *Dest) {
    if(!Src) return;   // XLΉȂ
    *Dest = Src;// XLRs[
    addReleaseList( *Dest );// [XXgɓo^
}

// t[֐
HRESULT GgafDxAllocHierarchy::CreateFrame(THIS_
        LPCSTR Name,
        LPD3DXFRAME *ppNewFrame) {
    // t[V
    D3DXFRAME *pFrame = createNewFrame();
    pFrame->Name = copyStr( Name );
    *ppNewFrame = pFrame;

    return D3D_OK;
}

// bVRei֐
HRESULT GgafDxAllocHierarchy::CreateMeshContainer(THIS_
        LPCSTR Name,
        CONST D3DXMESHDATA *pMeshData,
        CONST D3DXMATERIAL *pMaterials,
        CONST D3DXEFFECTINSTANCE *pEffectInstances,
        DWORD NumMaterials,
        CONST DWORD *pAdjacency,
        LPD3DXSKININFO pSkinInfo,
        LPD3DXMESHCONTAINER *ppNewMeshContainer) {
    // bVReiIuWFNg̐
    D3DXMESHCONTAINER *p = createNewMeshContainer();

    // Oo^
    p->Name = copyStr( Name );

    // bVf[^o^
    registerMeshData( pMeshData, &p->MeshData );

    // }eAo^
    p->NumMaterials = NumMaterials;
    registerMaterial( pMaterials, NumMaterials, &p->pMaterials);

    // GtFNgo^
    registerEffect( pEffectInstances, &p->pEffects );

    // אڃ|So^
    registerAdjacency( pAdjacency, pMeshData->pMesh->GetNumFaces(), &p->pAdjacency );

    // XLo^
    registerSkin( pSkinInfo, &p->pSkinInfo );

    *ppNewMeshContainer = p;

    return D3D_OK;
}

// t[폜
HRESULT GgafDxAllocHierarchy::DestroyFrame(THIS_
        LPD3DXFRAME pFrameToFree) {
    // ̃NXł̓fXgN^ō폜̂
    // ̊֐͎gȂ
    return D3D_OK;
}

// Rei폜
HRESULT GgafDxAllocHierarchy::DestroyMeshContainer(THIS_
        LPD3DXMESHCONTAINER pMeshContainerToFree) {
    // ̃NXł̓fXgN^ō폜̂
    // ̊֐͎gȂ
    return D3D_OK;
}
