#include "stdafx.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"

#include <math.h>
#include "jp/ggaf/dxcore/util/GgafDxUtil.h"
#include "jp/ggaf/dxcore/actor/GgafDxDrawableActor.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantA.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantB.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKurokoAssistantC.h"

using namespace GgafCore;
using namespace GgafDxCore;

GgafDxKuroko::GgafDxKuroko(GgafDxGeometricActor* prm_pActor) : GgafObject(),
_pActor(prm_pActor) {

    _pHlprA = nullptr;
    _pHlprB = nullptr;
    _pHlprC = nullptr;

    _apActorFaceAng[0] = &(prm_pActor->_rx);
    _apActorFaceAng[1] = &(prm_pActor->_ry);
    _apActorFaceAng[2] = &(prm_pActor->_rz);

    for (int ax = 0; ax < 3; ax++) { // i=0:XA1:YA2:Z \
        //ʕp̊pxiʕp̑j= 0 angle/fream
        _angveloFace[ax] = 0; //1t[ɉZ鐳ʕp̊pBftHg͐ʕp̊pA܂UB
        //ʕp̊px  360,000 angle/fream
        _angveloTopFace[ax] = D360ANG; //_angveloFace[n] ̑̏BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊px  -360,000 angle/fream
        _angveloBottomFace[ax] = D360ANG * -1; //_angveloFace[n] ̑̉BftHg1t[ōDȐʕpɐUo鎖Ӗ
        //ʕp̊pxipx̑j  0 angle/fream^2
        _angacceFace[ax] = 0; //_angveloFace[n] ̑BftHg͐ʕp̊px

        _angjerkFace[ax] = 0;
        //ڕWʕpւ̎tO = 
        _face_ang_targeting_flg[ax] = false;
        //ڕWʕpւ̎~tO = 
        _face_ang_targeting_stop_flg[ax] = false;
        //ڕW̐ʕp
        _angTargetFace[ax] = 0; //ڕWʕpւ̎tO = Ȁꍇ͖Ӗ
        //ڕW̐ʕp~@\LɂȂ]
        _face_ang_target_allow_way[ax] = TURN_BOTH;
        //ڕW̐ʕp~@\LɂȂpxi]ʁj
        _face_ang_target_allow_velo[ax] = D180ANG;
    }

    //////////////////////////////////////////////////////
    //L̈ړpPʃxNg
    _vX = 1.0f;
    _vY = _vZ = 0.0f;
    //ړpZ]
    _angRzMv = 0;
    //ړpY]
    _angRyMv = 0;
    //ړx
    _veloMv = 0;
    //ړx = 256 px/fream
    _veloTopMv = INT_MAX; //_veloMv  256000(=256px) ړʂłĂAIɍW 256px ɗ}B
    //ړx = 0   px/fream
    _veloBottomMv = INT_MIN; //_veloMv  -256000(-256px) ړʂĂAIɍW -256000px ɗ}B
    //ړxiړx̑j = 0 px/fream^2
    _accMv = 0; //_veloMv ̑BftHg͉

    //_jerkMv = 0;
    //ړpiZ]j̊px = 0 angle/fream
    _angveloRzMv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiZ]j̊px = +360,000 angle/fream
    _angveloRzTopMv = D360ANG; //_angveloRzMv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = -360,000 angle/fream
    _angveloRzBottomMv = D360ANG * -1; //_angveloRzMv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiZ]j̊px = 0 angle/fream^2
    _angacceRzMv = 0; //_angveloRzMv ̑BftHg͈ړp̊px

    _angjerkRzMv = 0;
    //ڕWړpiZ]jւ̎tO = 
    _mv_ang_rz_target_flg = false;
    //ڕWړpiZ]jւ̎~tO = 
    _mv_ang_rz_target_stop_flg = false;

    //ڕẄړpiZ]j
    _angTargetRzMv = 0;
    //ڕẄړpiZ]j~@\LɂȂ]
    _mv_ang_rz_target_allow_way = TURN_BOTH;
    //ڕẄړpiZ]j~@\LɂȂړppx(px)
    _mv_ang_rz_target_allow_velo = D180ANG;
    //ړpiZ]jɔZʕp̓@\tO  
    _relate_RzFaceAng_with_RzMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    //ړpiY]j̊px = 0 angle/fream
    _angveloRyMv = 0; //1t[ɉZړp̊pBftHg͈ړp̊pA܂蒼ړB
    //ړpiY]j̊px = +360,000 angle/fream
    _angveloRyTopMv = D360ANG; //_angveloRyMv ̑̏BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = -360,000 angle/fream
    _angveloRyBottomMv = D360ANG * -1; //_angveloRyMv ̑̉BftHg1t[ōDȈړɕύXo鎖Ӗ
    //ړpiY]j̊px = 0 angle/fream^2
    _angacceRyMv = 0; //_angveloRyMv ̑BftHg͈ړp̊px

    _angjerkRyMv = 0;
    //ڕWړpiY]jւ̎tO = 
    _mv_ang_ry_target_flg = false;
    //ڕWړpiY]jւ̎~tO = 
    _mv_ang_ry_target_stop_flg = false;
    //ڕẄړpiY]j
    _angTargetRyMv = 0;
    //ڕẄړpiY]j~@\LɂȂ]
    _mv_ang_ry_target_allow_way = TURN_BOTH;
    //ڕẄړpiY]j~@\LɂȂړppx(px)
    _mv_ang_ry_target_allow_velo = D180ANG;
    //ړpiY]jɔZʕp̓@\tO  
    _relate_RyFaceAng_with_RyMvAng_flg = false; //L̏ꍇ́Aړpݒ肷ZʕpɂȂB

    _taget_face_ang_alltime_flg = false;
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_tx = 0;
    _taget_face_ang_alltime_ty = 0;
    _taget_face_ang_alltime_tz = 0;
    _taget_face_ang_alltime_angVelo = 0;
    _taget_face_ang_alltime_angAcce = 0;
    _taget_face_ang_alltime_way = TURN_CLOSE_TO;
    _taget_face_ang_alltime_optimize_ang = true;

}
GgafDxKurokoAssistantA* GgafDxKuroko::asstA() {
    return _pHlprA ? _pHlprA : _pHlprA = NEW GgafDxKurokoAssistantA(this);
}
GgafDxKurokoAssistantB* GgafDxKuroko::asstB() {
    return _pHlprB ? _pHlprB : _pHlprB = NEW GgafDxKurokoAssistantB(this);
}
GgafDxKurokoAssistantC* GgafDxKuroko::asstC() {
    return _pHlprC ? _pHlprC : _pHlprC = NEW GgafDxKurokoAssistantC(this);
}
void GgafDxKuroko::behave() {
    if (_pHlprA) {
        _pHlprA->behave();
    }
    if (_pHlprB) {
        _pHlprB->behave();
    }
    if (_pHlprC) {
        _pHlprC->behave();
    }

    //ʕp
    for (axis ax = 0; ax < 3; ax++) {

        _angveloFace[ax] += _angacceFace[ax];
        if (_angveloFace[ax] > _angveloTopFace[ax]) {
            _angveloFace[ax] = _angveloTopFace[ax];
        } else if (_angveloFace[ax] < _angveloBottomFace[ax]) {
            _angveloFace[ax] = _angveloBottomFace[ax];
        }

        if (_face_ang_targeting_flg[ax]) { //^[Qbgꍇ

            if (_angveloFace[ax] > 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance(ax, _angTargetFace[ax], TURN_COUNTERCLOCKWISE);
                if (_angveloFace[ax] > angDistance && _face_ang_target_allow_way[ax] != TURN_CLOCKWISE &&
                        _face_ang_target_allow_velo[ax] >= _angveloFace[ax]) {
                    _angveloFace[ax] = angDistance;
                    if (_face_ang_targeting_stop_flg[ax]) {
                        _face_ang_targeting_flg[ax] = false; //tO߂ďI
                        _face_ang_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else if (_angveloFace[ax] < 0) { //v̏ꍇ
                angle angDistance = getFaceAngDistance(ax, _angTargetFace[ax], TURN_CLOCKWISE);
                if (_angveloFace[ax] < angDistance && _face_ang_target_allow_way[ax] != TURN_COUNTERCLOCKWISE
                        && -1 * _face_ang_target_allow_velo[ax] <= _angveloFace[ax]) { //ڕWs߂Ă܂EEEȓ
                    _angveloFace[ax] = angDistance;
                    if (_face_ang_targeting_stop_flg[ax]) {
                        _face_ang_targeting_flg[ax] = false; //tO߂ďI
                        _face_ang_targeting_stop_flg[ax] = false;
                    }
                } else {
                    // ȂɂȂĂ悢
                }
            } else {
                //_angveloFace[ax] == 0
                angle angDistance = getFaceAngDistance(ax, _angTargetFace[ax], TURN_CLOSE_TO);
                if (angDistance == 0) {
                    if (_face_ang_targeting_stop_flg[ax]) {
                        _face_ang_targeting_flg[ax] = false; //tO߂ďI
                        _face_ang_targeting_stop_flg[ax] = false;
                    }
                }
            }

            //Actorɔf
            (*(_apActorFaceAng[ax])) = UTIL::simplifyAng((*(_apActorFaceAng[ax])) + _angveloFace[ax]);
            if (_face_ang_targeting_flg[ax] == false) {
                //ڕWɓB̏
                //_angveloTopFace[ax] = D360ANG; //ʕp̊px  360,000 angle/fream
                //_angveloBottomFace[ax] = D360ANG * -1; //ʕp̊px  -360,000 angle/fream
                //ڕWɓBA~sȂ
                _angacceFace[ax] = 0; //]pApxO
                setFaceAngVelo(ax, 0); //]pApxO
            }

        } else {
            //^[Qbgꍇ
            //Actorɔf
            (*(_apActorFaceAng[ax])) = UTIL::simplifyAng((*(_apActorFaceAng[ax])) +  _angveloFace[ax]);
        }

    }


    ///////////////////////////////////////////////////Mover

    //_accMv += _jerkMv;
    //ړx̏
    _veloMv += _accMv;
    if (_veloMv > _veloTopMv) {
        _veloMv = _veloTopMv;
    } else if (_veloMv < _veloBottomMv) {
        _veloMv = _veloBottomMv;
    }

    ///////////
    //ڕWړpiZ]jAO~@\gp̏ꍇ
    if (_mv_ang_rz_target_flg) {

        _angveloRzMv += _angacceRzMv;
        setRzMvAngVelo(_angveloRzMv);

        if (_angveloRzMv > 0) { //v̏ꍇ
            angle angDistance = getRzMvAngDistance(_angTargetRzMv, TURN_COUNTERCLOCKWISE);
            if (_angveloRzMv > angDistance && _mv_ang_rz_target_allow_way != TURN_CLOCKWISE
                    && _mv_ang_rz_target_allow_velo >= _angveloRzMv) { //ڕWs߂Ă܂EEEȓ
                addRzMvAng(angDistance);
                if (_mv_ang_rz_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_rz_target_flg = false; //tO߂ďI
                    _mv_ang_rz_target_stop_flg = false;
                }
            } else {
                addRzMvAng(_angveloRzMv);
            }
        } else if (_angveloRzMv < 0) { //v̏ꍇ

            angle angDistance = getRzMvAngDistance(_angTargetRzMv, TURN_CLOCKWISE);
            if (_angveloRzMv < angDistance && _mv_ang_rz_target_allow_way != TURN_COUNTERCLOCKWISE
                    && -1*_mv_ang_rz_target_allow_velo <= _angveloRzMv) {
                addRzMvAng(angDistance);
                if (_mv_ang_rz_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_rz_target_flg = false; //tO߂ďI
                    _mv_ang_rz_target_stop_flg = false;
                }
            } else {
                addRzMvAng(_angveloRzMv);
            }
        } else {
            angle angDistance = getRzMvAngDistance(_angTargetRzMv, TURN_CLOSE_TO);
            if (angDistance == 0) {
                addRzMvAng(angDistance);
                if (_mv_ang_rz_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_rz_target_flg = false; //tO߂ďI
                    _mv_ang_rz_target_stop_flg = false;
                }
            }
        }
        if (_mv_ang_rz_target_flg == false) {
            //_angveloRzTopMv = D360ANG; //ړpiZ]j̊px  360,000 angle/fream
            //_angveloRzBottomMv = D360ANG * -1; //ړpiZ]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacceRzMv = 0; //ZړpApxO
            setRzMvAngVelo(0); //ZړpApxO
        }

    } else {
        //if (_angacceRzMv != 0) {

        _angacceRzMv += _angjerkRzMv;
        //t[̈ړpiZ]j̏
        _angveloRzMv += _angacceRzMv;
        if (_angveloRzMv != 0) {
            addRzMvAng(_angveloRzMv);
        }
        //}
    }
    ////////////////
    //ڕWړpiY]jAO~@\gp̏ꍇ
    if (_mv_ang_ry_target_flg) {

        _angveloRyMv += _angacceRyMv;
        setRyMvAngVelo(_angveloRyMv);

        if (_angveloRyMv > 0) { //݂͔v̏ꍇ
            angle angDistance = getRyMvAngDistance(_angTargetRyMv, TURN_COUNTERCLOCKWISE);
            if (_angveloRyMv > angDistance &&
                _mv_ang_ry_target_allow_way != TURN_CLOCKWISE &&
                _mv_ang_ry_target_allow_velo >= _angveloRyMv)
            { //ڕWs߂Ă܂EEEȓ
                addRyMvAng(angDistance);
                if (_mv_ang_ry_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_ry_target_flg = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angveloRyMv);
            }
        } else if (_angveloRyMv < 0) { //݂͎v̏ꍇ

            angle angDistance = getRyMvAngDistance(_angTargetRyMv, TURN_CLOCKWISE);
            if (_angveloRyMv < angDistance &&
                _mv_ang_ry_target_allow_way != TURN_COUNTERCLOCKWISE &&
                -1*_mv_ang_ry_target_allow_velo <= _angveloRyMv)
            {
                addRyMvAng(angDistance);
                if (_mv_ang_ry_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_ry_target_flg = false; //tO߂ďI
                }
            } else {
                addRyMvAng(_angveloRyMv);
            }
        } else { //_angveloRyMv==0
            angle angDistance = getRyMvAngDistance(_angTargetRyMv, TURN_CLOSE_TO);
            if (angDistance == 0) {
                addRyMvAng(angDistance);
                if (_mv_ang_ry_target_stop_flg) { //~w肠Ȃ
                    _mv_ang_ry_target_flg = false; //tO߂ďI
                    _mv_ang_ry_target_stop_flg = false;
                }
            }
        }
        if (_mv_ang_ry_target_flg == false) {
            //_angveloRyTopMv = D360ANG; //ړpiY]j̊px  360,000 angle/fream
            //_angveloRyBottomMv = D360ANG*-1; //ړpiY]j̊px  -360,000 angle/fream

            //ڕWɓBA~sȂ
            _angacceRyMv = 0; //YړpApxO
            setRyMvAngVelo(0); //YړpApxO
        }

    } else {
        //if (_angacceRyMv != 0) {
        _angacceRyMv += _angjerkRyMv;
        //t[̈ړpiY]j̏
        _angveloRyMv += _angacceRyMv;
        if(_angveloRyMv != 0) {
            addRyMvAng(_angveloRyMv);
        }
        //}
    }

    ///////////////
    if (_taget_face_ang_alltime_flg && _face_ang_targeting_flg[AXIS_Z] == false && _face_ang_targeting_flg[AXIS_Y] == false) {
        if (_taget_face_ang_alltime_pActor) {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        } else {
            keepOnTurningFaceAngTwd(
                    _taget_face_ang_alltime_pActor->_x,
                    _taget_face_ang_alltime_pActor->_y,
                    _taget_face_ang_alltime_pActor->_z,
                    _taget_face_ang_alltime_angVelo,
                    _taget_face_ang_alltime_angAcce,
                    _taget_face_ang_alltime_way,
                    _taget_face_ang_alltime_optimize_ang);
        }

    }
    //Actorɔf
    _pActor->_x += (coord)(_vX * _veloMv);
    _pActor->_y += (coord)(_vY * _veloMv);
    _pActor->_z += (coord)(_vZ * _veloMv);
}

void GgafDxKuroko::setFaceAngVelo(axis prm_axis, angvelo prm_angveloRot) {
    if (prm_angveloRot > _angveloTopFace[prm_axis]) {
        _angveloFace[prm_axis] = _angveloTopFace[prm_axis];
    } else if (prm_angveloRot < _angveloBottomFace[prm_axis]) {
        _angveloFace[prm_axis] = _angveloBottomFace[prm_axis];
    } else {
        _angveloFace[prm_axis] = prm_angveloRot;
    }
}

void GgafDxKuroko::setFaceAngVelo(angvelo prm_axis_x_angveloRot,
                                   angvelo prm_axis_y_angveloRot,
                                   angvelo prm_axis_z_angveloRot) {
    setFaceAngVelo(AXIS_X, prm_axis_x_angveloRot);
    setFaceAngVelo(AXIS_Y, prm_axis_y_angveloRot);
    setFaceAngVelo(AXIS_Z, prm_axis_z_angveloRot);
}

void GgafDxKuroko::forceFaceAngVeloRange(axis prm_axis,
                                          angvelo prm_angveloRot01,
                                          angvelo prm_angveloRot02) {
    if (prm_angveloRot01 < prm_angveloRot02) {
        _angveloTopFace[prm_axis] = prm_angveloRot02;
        _angveloBottomFace[prm_axis] = prm_angveloRot01;
    } else {
        _angveloTopFace[prm_axis] = prm_angveloRot01;
        _angveloBottomFace[prm_axis] = prm_angveloRot02;
    }
    setFaceAngVelo(prm_axis, _angveloFace[prm_axis]); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setFaceAngAcce(axis prm_axis, angacce prm_angacceRot) {
    _angacceFace[prm_axis] = prm_angacceRot;
}

void GgafDxKuroko::setStopTargetFaceAngTwd(axis prm_axis,
                                            coord prm_tx,
                                            coord prm_ty,
                                            int prm_way_allow,
                                            angvelo prm_angveloAllowRyMv) {
    setStopTargetFaceAng(
      prm_axis,
      UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)),
      prm_way_allow,
      prm_angveloAllowRyMv
    );
}

void GgafDxKuroko::setStopTargetFaceAng(axis prm_axis,
                                        angle prm_angTargetRot,
                                        int prm_way_allow,
                                        angvelo prm_angveloAllow) {
    _face_ang_targeting_flg[prm_axis] = true;
    _face_ang_targeting_stop_flg[prm_axis] = true;
    _angTargetFace[prm_axis] = UTIL::simplifyAng(prm_angTargetRot);
    _face_ang_target_allow_way[prm_axis] = prm_way_allow;
    _face_ang_target_allow_velo[prm_axis] = prm_angveloAllow;
}

angle GgafDxKuroko::getFaceAngDistance(axis prm_axis, coord prm_tx, coord prm_ty, int prm_way) {
    return getFaceAngDistance(
               prm_axis,
               UTIL::getAngle2D(prm_tx-(_pActor->_x), prm_ty-(_pActor->_y)),
               prm_way);
}

angle GgafDxKuroko::getFaceAngDistance(axis prm_axis, angle prm_angTargetRot, int prm_way) {
    return UTIL::getAngDiff( (*(_apActorFaceAng[prm_axis])),  prm_angTargetRot, prm_way);
}

void GgafDxKuroko::forceMvVeloRange(velo prm_velo) {
    forceMvVeloRange(-prm_velo, prm_velo);
}

void GgafDxKuroko::forceMvVeloRange(velo prm_veloMv01, velo prm_veloMv02) {
    if (prm_veloMv01 < prm_veloMv02) {
        _veloTopMv = prm_veloMv02;
        _veloBottomMv = prm_veloMv01;
    } else {
        _veloTopMv = prm_veloMv01;
        _veloBottomMv = prm_veloMv02;
    }
    setMvVelo(_veloMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setMvVelo(velo prm_veloMv) {
    if (prm_veloMv > _veloTopMv) {
        _veloMv = _veloTopMv;
    } else if (prm_veloMv < _veloBottomMv) {
        _veloMv = _veloBottomMv;
    } else {
        _veloMv = prm_veloMv;
    }
}

void GgafDxKuroko::addMvVelo(velo prm_veloMv_Offset) {
    setMvVelo(_veloMv + prm_veloMv_Offset);
}

void GgafDxKuroko::setMvAcce(int prm_acceMove) {
    _accMv = prm_acceMove;
}

frame GgafDxKuroko::setMvAcceToStop(coord prm_target_distance) {
    double acc = UTIL::getAcceToStop(prm_target_distance, _veloMv);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    return (frame)((2.0*prm_target_distance) / _veloMv); //gpt[
}

frame GgafDxKuroko::setFaceAngAcceToStop(axis prm_axis, angle prm_target_angle_distance) {
    double acc = UTIL::getAcceToStop(prm_target_angle_distance, _angveloFace[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacceFace[prm_axis] = acc;
    return (frame)((2.0*prm_target_angle_distance) / _angveloFace[prm_axis]); //gpt[
}

frame GgafDxKuroko::setMvAcceByD(coord prm_target_distance, velo prm_target_velo) {
    double acc = UTIL::getAcceByVd(_veloMv, prm_target_velo, prm_target_distance);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    return (frame)((1.0*prm_target_velo - _veloMv) / acc); //gpt[
}
frame GgafDxKuroko::setFaceAngAcceByD(axis prm_axis, angle prm_target_angle_distance, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByVd(prm_target_angvelo, prm_target_angle_distance, _angveloFace[prm_axis]);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacceFace[prm_axis] = acc;
    return (frame)((1.0*prm_target_angvelo - _angveloFace[prm_axis]) / acc); //gpt[
}
    // y⑫z
    // V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇ́AD(ڕW)LŖȂB
    // ł
    // V0 < 0     Vt > 0  ꍇA邢  V0 > 0     Vt < 0   ꍇ́AǂȂ邩H
    //
    //    x(v)
    //     ^        a:x
    //     |        D:ړiڕWBxɒB܂łɔ₷j
    //     |       V0:_̑x
    //     |       Vt:ڕWBx
    //     |       Te:ڕWBxɒB̎ԁit[j
    //  V0 |
    //     |_
    //     |  _  Xa
    //     | D1 _
    //     |      _ Tc     Te
    //   --+--------_------+---> (t)
    //   0 |          _ D2 |
    //     |            _  |
    //   Vt|.............._|
    //     |
    //
    //    D Ŝ̈ړƂ
    //    D = D1 - D2 , v = 0  t  Tc Ƃ
    //
    //    D1 = (1/2) V0 Tc
    //    D2 = (1/2) -Vt (Te - Tc)
    //    D = D1 - D2 
    //    D = (1/2) V0 Tc -  { (1/2) -Vt (Te - Tc) }
    //      = (V0 Tc + Vt Te - Vt Tc) / 2    EEE@
    //
    //     v = a t + V0 ɂ v = 0  t = Tc ł̂
    //    0 = a Tc + V0
    //    Tc = -V0 / a
    //     @ ֑
    //    D = (V0 (-V0 / a) + Vt Te - Vt (-V0 / a)) / 2 EEEA
    //    ܂ a = (Vt - V0) / Te ł̂
    //    Te = (Vt - V0) / a  A ֑
    //    
    //    D = (V0 (-V0 / a) + Vt ((Vt - V0) / a) - Vt (-V0 / a)) / 2
    //
    //    a ɂĉ
    //
    //    D = ( -(V0^2) / a  + (Vt (Vt - V0)) / a + (Vt V0) / a) / 2
    //    a D = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2
    //    a = { -(V0^2) + (Vt (Vt - V0)) + (Vt V0) } / 2D
    //    a = (-(V0^2) + Vt^2 - Vt V0 + Vt V0) / 2D
    //    a = (Vt^2 - V0^2) / 2D
    //
    //     a = (Vt^2 - V0^2) / 2D ƂȂ̂
    //    V0 <= 0    Vt <= 0 ꍇA邢  V0 >= 0    Vt >= 0  ꍇƓł

coord GgafDxKuroko::setMvAcceByT(frame prm_target_frames, velo prm_target_velo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _veloMv, prm_target_velo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _accMv = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_veloMv + prm_target_velo) * prm_target_frames) / 2 ;
}
angle GgafDxKuroko::setFaceAngAcceByT(axis prm_axis, frame prm_target_frames, angvelo prm_target_angvelo) {
    double acc = UTIL::getAcceByTv(prm_target_frames, _angveloFace[prm_axis], prm_target_angvelo);
    if (acc > 0.0) {
        acc += 0.5;
    } else if (acc < 0.0) {
        acc -= 0.5;
    }
    _angacceFace[prm_axis] = acc;
    //  D = (1/2) (Vo + Vt) Te
    return ((_angveloFace[prm_axis] + prm_target_angvelo) * prm_target_frames) / 2 ;
}

void GgafDxKuroko::setRzMvAng(angle prm_ang) {
    if (prm_ang !=  _angRzMv) {
        _angRzMv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _angRzMv;
    }
}

void GgafDxKuroko::addRzMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_angveloRzBottomMv > prm_angDistance) {
        angOffset = _angveloRzBottomMv;
    } else if (prm_angDistance > _angveloRzTopMv) {
        angOffset = _angveloRzTopMv;
    }
    setRzMvAng(_angRzMv + angOffset);
}

void GgafDxKuroko::setRzMvAngVelo(angvelo prm_angveloRzMv) {
    if (prm_angveloRzMv > _angveloRzTopMv) {
        _angveloRzMv = _angveloRzTopMv;
    } else if (prm_angveloRzMv < _angveloRzBottomMv) {
        _angveloRzMv = _angveloRzBottomMv;
    } else {
        _angveloRzMv = prm_angveloRzMv;
    }
}

void GgafDxKuroko::setRzMvAngAcce(angacce prm_angacceRzMv) {
    _angacceRzMv = prm_angacceRzMv;
}

void GgafDxKuroko::forceRzMvAngVeloRange(angvelo prm_angveloRzMv01,
                                         angvelo prm_angveloRzMv02) {
    if (prm_angveloRzMv01 < prm_angveloRzMv02) {
        _angveloRzTopMv = prm_angveloRzMv02;
        _angveloRzBottomMv = prm_angveloRzMv01;
    } else {
        _angveloRzTopMv = prm_angveloRzMv01;
        _angveloRzBottomMv = prm_angveloRzMv02;
    }
    setRzMvAngVelo(_angveloRzMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setStopTargetRzMvAng(angle prm_angTargetRzMv,
                                         int prm_way_allow,
                                         angvelo prm_angveloAllowRyMv) {
    _mv_ang_rz_target_flg = true;
    _mv_ang_rz_target_stop_flg = true;
    _angTargetRzMv = UTIL::simplifyAng(prm_angTargetRzMv);
    _mv_ang_rz_target_allow_way = prm_way_allow;
    _mv_ang_rz_target_allow_velo = prm_angveloAllowRyMv;
}

angle GgafDxKuroko::getRzMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRzMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)), prm_way);
}

angle GgafDxKuroko::getRzMvAngDistance(angle prm_angTargetRzMv, int prm_way) {
    return UTIL::getAngDiff(_angRzMv, prm_angTargetRzMv, prm_way);
}


//void GgafDxKuroko::setRyMvAngTwd(coord prm_tx, coord prm_ty) {
//    setRyMvAng(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)));
//}

void GgafDxKuroko::setRyMvAng(angle prm_ang) {
    if (prm_ang != _angRyMv) {
        _angRyMv = UTIL::simplifyAng(prm_ang);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _angRyMv;
    }
}

void GgafDxKuroko::addRyMvAng(angle prm_angDistance) {
    angle angOffset = prm_angDistance;
    if (_angveloRyBottomMv > prm_angDistance) {
        angOffset = _angveloRyBottomMv;
    } else if (prm_angDistance > _angveloRyTopMv) {
        angOffset = _angveloRyTopMv;
    }
    setRyMvAng(_angRyMv + angOffset);
}

void GgafDxKuroko::setRyMvAngVelo(angvelo prm_angveloRyMv) {
    if (prm_angveloRyMv > _angveloRyTopMv) {
        _angveloRyMv = _angveloRyTopMv;
    } else if (prm_angveloRyMv < _angveloRyBottomMv) {
        _angveloRyMv = _angveloRyBottomMv;
    } else {
        _angveloRyMv = prm_angveloRyMv;
    }
}

void GgafDxKuroko::setRyMvAngAcce(angacce prm_angacceRyMv) {
    _angacceRyMv = prm_angacceRyMv;
}

void GgafDxKuroko::forceRyMvAngVeloRange(angvelo prm_angveloRyMv01,
                                         angvelo prm_angveloRyMv02) {
    if (prm_angveloRyMv01 < prm_angveloRyMv02) {
        _angveloRyTopMv = prm_angveloRyMv02;
        _angveloRyBottomMv = prm_angveloRyMv01;
    } else {
        _angveloRyTopMv = prm_angveloRyMv01;
        _angveloRyBottomMv = prm_angveloRyMv02;
    }
    setRyMvAngVelo(_angveloRyMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::forceRzRyMvAngVeloRange(angvelo prm_angveloRzRyMv01, angvelo prm_angveloRzRyMv02) {
    if (prm_angveloRzRyMv01 < prm_angveloRzRyMv02) {
        _angveloRzTopMv = prm_angveloRzRyMv02;
        _angveloRzBottomMv = prm_angveloRzRyMv01;
        _angveloRyTopMv = prm_angveloRzRyMv02;
        _angveloRyBottomMv = prm_angveloRzRyMv01;
    } else {
        _angveloRzTopMv = prm_angveloRzRyMv01;
        _angveloRzBottomMv = prm_angveloRzRyMv02;
        _angveloRyTopMv = prm_angveloRzRyMv01;
        _angveloRyBottomMv = prm_angveloRzRyMv02;
    }
    setRzMvAngVelo(_angveloRzMv); //Đݒ肵Ĕ͈͓ɕ␳
    setRyMvAngVelo(_angveloRyMv); //Đݒ肵Ĕ͈͓ɕ␳
}

void GgafDxKuroko::setRzRyMvAngAcce(angacce prm_angacceRzMv, angacce prm_angacceRyMv) {
    _angacceRzMv = prm_angacceRzMv;
    _angacceRyMv = prm_angacceRyMv;
}

void GgafDxKuroko::setRzRyMvAngVelo(angvelo prm_angveloRzMv, angvelo prm_angveloRyMv) {
    if (prm_angveloRzMv > _angveloRzTopMv) {
        _angveloRzMv = _angveloRzTopMv;
    } else if (prm_angveloRzMv < _angveloRzBottomMv) {
        _angveloRzMv = _angveloRzBottomMv;
    } else {
        _angveloRzMv = prm_angveloRzMv;
    }
    if (prm_angveloRyMv > _angveloRyTopMv) {
        _angveloRyMv = _angveloRyTopMv;
    } else if (prm_angveloRyMv < _angveloRyBottomMv) {
        _angveloRyMv = _angveloRyBottomMv;
    } else {
        _angveloRyMv = prm_angveloRyMv;
    }
}

void GgafDxKuroko::setStopTargetRyMvAng(angle prm_angTargetRyMv,
                                        int prm_way_allow,
                                        angvelo prm_angveloAllowRyMv) {
    _mv_ang_ry_target_flg = true;
    _mv_ang_ry_target_stop_flg = true;
    _angTargetRyMv = UTIL::simplifyAng(prm_angTargetRyMv);
    _mv_ang_ry_target_allow_way = prm_way_allow;
    _mv_ang_ry_target_allow_velo = prm_angveloAllowRyMv;
}

angle GgafDxKuroko::getRyMvAngDistanceTwd(coord prm_tx, coord prm_ty, int prm_way) {
    return getRyMvAngDistance(UTIL::getAngle2D(prm_tx - (_pActor->_x), prm_ty - (_pActor->_y)),
                                        prm_way);
}

angle GgafDxKuroko::getRyMvAngDistance(angle prm_angTargetRyMv, int prm_way) {
    return UTIL::getAngDiff(_angRyMv, prm_angTargetRyMv, prm_way);
}

void GgafDxKuroko::getRzRyMvAngDistanceTwd(angle prm_target_angRz, angle prm_target_angRy, int prm_way,
                                           angle& out_d_angRz, angle& out_d_angRy) {
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        //ڕWɓB邽߂ɂ́AɂQp^[B
        //ꂼꋅʏ̂Q_̋ȈՋߎlixD̂߁jŔrA߂Ǝvق̗pB
        angle d1_angRz = getRzMvAngDistance(prm_target_angRz, TURN_CLOSE_TO); //Rz̍
        angle d1_angRy = getRyMvAngDistance(prm_target_angRy, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getRzMvAngDistance(prm_target_angRz, TURN_CLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(prm_target_angRy, TURN_CLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) { //߂̗p
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else if (prm_way == TURN_ANTICLOSE_TO) {
        angle d1_angRz = getRzMvAngDistance(prm_target_angRz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getRyMvAngDistance(prm_target_angRy, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getRzMvAngDistance(prm_target_angRz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getRyMvAngDistance(prm_target_angRy, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 >= d2) { //艓̗p
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getRzMvAngDistance(prm_target_angRz, TURN_COUNTERCLOCKWISE);
        angle d1_angRy = getRyMvAngDistance(prm_target_angRy, TURN_COUNTERCLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getRzMvAngDistance(prm_target_angRz, TURN_COUNTERCLOCKWISE);
        angle d2_angRy = getRyMvAngDistance(prm_target_angRy, TURN_COUNTERCLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getRzMvAngDistance(prm_target_angRz, TURN_CLOCKWISE);
        angle d1_angRy = getRyMvAngDistance(prm_target_angRy, TURN_CLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getRzMvAngDistance(prm_target_angRz, TURN_CLOCKWISE);
        angle d2_angRy = getRyMvAngDistance(prm_target_angRy, TURN_CLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else {
        //
        throwGgafCriticalException("GgafDxKuroko::getRzRyMvAngDistanceTwd() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKuroko::getRzRyFaceAngDistanceTwd(angle prm_target_angRz, angle prm_target_angRy,int prm_way,
                                               angle& out_d_angRz, angle& out_d_angRy) {
    if (prm_way == TURN_CLOSE_TO) { //߂ق]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_CLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_CLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_CLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_CLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }

    } else if (prm_way == TURN_ANTICLOSE_TO) { //̉]
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_ANTICLOSE_TO);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_ANTICLOSE_TO);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_ANTICLOSE_TO);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_ANTICLOSE_TO);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 >= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else if (prm_way == TURN_COUNTERCLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_COUNTERCLOCKWISE);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_COUNTERCLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_COUNTERCLOCKWISE);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_COUNTERCLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else if (prm_way == TURN_CLOCKWISE) { //v̏ꍇ
        angle d1_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_CLOCKWISE);
        angle d1_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_CLOCKWISE);
        angle d1 = ABS(d1_angRz) + ABS(d1_angRy);
        UTIL::anotherRzRy(prm_target_angRz, prm_target_angRy);
        angle d2_angRz = getFaceAngDistance(AXIS_Z, prm_target_angRz, TURN_CLOCKWISE);
        angle d2_angRy = getFaceAngDistance(AXIS_Y, prm_target_angRy, TURN_CLOCKWISE);
        angle d2 = ABS(d2_angRz) + ABS(d2_angRy);
        if (d1 <= d2) {
            out_d_angRz = d1_angRz;
            out_d_angRy = d1_angRy;
        } else {
            out_d_angRz = d2_angRz;
            out_d_angRy = d2_angRy;
        }
    } else {
        //
        throwGgafCriticalException("GgafDxKuroko::getRzRyMvAngDistanceTwd() prm_way="<<prm_way<<" ͑zOłB_pActor="<<_pActor->getName());
    }
}

void GgafDxKuroko::setRzRyMvAng(angle prm_angRz, angle prm_angRy) {
    if (prm_angRz != _angRzMv || prm_angRy !=_angRyMv ) {
        _angRzMv = UTIL::simplifyAng(prm_angRz);
        _angRyMv = UTIL::simplifyAng(prm_angRy);
        UTIL::convRzRyToVector(_angRzMv, _angRyMv, _vX, _vY, _vZ);
    }
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _angRzMv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _angRyMv;
    }
}

void GgafDxKuroko::setRzRyMvAng_by_RyRz(angle prm_angRyRz_Ry, angle prm_angRyRz_Rz) {
    angle RyRz_Ry = UTIL::simplifyAng(prm_angRyRz_Ry);
    angle RyRz_Rz = UTIL::simplifyAng(prm_angRyRz_Rz);
    float out_vY, out_vZ;
    UTIL::convRzRyToVector(RyRz_Ry, D360ANG-RyRz_Rz, _vX, out_vY, out_vZ);
    _vY = -1.0f*out_vZ;
    _vZ = out_vY;
    UTIL::convVectorToRzRy(_vX, _vZ, _vY, _angRzMv, _angRyMv);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _angRzMv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _angRyMv;
    }
}


void GgafDxKuroko::setMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           _vX, _vY, _vZ,
                           _angRzMv, _angRyMv );
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _angRzMv;
    }
    if (_relate_RyFaceAng_with_RyMvAng_flg) {
        _pActor->_ry = _angRyMv;
    }
}

void GgafDxKuroko::reverseMvAng() {
    _vX = -_vX;
    _vY = -_vY;
    _vZ = -_vZ;
    _angRzMv = UTIL::simplifyAng(_angRzMv-D180ANG);
    if (_relate_RzFaceAng_with_RzMvAng_flg) {
        _pActor->_rz = _angRzMv;
    }
}

void GgafDxKuroko::setStopTargetMvAngTwd(GgafDxGeometricActor* prm_pActor_Target) {
    setStopTargetMvAngTwd(
        prm_pActor_Target->_x,
        prm_pActor_Target->_y,
        prm_pActor_Target->_z
    );
}

void GgafDxKuroko::setStopTargetMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz) {
    angle angRz_Target;
    angle angRy_Target;
    float dummy1, dummy2, dummy3;

    UTIL::convVectorToRzRy(
                   prm_tx - _pActor->_x,
                   prm_ty - _pActor->_y,
                   prm_tz - _pActor->_z,
                   dummy1,
                   dummy2,
                   dummy3,
                   angRz_Target,
                   angRy_Target
                 );
    setStopTargetRzMvAng(angRz_Target);
    setStopTargetRyMvAng(angRy_Target);
}

void GgafDxKuroko::turnRzRyFaceAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                                      angvelo prm_angVelo, angacce prm_angAcce,
                                      int prm_way, bool prm_optimize_ang) {
    angle out_d_angRz;
    angle out_d_angRy;
    if (prm_optimize_ang) {
        getRzRyFaceAngDistanceTwd(prm_angRz_Target, prm_angRy_Target,prm_way,
                                   out_d_angRz, out_d_angRy);
    } else {
        out_d_angRz = getFaceAngDistance(AXIS_Z, prm_angRz_Target, prm_way);
        out_d_angRy = getFaceAngDistance(AXIS_Y, prm_angRy_Target, prm_way);
    }
    double drz = ABS(out_d_angRz);
    double dry = ABS(out_d_angRy);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_angRz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angVelo);
            setFaceAngAcce(AXIS_Z, prm_angAcce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angVelo);
            setFaceAngAcce(AXIS_Z, -prm_angAcce);
        }
        if (out_d_angRy > 0) {
            setFaceAngVelo(AXIS_Y, prm_angVelo*drr);
            setFaceAngAcce(AXIS_Y, prm_angAcce*drr);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angVelo*drr);
            setFaceAngAcce(AXIS_Y, -prm_angAcce*drr);
        }
    } else if (drz < dry) {
        double drr = drz / dry ;
        if (out_d_angRz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angVelo*drr);
            setFaceAngAcce(AXIS_Z, prm_angAcce*drr);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angVelo*drr);
            setFaceAngAcce(AXIS_Z, -prm_angAcce*drr);
        }
        if (out_d_angRy > 0) {
            setFaceAngVelo(AXIS_Y, prm_angVelo);
            setFaceAngAcce(AXIS_Y, prm_angAcce);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angVelo);
            setFaceAngAcce(AXIS_Y, -prm_angAcce);
        }
    } else {
        if (out_d_angRz > 0) {
            setFaceAngVelo(AXIS_Z, prm_angVelo);
            setFaceAngAcce(AXIS_Z, prm_angAcce);
        } else {
            setFaceAngVelo(AXIS_Z, -prm_angVelo);
            setFaceAngAcce(AXIS_Z, -prm_angAcce);
        }
        if (out_d_angRy > 0) {
            setFaceAngVelo(AXIS_Y, prm_angVelo);
            setFaceAngAcce(AXIS_Y, prm_angAcce);
        } else {
            setFaceAngVelo(AXIS_Y, -prm_angVelo);
            setFaceAngAcce(AXIS_Y, -prm_angAcce);
        }
    }

    setStopTargetFaceAng(AXIS_Z, prm_angRz_Target);
    setStopTargetFaceAng(AXIS_Y, prm_angRy_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::turnFaceAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                   angvelo prm_angVelo, angacce prm_angAcce,
                                   int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           out_angRz_Target,
                           out_angRy_Target);

    turnRzRyFaceAngTo(out_angRz_Target, out_angRy_Target,
                      prm_angVelo, prm_angAcce,
                      prm_way, prm_optimize_ang);
}


void GgafDxKuroko::turnFaceAng(axis prm_axis,
                               angle prm_angular_distance,
                               angvelo prm_angVelo, angacce prm_angAcce) {
    int s = SGN(prm_angular_distance);
    setFaceAngVelo(prm_axis, ABS(prm_angVelo)*s);
    setFaceAngAcce(prm_axis, ABS(prm_angAcce)*s);
    setStopTargetFaceAng(prm_axis, (*(_apActorFaceAng[prm_axis])) + prm_angular_distance);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}


void GgafDxKuroko::turnRzFaceAngTo(angle prm_angRz_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_Z, prm_angRz_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Z, prm_angVelo);
        setFaceAngAcce(AXIS_Z, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Z, -prm_angVelo);
        setFaceAngAcce(AXIS_Z, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_Z, prm_angRz_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::turnRyFaceAngTo(angle prm_angRy_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_Y, prm_angRy_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_Y, prm_angVelo);
        setFaceAngAcce(AXIS_Y, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_Y, -prm_angVelo);
        setFaceAngAcce(AXIS_Y, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_Y, prm_angRy_Target);
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
}

void GgafDxKuroko::spinRxFaceAngTo(angle prm_angRx_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way) {
    if (getFaceAngDistance(AXIS_X, prm_angRx_Target, prm_way) > 0) {
        setFaceAngVelo(AXIS_X, prm_angVelo);
        setFaceAngAcce(AXIS_X, prm_angAcce);
    } else {
        setFaceAngVelo(AXIS_X, -prm_angVelo);
        setFaceAngAcce(AXIS_X, -prm_angAcce);
    }
    setStopTargetFaceAng(AXIS_X, prm_angRx_Target);
}

void GgafDxKuroko::turnRzRyMvAngTo(angle prm_angRz_Target, angle prm_angRy_Target,
                                    angvelo prm_angVelo, angacce prm_angAcce,
                                    int prm_way, bool prm_optimize_ang) {
    angle out_d_angRz;
    angle out_d_angRy;
    if (prm_optimize_ang) {
        getRzRyMvAngDistanceTwd(prm_angRz_Target, prm_angRy_Target,prm_way,
                                out_d_angRz, out_d_angRy);
    } else {
        out_d_angRz = getRzMvAngDistance(prm_angRz_Target, prm_way);
        out_d_angRy = getRyMvAngDistance(prm_angRy_Target, prm_way);
    }

    //Rz, Ry AڕWAO֓ɓB悤Ɋpx𒲐
    double drz = ABS(out_d_angRz);
    double dry = ABS(out_d_angRy);
    if (drz > dry) {
        double drr = dry / drz ;
        if (out_d_angRz > 0) {
            setRzMvAngVelo(prm_angVelo);
            setRzMvAngAcce(prm_angAcce);
        } else {
            setRzMvAngVelo(-prm_angVelo);
            setRzMvAngAcce(-prm_angAcce);
        }
        if (out_d_angRy > 0) {
            setRyMvAngVelo(prm_angVelo*drr);
            setRyMvAngAcce(prm_angAcce*drr);
        } else {
            setRyMvAngVelo(-prm_angVelo*drr);
            setRyMvAngAcce(-prm_angAcce*drr);
        }
    } else if (drz < dry) {
        double drr = drz / dry;
        if (out_d_angRz > 0) {
            setRzMvAngVelo(prm_angVelo*drr);
            setRzMvAngAcce(prm_angAcce*drr);
        } else {
            setRzMvAngVelo(-prm_angVelo*drr);
            setRzMvAngAcce(-prm_angAcce*drr);
        }
        if (out_d_angRy > 0) {
            setRyMvAngVelo(prm_angVelo);
            setRyMvAngAcce(prm_angAcce);
        } else {
            setRyMvAngVelo(-prm_angVelo);
            setRyMvAngAcce(-prm_angAcce);
        }
    } else {
        if (out_d_angRz > 0) {
            setRzMvAngVelo(prm_angVelo);
            setRzMvAngAcce(prm_angAcce);
        } else {
            setRzMvAngVelo(-prm_angVelo);
            setRzMvAngAcce(-prm_angAcce);
        }
        if (out_d_angRy > 0) {
            setRyMvAngVelo(prm_angVelo);
            setRyMvAngAcce(prm_angAcce);
        } else {
            setRyMvAngVelo(-prm_angVelo);
            setRyMvAngAcce(-prm_angAcce);
        }
    }

    setStopTargetRzMvAng(prm_angRz_Target);
    setStopTargetRyMvAng(prm_angRy_Target);

}


void GgafDxKuroko::turnMvAngTwd(coord prm_tx, coord prm_ty, coord prm_tz,
                                angvelo prm_angVelo, angacce prm_angAcce,
                                int prm_way, bool prm_optimize_ang) {
    angle out_angRz_Target;
    angle out_angRy_Target;
    UTIL::convVectorToRzRy(prm_tx - _pActor->_x,
                           prm_ty - _pActor->_y,
                           prm_tz - _pActor->_z,
                           out_angRz_Target,
                           out_angRy_Target);
    turnRzRyMvAngTo(out_angRz_Target, out_angRy_Target,
                    prm_angVelo, prm_angAcce,
                    prm_way, prm_optimize_ang);
}
void GgafDxKuroko::turnRzMvAng(angle prm_angular_distance,
                               angvelo prm_angVelo, angacce prm_angAcce) {
    int s = SGN(prm_angular_distance);
    setRzMvAngVelo(ABS(prm_angVelo) * s);
    setRzMvAngAcce(ABS(prm_angAcce) * s);
    setStopTargetRzMvAng(_angRzMv+prm_angular_distance);
}

void GgafDxKuroko::turnRyMvAng(angle prm_angular_distance,
                               angvelo prm_angVelo, angacce prm_angAcce) {
    int s = SGN(prm_angular_distance);
    setRyMvAngVelo(ABS(prm_angVelo) * s);
    setRyMvAngAcce(ABS(prm_angAcce) * s);
    setStopTargetRyMvAng(_angRyMv+prm_angular_distance);
}

void GgafDxKuroko::turnRzMvAngTo(angle prm_angRz_Target,
                                 angvelo prm_angVelo, angacce prm_angAcce,
                                 int prm_way) {
    if (getRzMvAngDistance(prm_angRz_Target, prm_way) > 0) {
        setRzMvAngVelo(prm_angVelo);
        setRzMvAngAcce(prm_angAcce);
    } else {
        setRzMvAngVelo(-prm_angVelo);
        setRzMvAngAcce(-prm_angAcce);
    }
    setStopTargetRzMvAng(prm_angRz_Target);
}

void GgafDxKuroko::turnRyMvAngTo(angle prm_angRy_Target,
                                 angvelo prm_angVelo, angacce prm_angAcce,
                                 int prm_way) {
    if (getRyMvAngDistance(prm_angRy_Target, prm_way) > 0) {
        setRyMvAngVelo(prm_angVelo);
        setRyMvAngAcce(prm_angAcce);
    } else {
        setRyMvAngVelo(-prm_angVelo);
        setRyMvAngAcce(-prm_angAcce);
    }
    setStopTargetRyMvAng(prm_angRy_Target);
}

void GgafDxKuroko::takeoverMvFrom(GgafDxKuroko* const prm_pKuroko) {
    // L̈ړpPʃxNg
    _vX = prm_pKuroko->_vX;
    _vY = prm_pKuroko->_vY;
    _vZ = prm_pKuroko->_vZ;
    // ړpZ]p
    _angRzMv = prm_pKuroko->_angRzMv;
    // ړpY]p
    _angRyMv = prm_pKuroko->_angRyMv;
    // ړx
    _veloMv = prm_pKuroko->_veloMv;
    // ړx
    _veloTopMv = prm_pKuroko->_veloTopMv;
    // ړx
    _veloBottomMv = prm_pKuroko->_veloBottomMv;
    // ړx
    _accMv = prm_pKuroko->_accMv;
    // ړx
    //_jerkMv = prm_pKuroko->_jerkMv;
}

void GgafDxKuroko::stopTurnMvAng() {
    _mv_ang_rz_target_flg = false;
    _mv_ang_rz_target_stop_flg = false;
    _mv_ang_ry_target_flg = false;
    _mv_ang_ry_target_stop_flg = false;
    if (_pHlprC) {
        _pHlprC->stopTurnMvAng();
    }
}

void GgafDxKuroko::stopTurnFaceAng() {
    _face_ang_targeting_flg[AXIS_X] = false;
    _face_ang_targeting_flg[AXIS_Y] = false;
    _face_ang_targeting_flg[AXIS_Z] = false;
    _taget_face_ang_alltime_pActor = nullptr;
    _taget_face_ang_alltime_flg = false;
    if (_pHlprB) {
        _pHlprB->stopTurnFaceAng();
    }
}

bool GgafDxKuroko::isTurningFaceAng() {
    if (_face_ang_targeting_flg[AXIS_X] ||
        _face_ang_targeting_flg[AXIS_Y] ||
        _face_ang_targeting_flg[AXIS_Z] ) {
        return true;
    } else {
        if (_pHlprB) {
            return _pHlprB->isTurningFaceAng();
        } else {
            return false;
        }
        return false;
    }
}

bool GgafDxKuroko::isTurningMvAng() {
    if (_mv_ang_rz_target_flg || _mv_ang_ry_target_flg) {
        return true;
    } else {
        if (_pHlprC) {
            return _pHlprC->isTurningMvAng();
        } else {
            return false;
        }
    }
}

void GgafDxKuroko::stopMv() {
   setMvAcce(0);
   setMvVelo(0);
   if (_pHlprA) {
       _pHlprA->stopSlidingMv();
   }
}

GgafDxKuroko::~GgafDxKuroko() {
    GGAF_DELETE_NULLABLE(_pHlprA);
    GGAF_DELETE_NULLABLE(_pHlprB);
    GGAF_DELETE_NULLABLE(_pHlprC);
}


// yY^z{NX̍lƃRg̒P̕\
//
// Qނ̕
// uL̕vƂtBȂ߁ÂQނ̒P`BuړpijvƁuʕpijvB
// uړpv̓L̐iŝ݂\B́uړxvƔāAL͍Wړ邱ƂƂB
// uʕpv̓ĽiOĵ݂\鎖ƂB
// LN^ʂ̏㕔牺ֈړĂALN^͉Ƃ͌炸@ɌĂقꍇB
// ܂́AEɃLāAɈړƂBꂼQ̕ݒ肪KvB
//
// ړp̂Qނ̕\@
// LiޕA܂uړpv́̕A_Pʋ̕\ʂɌĐLтxNg (_vX, _vY, _vZ) ŕ\@ƁA
// Q]AOl (_angRzMv, _angRyMv) ŕ\@̂QޗpӂBNH[^jÎ͍Ƃ떳B
// _angRzMv  Z]pA _angRyMv  Y]p ӖĂB
// ͕xNgAܓxƌoxAipƃAW}Xj̊֌WɌāAΉ悤ƂB
// ӂ邱Ƃ́AY]pox ͏ɐ藧AZ]pܓx ́AZ]p  Y]p̏ԂłꍇɌ萬藧B
// {NXł́AuZ]  Y]̏ԂłZ]pEY]pvȗāAPɁuZ]pEY]pvƕ\鎖ƂB
// ꂼuړpiZjvuړpiYjvƕ\鎖B
//
// \[XR[h́Aϐ⃁\bh
// uRzMvvƂ\ĹuړpiZjvӖĂB
// uRyMvvƂ\ĹuړpiYjvӖĂB
// uRzRyMvvƂ\́uZ]  Y]̏Ԃ̈ړpv\ĂB
//
// Z]pAY]pƂ0xAxNg(1, 0, 0) ̕ƒ`B
// Z]p̐̑́AZ̐̕ĔvB
// Y]p̐̑́AY̐̕ĔvBƂB
//
// ƂŐwIɁupv́AxNgiXYZ̒ljŕ\邱ƂƎvB
// ̖{NXł́A悭ĝ͂Q\̕ŁA\bh _angRzMv  _angRyMv 𑀍삷̂SƂȂĂB
// ͌ǓŒPʕxNg߂Ă̂AW]vZA^ _angRzMv  _angRyMv ł񂴂sĂA
// ŌɂPPʃxNg߂BƂ̂ł͂ƍl߁Â悤Ȑ݌vɂȂB
// TODO:œK̗]nԎcĂnYB܂B
// (_angRzMv, _angRyMv)\bhɂ葀삵āAet[̍Ō̓ŕxNg(_vX, _vY, _vZ) 𓯊ĂB
// (_vX, _vY, _vZ)o[\bhg킸ڑ삷ƁA(_angRzMv, _angRyMv)Ƃ̓̂ŒӁB
// {NX̃\bhgpł́AȂƂ͋NȂB
//
// ړx:Velo or MvVelo
// Ĺuړxv(_veloMv)ێĂBړ@͊ȒPŁA{Iɖt[uړpvɁuړxvB
// Ẃuړpv(_vX, _vY, _vZ)Ɂuړxv(_veloMv)|ZĂB
// Pt[̍W݂͌̍W (_vX*_veloMv, _vY*_veloMv, _vZ*_veloMv) ړꏊłB
// ̃xNgɖ{Cu̒Pʋ(Q[̒Pƍl鐮{lj悶B
// āA(_vX*_veloMv*LEN_UNIT, _vY*_veloMv*LEN_UNIT, _vZ*_veloMv*LEN_UNIT)Pt[̍WB

// ʕp:AngFace
// L̃[JWŌĂpijuʕpvƌĂԂƂɂB
//uʕpv́A[hϊs̎]Ɠ]@łB
// [hϊs̎]Ƃ́AX]pAY]pAZ]p̂ƂŁAꂼA
// _angFace[AXIS_X], _angFace[AXIS_Y], _angFace[AXIS_Z] ƈvB
// {Cuł́AxNg(1, 0, 0) ĹuOvƐݒ肵ĂB
// Xt@CȂǂ̃Lf́AԂŐXɌĂ邱ƂOƂB܂Afúv́i0, 1, 0)ƂB
// [hϊs̉]s̊|鏇Ԃ́A{I uX]s > Z]s > Y]s > ړs v ƂB
// (  X > Y > Z ̏ł͂ȂIj
// āAX]p͊]悤ƂALĂ͕ς炸AcZ]pƁAY]pŃLĂ肷邱ƂƂB
// X]p̓L̃XsÂQpiZ]pEY]pjŃĹuOvp肷ƂꍇA
// uʕpvقǂ́uړpvƓ悤ɁAZ]pY]piܓxƌox)̂Q̃AOl
// (_angFace[AXIS_Z], _angFace[AXIS_Y])ŕ\łB
// ܂AuOv Z]pEY]p0xƂAႦ΁uv(Z]p,Y]p)=(0x,180x) ƕ\BB
// PɁuZ]pvȂǂƏƁAuړpvZ]pȂ̂AuʕpvZ]pȂ̂BɂȂ邽߁A
// uʕp(Z)vuʕp(Y)vƏƂƂBiuʕp(X)v邪A̓Xs\ւ̉e͂Ȃj
// Œӂ́AP̃LĂpɑ΂āAɂQʂ̃ANZX@ƂƁBႦ΁A
// uO(1, 0, 0)Đ^Ev  (ʕp(Z), ʕp(Y))=(0, 90x) or (180x,270x) Ƃŕ\łB
// iʕp(Y)͍nŴY̐Ĕvj
//  uOv (0x,0x) Ƃ (180x,180x) Ƃ\ł邵Au^v  (0x,180x) Ƃ (180x,0x) Ƃ\łB
// Ă͓Ap(L̏)قȂBpقȂƂ܂L͒ӂ邱ƁB
// RAuړpvłAQʂ̃ANZX@̂A͎p̂ŌڂŕȂB
// pxvZƂɉeoꍇ̂ŒӂKvB


// O@\
// Ă uړpiZjvuړpiYjvAꂼuʕp(Z)vuʕp(Y)v փRs[ĂƁA
// ړpƁALN^̌̓ȒPɎ邶ȂI
// uO@\vƂ́Auړpvݒ肷ƁAɔĎIɁuʕpvݒ肷鎖ƂB
// ̓Iɂ́Aȉ̂悤Ƀt[ɁAAOl㏑Rs[ijB͍Zi炩ɕ`jĂB
//  EړpiZj  ʕp(Z)
//  EړpiYj  ʕp(Y)
// uʕpvݒĂuړpvωȂit͊֘AȂĵŒӁB

// px:AngVelo
// uړpiZjvuړpiYjvAuʕp(Z)vuʕp(Y)vɂ́Aꂼ́upxv݂ĂB
// Ⴆ90xEɌꍇALȂJNƌςĂ͔߂̂ŁAt[pxpZ悤ɂāA
// 炩Ɍς悤ɂB
// upxv͐̒ӂKvB̏ꍇ͔vȀꍇ͎vɂȂB
// ]ꍇA^[QbgƂȂpxւ̓BAv[`͐]̂Qʂ肾A
// \5ʂ̍lŎwł悤݌vB
// 1.uɔvōsv TURN_ANTICLOSE_TO
// 2.uɎvōsv TURN_CLOCKWISE
// 3.u߂p̎ōsvTURN_CLOSE_TO
// 4.uȊp̎ōsvTURN_ANTICLOSE_TO
// 5.u݉Ă̂܂܂ōsv
// łBꂼpr̂ŁAIvVȂǂŁAIł悤ɂȁBłB



//̑ǋLA
//EړxAړppxA]ppxɂ́AꂼxݒłI
//E]́A{ Z > X > Y ̎]Ԃɂ̂ʓÎ悤B܂O̊TOZŉł킯AȂقǂ킩₷B
//  ݂ X > Z > Y ́AZOXłB
//  Ƃ2D̉XN[V[eBO낤ƎvĂA X > Z Ő݌vsĂ̂ł邪AǂȂB
//  ܂A3DV[eBOɂƂ͎łvĂ݂ȂEEE

// ړ: VxMv VyMv VzMv
// L̈ړ̌nƂ͂܂ʂɁAƗ XAYAZɕsȈړw肪łB
// uXړxvuYړxvuZړxvݒ肷ƁAt[(_x,_y,_z)ɂꂼ̈ړ
// ZB
// i̋@\ GgafDxAxesMover ɏW񂳂ƗNXƂȂ܂Ij

//2010/02/19ǋL
// ܂ɁuRyRzvƂ\݂iuRzRyvƈقȂjÁuY]  Z]̏Ԃ̈ړpv\Ă̂ŒӁB
//   ܂AuړpiZjv]̏Ԃ̈Ⴂ𖾊mɂ邽
//   uRzRyRzvuRyRzRzvƏ肵ĂƂBiPɁuRzv̏ꍇ́uRzRyRzvӖĂj

//ǋL
//E炩ړ\ɁI

//TODO:
//xixj̒ǉ
//Cӎ]iNH[^jIj
//NX̔剻  sړx
//yzZ߂
