#ifndef GGAFDXCORE_GGAFDXEFFECT_H_
#define GGAFDXCORE_GGAFDXEFFECT_H_
#include "jp/ggaf/core/GgafObject.h"

#include <d3dx9.h>
#include <string>

namespace GgafDxCore {

/**
 * GtFNgNX.
 * L(AN^[)̃GtFNgێNXłB<BR>
 * @version 1.00
 * @since 2009/03/09
 * @author Masatoshi Tsuge
 */
class GgafDxEffect : public GgafCore::GgafObject {
    friend class GgafDxEffectManager;

    static std::string getEffectFileName(std::string prm_file);

protected:
    static D3DXMACRO _aD3DXMacro_Defines[3];

public:
    D3DXHANDLE _h_alpha_master;
    /** [r]GtFNg`̎ʖB(50܂) */
    char* _effect_name;
    /** [r]GtFNg */
    ID3DXEffect* _pID3DXEffect;
#ifdef MY_DEBUG
    bool _begin;
#endif

public:
    /**
     * RXgN^<BR>
     * @param prm_effect_name GtFNg`̎ʖB".fx"ǉƃGtFNgt@CɂȂB
     */
    explicit GgafDxEffect(char* prm_effect_name);

    char* getName() {
        return _effect_name;
    }

    /**
     * 1t[1s邾ŗǂGtFNgp[^
     * ̃\bhɋLqB
     */
    virtual void setParamPerFrame() = 0;

    /**
     * fXgN^<BR>
     * deletêGgafDxEffectManagerł<BR>
     */
    virtual ~GgafDxEffect();
};

}
#endif /*GGAFDXCORE_GGAFDXEFFECT_H_*/
