#ifndef GGAFCORE_GGAFTABLE_H_
#define GGAFCORE_GGAFTABLE_H_
#include "jp/ggaf/core/GgafObject.h"

#include <string>
#include <vector>
#include <map>

/** GgafTablêPR[ȟ^ */
typedef std::map<std::string, std::string> GgafRecord;
/** GgafTablet@C̃Zp[^ */
#define GGAFTABLE_SEPA "\t"

namespace GgafCore {

/**
 * DB̃NGʂ̂悤ȃIuWFNgNX.
 * f[^S std::string ŕێĂB
 * @version 1.00
 * @since 2012/10/02
 * @author Masatoshi Tsuge
 */
class GgafTable : public GgafCore::GgafObject {

private:
    /**
     * ̗̔z񏇂̗vflŁAR[h\[gוς܂. <BR>
     * NCbN\[ggpB<BR>
     * @param prm_col \[g鏇Ԃ̗񖼔z
     * @param prm_col_num 񖼔zvf
     * @param prm_begin_index JnINDEX
     * @param prm_end_index IINDEX
     * @param prm_blank_is_max true:󕶎("")őlƂ܂^false:󕶎("")ŏlƂ܂B
     */
    void sortBy(std::string prm_col[], int prm_col_num, int prm_begin_index, int prm_end_index,
                bool prm_blank_is_max);

    /**
     * ̗̔z񏇂̗vflŁAR[h~\[gוς܂. <BR>
     * NCbN\[ggpB<BR>
     * @param prm_col ~\[g鏇Ԃ̗񖼔z
     * @param prm_col_num 񖼔zvf
     * @param prm_begin_index JnINDEX
     * @param prm_end_index IINDEX
     * @param prm_blank_is_max true:󕶎("")őlƂ܂^false:󕶎("")ŏlƂ܂B
     */
    void sortDescBy(std::string prm_col[], int prm_col_num, int prm_begin_index, int prm_end_index,
                    bool prm_blank_is_max);

    /** NG̗ԍƒl̃yAMapListł */
    std::vector<GgafRecord*> _lstTtable;

public:
    /**
     * ẽNG쐬 .
     */
    GgafTable();

    /**
     * TSVŃt@CǂݍŁANG쐬 .
     * @param prm_file_name
     */
    void importFromFile(std::string prm_file_name);

    /**
     * TSVŃt@Cɕۑ .
     * wb_[͂Ps(index=0)̃R[hMp܂B
     * @param prm_file_name ۑt@C
     */
    void exportToFile(std::string prm_file_name);

    /**
     * R[hԂ .
     * @return R[h
     */
    size_t getCount();

    bool hasRecord();

    /**
     * f[^擾 .
     * @param prm_col   
     * @param prm_index R[hindex(0`)
     * @return f[^l
     */
    std::string getVal(std::string& prm_col, int prm_index);

    /**
     * f[^擾 .
     * @param prm_col   
     * @param prm_index R[hindex(0`)
     * @return f[^l
     */
    std::string getVal(const char* prm_col, int prm_index);

    /**
     * f[^㏑ݒ肵܂ .
     * @param prm_col    
     * @param prm_index  R[hindex(0`)
     * @param prm_val    ㏑ݒl
     */
    void setVal(std::string& prm_col, int prm_index, std::string& prm_val);
    /**
     * f[^㏑ݒ肵܂ .
     * @param prm_col    
     * @param prm_index  R[hindex(0`)
     * @param prm_val    ㏑ݒl
     */
    void setVal(const char* prm_col, int prm_index, std::string& prm_val);
    /**
     * f[^㏑ݒ肵܂ .
     * @param prm_col    
     * @param prm_index  R[hindex(0`)
     * @param prm_val    ㏑ݒl
     */
    void setVal(std::string& prm_col, int prm_index, const char* prm_val);
    /**
     * f[^㏑ݒ肵܂ .
     * @param prm_col    
     * @param prm_index  R[hindex(0`)
     * @param prm_val    ㏑ݒl
     */
    void setVal(const char* prm_col, int prm_index, const char* prm_val);

    /**
     * R[h擾܂B .
     * @param prm_index R[hindex(0`)
     * @return
     */
    GgafRecord* getRecord(int prm_index);

    /**
     * R[h폜܂B .
     * @param prm_index R[hindex(0`)
     */
    void removeRow(int prm_index);

    /**
     * windexȍ~̃R[h폜܂B .
     * @param prm_start_index R[hindex(0`)
     */
    void removeRows(int prm_start_index);

    /**
     * w͈index̃R[h폜܂B .
     * @param prm_start_index 폜Jnindex(0 `)
     * @param prm_end_index   폜Iindex(0 ` getCount()-1)
     */
    void removeRows(int prm_start_index, int prm_end_index);

    /**
     * R[h𖖔sɒǉ܂ .
     * GgafRecord IuWFNg̃|C^nĉB<BR>
     * {NGIuWFNgJɁASGgafRecord̉sdlłB
     * Ăь GgafRecord IuWFNg delete ͕svB(ނAo܂BsȂŉ)
     * @param prm_pRow q[vɍ쐬R[hIuWFNgĩ|C^j
     */
    void addRow(GgafRecord* prm_pRow);

    /**
     * R[h𖖔sɋ󃌃R[hǉ܂
     */
    void addNewRow();

    /**
     * AB̃R[h̏ꏊ(INDEX)ւ܂. <BR>
     * @param prm_index_A ւΏۃR[hINDEX A
     * @param prm_index_B ւΏۃR[hINDEX B
     */
    void swapIndex(int prm_index_A, int prm_index_B);

    /**
     * ̗ŏ\[g܂ .
     * @param prm_col 
     * @param prm_blank_is_max 󕶎("")\[g̍őƂ邩ۂB
     */
    void sortBy(const char* prm_col, bool prm_blank_is_max);
    /**
     * ̗ŏ\[g܂ .
     * @param prm_col1  P\[g
     * @param prm_col2  Q\[g
     * @param prm_blank_is_max 󕶎("")\[g̍őƂ邩ۂB
     */
    void sortBy(const char* prm_col1, const char* prm_col2, bool prm_blank_is_max);
    void sortBy(const char* prm_col1, const char* prm_col2, const char* prm_col3, bool prm_blank_is_max);
    void sortBy(std::string prm_col[], int prm_col_num, bool prm_blank_is_max);

    void sortDescBy(const char* prm_col, bool prm_blank_is_max);
    void sortDescBy(const char* prm_col1, const char* prm_col2, bool prm_blank_is_max);
    void sortDescBy(const char* prm_col1, const char* prm_col2, const char* prm_col3, bool prm_blank_is_max);
    void sortDescBy(std::string prm_col[], int prm_col_num, bool prm_blank_is_max);

    /**
     * 󕶎lTABŕ .
     * <pre>
     * yz
     * std::vector<std::string> data = split("\taaa\tbbb\t\t\tcccc\tddd\teeee\t\t", "\t");
     * ʁ
     * data[0] = (󕶎)
     * data[1] = "aaa"
     * data[2] = "bbb"
     * data[3] = (󕶎)
     * data[4] = (󕶎)
     * data[5] = "cccc"
     * data[6] = "ddd"
     * data[7] = "eeee"
     * data[8] = (󕶎)
     * data[9] = (󕶎)
     * </pre>
     * @param str
     * @return ̃xN^Xg
     */
    static inline std::vector<std::string> split(std::string str) {
        std::vector<std::string> r;
        size_t cutAt;
        while ((cutAt = str.find_first_of(GGAFTABLE_SEPA)) != str.npos) {
            r.push_back(str.substr(0, cutAt));
            str = str.substr(cutAt + 1);
        }
        r.push_back(str);
        return r;
    }

    void dump();
    virtual ~GgafTable();
};

}
#endif /*GGAFCORE_GGAFTABLE_H_*/
