#include "stdafx.h"
#include "Stage01PartController.h"

#include "jp/ggaf/core/actor/GgafSceneDirector.h"
#include "jp/ggaf/dxcore/scene/supporter/GgafDxBgmPerformerForScene.h"
#include "jp/gecchi/VioletVreath/actor/VVEnemysHeader.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "../Stage.h"
#include "part/Stage01_01.h"
#include "part/Stage01_02.h"
#include "part/Stage01_03.h"
#include "part/Stage01_Climax.h"
#include "part/Stage01WalledScene.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

Stage01PartController::Stage01PartController(const char* prm_name) : StagePartController(prm_name) {
    _class_name = "Stage01PartController";

    // ȉ gen01 start ` end Excel}Nɂ莩ꂽR[hłB
    // R[h̕ύX́uV[Creater.xlsvsƂimۂ̂߁jB
    // gen01 start
	frame f[] = {1,200,202};
	_paFrame_NextEvent = new frame[3];
	memcpy(_paFrame_NextEvent, f, sizeof(f));
	_event_num = 3;
	orderSceneToFactory(10000000, Stage01WalledScene, "Stage01WalledScene-1");
	orderActorToFactory(10000001, EnemyHisbe, "EnemyHisbe-2");
    // gen01 end
    useProgress(Stage01PartController::PROG_BANPEI-1);
}

void Stage01PartController::initialize() {
    getProgress()->reset(Stage01PartController::PROG_INIT);
}

void Stage01PartController::processBehavior() {
    // ȉ gen02 start ` end Excel}Nɂ莩ꂽR[hłB
    // R[h̕ύX́uV[Creater.xlsvsƂimۂ̂߁jB
    // gen02 start
	if (getBehaveingFrame() == _paFrame_NextEvent[_cnt_event]) {
		switch (getBehaveingFrame()) {
			case 1: {
				break;
			}
			case 200: {
				Stage01WalledScene* pWScene = (Stage01WalledScene*)obtainSceneFromFactory(10000000);
				addSubLast(pWScene);
				break;
			}
			case 202: {
				EnemyHisbe* p = (EnemyHisbe*)obtainActorFromFactory(10000001);
				getSceneDirector()->addSubGroup(p);
				p->_x = PX_C(3500);
				p->_y = 0;
				p->_z = 1000000;
				p->setRyFaceAng(D90ANG);
				break;
			}
			default :
				break;
		}
		_cnt_event = (_cnt_event < 3-1 ? _cnt_event+1 : _cnt_event);
	}
    // gen02 end

    SceneProgress* pProg = getProgress();
    switch (pProg->get()) {
        case PROG_FAINAL: {
            if (pProg->isJustChanged()) {
                //STG01Climax_Ȉ
                _TRACE_("STG01Climax_IStage01PartController::PROG_FAINAL");
            }

            if (pProg->getFrameInProgress() == 60) {
                fadeoutSceneWithBgm(300);
                throwEventUpperTree(EVENT_STG01_CTRLER_WAS_END); //Xe[WGhʂɓ`
            }
            //Cxg҂
            break;
        }
        default :
            break;
    }
}

void Stage01PartController::onCatchEvent(hashval prm_no, void* prm_pSource) {
    SceneProgress* pProg = getProgress();
    if (prm_no == EVENT_STG01_01_WAS_BROKEN) {
        _TRACE_("Stage01PartController::onCatchEvent() EVENT_STG01_01_WAS_BROKEN");
        ((DefaultScene*)prm_pSource)->sayonara(60*60);
    } else if (prm_no == EVENT_STG01_02_WAS_BROKEN) {
        _TRACE_("Stage01PartController::onCatchEvent() EVENT_STG01_02_WAS_BROKEN");
        ((DefaultScene*)prm_pSource)->sayonara(60*60);
    } else if (prm_no == EVENT_STG01_03_WAS_BROKEN) {
        _TRACE_("Stage01PartController::onCatchEvent() EVENT_STG01_03_WAS_BROKEN");
        ((DefaultScene*)prm_pSource)->sayonara(60*60);
    } else if (prm_no == EVENT_STG01_WALLED_WAS_BROKEN) {
        _TRACE_("Stage01PartController::onCatchEvent() EVENT_STG01_WALLED_WAS_BROKEN");
        ((DefaultScene*)prm_pSource)->sayonara(60*60);
    } else if (prm_no == EVENT_STG01_CLIMAX_WAS_BROKEN) {
        _TRACE_("Stage01PartController::onCatchEvent() EVENT_STG01_CLIMAX_WAS_BROKENLb`BSTAGE01PARTCONTROLLER_ENDING𓊂");
        ((DefaultScene*)prm_pSource)->sayonara(60*60);
        pProg->change(PROG_FAINAL); //iStage01PartController::PROG_FAINALɐ؂ւ
    } else {

    }

}

Stage01PartController::~Stage01PartController() {

}
