#include "stdafx.h"
#include "MyStraightLaserChip001.h"

#include "jp/ggaf/core/util/GgafLinkedListRing.hpp"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxSeTransmitterForActor.h"
#include "jp/ggaf/dxcore/manager/GgafDxTextureConnection.h"
#include "jp/ggaf/dxcore/model/GgafDxModel.h"
#include "jp/ggaf/lib/util/CollisionChecker3D.h"
#include "jp/gecchi/VioletVreath/actor/my/MyLockonController.h"
#include "jp/gecchi/VioletVreath/actor/my/MyShip.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Universe/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;


GgafDxCore::GgafDxModel* MyStraightLaserChip001::pModel_  = nullptr;
char MyStraightLaserChip001::aaTextureName[3][51];
int MyStraightLaserChip001::tex_no_ = 0;


MyStraightLaserChip001::MyStraightLaserChip001(const char* prm_name) :
        StraightLaserChip(prm_name, "MyStraightLaserChip001", STATUS(MyStraightLaserChip001)) {
    _class_name = "MyStraightLaserChip001";
    default_stamina_ = getStatus()->get(STAT_Stamina);
    _veloMv = 100000;
    pOrg_ = nullptr;
    lockon_st_ = 0;
    GgafDxModel* pModel = getModel();
    if (!MyStraightLaserChip001::pModel_) {
        if (pModel->_num_materials != 3) {
            throwGgafCriticalException("MyStraightLaserChip001::onCreateModel() MyStraightLaserChip001f́A}eARKvłB");
        }
        for (DWORD i = 0; i < pModel->_num_materials; i ++) {
            strcpy(MyStraightLaserChip001::aaTextureName[i], pModel->_papTextureConnection[i]->peek()->getName());
        }
        MyStraightLaserChip001::pModel_ = pModel;
    }
}

void MyStraightLaserChip001::initialize() {
    pOrg_ = P_MYSHIP;
    getKuroko()->setRzRyMvAng(0,0);
    CollisionChecker3D* pChecker = getCollisionChecker();
    pChecker->makeCollision(1);
    pChecker->setColliAAB_WHD(0,120000,60000,60000);

    setHitAble(true);
    _sx = _sy = _sz = R_SC(5);
    setAlpha(0.99);
    _bounding_sphere_radius = 20.0;
}

void MyStraightLaserChip001::onCreateModel() {
}


void MyStraightLaserChip001::onActive() {
    getStatus()->reset();
    default_stamina_ = getStatus()->get(STAT_Stamina);
    StraightLaserChip::onActive();

    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    getKuroko()->setMvVelo(80000);
    getKuroko()->setMvAcce(1000);
    if (pMainLockOnTarget && pMainLockOnTarget->isActiveInTheTree()) {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 1;
        } else {
            //[ȊO
            lockon_st_ = ((MyStraightLaserChip001*)getFrontChip())->lockon_st_;//ÕbNIp
        }
    } else {
        if (getFrontChip() == nullptr) {
            //[`bv
            lockon_st_ = 0;
        } else {
            //[ȊO
            lockon_st_ = ((MyStraightLaserChip001*)getFrontChip())->lockon_st_;//ÕbNIp
        }
    }
}

void MyStraightLaserChip001::processBehavior() {
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();

    if (lockon_st_ == 1) {
        if (getActiveFrame() < 120) {
            if (pMainLockOnTarget) {
            } else {
                lockon_st_ = 2;
            }
        } else {
            lockon_st_ = 2;
        }
    }
    if (getFrontChip() == nullptr) {
        getSeTx()->behave();
    }
    StraightLaserChip::processBehavior();//WړĂĂяo
    //烌[U[\̂ߋIɍW␳
    if (onChangeToActive()) {
        positionAs(pOrg_);
    }
}

void MyStraightLaserChip001::onHit(GgafActor* prm_pOtherActor) {
    GgafDxGeometricActor* pOther = (GgafDxGeometricActor*) prm_pOtherActor;
    GgafDxGeometricActor* pMainLockOnTarget = pOrg_->pLockonCtrler_->pRingTarget_->getCurrent();
    //qbgGtFNg
    //
    if ((pOther->getKind() & KIND_ENEMY_BODY) ) {
        if (pMainLockOnTarget) { //ɃIvV̓bNI
            if (pOther == pMainLockOnTarget) {
                //IvṼbNIɌꍇ
                lockon_st_ = 2; //bNI߂B񃍃bNIibNI񃍃bNIj
                if (getFrontChip() && getFrontChip()->getFrontChip() == nullptr) {
                    //Ԑ擪`bvqbgꍇA[ɂ`
                    ((MyStraightLaserChip001*)getFrontChip())->lockon_st_ = 2;
                }
            } else {
                //IvṼbNIȊÕAN^[ɖꍇ
            }
        } else {
            //IvV񃍃bNIɖꍇ
        }
        //bNI\AN^[Ȃ烍bNI݂
        if (pOther->getStatus()->get(STAT_LockonAble) == 1) {
            pOrg_->pLockonCtrler_->lockon(pOther);
        }

        int stamina = UTIL::calcMyStamina(this, pOther);
        if (stamina <= 0) {
            //ꌂŃ`bvł̍U
            setHitAble(false);
            UTIL::activateExplosionEffectOf(this); //j󂳂ꂽGtFNg
            sayonara();
        } else {
            //ςȂ΁AʊтAX^~i񕜁iU100̎GȂΒʊсj
            getStatus()->set(STAT_Stamina, default_stamina_);
        }
    } else if (pOther->getKind() & KIND_CHIKEI) {
        //n`͖悤Ȃ
        setHitAble(false);
        UTIL::activateExplosionEffectOf(this); //j󂳂ꂽGtFNg
        sayonara();
    }

}

void MyStraightLaserChip001::onInactive() {
    StraightLaserChip::onInactive();
    lockon_st_ = 0;
}

void MyStraightLaserChip001::chengeTex(int prm_tex_no) {
    if (MyStraightLaserChip001::pModel_) {
        MyStraightLaserChip001::tex_no_ = prm_tex_no;
        MyStraightLaserChip001::pModel_->swapTopTextureOrder(aaTextureName[prm_tex_no]);
    }
}

MyStraightLaserChip001::~MyStraightLaserChip001() {
    MyStraightLaserChip001::pModel_ = nullptr;
}


