#include "stdafx.h"
#include "EffectTorpedoMagic.h"

#include "jp/ggaf/dxcore/actor/supporter/GgafDxKuroko.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxScaler.h"
#include "jp/ggaf/dxcore/actor/supporter/GgafDxUvFlipper.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;
using namespace VioletVreath;

EffectTorpedoMagic::EffectTorpedoMagic(const char* prm_name) :
        DefaultSpriteActor(prm_name, "EffectTorpedoMagic", nullptr) {
    _class_name = "EffectTorpedoMagic";
    pScaler_ = NEW GgafDxScaler(this);
    effectBlendOne(); //ZTechnique
    setZEnable(true);       //Zobt@͍lL
    setZWriteEnable(false); //Zobt@͏ݖ
    defineRotMvWorldMatrix(UTIL::setWorldMatrix_RzBxyzMv); //ϊsr{[h
    setHitAble(false);
}

void EffectTorpedoMagic::initialize() {
    setAlpha(0.9);
    getUvFlipper()->exec(FLIP_ORDER_LOOP, 1);
}

void EffectTorpedoMagic::onActive() {
}

void EffectTorpedoMagic::processBehavior() {
    getUvFlipper()->behave();
    getKuroko()->behave();
    pScaler_->behave();
}

void EffectTorpedoMagic::processJudgement() {
}

void EffectTorpedoMagic::onInactive() {
}

EffectTorpedoMagic::~EffectTorpedoMagic() {
    GGAF_DELETE(pScaler_);
}
