#include "StageController.h"

#include "jp/ggaf/core/actor/SceneMediator.h"
#include "jp/gecchi/VioletVreath/actor/VVCommonActorsHeader.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/CommonScene.h"
#include "StageController/StageDebug.h"
#include "StageController/StageDebug/StageDebugPartController.h"
#include "StageController/Stage01.h"
#include "StageController/Stage01/Stage01PartController.h"
#include "StageController/Stage02.h"
#include "StageController/Stage02/Stage02PartController.h"
#include "StageController/Stage03.h"
#include "StageController/Stage04.h"
#include "StageController/Stage05.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"



using namespace GgafLib;
using namespace VioletVreath;

#define ORDER_ID_STAGE 11

enum {
    PROG_INIT        ,
    PROG_BEGIN       ,
    PROG_PLAY_STAGE  ,
    PROG_PLAY_TRANSIT,
    PROG_PLAY_RANKUP ,
    PROG_FINISH      ,
    PROG_BANPEI,
};

StageController::StageController(const char* prm_name) : VvScene<DefaultScene>(prm_name) {
    _class_name = "StageController";

    _TRACE_("StageController::StageController("<<prm_name<<")");
//    had_ready_main_stage_ = false;
    loop_ = 1;
    main_stage_ = 0; //stage0̓fobO
    pStageMainCannel_ = nullptr;

    pTransitStage_ = NEW TransitStage("TransitStage");
    pTransitStage_->inactivate();
    appendChild(pTransitStage_);

    _pSceneSymbol = NEW LabelSceneSymbol("LabelSceneSymbol");
    bringSceneMediator()->appendGroupChild(_pSceneSymbol);
}

void StageController::onReset() {
    _TRACE_(FUNC_NAME<<" "<<NODE_INFO<<"");
    loop_ = 1;
    main_stage_ = 0; //stage0̓fobO
    if (pStageMainCannel_) {
        pStageMainCannel_->inactivate();
    }
    //ʃV[A@V[zɈĂ
    pCOMMON_SCENE->resetTree();
    pCOMMON_SCENE->activateImmed();
    appendChild(pCOMMON_SCENE->extract());
    getProgress()->reset(PROG_INIT);
}
//void StageController::readyNextStage() {
//    main_stage_++;
//    readyStage(main_stage_);
//}


void StageController::readyStage(int prm_main_stage) {
    _TRACE_("StageController::readyStage("<<prm_main_stage<<")");
    //ő僉N𒲐AɂĕωBTODO:ՓxxƂ G_MIN_RANK グƂ
    G_MAX_RANK = 1.0 + ((loop_-1) * 0.2);


    switch (prm_main_stage) {
        case 0:
            requestScene(ORDER_ID_STAGE+prm_main_stage, StageDebug);
            break;
        case 1:
            requestScene(ORDER_ID_STAGE+prm_main_stage, Stage01);
            break;
        case 2:
            requestScene(ORDER_ID_STAGE+prm_main_stage, Stage02);
            break;
        case 3:
            requestScene(ORDER_ID_STAGE+prm_main_stage, Stage03);
            break;
        case 4:
            requestScene(ORDER_ID_STAGE+prm_main_stage, Stage04);
            break;
        case 5:
            requestScene(ORDER_ID_STAGE+prm_main_stage, Stage05);
            break;
        default:
            break;
    }
}

void StageController::initialize() {
}

void StageController::processBehavior() {
    //SCORE\
    SceneProgress* pProg = getProgress();
    switch (pProg->get()) {
        case PROG_INIT: {
            _TRACE_(FUNC_NAME<<" Prog is PROG_INIT");

            readyStage(main_stage_);
            pProg->change(PROG_BEGIN);
            break;
        }

        case PROG_BEGIN: {
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed to PROG_BEGIN");
                _TRACE_(FUNC_NAME<<" main_stage_="<<main_stage_);
            }
            if (pProg->hasArrivedAt(120)) { //QbV
                pProg->change(PROG_PLAY_STAGE);
            }
            break;
        }

        case PROG_PLAY_STAGE: {
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed to PROG_PLAY_STAGE");
                _TRACE_(FUNC_NAME<<" main_stage_="<<main_stage_);
                readyStage(main_stage_); //Ô߂ɌĂԁBʏ͂łĂnYB
                //Xe[WV[ǉ
                if (pStageMainCannel_) {
                    _TRACE_("̂I PROG_PLAY_STAGE:  pStageMainCannel_="<<pStageMainCannel_->getName()<<"");
                }
                pStageMainCannel_ = (Stage*)receiveScene(ORDER_ID_STAGE+main_stage_);
                _TRACE_("PROG_PLAY_STAGE: V pStageMainCannel_="<<pStageMainCannel_->getName()<<"");
                pStageMainCannel_->fadeoutSceneWithBgm(0);

                appendChild(pStageMainCannel_);
                pStageMainCannel_->fadeinScene(180);
            }
            break;
        }

        case PROG_PLAY_TRANSIT: {
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed to PROG_PLAY_TRANSIT");
                _TRACE_(FUNC_NAME<<" main_stage_="<<main_stage_);
                pTransitStage_->fadeoutSceneWithBgmTree(0);
                _TRACE_(FUNC_NAME<<" pTransitStage_->setStage("<<main_stage_<<")");
                pTransitStage_->setStage(main_stage_);
                pTransitStage_->reset();
                pTransitStage_->activate();
                pTransitStage_->fadeinScene(180);
            }
            //EVENT_TRANSIT_WAS_ENDCxg҂
            break;
        }

        case PROG_FINISH: {
            if (pProg->hasJustChanged()) {
                _TRACE_(FUNC_NAME<<" Prog has Just Changed to PROG_FINISH");
                _TRACE_(FUNC_NAME<<" main_stage_="<<main_stage_);
                main_stage_ = pTransitStage_->next_main_stage_; //̃Xe[W
                _TRACE_(FUNC_NAME<<" main_stage_ = pTransitStage_->next_main_stage_;");
                _TRACE_(FUNC_NAME<<" XVꂽ main_stage_="<<main_stage_);
                pProg->change(PROG_BEGIN); //[v
            }
            break;
        }

        default: {
            break;
        }
    }


/*
    //NAbvV[
    if (G_RANK_DISP % 10 == 0) {
        if (can_rank_up_) {
            can_rank_up_ = false;
            G_RANKUP_LEVEL++;
            pRankUpStageCtrler_->execute();
        } else {
            //X[
        }
    } else {
        can_rank_up_ = false;
    }
*/
//    _non_rtti_object_
//    http://msdn.microsoft.com/en-us/library/cby9kycs.aspx

}
void StageController::onCatchEvent(hashval prm_no, void* prm_pSource) {
    if (prm_no == EVENT_PREPARE_TRANSIT_STAGE) {
        _TRACE_("StageController::onCatchEvent(EVENT_PREPARE_TRANSIT_STAGE)");
        pTransitStage_->ready(main_stage_);
    }

    if (prm_no == EVENT_PREPARE_NEXT_STAGE) {
        _TRACE_("StageController::onCatchEvent(EVENT_PREPARE_NEXT_STAGE)");
        int next_stage = *((int*)(prm_pSource));
        readyStage(next_stage);//̃Xe[W
//            _TRACE_("ŏIʃNA");
//            pProg->change(PROG_END);
            //TODO:GfjOH
//        }
    }
    SceneProgress* pProg = getProgress();
    if (prm_no == EVENT_STAGEDEBUG_WAS_FINISHED) {
        _TRACE_("StageController::onCatchEvent(EVENT_STAGEDEBUG_WAS_FINISHED)");
        pStageMainCannel_->sayonara(180);
        pStageMainCannel_->fadeoutSceneWithBgmTree(180);
        pProg->change(PROG_PLAY_TRANSIT);
    }

    if (prm_no == EVENT_STAGE01_WAS_FINISHED) {
        _TRACE_("StageController::onCatchEvent(EVENT_STAGE01_WAS_FINISHED)");
        pStageMainCannel_->sayonara(180);
        pStageMainCannel_->fadeoutSceneWithBgmTree(180);
        pProg->change(PROG_PLAY_TRANSIT);
    }
    if (prm_no == EVENT_STAGE02_WAS_FINISHED) {
        _TRACE_("StageController::onCatchEvent(EVENT_STAGE02_WAS_FINISHED)");
        pStageMainCannel_->sayonara(180);
        pStageMainCannel_->fadeoutSceneWithBgmTree(180);
        pProg->change(PROG_PLAY_TRANSIT);
    }
    if (prm_no == EVENT_TRANSIT_WAS_END) {
        _TRACE_("StageController::onCatchEvent(EVENT_TRANSIT_WAS_END)");
        pTransitStage_->inactivateDelay(180);
        pTransitStage_->fadeoutSceneWithBgmTree(180);
        pProg->change(PROG_FINISH);
    }

}

StageController::~StageController() {
}

