#ifndef COMMONSCENE_H_
#define COMMONSCENE_H_
#include "VioletVreath.h"

#include "jp/gecchi/VioletVreath/scene/VvScene.hpp"
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "../GameScene.h"

#ifdef pGAME_SCENE
    #define pCOMMON_SCENE (pGAME_SCENE->pCommonScene_)
#else
    #undef pCOMMON_SCENE
#endif

/**
 * ʃIuWFNg擾}N
 */
#define pCOMMON_DEPO(X)                   pDepo_##X##_
#define getCommonDepository(X)             (pCOMMON_SCENE->pCOMMON_DEPO(X))
#define dispatchFromCommon(X)              ( (X*)(getCommonDepository(X)->dispatch()) )
#define dispatchDelayFromCommon(X, F)      ( (X*)(getCommonDepository(X)->dispatch((F))) )
#define dispatchForceFromCommon(X)         ( (X*)(getCommonDepository(X)->dispatchForce()) )

#define pCOMMON_DEPO_STORE(X)              pStore_##X##_
#define getCommonDepoStore(X)                  (pCOMMON_SCENE->pCOMMON_DEPO_STORE(X))
#define dispatchFromCommonDepositoryStore(X)         ( (GgafCore::ActorDepository*)(getCommonDepoStore(X)->dispatch()) )
namespace VioletVreath {

/**
 * ʃV[NX .
 * Ȏd͎̃Xe[W肷邱ƂłB
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class CommonScene : public VvScene<GgafLib::DefaultScene> {

public:
    /** ėpGtFNĝPpAf|Wg */

    GgafCore::ActorDepository* pCOMMON_DEPO(EffectExplosion001);
    /** ėpGtFNĝQpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectExplosion002);
    /** ėpGtFNĝRpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectExplosion003);
    /** ėpGtFNĝSpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectExplosion004);
    /** ^[{GtFNgpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectTurbo002);
    /** ACeIuWFNgAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(MagicPointItem001);
    /** ACeIuWFNgAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(MagicPointItem002);
    /** ACeIuWFNgAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(MagicPointItem003);

    /** ėpoGtFNĝPpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectBlink001);
    /** ėpoGtFNĝQpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectBlink002);
    /** ėpoGtFNĝRpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(EffectBlink003);

    GgafCore::ActorDepository* pCOMMON_DEPO(SpriteLabelBonus001);

    /** ėpoGtFNĝRpAf|Wg */
    GgafCore::ActorDepository* pCOMMON_DEPO(Shot004);

    /**  */
    GgafCore::ActorDepositoryStore* pCOMMON_DEPO_STORE(EnemyWateringLaserChip001);
    GgafCore::ActorDepositoryStore* pCOMMON_DEPO_STORE(EnemyStraightLaserChip001);

public:
    CommonScene(const char* prm_name);
    /**
     * 
     */
    void initialize() override;
    void onReset() override;

    virtual void processBehavior() override;

    /**
     * X̕̕ɃXN[֐ .
     * @param pThat AN^[
     * @param p1 XN[Xs[h(_feature_p1ւ̃|C^)
     * @param p2 nullptr
     * @param p3 nullptr
     */
    static void scrollX(GgafCore::Object* pThat, void* p1, void* p2, void* p3);

    virtual ~CommonScene();
};

}
#endif /*COMMONSCENE_H_*/
