#include "MyTorpedo.h"

#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChipDepository.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/ggaf/dx/actor/supporter/Scaler.h"
#include "jp/ggaf/dx/actor/GeometricActor.h"
#include "MyTorpedoBlast.h"
#include "jp/gecchi/VioletVreath/actor/my/MyTorpedoController.h"
#include "MyTorpedoTail.h"



using namespace GgafLib;
using namespace VioletVreath;

enum {
    SE_EXPLOSION,
};

MyTorpedo::MyTorpedo(const char* prm_name, MyTorpedoController* prm_pTorpedoController)
               : VvMyActor<DefaultMeshSetActor>(prm_name, "EffectLaserRefraction001", StatusReset(MyTorpedo)) {
    _class_name = "MyTorpedo";
    pTorpedoCtrler_ = prm_pTorpedoController;
    length_TailEffect_ = 5;
    begin_x_ = _x;
    begin_y_ = _y;
    begin_z_ = _z;

    pTailEffectDepository_ = NEW LaserChipDepository("Depo_TorpedoTailEffect");
    pTailEffectDepository_->config(length_TailEffect_, 0, nullptr);
    for (int i = 0; i < length_TailEffect_; i++) {
        std::string name = std::string(getName())+"'s Tail("+XTOS(i)+")";
        pTailEffectDepository_->put(NEW MyTorpedoTail(name.c_str(), this));
    }
    move_section_ = 0;
    appendGroupChild(pTailEffectDepository_);
    effectBlendOne(); //ZTechniquew
    setZEnableDraw(true);        //`掞AZobt@l͍l
    setZWriteEnable(false);  //gZobt@݂Ȃ
    pTarget_ = nullptr;
    trz_ = try_ = 0;
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_TORPEDO");
}

void MyTorpedo::initialize() {
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, 70000);
}

void MyTorpedo::onReset() {
    pTarget_ = nullptr;
}

void MyTorpedo::onActive() {
    getStatus()->reset();
    setAlpha(0.3);
    _sx = _sy = _sz = 100;
    setScale(100);
    getScaler()->transitionLinearStep(7000, 500);
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setRollPitchYawFaceAngVelo(D_ANG(3), D_ANG(5), D_ANG(7));
    if (pTarget_) {
        pVecDriver->forceMvVeloRange(4000, 100000);
        pVecDriver->setMvVelo(20000);
        pVecDriver->setMvAcce(-600); //ŏ
    } else {
        pVecDriver->forceMvVeloRange(4000, 70000);
        pVecDriver->setMvVelo(10000);
        pVecDriver->setMvAcce(-500); //ŏ
    }

    pVecDriver->forceRzRyMvAngVeloRange(-40000, 40000);
    pVecDriver->setRzRyMvAngVelo(0,0);
    pVecDriver->setRzRyMvAngAcce(0,0);
    pVecDriver->stopTurningMvAng();
    begin_x_ = _x;
    begin_y_ = _y;
    begin_z_ = _z;
    setHitAble(true);
    getProgress()->reset(MyTorpedo_IN_FIRE);
    move_section_ = 0;
    //^[Qbg̕AIvV̌Ăɔ΂
    trz_ = pTorpedoCtrler_->pOrg_->_rz;
    try_ = pTorpedoCtrler_->pOrg_->_ry;
}

void MyTorpedo::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafCore::Progress* const pProg = getProgress();
    if (pProg->get() == MyTorpedo_RELEASE) {
        if (pTailEffectDepository_->_num_chip_active == 0) {
            //OՃGtFNgSĔ񊈓ɂȂꍇ
            inactivate(); //gŌinactivate()
        } else {
            addAlpha(-0.05);
        }
    }

    if (pProg->get() == MyTorpedo_IN_FIRE) {
        //ۃGtFNgǉ
        if (pTailEffectDepository_->_num_chip_active < length_TailEffect_) {
            MyTorpedoTail* pTailEffect = (MyTorpedoTail*)pTailEffectDepository_->dispatch();
            if (pTailEffect) {
                pTailEffect->setPosition(begin_x_,begin_y_,begin_z_);
            }
        }
        //̃[u
        if (move_section_ == 0) { //ˊJn`܂
            if (pVecDriver->_velo_mv == pVecDriver->_bottom_velo_mv) { //I

                if (pTarget_) {
                    //^[QbeBÓATURN_CLOSE_TO œă^[Qbg
                    pVecDriver->setMvAcce(600);
                    pVecDriver->turnMvAngTwd(pTarget_,
                                          1000, 100,
                                          TURN_CLOSE_TO, false);
                } else {
                    //m[^[QbeBÓATURN_ANTICLOSE_TO œ^
                    pVecDriver->setMvAcce(500);
                    pVecDriver->turnRzRyMvAngTo(
                                trz_, try_,
                                2000, 200,
                                TURN_ANTICLOSE_TO, false);
                }
                move_section_++;
            }
        }

        //[uP `]
        if (move_section_ == 1) {
            if (pVecDriver->isTurningMvAng()) {
                //TURN_ANTICLOSE_TO^[Qbg҂
            } else {
                //TURN_ANTICLOSE_TO^[Qbg
                move_section_++;
            }
        }
        //[uQ ]`120t[Ԃ͂⋭pxŃ^[Qbg␳
        if (move_section_ == 2) {
            if (getActiveFrame() < 120) {
                if (getActiveFrame() % 16U == 0) {
                    if (pTarget_) {
                        if (pTarget_->isActiveInTheTree())  {
                            //^[QbgL
                            pVecDriver->turnMvAngTwd(pTarget_,
                                                  1000, 200,
                                                  TURN_CLOSE_TO, false);

                        } else {
                            //^[QbgÂ܂܂܂
                            pVecDriver->setRzRyMvAngVelo(0, 0);
                            pVecDriver->setRzRyMvAngAcce(0, 0);
                        }
                    } else {
                        //^[QbgiIvV̌Ăցj
                        pVecDriver->turnRzRyMvAngTo(
                                    trz_, try_,
                                    1000, 200,
                                    TURN_CLOSE_TO, false);
                    }
                } else {
                   //
                }
            } else {
                move_section_++;
            }
        }
        //[uR `300t[Ԃ͊ɂ₩ȊpxŃ^[Qbg␳
        if (move_section_ == 3) {
            if (getActiveFrame() < 300) {
                if (getActiveFrame() % 16U == 0) {
                    if (pTarget_) {
                        if (pTarget_->isActiveInTheTree())  {
                            //^[QbgL
                            pVecDriver->turnMvAngTwd(pTarget_,
                                                  500, 0,
                                                  TURN_CLOSE_TO, false);
                        } else {
                            //^[QbgÂ܂܂܂
                            pVecDriver->setRzRyMvAngVelo(0,0);
                            pVecDriver->setRzRyMvAngAcce(0,0);
                        }
                    } else {
                        //^[QbgiIvV̌Ăցj
                        pVecDriver->turnRzRyMvAngTo(
                                    trz_, try_,
                                    300, 0,
                                    TURN_CLOSE_TO, false);

                    }
                } else {
                   //
                }
            } else {
                move_section_++;
            }
        }
        //[uS
        if (move_section_ == 4) {
            pVecDriver->setRzRyMvAngVelo(0,0);
            pVecDriver->setRzRyMvAngAcce(0,0);
        }
        pVecDriver->behave();
        getScaler()->behave();
    }
}

void MyTorpedo::processJudgement() {
    GgafCore::Progress* const pProg = getProgress();
    if (isOutOfSpacetime() && pProg->get() == MyTorpedo_IN_FIRE) {
        setHitAble(false);
        pProg->change(MyTorpedo_RELEASE);
        GgafCore::MainActor* pTailEffect = (GgafCore::MainActor*)pTailEffectDepository_->getChildFirst();
        for (int i = 0; i < length_TailEffect_; i++) {
            pTailEffect->inactivateDelay(i+1); //OՃGtFNgXɏ悤ɗ\
            pTailEffect = pTailEffect->getNext();
        }
        getVecDriver()->setMvVelo(0);
        //ginactive()processBehavior()ōs
        //̈ړGtFNgSinactive()ɂȂۂɎginactive()
    }

}

void MyTorpedo::onInactive() {
}

void MyTorpedo::onHit(const GgafCore::Actor* prm_pOtherActor) {
    GgafDx::GeometricActor* pOther = (GgafDx::GeometricActor*)prm_pOtherActor;
    //qbgʊт͂܂
    int sta = UTIL::calcMyStamina(this, pOther);
    setHitAble(false);

    GgafCore::Progress* const pProg = getProgress();
    pProg->change(MyTorpedo_RELEASE);
    GgafCore::MainActor* pTailEffect = (GgafCore::MainActor*)pTailEffectDepository_->getChildFirst();
    for (int i = 0; i < length_TailEffect_; i++) {
        pTailEffect->inactivateDelay(i+1); //OՃGtFNgXɏ悤ɗ\
        pTailEffect = pTailEffect->getNext();
    }
    getVecDriver()->setMvVelo(0);
    //ginactive()processBehavior()ōs
    //̈ړGtFNgSinactive()ɂȂۂɎginactive()

    //
    MyTorpedoBlast* pBlast = (MyTorpedoBlast*)(pTorpedoCtrler_->pDepo_TorpedoBlast_->dispatchForce());
    getSeTransmitter()->play3D(SE_EXPLOSION);
    pBlast->reset();
    pBlast->setPositionAt(this);
}

MyTorpedo::~MyTorpedo() {
}
