#ifndef MAGIC_H_
#define MAGIC_H_
#include "VioletVreath.h"
#include "jp/ggaf/core/actor/MainActor.h"

namespace VioletVreath {

typedef int_fast32_t magic_point;
typedef frame magic_time;
#define MAX_MAGIC_TIME MAX_FRAME

#define MAGIC_CAST_NG_INVOKING_NOW          (-5)
#define MAGIC_CAST_NG_MP_IS_SHORT           (-4)
#define MAGIC_CAST_CANCEL                   (-3)
#define MAGIC_CAST_LEVELDOWN                (-2)
#define MAGIC_CAST_CANCEL_AND_LEVELDOWN     (-1)
#define MAGIC_CAST_NOTHING                  (0)
#define MAGIC_CAST_OK_LEVELUP               (1)
#define MAGIC_CAST_OK_CANCEL_AND_LEVELUP    (3)

#define MAGIC_INVOKE_NG_INVOKING_NOW (-3)
#define MAGIC_INVOKE_NG_MP_IS_SHORT  (-2)
#define MAGIC_INVOKE_NOTHING         (0)
#define MAGIC_INVOKE_OK_LEVELUP      (1)
#define MAGIC_INVOKE_OK_LEVELDOWN    (2)

#define MAGIC_EFFECT_NG_MP_IS_SHORT (-2)
#define MAGIC_EFFECT_NOTHING        (0)
#define MAGIC_EFFECT_OK_LEVELUP     (1)
#define MAGIC_EFFECT_OK_LEVELDOWN   (2)

#define MMETER_MAX_LEVEL 10

/**
 * ۖ@NX .
 * @MPɂĂ̖{NX̊{IȐB<BR>
 * E@gpƊe@ɐݒ肳ꂽMP܂B<BR>
 * E@ɂ̓xƂTOAȂԂ̓xOłBxPɂꍇu{@RXgv܂B<BR>
 * EexɃRXgݒo܂BxɉāAu{@RXgvɁuxv 悶ꂽlRXgɂȂ܂B<BR>
 * EAAуxAbv({Qȏ)̏ꍇAMPɂݒ肪\łB<BR>
 * EуxAbvɂāAƂ΁uXs[hvƌ@ɃxP`TA
 *   {@RXg = 10, x = 1.2 ƂāAexɕKvȃRXg 10,12,14,17,21 Ƃ܂B<BR>
 *   uv uXs[h Level1vuXs[h Level2v ƂPiKÂQ񃌃xAbvsꍇAMPRXg 10+12=22 łA<BR>
 *   Ȃ uv uXs[h Level2vƂꍇAMPRXg (10+12)*0.8 = 19 Ƃ悤Ȑݒ肪уxAbvł͉\łB<BR>
 *    0.8 ̂Ƃuуx팸vƌĂԎƂ܂Buуx팸v̓xɉʐݒł悤ɂȂĂ܂B<BR>
 * Ex_E̊TO݂܂Bx_E͂łs܂B<BR>
 *   x_EɎgpɉMPɊ炩ҌƂݒo܂B<BR>
 * E@ɂ̓CtTCNÃXebv݂܂Bep[^ݒ\łB<BR>
 *   a) @̃xAbvs<BR>
 *   b) rF@rJnrrI (r͓rŃLZ)  <BR>
 *   c) F@Jn@@I (ɂȂƃLZs) <BR>
 *   d) F@ʎJn(RXgEʔ) ʎʎIi@̃x_Ej<BR>
 * E@̎ނɂ́Au@vAuʎ@v ̂Qނ܂B
 *   1)u@v ud) ṽvZX@łAxAbvE_EƂTO݂܂B<BR>
 *   2)uʎ@v́Aud) vAMPuێRXgLvAMPȂuێRXgv̂Qނ܂B
 *      ܂A\ߐݒ肳ꂽʎԂ𒴂ƎŃx_E(|P)܂B<BR>
 *      2-a)uێRXgLv ud) vMPArMP0ɂȂĂ܂ꍇAIɃx0ɂ܂Ńx_E܂B<BR>
 *      2-b)uێRXgv ud) vMP܂BrMP0łx_E͋N܂BiʎԐ؂݂̂ŋNj<BR>
 * @version 1.00
 * @since 2009/05/19
 * @author Masatoshi Tsuge
 */
class Magic : public GgafCore::MainActor {
public:
    enum {
        STATE_NOTHING     ,
        STATE_RE_CASTING  ,
        STATE_CASTING     ,
        STATE_INVOKING    ,
        STATE_RE_EFFECT   ,
        STATE_EFFECT_START,
        STATE_ABANDONING  ,
        PROG_BANPEI,
    };

    /**
     * ex̏ .
     */
    class LevelInfo {
    public:
        /** [r]@ʎIc莞 */
        magic_time remained_frame_of_effecting;
        /** [r/w]@RXg */
        magic_point cost_;
        /** [r/w]r */
        magic_time casting_frames_;
        /** [r/w] */
        magic_time invoking_frames_;
        /** [r/w]@ʎ */
        magic_time effecting_frames_;
        /** [r/w]@ʎRXg  */
        magic_point keep_cost_;
        /** [r/w]Ajp^[ԍ */
        int pno_;
        LevelInfo() : remained_frame_of_effecting(0),
                      cost_(0),
                      casting_frames_(0),
                      invoking_frames_(0),
                      effecting_frames_(0),
                      keep_cost_(0),
                      pno_(0) {
        }
    };

    /**
     * x̏ .
     */
    class LevelDiffInfo {
    public:
        /** [r]уx̖@RXg팸(0.0`1.0) */
        double r_cost_lv_diff_;
        /** [r]уx̉rԍ팸(0.0`1.0) */
        double r_casting_frames_lv_diff_;
        /** [r]уx̔ԍ팸(0.0`1.0) */
        double r_invoking_frames_lv_diff_;

        LevelDiffInfo() : r_cost_lv_diff_(0.0),
                          r_casting_frames_lv_diff_(0.0),
                          r_invoking_frames_lv_diff_(0.0) {
        }
    };

public:
    /** [r]}WbN|Cg */
    int* const pMP_;

    /** [r]݂̍ōx */
    int max_level_;
    /** [r]݂̃x(݌ʎĂ郌xAIʎJñ^C~OŐ؂ւ) */
    int level_;
    /** [r]Vx(rA̎AɎɂȂ낤Ƃ郌x) */
    int new_level_;
    /** [r]Õx(ʎ̎AʎÕx) */
    int last_level_;
    /** [r]Pt[Õx */
    int prev_frame_level_;

    int level_nextframe_;
    int new_level_nextframe_;
    int last_level_nextframe_;

    /** [r]{@ɕKvȃRXg̊{P */
    const magic_point cost_base_;
    /** [r]{@rJn ` @rI̊{Pʎ  */
    const magic_time casting_frames_base_;
    /** [r]{@Jn ` @I̊{Pʎ */
    const magic_time invoking_frames_base_;
    /** [r]{@ʎJn ` @ʎI̊{Pʎ  */
    const magic_time effecting_frames_base_;
    /** [r]{@ʎRXg̊{P  */
    const magic_point keep_cost_base_;

    /** [r]ex̖@RXg(1.0`) ʏAxقǖ@RXg */
    const double r_every_lv_cost_;
    /** [r]ex̉rԑ(1.0`) ʏAxقǉrԂ */
    const double r_every_lv_casting_frames_;
    /** [r]ex̔ԑ(1.0`) ʏAxقǔԂ */
    const double r_every_lv_invoking_frames_;
    /** [r]ex̌ʎԍ팸(0.0`1.0) ʏAxقǌʎԂZ */
    const double r_every_lv_effecting_frames_;
    /** [r]eẍێRXg (1.0` ) ʏAxقǈێRXg */
    const double r_each_lv_keep_cost_;
    /** [r]ex̏ zCfbNX[x] */
    LevelInfo lvinfo_[MMETER_MAX_LEVEL+1];

    /** [r]уx̖@RXg팸(ʏ 0.0`1.0) ʏAxقǖ@RXg */
    const double r_cost_lv_diff_base_;
    /** [r]уx̉rԍ팸(ʏ 0.0`1.0) ʏAxقǉrԂZk */
    const double r_casting_frames_lv_diff_base_;
    /** [r]уx̔ԍ팸(ʏ 0.0`1.0) ʏAxقǔԂZk */
    const double r_invoking_frames_lv_diff_base_;
    /** [r]ex̏̔zAzCfbNX[x] */
    LevelDiffInfo lvdiff_[MMETER_MAX_LEVEL+1];

    /** [r]xAbvɕKvȃRXg̏ZbgBzCfbNX[x][Vx] */
    magic_point level_up_cost_[MMETER_MAX_LEVEL+1][MMETER_MAX_LEVEL+1];
    /** [r]xAbvɉrԂ̏ZbgBzCfbNX[x][Vx] */
    magic_time  level_up_casting_frames_[MMETER_MAX_LEVEL+1][MMETER_MAX_LEVEL+1];
    /** [r]xAbvɔԂ̏ZbgBzCfbNX[x][Vx] */
    magic_time  level_up_invoking_frames_[MMETER_MAX_LEVEL+1][MMETER_MAX_LEVEL+1];

    /** [r]̐iԂɂȂׂɕKvȃt[(ꎞێ) */
    magic_time time_of_next_state_;

    progress temp_hold_status_;
    int temp_hold_new_level_;

    int last_cast_;
    int last_invoke_;
    int last_effect_;

public:
    /**
     * @̒`s .
     * уxƂ̓xP傫(xQȏ)wB
     * @param prm_name @
     * @param prm_pMP }WbN|Cg̐ʃo[
     * @param prm_max_level {@̏ōx 1`MMETER_MAX_LEVEL
     * @param prm_cost_base       {@RXg({MP)
     * @param prm_r_every_lv_cost ex̃RXgBʏA1.0` i1.0傫ƍxقǃRXgɂȂj<br>
     *                      (yz1.0:xɂ鑝iSx{@RXgj<br>
     *                             1.2:x1P̂ŕKvȃRXg  {RXg<br>
     *                                 x2P̂ŕKvȃRXg  {RXg * 1.2<br>
     *                                 x3P̂ŕKvȃRXg  {RXg * 1.2 * 1.2<br>
     *                                 x4P̂ŕKvȃRXg  {RXg * 1.2 * 1.2 * 1.2  RXgݒ肳)
     * @param prm_r_cost_lv_diff уx̖@RXg팸 0.0`1.0 i1.0菬ƁAуxRXgɂȂBZ߂ĔԂقǂj<br>
     *                      (yz1.0:уxłRXg,<br>
     *                             0.8:уx2̂ƂÃxAbvɕKvȃRXg * 0.8<br>
     *                                 уx3̂ƂÃxAbvɕKvȃRXg * 0.8 * 0.8<br>
     *                                 уx4̂ƂÃxAbvɕKvȃRXg * 0.8 * 0.8 * 0.8
     * @param prm_casting_frames_base {r
     * @param prm_r_every_lv_cost ex̉rԑBʏA1.0` i1.0傫ƍxقǉrԂj<br>
     *                      (yz1.0:xɂrԑiSx{rԁj<br>
     *                             1.2:x1P̂ŕKvȉr  {r<br>
     *                                 x2P̂ŕKvȉr  {r * 1.2<br>
     *                                 x3P̂ŕKvȉr  {r * 1.2 * 1.2<br>
     *                                 x4P̂ŕKvȉr  {r * 1.2 * 1.2 * 1.2 Ԃݒ肳)
     * @param prm_r_casting_frames_lv_diff_base уx̉rԍ팸 0.0`1.0 i1.0菬ƁAуxArԂZkɂȂBZ߂ĔԂقǂj<br>
     *                      (yz1.0:уxłRXg,<br>
     *                             0.8:уx2̂ƂÃxAbvɕKvȉr * 0.8<br>
     *                                 уx3̂ƂÃxAbvɕKvȉr * 0.8 * 0.8<br>
     *                                 уx4̂ƂÃxAbvɕKvȉr * 0.8 * 0.8 * 0.8
     * @param prm_invoking_frames_base {
     * @param prm_r_every_lv_invoking_frames ex̔ԑBʏA1.0` i1.0傫ƍxقǔ܂łȂj<br>
     *                      (yz1.0:xɂ锭ԑiSx{rԁj<br>
     *                             1.2:x1P̂ŕKvȔ  {<br>
     *                                 x2P̂ŕKvȔ  { * 1.2<br>
     *                                 x3P̂ŕKvȔ  { * 1.2 * 1.2<br>
     *                                 x4P̂ŕKvȔ  { * 1.2 * 1.2 * 1.2 Ԃݒ肳)
     * @param prm_r_invoking_frames_lv_diff_base уx̔ԍ팸 0.0`1.0 i1.0菬ƁAуxAԂZkɂȂBZ߂ĔԂقǂj<br>
     *                      (yz1.0:уxłRXg,<br>
     *                             0.8:уx2̂ƂÃxAbvɕKvȔ * 0.8<br>
     *                                 уx3̂ƂÃxAbvɕKvȔ * 0.8 * 0.8<br>
     *                                 уx4̂ƂÃxAbvɕKvȔ * 0.8 * 0.8 * 0.8
     *
     * @param prm_effecting_frames_base {ʎԁB<br>
     *                                0w肷ƁAu@vƉ߂B<br>
     *                                0傫lݒ肷ƁAuʎ@vƉ߂B<br>
     * @param prm_r_every_lv_effecting_frames ex̌ʎԍ팸Bʏ 0.0`1.0 ixقǎ͒Zj<br>
     *                      (yz1.0:xɂʎ팸,<br>
     *                             0.9:x1P̂œ鎝  {ʎ<br>
     *                                 x2P̂œ鎝  {ʎ * 0.9<br>
     *                                 x3P̂œ鎝  {ʎ * 0.9 * 0.9<br>
     *                                 x4P̂œ鎝  {ʎ * 0.9 * 0.9 * 0.9  ƂԂݒ肳)
     * @param prm_keep_cost_base ʎ̊{ێRXgB0Ȃ΁uێRXgv0傫lݒ肷ƁuێRXgLvƂȂB
     * @param prm_r_each_lv_keep_cost ẍێRXg ʏ 1.0` (xقǈێRXgj<br>
     *                      (yz1.0:xɂێRXg,<br>
     *                             1.1:x1̂Ƃ̈ێRXg  {ێRXg<br>
     *                                 x2̂Ƃ̈ێRXg  {ێRXg * 1.1<br>
     *                                 x3̂Ƃ̈ێRXg  {ێRXg * 1.1 * 1.1<br>
     *                                 x4̂Ƃ̈ێRXg  {ێRXg * 1.1 * 1.1 * 1.1  ƂێRXgݒ肳)
     * @return
     */
    Magic(const char* prm_name, int* prm_pMP,
          int prm_max_level,
          magic_point prm_cost_base            , double prm_r_every_lv_cost            , double prm_r_cost_lv_diff_base,
          magic_time  prm_casting_frames_base  , double prm_r_every_lv_casting_frames  , double prm_r_casting_frames_lv_diff_base,
          magic_time  prm_invoking_frames_base , double prm_r_every_lv_invoking_frames , double prm_r_invoking_frames_lv_diff_base,
          magic_time  prm_effecting_frames_base, double prm_r_every_lv_effecting_frames,
          magic_point prm_keep_cost_base       , double prm_r_each_lv_keep_cost);

    void init();

    virtual void initialize() override {}

    virtual void onReset() override;

    virtual void nextFrame() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void processDraw() override {}

    virtual void processFinal() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    virtual void save(std::stringstream& sts);

    virtual void loadProperties(std::stringstream& sts);

    /**
     * rJns .
     * @param prm_new_level rVx
     * @return rs̏
     * @retval  MAGIC_CAST_NG_INVOKING_NOW         ʔ̂߉rs̂ŁA
     *                                             ȂB
     * @retval  MAGIC_CAST_NG_MP_IS_SHORT          MPȂrs̂ŁA
     *                                             ȂB
     * @retval  MAGIC_CAST_NOTHING                 ݂̃xƓxr悤ƂĂ̂ŁA
     *                                             ȂB
     * @retval  MAGIC_CAST_CANCEL                  ̃xrǍ݂ʎxƓxrw肵̂ŁA
     *                                             r~BiXe[^X STATE_NOTHING ւ̑JڂsB
     * @retval  MAGIC_CAST_OK_LEVELUP              ݂̌ʎx荂xrŵŁA
     *                                             rV[NGXJnAiXe[^X STATE_CASTING ւ̑JڂsB
     * @retval  MAGIC_CAST_LEVELDOWN               ݂̌ʎxႢxrŵŁA
     *                                             @ʊJn effect(prm_new_level) sB
     * @retval  MAGIC_CAST_OK_CANCEL_AND_LEVELUP   ̃xrɍĉrsƂĂāAĉr̃xǍ݂ʎx荂̂ŁA
     *                                             ĉrV[NGXJnAiXe[^X STATE_RE_CASTING ւ̑JڂsB
     * @retval  MAGIC_CAST_CANCEL_AND_LEVELDOWN    ̃xrɍĉrsƂĂāAĉr̃xǍ݂ʎxႢ̂ŁA
     *                                             @ʊJn effect(prm_new_level) sB
     */
    virtual int cast(int prm_new_level);

    /**
     * @rJnR[obN(P񂾂R[obN) .
     * ̃^C~OŌĂяoB<BR>
     * Erł͂ȂԁʒxȊÕx̖@̉rs<BR>
     * E݉rʒxȊÕx̖@̉rs<BR>
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level rVx(1` )
     */
    virtual void processCastBegin(int prm_now_level, int prm_new_level) = 0;

    /**
     * @rR[obN(t[R[obN) .
     * yӁzx_E͂P񂾂R[ processCastFinish() s܂B
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level r̐Vx(1` )
     */
    virtual void processCastingBehavior(int prm_now_level, int prm_new_level) = 0;

    /**
     * @rArLZ̃R[obN .
     * @param prm_now_level ݂̃x(0` )
     */
    virtual void processCastingCancel(int prm_now_level) = 0;

    /**
     * @rIR[obN(P񂾂R[obN) .
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level r\̐Vx(1` )
     */
    virtual void processCastFinish(int prm_now_level, int prm_new_level, int prm_result_invoke) = 0;

    /**
     * Jns(P񂾂R[obN) .
     * @param prm_new_level Vx
     * @return s̏
     */
    virtual int invoke(int prm_new_level);

    /**
     * @JnR[obN .
     * ܂łƉrLZ͕sƂB(P񂾂R[obN)
     * x_EĂяo܂B
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level 悤ƂĂVx(1` )
     */
    virtual void processInvokeBegin(int prm_now_level, int prm_new_level) = 0;

    /**
     * @R[obN(t[R[obN) .
     * yӁzx_E͂P񂾂R[ processInvokeFinish() s܂B
     * @param prm_now_level ݂̃x(0` )
     * @param prm_new_level ݔ̐Vx(1` )
     */
    virtual void processInvokingBehavior(int prm_now_level, int prm_new_level) = 0;

    /**
     * @ALZ̃R[obN .
     * ʏ͖@ɃLZ͂łȂAނ𓾂ȂɎɂ苭LZꍇ
     * ĂяoB
     * Ⴆ΁AMP͊Ă܂ƂA񂾂ƂB
     * @param prm_now_level ݂̃x(0` )
     */
    virtual void processInvokingCancel(int prm_now_level) = 0;

    /**
     * @IR[obN(P񂾂R[obN) .
     * x_EĂяo܂B
     * @param prm_now_level @IÓÃ݂xB(0` )
     * @param prm_new_level @ÍAiׂVxB(1` )
     * @param prm_result_effect invoke()̌
     */
    virtual void processInvokeFinish(int prm_now_level, int prm_new_level, int prm_result_effect) = 0;

    /**
     * ʔs .
     * @param prm_level ʔx
     */
    virtual int effect(int prm_level);

    /**
     * @ʎJnR[obN(P񂾂R[obN) .
     * ̃^C~OŌĂяo
     * E@I  @ʎJniprm_last_level < prm_now_levelj<BR>
     * Ex_Es i蓮 or ʎԖ or RXg薂@MP͊j<BR>
     * @param prm_last_level ʎJnÕxB(xAbvF0` ^x_EF1`)
     * @param prm_now_level ʎJnꂽxB(xAbvF1` ^x_EF0`)
     */
    virtual void processEffectBegin(int prm_last_level, int prm_now_level) = 0;

    /**
     * @ʎR[obN(t[R[obN) .
     * @(effecting_frames_base_==0)̖@͂P񂾂R[obN邱ƂɂȂ܂B
     * yӁzx0łAIɂ̓x0̖@ʎƍl{\bh͌Ăяoꑱ܂B
     * @param prm_last_level  ȑÕxB
     * @param prm_now_level ()̃xB
     */
    virtual void processEffectingBehavior(int prm_last_level, int prm_now_level) = 0;

    /**
     * ̃x̖@rsł邩ׂ
     * @param prm_new_level r郌x
     * @retval MAGIC_CAST_NG_INVOKING_NOW       (-3)  ݔׁ̂As
     * @retval MAGIC_CAST_NG_MP_IS_SHORT        (-2)  xAbvrƂȂ邪AMPȂׁAs
     * @retval MAGIC_CAST_CANCEL                (-1)  ݉rŁÃx́Ã݂xƈvB܂rLZwɂȂBi\Es\ŌΉ\j
     * @retval MAGIC_CAST_NOTHING               (0)   ̃x́Ã݂xƈvBȂɂwĂȂƂɂȂBi\Es\ŌΉ\j
     * @retval MAGIC_CAST_OK_LEVELUP            (1)   xAbvrƂȂBMP׉\
     * @retval MAGIC_CAST_LEVELDOWN             (2)   x_ErƂȂB\
     * @retval MAGIC_CAST_OK_CANCEL_AND_LEVELUP (3)   ݂̉rLZẴxAbvrƂȂBMP׉\
     * @retval MAGIC_CAST_CANCEL_AND_LEVELDOWN  (4)   ݂̉rLZẴx_ErƂȂB\
     */
    int chkCastAble(int prm_new_level);

    /**
     * ̃x̖@sł邩ׂ
     * @param prm_new_level 郌x
     * @return
     */
    int chkInvokeAble(int prm_new_level);

    /**
     * ̃x̖@ʂsł邩ׂ
     * @param prm_level
     * @return
     */
    int chkEffectAble(int prm_level);

    /**
     * _Exs̊ҌMPvZĕԂ .
     * cʎ̊悸B
     * x_Eقɂ邽߁B
     * @param prm_now_level ݂̃x
     * @param prm_target_down_level _Ex
     * @return
     */
    magic_point calcReduceMp(int prm_now_level, int prm_target_down_level);

    virtual ~Magic();
};

}

#endif /*MAGIC_H_*/
