#ifndef MAGICMETER_H_
#define MAGICMETER_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMassBoardActor.h"

#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/Magic.h"
#include "jp/ggaf/core/util/LinkedListRing.hpp"

namespace VioletVreath {

#ifdef pMYSHIP
    #define pMAGICMETER (pMYSHIP->pMagicMeter_)
#else
    #error pMAGICMETER isnt define
#endif


typedef GgafCore::LinkedListRing<Magic> MagicList;

/**
 * @[^[ .
 * @version 1.00
 * @since 2011/01/11
 * @author Masatoshi Tsuge
 */
class MagicMeter : public GgafLib::DefaultMassBoardActor {
protected:
    VERTEX_instancedata* paInstancedata_MM_;
    int max_draw_num_;
public:
    TractorMagic* pTractorMagic_;
    SpeedMagic*   pSpeedMagic_;
    LockonMagic*  pLockonMagic_;
    TorpedoMagic* pTorpedoMagic_;
    ShotMagic*    pShotMagic_;
    LaserMagic*   pLaserMagic_;
    BunshinMagic* pBunshinMagic_;
    VreathMagic*  pVreathMagic_;
    SmileMagic*   pSmileMagic_;

//    /** @MP */
//    GgafLib::Quantity* pMP_MyShip_;
//    /** @Vreath */
//    GgafLib::Quantity* pVreath_MyShip_;
//    /** Vreath̃_[W\p */
//    GgafLib::Quantity damage_disp_vreath;

    /** c@ʎԕ\ */
    MagicMeterStatus* pMagicMeterStatus_;
    /** Gl[o[ */
    MpBar* pMpBar_;
    /** RXg\o[ */
    CostDispBar* pMpCostDispBar_;
    /** X[o[ */
    VreathBar* pVreathBar_;
    /** RXg\o[ */
    CostDispBar* pVreathCostDispBar_;
    /** _[W\o[ */
    DamageDispBar* pDamageDispBar_;

    /** @Xg */
    MagicList lstMagic_;

    /** [^J[\ */
    MagicMeterCursor001* pMainCur_;
    /** e@(z)̃x̃J[\(ړ) */
    MagicLvCursor001** papLvTgtMvCur_;
    /** e@(z)̌x\pJ[\ */
    MagicLvCursor002** papLvNowCur_;
    /** e@(z)̉rx\pJ[\ */
    MagicLvCursor003** papLvCastingCur_;

    /** [r]݂̊e@(z)̃[Abv\(0.0:Ă ` 1.0:JĂ) */
    float* r_roll_;
    /** [r/w]e@(z)̃[Abv̑ */
    float* r_roll_velo_;

    float alpha_velo_;

    /** @[^[P̉(px) */
    const float width_px_;
    /** @[^[P̍(px) */
    const float height_px_;
    /** @[^[P̉ */
    const coord width_;
    /** @[^[P̍ */
    const coord height_;

    std::stringstream st_[10];

    /** [r]rʉǗ */
    GgafDx::SeTransmitterForActor* pSeTx4Cast_;
    /** [r]ʉǗ */
    GgafDx::SeTransmitterForActor* pSeTx4Invoke_;
    /** \̎c莞Ԃݒ */
    frame fraeme_of_notice_remaind_;

public:
    /**
     * RXgN^ .
     * @param prm_name ʖ
     * @param prm_pMP_MyShip MPlϐ̃AhX
     * @param prm_pVreath_MyShip Vreathlϐ̃AhX
     */
    MagicMeter(const char* prm_name, int* prm_pMP_MyShip, int* prm_pVreath_MyShip);

    void saveStatus(int prm_saveno);

    void loadStatus(int prm_saveno);

    void save(std::stringstream& sts);

    void loadProperties(std::stringstream& sts);

    void initialize() override;

    void onReset() override;

    void onActive() override;

    void processBehavior() override;

    void onInactive() override;

    void processDraw() override;

    void rollOpen(int prm_meter_index);

    void rollClose(int prm_meter_index);


    void setMeterAlpha(float a);
    virtual ~MagicMeter();
};

}
#endif /*MAGICMETER_H_*/

