#include "ScoreItem.h"

#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/GeoDriver.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/gecchi/VioletVreath/actor/my/MagicMeter/magic/TractorMagic.h"
#include "jp/gecchi/VioletVreath/God.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"



using namespace GgafLib;
using namespace VioletVreath;

enum {
    PROG_DRIFT      , //ʏړ
    PROG_ATTACH     , //z(z)
    PROG_ABSORB     , //z(z)
    PROG_BANPEI,
};

ScoreItem::ScoreItem(const char* prm_name, const char* prm_model, void* prm_pFuncStatusReset)
               : Item(prm_name, prm_model, prm_pFuncStatusReset) {
    _class_name = "ScoreItem";
    effectBlendOne(); //ZTechniquew
    setZEnableDraw(true);        //`掞AZobt@l͍l
    setZWriteEnable(false);  //gZobt@݂Ȃ
    setCullingDraw(false);
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setFaceAngVelo(AXIS_X, D_ANG(3));
    pVecDriver->setFaceAngVelo(AXIS_Y, D_ANG(5));
    pVecDriver->setFaceAngVelo(AXIS_Z, D_ANG(7));
    pVecDriver->linkFaceAngByMvAng(true);
    kDX_ = kDY_ = kDZ_ = 0;
    setHitAble(true, false); //ʊO蔻͖
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, 400000);
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(0, "WAVE_GET_ITEM_001");
}

void ScoreItem::initialize() {
}

void ScoreItem::onActive() {
    // _x, _y, _z ͔Wɐݒς
    setHitAble(true, false);
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    pGeoDriver->forceVxyzMvVeloRange(-30000, 30000);
    pGeoDriver->setZeroVxyzMvVelo();
    pGeoDriver->setZeroVxyzMvAcce();
    pGeoDriver->stopGravitationMvSequence();

    //ݒ
    MyShip* pMyShip = pMYSHIP;
//    //U΂͈͐`Pӂ̒
//    int scattered_renge    = pChecker->_pCollisionArea->_papColliPart[0]->_dx; //蔻Ɠ
//    //n_A@ւ̕ւ̎U΂͈͐`̈悪ʒu鋗iscattered_distance > (scattered_renge/2) ł邱)
////    int scattered_distance = scattered_renge/2 + 400000;
//    //]āAscattered_distance ĂĂA@͓ȂĂ肬SĉłB
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->forceMvVeloRange(0, 20000);
    float vX, vY, vZ;
    UTIL::getNormalizedVector(
            pMyShip->_x - _x,
            pMyShip->_y - _y,
            pMyShip->_z - _z,
            vX, vY, vZ);
    int d = PX_C(200);
    int r = PX_C(75);
    pVecDriver->setMvAngTwd((coord)(_x + (vX * d) + RND(-r, +r)),
                         (coord)(_y + (vY * d) + RND(-r, +r)),
                         (coord)(_z + (vZ * d) + RND(-r, +r)) );
    pVecDriver->setMvVelo(2000);
    pVecDriver->setMvAcce(100);

    getProgress()->reset(PROG_DRIFT);
    _sx = _sy = _sz = 1000;
}

void ScoreItem::processBehavior() {
    //ʏړ
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafDx::GeoDriver* const pGeoDriver = getGeoDriver();
    GgafCore::Progress* const pProg = getProgress();
    if (pProg->get() == PROG_DRIFT) {
        //TractorMagicPROG_ATTACHֈڍs
        if (getTractorMagic()->is_tracting_) {
            effectFlush(6); //tbV
            setHitAble(false);
            pProg->change(PROG_ATTACH);
        }
        //邢 onHit()  PROG_ATTACH ԕω̂҂
    }

    //@Ɠ蔻肪qbgA@Ɍ
    if (pProg->get() == PROG_ATTACH) {
        MyShip* pMyShip = pMYSHIP;
        if (pProg->hasJustChanged()) {
            //@Ɉ͂ň񂹂悤ȓݒ
            pGeoDriver->setVxyzMvVelo(pVecDriver->_vX * pVecDriver->_velo_mv,
                                     pVecDriver->_vY * pVecDriver->_velo_mv,
                                     pVecDriver->_vZ * pVecDriver->_velo_mv);
            pGeoDriver->execGravitationMvSequenceTwd(pMyShip,
                                                    PX_C(20), 200, PX_C(100));
            pVecDriver->stopMv();
        }

        //@ߕӂɓBH
        if (ABS(pMyShip->_x - _x) < 20000 &&
            ABS(pMyShip->_y - _y) < 20000 &&
            ABS(pMyShip->_z - _z) < 20000 ) {

            kDX_ = pMyShip->_x - _x;
            kDY_ = pMyShip->_y - _y;
            kDZ_ = pMyShip->_z - _z;
            pProg->change(PROG_ABSORB); //zz
        }

    }

    //@ߕӂɓBAzAz̓
    if (pProg->get() == PROG_ABSORB) {
        MyShip* pMyShip = pMYSHIP;
        if (pProg->hasJustChanged()) {
            pGeoDriver->setZeroVxyzMvVelo();
            pGeoDriver->setZeroVxyzMvAcce();
            pGeoDriver->stopGravitationMvSequence();
        }
        _x = pMyShip->_x + kDX_;
        _y = pMyShip->_y + kDY_;
        _z = pMyShip->_z + kDZ_;
        _sx -= 100;
        _sy -= 100;
        _sz -= 100;
        if (_sx < 5) {
            getSeTransmitter()->play(0);
            pProg->changeNothing();
            sayonara(); //I
        }
        G_SCORE += 100;
    }
    pVecDriver->behave();
    pGeoDriver->behave();
}

void ScoreItem::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
//    //ʏړ
//    if (pProg->get() == PROG_DRIFT) {
//        //onHit() ŏԕω̂҂
//    }
//
//    //@Ɠ蔻肪qbg
//    if (pProg->get() == PROG_ATTACH) {
//
//    }
//
//    //@ɋzAz̓
//    if (pProg->get() == PROG_ABSORB) {
//    }
}

void ScoreItem::onInactive() {
}

void ScoreItem::onHit(const GgafCore::Actor* prm_pOtherActor) {
    GgafDx::GeometricActor* pOther = (GgafDx::GeometricActor*)prm_pOtherActor;
    //ɃqbgGtFNg

    GgafCore::Progress* const pProg = getProgress();
    if (pProg->get() == PROG_DRIFT && (pOther->lookUpKind() & KIND_MY_BODY))  {
        setHitAble(false);
        pProg->change(PROG_ATTACH);
    }

}

ScoreItem::~ScoreItem() {
}
