#include "TestPa.h"

#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"

using namespace GgafLib;
using namespace VioletVreath;

enum {
    SE_DAMAGED   ,
    SE_EXPLOSION ,
};

TestPa::TestPa(const char* prm_name)
      : TestEnemy(prm_name, "TestPa", StatusReset(TestPa)) {
    _class_name = "TestPa";

    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_DAMAGED  , "WAVE_ENEMY_DAMAGED_001");
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_MIDDLE_001");
}

void TestPa::onActive() {
    getStatus()->reset();
}

void TestPa::processBehavior() {
    getVecDriver()->behave();
    //getSeTransmitter()->behave();
    dispStamina();
}

void TestPa::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void TestPa::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(SE_EXPLOSION);
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
        getSeTransmitter()->play3D(SE_DAMAGED);
    }
}

TestPa::~TestPa() {
}
