#ifndef ENEMYRATISLAVIA_H_
#define ENEMYRATISLAVIA_H_
#include "VioletVreath.h"
#include "jp/gecchi/VioletVreath/actor/VvChikeiActor.hpp"
#include "jp/ggaf/lib/actor/CubeMapMeshActor.h"

namespace VioletVreath {


DECLARE_HASHVAL(RATISLAVIA_EXPLOSION);

/**
 * eBXBA .
 * ŏɍn`ig[Xj
 * @version 1.00
 * @since 2010/05/08
 * @author Masatoshi Tsuge
 */
class EnemyRatislavia : public VvChikeiActor<GgafLib::CubeMapMeshActor> {

public:
    /** g[X̔a1(ւ̔a) */
    coord r1_;
    /** g[X̔a2(̔a) */
    coord r2_;
    int colli_part_num_;
public:
    /**
     * RXgN^ .
     * @param prm_name
     * @param prm_model
     * @param prm_r1 g[X̔a1(ւ̔a)
     * @param prm_r2 g[X̔a2(̔a)
     * @return
     */
    EnemyRatislavia(const char* prm_name, const char* prm_model, coord prm_r1, coord prm_r2);

    virtual void onCreateModel() override;

    virtual void initialize() override;

    virtual void onActive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    virtual void onHit(const GgafCore::Actor* prm_pOtherActor) override;

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override;

    virtual int isOutOfView() override;

    virtual bool isOutOfSpacetime() const override;

    virtual ~EnemyRatislavia();

protected:
    /**
     * eBXBA̓蔻̈쐬ݒ肷 .
     * @param prm_nSphere 蔻苅̐
     */
    void createCollisionAreaArea(int prm_nSphere);

    /**
     * eBXBA̕\ʂɎq{[ǉ
     * @param prm_pGeoActor ǉAN^[
     * @param prm_ang1 ւ̊pxʒu
     * @param prm_ang2 ֎̊pxʒu
     */
    void appendGroupChildAsFkOnSurface(GgafDx::GeometricActor* prm_pGeoActor, angle prm_ang1, angle prm_ang2);

};

}
#endif /*ENEMYRATISLAVIA_H_*/

