#include "EnemyAllas.h"

#include "jp/ggaf/core/actor/ex/ActorDepository.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/SeTransmitterForActor.h"
#include "jp/ggaf/dx/model/Model.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"
#include "jp/ggaf/dx/util/curve/DriverLeader.h"
#include "jp/gecchi/VioletVreath/GameGlobal.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/gecchi/VioletVreath/scene/Spacetime/World/GameScene/MyShipScene.h"
#include "jp/gecchi/VioletVreath/God.h"

using namespace GgafDx;
using namespace GgafLib;
using namespace VioletVreath;

enum {
    SE_EXPLOSION ,
};

EnemyAllas::EnemyAllas(const char* prm_name) :
        VvEnemyActor<DefaultMeshSetActor>(prm_name, "Allas", StatusReset(EnemyAllas)) {
    _class_name = "EnemyAllas";
    iMovePatternNo_ = 0;
    pDriverLeader_ = nullptr;
    pDepo_shot_ = nullptr;
    pDepo_effect_ = nullptr;
    GgafDx::SeTransmitterForActor* pSeTx = getSeTransmitter();
    pSeTx->set(SE_EXPLOSION, "WAVE_EXPLOSION_001");     //
}

void EnemyAllas::onCreateModel() {
    GgafDx::Model* pModel = getModel();
    pModel->setSpecular(5.0, 1.0);
}

void EnemyAllas::initialize() {
    setHitAble(true);
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setFaceAngVelo(AXIS_Z, -7000);
    pVecDriver->linkFaceAngByMvAng(true);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, 40000);
}

void EnemyAllas::onActive() {
    if (pDriverLeader_ == nullptr) {
        throwCriticalException("EnemyAllas̓XvCK{łconfigĉ");
    }

    getStatus()->reset();
   iMovePatternNo_ = 0; //sp^[Zbg
   getProgress()->change(1);
}

void EnemyAllas::processBehavior() {
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    GgafCore::Progress* const pProg = getProgress();
    //yp^[1FJ[uړz
    if (pProg->hasJustChangedTo(1)) {
        pDriverLeader_->start(ABSOLUTE_COORD); //J[uړJn(1:W)
    }
    if (pProg->get() == 1) {
        //J[uړI҂
        if (pDriverLeader_->isFinished()) {
            pProg->changeNext(); //̃p^[
        }
    }

    switch (iMovePatternNo_) {
        case 0:  //yp^[OFJ[uړJnz
            if (pDriverLeader_) {
                pDriverLeader_->start(ABSOLUTE_COORD); //J[uړJn(1:W)
            }
            iMovePatternNo_++; //̍sp^[
            break;

        case 1:  //yp^[PFJ[uړI҂z
            if (pDriverLeader_) {
                //J[uړL
                if (pDriverLeader_->isFinished()) {
                    iMovePatternNo_++; //J[uړI玟̍sp^[
                }
            } else {
                //J[uړ
                iMovePatternNo_++; //Ɏ̍sp^[
            }
            break;

        case 2:  //yp^[QFˏVbg˂Ǝ@֕]z
            if (pDepo_shot_) {
                //ˏVbg
                int way = RF_EnemyAllas_ShotWay(G_RANK); //VbgWAY
                angle* paAng_way = NEW angle[way];
                UTIL::getRadialAngle2D(0, way, paAng_way);
                GgafDx::FigureActor* pActor_shot;
                for (int i = 0; i < way; i++) {
                    pActor_shot = (GgafDx::FigureActor*)pDepo_shot_->dispatch();
                    if (pActor_shot) {
                        pActor_shot->setPositionAt(this);
                        pActor_shot->getVecDriver()->setRzRyMvAng(paAng_way[i], D90ANG);
                        pActor_shot->activate();
                    }
                }
                GGAF_DELETEARR(paAng_way);
                //Vbg˃GtFNg
                if (pDepo_effect_) {
                    GgafDx::FigureActor* pTestActor_Shot = (GgafDx::FigureActor*)pDepo_effect_->dispatch();
                    if (pTestActor_Shot) {
                        pTestActor_Shot->setPositionAt(this);
                    }
                }
            }
//            //@֕]
            pVecDriver->turnMvAngTwd(pMYSHIP->_x, _y, pMYSHIP->_z,
                                    2000, 0,
                                    TURN_CLOSE_TO, true);
            iMovePatternNo_++; //̍sp^[
            break;

        case 3:   //ysp^[Rz

            break;
        default:
            break;
    }

    if (pDriverLeader_) {
        pDriverLeader_->behave(); //J[uړ悤Driver𑀍
    }
    pVecDriver->behave();
    //getSeTransmitter()->behave();
}

void EnemyAllas::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void EnemyAllas::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        //j󂳂ꂽ(X^~i <= 0)
        getSeTransmitter()->play3D(SE_EXPLOSION);
        sayonara();
    } else {
        //j󂳂Ȃ(X^~i > 0)
    }
}

void EnemyAllas::onInactive() {
    sayonara();
}

void EnemyAllas::config(
        GgafDx::CurveManufacture* prm_pCurveManufacture,
        GgafCore::ActorDepository* prm_pDepo_shot,
        GgafCore::ActorDepository* prm_pDepo_shotEffect
        ) {
    //J[uړvOݒ
    pDriverLeader_ = createCurveDriverLeader(prm_pCurveManufacture);
    pDepo_shot_ = prm_pDepo_shot;
    pDepo_effect_ = prm_pDepo_shotEffect;
}

EnemyAllas::~EnemyAllas() {
    GGAF_DELETE_NULLABLE(pDriverLeader_);
}
