#include "EffectTurbo002.h"

#include "jp/ggaf/dx/actor/supporter/Scaler.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"



using namespace GgafLib;
using namespace VioletVreath;

EffectTurbo002::EffectTurbo002(const char* prm_name) :
        DefaultSpriteActor(prm_name, "Turbo002") {
    _class_name = "EffectTurbo002";
    inactivate();
    effectBlendOne(); //Z
    setHitAble(false); //蔻薳
}

void EffectTurbo002::initialize() {
    GgafDx::UvFlipper* pUvFlipper = getUvFlipper();
    pUvFlipper->setFlipPtnRange(0, 0);   //Aj͈͂O`PT
    pUvFlipper->exec(FLIP_ORDER_LOOP, 2); //Aj
}

void EffectTurbo002::onActive() {
    getUvFlipper()->setActivePtnToTop();
    setAlpha(0.4);
    getScaler()->setRange(100000, 1000); //XP[OE͈
    setScale(1000);
    getScaler()->transitionLinearUntil(100000, 60);//XP[OE60F₵1000ɏk
    setRyFaceAng(D90ANG);
    getVecDriver()->setFaceAngVelo(AXIS_Z, 2000);
}

void EffectTurbo002::processBehavior() {
    addAlpha(-(1.0/60.0));
    getUvFlipper()->behave();
    getVecDriver()->behave();
    getScaler()->behave();
}

void EffectTurbo002::processJudgement() {
    if (!getScaler()->isTransitioning()) {
        inactivate();
    }
}

void EffectTurbo002::onInactive() {
}

EffectTurbo002::~EffectTurbo002() {
}
