#include "EffectExplosion001.h"

#include "jp/ggaf/dx/actor/supporter/Scaler.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/dx/actor/supporter/UvFlipper.h"
#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"



using namespace GgafLib;
using namespace VioletVreath;

EffectExplosion001::EffectExplosion001(const char* prm_name) :
        DefaultMassSpriteActor(prm_name, "EffectExplosion001") {
    _class_name = "EffectExplosion001";
    effectBlendOne(); //ZTechniquew
    defineRotMvWorldMatrix_Billboard(); //XYZr{[h
}

void EffectExplosion001::initialize() {
    setHitAble(false);
}

void EffectExplosion001::onActive() {
    GgafDx::UvFlipper* pUvFlipper = getUvFlipper();
    pUvFlipper->setActivePtnToTop();
    pUvFlipper->exec(FLIP_ORDER_NOLOOP, 1);
    setCullingDraw(false);
    setAlpha(1.0);
    _sx = _sy = _sz = 1000;
}

void EffectExplosion001::processBehavior() {
    _alpha -= 0.03;
    _sx+= 100;
    _sy+= 100;
    getUvFlipper()->behave();
    getVecDriver()->behave();
    getScaler()->behave();
}

void EffectExplosion001::processJudgement() {
    if (!getUvFlipper()->isFlipping()) {
        //Aj[VII
        sayonara();
    }
}

void EffectExplosion001::onInactive() {
    getVecDriver()->stopMv();
}


EffectExplosion001::~EffectExplosion001() {
}
