#ifndef EFFECTENTRY_H_
#define EFFECTENTRY_H_
#include "VioletVreath.h"
#include "jp/ggaf/lib/actor/DefaultMassMeshActor.h"

namespace VioletVreath {

/**
 * uGtFNg .
 * ޏꎞ̃GtFNgȂǂzB
 * @version 1.00
 * @since 2013/06/28
 * @author Masatoshi Tsuge
 */
class EffectBlink : public GgafLib::DefaultMassMeshActor {

public:
    /** [r]GtFNg`ő̑傫܂ŊgA܂ł̃t[ */
    frame scale_in_frames_;
    /** [r]GtFNgt[ */
    frame duration_frames_;
    /** [r]GtFNg`ł܂ł̃t[ */
    frame scale_out_frames_;
    /** [r]GtFNgΏۂ̃AN^[ */
    const GgafDx::GeometricActor* pTarget_;
    /** [r]GtFNgIsayonara()邩ۂ */
    bool sayonara_end_;

public:
    /**
     * RXgN^ .
     * @param prm_name ʖ
     * @param prm_model fID
     */
    EffectBlink(const char* prm_name, const char* prm_model);

    virtual void onInactive() override;

    virtual void onActive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    /**
     * u .
     * GtFNg̔AAłsB
     * </PRE>
     *       QQQQ                Top XP[
     *      /:      :_
     *     / :      :  _
     *    /  :      :    _
     *   /   :      :      _
     *  /    :      :        _
     * /     :      :          _    Bottom XP[
     * ----------------------------------------------->ԁit[j
     * @|A| B |
     *
     * </PRE>
     * Top XP[,Bottom XP[ pScaler_->setRange(TOP,BOTTOM) ŏ㏑ݒ\B
     * @param prm_scale_in_frames uԁAL@̃t[ (1`)
     * @param prm_duration_frames uԁALÃt[ (0`)
     * @param prm_scale_out_frames uŎԁALB̃t[ (1`)
     * @param prm_pFollowTarget GtFNgW̃AN^[ƓWɓƂ(Ǐ])B sv̏ꍇ nullptr .
     * @param prm_sayonara_end true:uI sayonara() /false: uIĂ sayonara() ȂBȗtrue
     */
    virtual void blink(frame prm_scale_in_frames, frame prm_duration_frames, frame prm_scale_out_frames,
                       const GgafDx::GeometricActor* prm_pFollowTarget, bool prm_sayonara_end = true);

    /**
     * u .
     * L blink() ƓAŏ̃XP[݂̃XP[ł̂܂܊JnB
     * @param prm_scale_in_frames
     * @param prm_duration_frames
     * @param prm_scale_out_frames
     * @param prm_pFollowTarget
     * @param prm_sayonara_end
     */
    virtual void blink2(frame prm_scale_in_frames, frame prm_duration_frames, frame prm_scale_out_frames,
                        const GgafDx::GeometricActor* prm_pFollowTarget, bool prm_sayonara_end = true);


    /**
     * uĂ邩 .
     * @return
     */
    bool isBlinking();

    void forceFadeOut(frame prm_scale_out_frames);

    /**
     * ut[擾 .
     */
    frame getBlinkFrames() {
        return (scale_in_frames_+duration_frames_+scale_out_frames_);
    }

    /**
     * GtFNgƂĎgpꍇ́AAN^[̓Jnt[擾 .
     * @return Jnt[
     */
    frame getFrameOfSummonsBegin() {
        return (scale_in_frames_/2);
    }

    /**
     * GtFNgƂĎgpꍇ́Aɔ₷t[擾 .
     * @return ɔ₷t[
     */
    frame getSummoningFrames() {
        return ( (scale_in_frames_/2) + duration_frames_ + (scale_out_frames_/2) );
    }

    virtual ~EffectBlink();
};

}
#endif /*EFFECTENTRY_H_*/

