#include "AliceShot.h"

#include "jp/gecchi/VioletVreath/util/MyStgUtil.h"
#include "jp/ggaf/dx/actor/supporter/VecDriver.h"
#include "jp/ggaf/lib/util/CollisionChecker.h"

using namespace GgafLib;
using namespace VioletVreath;

AliceShot::AliceShot(const char* prm_name, const char* prm_model_id) :
        VvEnemyActor<SingleLaser>(prm_name, prm_model_id, StatusReset(AliceShot)) { //SingleLaser͍ő27Zbgł
        //SingleLaser(prm_name, "27,laser_single") { //SingleLaser͍ő27Zbgł
    _class_name = "AliceShot";
}

void AliceShot::initialize() {
    setHitAble(false);
    CollisionChecker* pChecker = getCollisionChecker();
    pChecker->createCollisionArea(1);
    pChecker->setColliAACube(0, PX_C(16));
}
void AliceShot::onReset() {
    setCullingDraw(false);
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setRollFaceAngVelo(D_ANG(3));
    pVecDriver->linkFaceAngByMvAng(true);
}

void AliceShot::onActive() {
    setHitAble(true, false);
    getStatus()->reset();
    GgafDx::VecDriver* const pVecDriver = getVecDriver();
    pVecDriver->setRyMvAng(D90ANG);
    pVecDriver->setRzMvAngVelo(D_ANG(1));
}

void AliceShot::processBehavior() {
    //Wɔf
    getVecDriver()->behave();
}

void AliceShot::processJudgement() {
    if (isOutOfSpacetime()) {
        sayonara();
    }
}

void AliceShot::onHit(const GgafCore::Actor* prm_pOtherActor) {
    bool was_destroyed = UTIL::performEnemyHit(this, (const GgafDx::GeometricActor*)prm_pOtherActor);
    if (was_destroyed) {
        sayonara();
    } else {
    }
}

AliceShot::~AliceShot() {
}
