#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// [U[`bvpVF[_[
//
// author : Masatoshi Tsuge
// date:2009/04/23
////////////////////////////////////////////////////////////////////////////////
/*
[U[`bv͎̂悤ȃbVł邱ƂO

 Mesh {
  8;
  0.000100;0.000000;1.000000;,
  0.000000;0.000000;1.000000;,
  0.000100;0.000000;-1.000000;,
  0.000100;-1.000000;0.000000;,
  0.000000;-1.000000;0.000000;,
  0.000100;1.000000;0.000000;,
  0.000000;0.000000;-1.000000;,
  0.000000;1.000000;0.000000;;
  4;
  3;0,1,2;,
  3;3,4,5;,
  3;2,1,6;,
  3;5,4,7;;

  MeshNormals {
   2;
   0.000000;-1.000000;0.000000;,
   0.000000;0.000000;-1.000000;;
   4;
   3;0,0,0;,
   3;1,1,1;,
   3;0,0,0;,
   3;1,1,1;;
  }

  MeshTextureCoords {
   8;
   0.532110;0.000000;,
   0.500000;0.000000;,
   0.533110;0.999000;,
   0.532110;0.000000;,
   0.500000;0.000000;,
   0.533110;0.999000;,
   0.501000;0.999000;,
   0.501000;0.999000;;
  }

  MeshMaterialList {
   1;
   4;
   0,
   0,
   0,
   0;

   Material {
    0.588235;0.588235;0.588235;1.000000;;
    0.100000;
    0.900000;0.900000;0.900000;;
    0.000000;0.000000;0.000000;;

    TextureFilename {
     "MyOptionWateringLaserChip001.png";
    }
   }
  }
*/
//G[̂߂ɂƂ肠ǉłƂ
float3 g_posCam_World;
float g_specular;
float g_specular_power;
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;
float g_zf;

float4x4 g_matView;   //Viewϊs
float4x4 g_matProj;   //ˉeϊs

float3 g_vecLightFrom_World; // Cg̕
float4 g_colLightAmbient;   // AmbienCgFiːFj
float4 g_colLightDiffuse;   // DiffuseCgFiːFj

float4 g_colMaterialDiffuse;  //}eADiffuseːFƁAAmbienːF

//soWX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj : POSITION;
    float2 uv            : TEXCOORD0;
    float4 color         : COLOR0;
};


///////////////////////////////////////////////////////////////////////////

//[U[`bv_VF[_[
OUT_VS VS_LaserChip(
      float4 prm_posModel_Local   : POSITION,   // f̒_
      float3 prm_vecNormal_Local  : NORMAL,
      float2 prm_uv               : TEXCOORD0,  // f̒_UV

      float4 prm_world0           : TEXCOORD1,
      float4 prm_world1           : TEXCOORD2,
      float4 prm_world2           : TEXCOORD3,
      float4 prm_world3           : TEXCOORD4,
      float4 prm_infront_world0   : TEXCOORD5,
      float4 prm_infront_world1   : TEXCOORD6,
      float4 prm_infront_world2   : TEXCOORD7,
      float4 prm_infront_world3   : TEXCOORD8,
      float4 prm_info             : TEXCOORD9   //x:`bv, y:, z:Η͗, w:O`bvΗ͗

) {
    OUT_VS out_vs = (OUT_VS)0;

    float4x4 matWorld = {prm_world0, prm_world1, prm_world2, prm_world3};
    float4x4 matWorld_infront = {prm_infront_world0, prm_infront_world1, prm_infront_world2, prm_infront_world3};
    int kind_t = (int)(prm_info.x);
    float force_alpha = prm_info.y;
    float power;
    float4 posModel_World;

    //[U[`bv ɂāB
    //
    //      -==========<>            [U[
    //
    //      -= === === === <>        ȂӂɕfĂ܂B
    //
    //    | -=|===|===|===|<> |     }̓[U[IuWFNgŋ؂̐}
    //
    //    <--><--><--><--><-->^
    //    ^   ^   ^   ^   ^   |
    //    |   |   |   |   |   |
    //    |   |   |   |   |    `----- 5:[`bv(\ŁAԐ擪`bv\邽߂ɑ)
    //    |   |   |   |    `----- 4:Ԑ擪`bv(\̐擪)
    //    |   |   |    `----- 3:ԃ`bv
    //    |   |    `----- 3:ԃ`bv
    //    |    `----- 3:ԃ`bv
    //     `----- 1:`bv
    //
    //擪Ɛ[ƂtŋʂĂ܂B
    if (prm_posModel_Local.x > 0.0) {
        prm_posModel_Local.x = 0;
        if (kind_t == 5) {  //4ł͂Ȃ
            prm_posModel_Local.y = 0;
            prm_posModel_Local.z = 0;
        }
        // Õ`bvWւ
        posModel_World = mul( prm_posModel_Local, matWorld_infront );  //Õ`bvWorldϊ
        power = prm_info.w; //O`bvΗ͗
    } else { // prm_posModel_Local.x <= 0.0
        //_vZ
        prm_posModel_Local.x = 0;
        posModel_World = mul( prm_posModel_Local, matWorld );  // Worldϊ
        power = prm_info.z; //Η͗
    }
    out_vs.posModel_Proj = mul(mul(posModel_World, g_matView), g_matProj);  // ViewϊEˉeϊ

    //UVݒ
    if (kind_t == 3) {
        //ԃ`bv
        out_vs.uv = prm_uv;
    } else if (kind_t == 2) {
        //`bvi悪ۂj
        if (prm_uv.x < 0.51f) {
            out_vs.uv.x = 0.0f;
        } else if (prm_uv.x > 0.51f) {
            out_vs.uv.x = 1.0f;
        } else {
            out_vs.uv.x = prm_uv.x;
        }
        out_vs.uv.y = prm_uv.y;
    } else if (kind_t == 1) {
        //`bv
        out_vs.uv.x = prm_uv.x < 0.51f ? 0.0f : prm_uv.x;
        out_vs.uv.y = prm_uv.y;
    } else if (kind_t == 4) {
        //Ԑ擪`bv
        out_vs.uv.x = prm_uv.x > 0.51f ? 1.0f : prm_uv.x;
        out_vs.uv.y = prm_uv.y;
    } else {
        //[`bv
        //`悵Ȃ
        out_vs.uv.x = 0;
        out_vs.uv.y = 1;
    }
    //tHO
    const float c = (1.25-(((out_vs.posModel_Proj.z)/g_zf)*2));
    out_vs.color = (c < 0.2  ? 0.2 : c) ;
    if (force_alpha > out_vs.color.a) {
        out_vs.color.a = force_alpha*g_alpha_master;
    } else {
        out_vs.color.a = out_vs.color.a*g_alpha_master;
    }
    out_vs.color.rgb *= power;  //power傫قǔP
//    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
//        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
//    }

//	if (out_vs.posModel_Proj.z > g_zf*0.75) { //ŉ 3/4 艜̏ꍇXɓ
//    	out_vs.color.a *= (-1.0/(g_zf*0.25)*out_vs.posModel_Proj.z + 4.0);
//	}

    //ȈՃtHO
//	out_vs.color.a = 1.0/((g_zf*0.9)*0.5))*out_vs.posModel_Proj.z - 1.0; // 1/2 艜̏ꍇXɓ
    //out_vs.color.a = 1.0/(g_zf - (g_zf*0.75))*out_vs.posModel_Proj.z - 3.0;  // 3/4 艜̏ꍇXɓ
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }

//ˉeϊƂ
//EʂX+1.0AʂX-1.0
//ʂY+1.0AʂY-1.0
//OʁiO̖ʁjZ0.0Awʁi̖ʁjZ+1.0
//g_zf:݂̎ˉeϊsvfzfBJ牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn
//    _zn = 0.1f;
//    _zf = -_cameraZ_org*(_dep+1.0);
// w =  _zf 
//
    return out_vs;
}

float4 PS_LaserChip(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color  : COLOR0
) : COLOR  {
    return tex2D( MyTextureSampler, prm_uv) * prm_color;
}

technique LaserChipTechnique
{
     pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = true; //!!
        SrcBlend  = SrcAlpha;
        DestBlend = One;
        BlendOp = Max;
        SrcBlendAlpha = One;
        DestBlendAlpha = Zero;
        BlendOpAlpha = Add;
        VertexShader = compile VS_VERSION VS_LaserChip();
        PixelShader  = compile PS_VERSION PS_LaserChip();
    }
}


