#include "GgafEffectConst.fxh"
/**
 * GgafLib::DefaultMeshActor pVF[_[ .
 * ÓIfP`悷WIȃVF[_[B
 * _obt@tH[}bǵAȉ̂悤 GgafLib::MeshModel ɒ`Ă̂OƂĂ܂B
 *
 * FVF = (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX3 |
 *                                                        D3DFVF_TEXCOORDSIZE2(0) |     // eNX`W
 *                                                        D3DFVF_TEXCOORDSIZE3(1) |     // ڃxNg
 *                                                        D3DFVF_TEXCOORDSIZE3(2)   )   // ]@xNg
 * {
 *     float x, y, z;             // W([JWn)
 *     float nx, ny, nz;          // @xNg([JWn)
 *     DWORD color;               // _J[
 *     float tu, tv;              // eNX`W
 *     float tan_x, tan_y, tan_z; // ڃxNg(uPʃxNgAov}bsOɎgp) ([JWn)
 *     float bin_x, bin_y, bin_z; // ]@xNg(vPʃxNgAov}bsOɎgp) ([JWn)
 * };
 *
 * @author Masatoshi Tsuge
 * @since 2009/03/06
 */

/** fWorldϊs */
float4x4 g_matWorld;
/** fViewϊs */
float4x4 g_matView;
/** f̎ˉeϊs */
float4x4 g_matProj;
/** fWorldϊs̋ts */
float4x4 g_matInvWorld;
/** Cg̕xNgiKς݁j */
float3 g_vecLightFrom_World;
/** Ji_j̈ʒuxNg */
float3 g_posCam_World;
/** ̐F */
float4 g_colLightAmbient;
/** Cg̐F(Cg̊gUˎ̃Cgg̐F) */
float4 g_colLightDiffuse;
/** f̃}eAF(CgɂgUˎ̃f̐F) */
float4 g_colMaterialDiffuse;
/** XyL[͈̔́in[txNgE@ςg_specularj */
float g_specular;
/** XyL[̋x */
float g_specular_power;
/** f̃eNX`F_ŋ@\(GgafDx::TextureBlinkerQ)̓_ŋx */
float g_tex_blink_power;
/** f̃eNX`F_ŋ@\(GgafDx::TextureBlinkerQ)̑ΏۂƂȂRGB̂l(0.0`1.0) */
float g_tex_blink_threshold;
/** tF[hCEAEg@\(GgafDx::AlphaCurtainQ)̂߂̃}X^[At@l(0.0`1.0) */
float g_alpha_master;
/** ݂̎ˉeϊsvfzfBJ牓̃Nbvʂ܂ł̋(ǂ܂ł̋\Ώۂj> zn */
float g_zf;
/** -1.0 or 0.999 Bł\ꍇ0.999 B*/
float g_far_rate;

float g_lambert_flg;


/** eNX`̃Tv[(s0 WX^ɃZbgꂽeNX`g) */
sampler MyTextureSampler : register(s0);
/** @}bveNX`̃Tv[(s2 WX^ɃZbgꂽeNX`g) */
sampler BumpMapTextureSampler : register(s2);

/** _VF[_[o͍\ */
struct OUT_VS {
    float4 posModel_Proj   : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊ)
    float2 uv              : TEXCOORD0;   //_eNX`UV
    float4 color           : COLOR0;      //_J[
    float3 vecNormal_World : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World    : TEXCOORD2;   //_̎(_->_)xNg([hWn)
};

/**
 * GgafLib::DefaultMeshActor p̕W_VF[_[ .
 * _ World > View > ˉe ϊA
 * fɈȉ̐FuhA_J[ƂĂ̐ݒ肷
 * ECg̐FigUFj
 * Ef̃}eAFigUːFj
 * EFZ
 *  iȏ̐Fƃf\ʂ̖@ƃCgˊpƂ̍vZACg̐Flj
 * E`掞̃tHO
 * @param prm_posModel_Local  _̃[JW
 * @param prm_vecNormal_Local [J_ł̖@xNg
 * @param prm_uv              _UVW
 * @return OUT_VS _VF[_[o͍\́BL̐Q
 */
OUT_VS VS_DefaultMesh(
      float4 prm_posModel_Local  : POSITION,
      float3 prm_vecNormal_Local : NORMAL,
      float2 prm_uv              : TEXCOORD0
) {
    OUT_VS out_vs = (OUT_VS)0;

    //_vZ
    const float4 posModel_World = mul(prm_posModel_Local, g_matWorld);        //Worldϊ
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe

    //UVvZ
    out_vs.uv = prm_uv;  //̂܂

    //_J[vZ
    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, g_matWorld));
    //@ƁAgU̓ς烉Cgˊp߁Aʂɑ΂gU˗߂B
    float refl_power = dot(out_vs.vecNormal_World, -g_vecLightFrom_World);
    if (g_lambert_flg > 0) {
        //ς̒̕lgpāAn[tEo[g ŊgỦ͂s
        refl_power = refl_power * 0.5f + 0.5f;
        refl_power *= refl_power;
    } else {
        //ʏ̃o[gˁAς̒̕lJbg
        refl_power = max(refl_power, 0);
    }
    refl_power *= refl_power;
    //gUFɔ˗悶AFZAŜ}eAF|B
    out_vs.color.rgb = (g_colLightAmbient + (g_colLightDiffuse*refl_power)) * g_colMaterialDiffuse.rgb;
    //̓CgɊ֌WȂ}eADƂ
    out_vs.color.a = g_colMaterialDiffuse.a;
    //u_J_vxNgBsNZVF[_[̃XyL[vZŎgpB
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);

    //̕\@B
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            //{OZłA`邽߁AˉeZW㏑A
            out_vs.posModel_Proj.z = g_zf*g_far_rate; //{OZłA`邽 g_zf*0.999 ɏ㏑A
        }
    } else {
        //tHO
        if (out_vs.posModel_Proj.z > 0.666f*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
            //  z : 0.666*g_zf ` 1.0*g_zf    : 1.0 ` 0.0  ƂȂ悤ɂɂ
            //   = ( (0.0-1.0)*z - (0.666*g_zf*0.0) + (1.0*1.0*g_zf) ) / (1.0*g_zf-0.666*g_zf)
            //   = (3.0*(g_zf-z))/g_zf = (3.0*g_zf - 3.0*z)/g_zf = 3.0 - 3.0*z/g_zf
            out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
        }
    }
    return out_vs;
}

/**
 * GgafLib::DefaultMeshActor p̕WsNZVF[_[ .
 * esNZɁA_J[Őݒ肳ꂽFɂƉL̐FuhB
 * EeNX`̐F
 * EXyL[̋Z
 * EBlinkeri臒l傫Fɂē_Ōʁjl
 * E}X^[
 * @param prm_uv              UVW
 * @param prm_color           Fi}eAACgAtHOlς݁j
 * @param prm_vecNormal_World @xNg([hWn)
 * @param prm_vecEye_World    (_ -> _)xNg([hWn)
 */
float4 PS_DefaultMesh(
    float2 prm_uv              : TEXCOORD0,
    float4 prm_color           : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD1,
    float3 prm_vecEye_World    : TEXCOORD2
) : COLOR  {
    const float4 colTex = tex2D( MyTextureSampler, prm_uv);
    //o͐FɃeNX`FɃ}eAJ[l
    float4 colOut = colTex * prm_color;
    //XyLvZ
    float s = 0.0f;
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        const float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }
    //o͐FɃXyL[l
    colOut.rgb += s;
    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    //}X^[
    colOut.a *= g_alpha_master;
    return colOut;
}


/**
 * [Jڋԕϊ sԂ .
 * ڋԂƂ̓bVT[tFCX̂_ɂāA
 * eNX`uxNg, eNX`vxNg, @xNg 
 * Rŕ\Wn̎BR͒ĂB<BR>
 * w}yP[ǂƃRx̋L <BR>
 * http://marupeke296.com/DXPS_S_No5_NormalMap.html<BR>
 * pĒ܂B<BR>
 * @param prm_vecTangent  ڃxNg(uPʃxNg)
 * @param prm_vecBinormal ]@xNg(vPʃxNg)
 * @param prm_vecNormal   @xNg
 **/
float4x4 getInvTangentMatrix(
    float3 prm_vecTangent,
    float3 prm_vecBinormal,
    float3 prm_vecNormal )
{
    float4x4 mat = { float4(prm_vecTangent , 0.0f),
                     float4(prm_vecBinormal, 0.0f),
                     float4(prm_vecNormal  , 0.0f)  ,
                     {  0.0f, 0.0f, 0.0f, 1.0f } };
    return transpose( mat );  // ]u(搳Kn̍s̋ts͓]usŗǂ)
}


/** ov}bsOp_VF[_[Ao͍\ */
struct OUT_VS_BM {
    float4 posModel_Proj    : POSITION;    //ŏIIȒ_W([hEr[Eˉeϊ)
    float2 uv               : TEXCOORD0;   //_eNX`UV
    float4 color            : COLOR0;      //_J[
    float3 vecNormal_World  : TEXCOORD1;   //_̖@xNg([hWn)
    float3 vecEye_World     : TEXCOORD2;   //_̎(_->_)xNg([hWn)
    float4 vecLight_Tangent : TEXCOORD3;   //_̃CgxNg([J̐ڋԍWn)
    float4 vecHarf_Tangent  : TEXCOORD4;   //_̃n[txNg([J̐ڋԍWn)
};

/**
 * GgafLib::DefaultMeshActor ov}bsOp̒_VF[_[ .
 * _ World > View > ˉe ϊA
 * fɈȉ̐FuhA_J[ƂĂ̐ݒ肷
 * Ef̃}eAFigUːFj
 * E`掞̃tHOB
 * @param prm_posModel_Local    f_([JWn)
 * @param prm_vecNormal_Local   _̖@([JWn)
 * @param prm_uv                _UVW
 * @param prm_vecTangent_Local  _̐ڃxNg(uPʃxNg)([JWn)
 * @param prm_vecBinormal_Local _̏]@xNg(vPʃxNg)([JWn)
 */
OUT_VS_BM VS_BumpMapping(
      float4 prm_posModel_Local    : POSITION,
      float3 prm_vecNormal_Local   : NORMAL,
      float2 prm_uv                : TEXCOORD0,
      float3 prm_vecTangent_Local  : TEXCOORD1,
      float3 prm_vecBinormal_Local : TEXCOORD2
) {
    OUT_VS_BM out_vs = (OUT_VS_BM)0;

    //_vZ
    const float4 posModel_World = mul(prm_posModel_Local, g_matWorld); //Worldϊ
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe

    //UVvZ
    out_vs.uv = prm_uv;  //̂܂

    // ڋԍs̋tsZo
    const float4x4 matTangent = getInvTangentMatrix(prm_vecTangent_Local, prm_vecBinormal_Local, prm_vecNormal_Local );
    // WorldCgxNgڋԂɈڂ
    const float3 vecLight_Local = mul(-g_vecLightFrom_World, g_matInvWorld); //[Jɖ߂āiTODO:͗\ߌvZłcj
    out_vs.vecLight_Tangent = mul(vecLight_Local, matTangent);         //ڋԍWn

    if (g_specular_power != 0) {
        //u_J_vxNgiXyLŎgpj
        out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
        //Worldn[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        float3 vecHarf_World = normalize(out_vs.vecEye_World + (-g_vecLightFrom_World));
        //Worldn[txNgڋԂɈڂ
        float3 vecHarf_Local = mul(vecHarf_World, g_matInvWorld); //[Jɖ߂
        out_vs.vecHarf_Tangent = mul(vecHarf_Local, matTangent ); //ڋԍWn
    }

    //_J[Ƀ}eAFݒ肵ĂA
    //Cg̊gUFvŹAov}bsǑvZ̃sNZVF[_[ōs
    out_vs.color = g_colMaterialDiffuse;

    //̕\@B
    if (g_far_rate > 0.0) {
        if (out_vs.posModel_Proj.z > g_zf*g_far_rate) {
            out_vs.posModel_Proj.z = g_zf*g_far_rate; //{OZłA`邽 g_zf*0.999 ɏ㏑A
        }
    } else {
        //tHO
        if (out_vs.posModel_Proj.z > 0.666*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
            out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
        }
    }

    return out_vs;
}

/**
 * GgafLib::DefaultMeshActor ov}bsOp̃sNZVF[_[ .
 * @}bv瓾@lgǓvZA
 * ^Iɕ\ʂɉʂ悤ɂ݂B
 * esNZɁA_J[Őݒ肳ꂽFɂƉL̐FuhB
 * ECg̐FigUFj
 * Ef̃}eAFigUːFj
 * EFZ
 * EFuh
 * EXyL[̋Z
 *  iȏ̐FɂāAf\ʂ̖@ƃCgˊpƂ̍vZACg̐Fl
 *      ̍ہAf\ʂ̖@ɂẮA@}bv瓾@lj
 * EBlinkeri臒l傫Fɂē_Ōʁjl
 * E}X^[uh
 * @param prm_uv               UVW
 * @param prm_color            Fi_J[ɂ}eAFݒρj
 * @param prm_vecNormal_World  @xNg(WorldWn)
 * @param prm_vecEye_World     (_->_)xNg(WorldWn)
 * @param prm_vecLight_Tangent gUxNg(ڋԍWn)
 * @param prm_vecHarf_Tangent  n[txNg(ڋԍWn)
 */
float4 PS_BumpMapping(
    float2 prm_uv               : TEXCOORD0,
    float4 prm_color            : COLOR0,
    float3 prm_vecNormal_World  : TEXCOORD1,
    float3 prm_vecEye_World     : TEXCOORD2,
    float3 prm_vecLight_Tangent : TEXCOORD3,
    float3 prm_vecHarf_Tangent  : TEXCOORD4
) : COLOR  {
    const float a = prm_color.a; //ێ

    //@}bv̖@
    const float3 vecNormal_Tangent = normalize(2.0f * tex2D( BumpMapTextureSampler, prm_uv ).xyz - 1.0);

    //@(@}bv̖@A܂ڋԍWn̖@ɂȂjƁA
    //gUxNg(_VF[_[ŐڋԍWnɗ\ߕϊς) ̓ς
    //Cgˊp߁Aʂɑ΂gǓ(power)߂
    float refl_power = dot(vecNormal_Tangent, normalize(prm_vecLight_Tangent));
    if (g_lambert_flg > 0) {
        //ς̒̕lgpāAn[tEo[g ŊgỦ͂s
        refl_power = refl_power * 0.5f + 0.5f;
        refl_power *= refl_power;
    } else {
        //ʏ̃o[gˁAς̒̕lJbg
        refl_power = max(refl_power, 0);
    }

    float s = 0.0f; //XyL
    if (g_specular_power != 0) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNg
        //ڋԍWnɗ\ߕϊς݁jƖ@(@}bv̖@A܂ڋԍWn̖@)̓ςXyLvZ
        s = pow( max(0.0f, dot(vecNormal_Tangent, prm_vecHarf_Tangent)), g_specular ) * g_specular_power; //@}bv̓ʉlB
    }

    const float4 colTex = tex2D( MyTextureSampler, prm_uv); //PUVF擾A܂@}bv̓ʉ͖lB
    //FAeNX`FA_J[AAXyL lF쐬
    //texEmateE(amb + (lightEpow)) + spow
    float4 colOut = colTex * ((g_colLightAmbient + ( g_colLightDiffuse * refl_power)) * prm_color ) + s; //prm_color = g_colMaterialDiffuse
    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    colOut.a = a * g_alpha_master;
    return colOut;
}

/**
 * GgafLib::DefaultMeshActor p̑MsNZVF[_[ .
 * eNX`F FLUSH_COLOR {ĐݒB
 * @param prm_uv     sNZłUVW
 * @param prm_color  sNZł̐Fi_J[ɂj
 */
float4 PS_Flush(
    float2 prm_uv  : TEXCOORD0,
    float4 prm_color : COLOR0
) : COLOR  {
    const float4 colTex = tex2D( MyTextureSampler, prm_uv);
    float4 colOut = colTex * prm_color * FLUSH_COLOR;
    colOut.a *= g_alpha_master;
    return colOut;
}

/**
 * ʏGtFNgTechnique .
 */
technique DefaultMeshTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;

        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;

        //SrcBlendAlpha = One;    //default
        //DestBlendAlpha = Zero;  //default
        //BlendOpAlpha = Add;     //default

        VertexShader = compile VS_VERSION VS_DefaultMesh();
        PixelShader  = compile PS_VERSION PS_DefaultMesh();
    }
}

/**
 * ov}bsOGtFNg̃eNjbN .
 */
technique BumpMapping
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_BumpMapping();
        PixelShader  = compile PS_VERSION PS_BumpMapping();
    }
}

/**
 * ZGtFNg̃eNjbN .
 */
technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMesh();
        PixelShader  = compile PS_VERSION PS_DefaultMesh();
    }
}

technique DestBlendOneMax
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One;
        BlendOp = Max;
        VertexShader = compile VS_VERSION VS_DefaultMesh();
        PixelShader  = compile PS_VERSION PS_DefaultMesh();
    }
}

/**
 * MGtFNg̃eNjbN .
 */
technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMesh();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}

