#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// ggaf CuAGgafDx::MassMeshModelpVF[_[
// author : Masatoshi Tsuge
// date:2016/02/17
////////////////////////////////////////////////////////////////////////////////

float g_zf;
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;
// Cg̕
float3 g_vecLightFrom_World;
// AmbienCgFiːFj
float4 g_colLightAmbient;
// DiffuseCgFiːFj
float4 g_colLightDiffuse;
//Viewϊs
float4x4 g_matView;
//ˉeϊs
float4x4 g_matProj;

/** XyL[͈̔́in[txNgE@ςg_specularj */
float g_specular;
/** XyL[̋x */
float g_specular_power;
/** Ji_j̈ʒuxNg */
float3 g_posCam_World;


//eNX`̃Tv(s0WX^)
sampler MyTextureSampler : register(s0);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj   : POSITION;
    float2 uv              : TEXCOORD0;
    float4 color           : COLOR0;
    float3 vecNormal_World : TEXCOORD6;   //IuWFNg̖@xNg
    float3 vecEye_World    : TEXCOORD7;   //_ -> _ xNg
};


///////////////////////////////////////////////////////////////////////////

//_VF[_[
OUT_VS VS_DefaultMassMesh(
      float4 prm_posModel_Local   : POSITION,      // f̒_
      float3 prm_vecNormal_Local  : NORMAL,        // f̒_̖@
      float2 prm_uv               : TEXCOORD0,     // f̒_UV

      float4 prm_world0           : TEXCOORD1,
      float4 prm_world1           : TEXCOORD2,
      float4 prm_world2           : TEXCOORD3,
      float4 prm_world3           : TEXCOORD4,
      float4 prm_color            : TEXCOORD5
) {
    OUT_VS out_vs = (OUT_VS)0;
    float4x4 matWorld = {prm_world0, prm_world1, prm_world2, prm_world3};
    //_vZ
    const float4 posModel_World = mul(prm_posModel_Local, matWorld);
    out_vs.posModel_Proj = mul( mul( posModel_World, g_matView), g_matProj);  //World*View*ˉe
    //UVvZ
    out_vs.uv = prm_uv;  //̂܂

    //_J[vZ
    //@ World ϊĐK
    out_vs.vecNormal_World = normalize(mul(prm_vecNormal_Local, matWorld));
    //@ƁAgU̓ς烉Cgˊp߁Aʂɑ΂gǓ߂B
    float refl_power = dot(out_vs.vecNormal_World, -g_vecLightFrom_World);
    //ς̒̕lgpāAn[tEo[g ŊgỦ͂s
    refl_power = refl_power * 0.5f + 0.5f;
    refl_power *= refl_power;
    //gUFɌ悶AFZAŜ}eAF|B
    out_vs.color = (g_colLightAmbient + (g_colLightDiffuse*refl_power)) * prm_color;
    //u_J_vxNg
    out_vs.vecEye_World = normalize(g_posCam_World.xyz - posModel_World.xyz);
    //̓}eAŗDƂi㏑j
    out_vs.color.a = prm_color.a;
    //tHO
    if (out_vs.posModel_Proj.z > 0.6*g_zf) {   // ŉ̖ 2/3 肳ɉ̏ꍇXɓ
        out_vs.color.a *= (-3.0*(out_vs.posModel_Proj.z/g_zf) + 3.0);
    }
//    if (out_vs.posModel_Proj.z > g_zf*0.98) {
//        out_vs.posModel_Proj.z = g_zf*0.98; //{OZłA`邽0.9ȓɏ㏑A
//    }
    return out_vs;
}

//bVWsNZVF[_[ieNX`Lj
float4 PS_DefaultMassMesh(
    float2 prm_uv              : TEXCOORD0,
    float4 prm_color           : COLOR0,
    float3 prm_vecNormal_World : TEXCOORD6,
    float3 prm_vecEye_World    : TEXCOORD7   //_ -> _ xNg
) : COLOR  {
    float s = 0.0f; //XyL
    if (g_specular_power != 0.0f) {
        //n[txNgiu_J_vxNg ƁAu_CgvxNg̐^񒆂̕xNgj
        const float3 vecHarf = normalize(prm_vecEye_World + (-g_vecLightFrom_World));
        //n[txNgƖ@̓ςXyLvZ
        s = pow( max(0.0f, dot(prm_vecNormal_World, vecHarf)), g_specular ) * g_specular_power;
    }
    const float4 colTex = tex2D( MyTextureSampler, prm_uv);
    //eNX`F
    float4 colOut = colTex * prm_color + s;

    //Blinkerl
    if (colTex.r >= g_tex_blink_threshold || colTex.g >= g_tex_blink_threshold || colTex.b >= g_tex_blink_threshold) {
        colOut *= g_tex_blink_power; //ă{|B_łڗB
    }
    //}X^[
    colOut.a *= g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv	 : TEXCOORD0,
    float4 prm_color : COLOR0
) : COLOR  {
    //eNX`TvOĐF擾iF擾j
    const float4 colTex = tex2D( MyTextureSampler, prm_uv);
    float4 colOut = colTex * prm_color * FLUSH_COLOR;
    colOut.a *= g_alpha_master;
    return colOut;
}

technique DefaultMassMeshTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassMesh();
        PixelShader  = compile PS_VERSION PS_DefaultMassMesh();
    }
}

technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassMesh();
        PixelShader  = compile PS_VERSION PS_DefaultMassMesh();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassMesh();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}
