#include "GgafEffectConst.fxh"
////////////////////////////////////////////////////////////////////////////////
// ggaf CuAGgafDx::MassBoardModelpVF[_[
//
// author : Masatoshi Tsuge
// date:2009/03/06
////////////////////////////////////////////////////////////////////////////////
float g_game_buffer_width; //ʕ(px)
float g_game_buffer_height; //ʍ(px)
float g_inv_game_buffer_width; //ʕ(px)̋t
float g_inv_game_buffer_height; //ʍ(px)̋t
float g_tex_blink_power;
float g_tex_blink_threshold;
float g_alpha_master;


//s0WX^̃Tvg(ŒpCvCɃZbgꂽeNX`VF[_[Ŏg)
sampler MyTextureSampler : register(s0);

//_VF[_[Ao͍\
struct OUT_VS
{
    float4 posModel_Proj    : POSITION;
    float4 color            : COLOR0;
    float2 uv               : TEXCOORD0;
};


///////////////////////////////////////////////////////////////////////////

//MassBoardModelW_VF[_[
OUT_VS VS_DefaultMassBoard(
      float4 prm_posModel_Local   : POSITION,      // f̒_
      float3 prm_vecNormal_Local  : NORMAL,        // f̒_̖@(gp)
      float2 prm_uv               : TEXCOORD0,     // f̒_UV

      float3 prm_pos              : TEXCOORD1,     // px_x, px_y, depth_z
      float2 prm_loc              : TEXCOORD2,     // local_px_x, local_px_y
      float3 prm_sc               : TEXCOORD3,     // r_sx, r_sy, rad_rz
      float2 prm_offset_uv        : TEXCOORD4,     // offset_u, offset_v
      float4 prm_color            : TEXCOORD5      // r, g, b, a
) {
    OUT_VS out_vs = (OUT_VS)0;
    float px_x = prm_pos.x; //ϊςXW(px)
    float px_y = prm_pos.y; //ϊςYW(px)
    float depthZ = prm_pos.z;  //[xZ (0 ` +1)
    float local_px_x = prm_loc.x; //[JXWiXW̃ItZbgj
    float local_px_y = prm_loc.y; //[JYWiYW̃ItZbgj
    float r_sx = prm_sc.x;     //Xg嗦
    float r_sy = prm_sc.y;     //Yg嗦
    float rad_rz = prm_sc.z;   //Z]px

    if (rad_rz == 0.0f) {
        //XWYW -1 ` +1 ɉ߂B
        out_vs.posModel_Proj.x = - 1 + ( (2*( ((prm_posModel_Local.x + local_px_x)*r_sx) + px_x)) * g_inv_game_buffer_width);
        out_vs.posModel_Proj.y =   1 - ( (2*( ((prm_posModel_Local.y + local_px_y)*r_sy) + px_y)) * g_inv_game_buffer_height);
    } else {
        //gk
        const float lx = (prm_posModel_Local.x + local_px_x) * r_sx;
        const float ly = (prm_posModel_Local.y + local_px_y) * r_sy;
        //]  XWYW -1 ` +1 ɉ߂B
        out_vs.posModel_Proj.x = - 1 + ( (2*( (lx * cos(rad_rz) - ly * sin(rad_rz))      + px_x)) * g_inv_game_buffer_width);
        out_vs.posModel_Proj.y =   1 - ( (2*( (lx * sin(rad_rz) + ly * cos(rad_rz))      + px_y)) * g_inv_game_buffer_height);
    }
    out_vs.posModel_Proj.z = depthZ;
    out_vs.posModel_Proj.w = 1.0;
    //dot by dotl
    out_vs.posModel_Proj = adjustDotByDot(out_vs.posModel_Proj);

    //UṼItZbgZ
    out_vs.uv.x = prm_uv.x + prm_offset_uv.x;
    out_vs.uv.y = prm_uv.y + prm_offset_uv.y;
    out_vs.color = prm_color;
    return out_vs;
}


//MassBoardModelWsNZVF[_[
float4 PS_DefaultMassBoard(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color  : COLOR0
) : COLOR  {
    float4 colOut = tex2D( MyTextureSampler, prm_uv) * prm_color;
//	if (colOut.r >= g_tex_blink_threshold || colOut.g >= g_tex_blink_threshold || colOut.b >= g_tex_blink_threshold) {
//		colOut *= g_tex_blink_power; //+ (colTex * g_tex_blink_power);
//	}
    colOut.a = colOut.a * prm_color.a * g_alpha_master;
    return colOut;
}

float4 PS_Flush(
    float2 prm_uv	  : TEXCOORD0,
    float4 prm_color    : COLOR0
) : COLOR  {
    //eNX`TvOĐF擾iF擾j
    float4 colOut = tex2D( MyTextureSampler, prm_uv) * FLUSH_COLOR * prm_color;
    //l
    colOut.a = colOut.a * prm_color.a * g_alpha_master;
    return colOut;

}

//eNjbNFDefaultMassBoardTechnique
//y@\z
//MassBoardModelpWVF[_[
//yTvz
//D3DFVF_XYZRHW ŕ`悵悤ȎdlłQc\܂B
//ʍ(0,0)ŉʉEiʕ(px), ʍ(px))ƂȂWn
//v~eBui|j̊_͍ɂȂ܂B
//--- VS ---
//E_ -1 ` +1։(ˉeϊ)AYW]
//--- PS ---
//EIuWFNg̃eNX`
//E
//
technique DefaultMassBoardTechnique
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassBoard();
        PixelShader  = compile PS_VERSION PS_DefaultMassBoard();
    }
}

technique DestBlendOne
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend  = SrcAlpha;
        DestBlend = One; //Z
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassBoard();
        PixelShader  = compile PS_VERSION PS_DefaultMassBoard();
    }
}

technique Flush
{
    pass P0 {
        AlphaBlendEnable = true;
        SeparateAlphaBlendEnable = false;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        BlendOp = Add;
        VertexShader = compile VS_VERSION VS_DefaultMassBoard();
        PixelShader  = compile PS_VERSION PS_Flush();
    }
}
