#include "jp/ggaf/lib/scene/FormationTableScene.h"

#include "jp/ggaf/core/actor/SceneMediator.h"
#include "jp/ggaf/core/actor/ex/Formation.h"



using namespace GgafLib;

FormationTableScene::FormationTableScene(const char* prm_name) :
        DefaultScene(prm_name) {
    _class_name = "FormationTableScene";
    _max_perform_frame = 0xffffffff;
    _frame_of_current_part_began = 0;
}


GgafCore::GroupHead* FormationTableScene::addToTable(GgafCore::Formation* prm_pFormationActor, frame prm_max_delay_offset) {
    if (prm_pFormationActor->instanceOf(Obj_ggaf_Formation)) {
        //OK
    } else {
        throwCriticalException("GgafCore::Formation ȊOo^Ă܂B");
    }
    prm_pFormationActor->_offset_frames_end = FORMATION_END_DELAY;
    prm_pFormationActor->inactivate();
    _table.addLast(NEW TblElem(prm_pFormationActor, prm_max_delay_offset), true);

    return bringSceneMediator()->appendGroupChild(prm_pFormationActor);
}

void FormationTableScene::onActive() {
    if (_table.length() > 0) {
        _frame_of_current_part_began = getActiveFrame();
        _table.first();
        _table.getCurrent()->_pFormationActor->activate();
        //OK
        //_frame_of_current_part_began = getActiveFrame(); todo:΂ɂOɂȂ邵B΃t[łEEE
        _TRACE_(FUNC_NAME<<" ["<<getName()<<"] ܂B");
    } else {
        throwCriticalException("["<<getName()<<"] e[uɃAN^[܂");
    }
}


void FormationTableScene::processBehavior() {

    if (wasDeclaredEnd()) {
        //I҂̂
    } else {

        if (!bringSceneMediator()->getChildFirst()) {
            sayonara(FORMATION_END_DELAY);
            return;
        }

        TblElem* e = _table.getCurrent();
        GgafCore::Formation* pF = e->_pFormationActor;
        //SŔ
        if (pF->_was_all_destroyed) {
            //Sł̏ꍇ
            if (_table.isLast()) {
                //ŏIp[gTABLEI
                _TRACE_(FUNC_NAME<<" ["<<getName()<<"] end() Sp[gIII");
                sayonara(FORMATION_END_DELAY);
            } else {
                _TRACE_(FUNC_NAME<<" ["<<getName()<<"] pActiveActor="<<pF->getName()<<" łɂ葁񂵂[II");
                //ŏIp[gł͂ȂꍇAe[uŜ̋et[f
                if (_max_perform_frame <  getActiveFrame()) {
                    //܂Ȃƌ킯ŁAȍ~͑SĖăV[I
                    _TRACE_(FUNC_NAME<<" ["<<getName()<<"] end() ܂ȂIPII");
                    sayonara(FORMATION_END_DELAY); //0.5j(Op[gcĂ邩mȂߗ]T)
                    //sayonara() ɂA{擪 wasDeclaredEnd() ^ƂȂ
                } else {
                    //]T邽ߎ̃p[gANeBuɂB
                    TblElem* n = _table.next(); //ANeBũp[g
                    n->_pFormationActor->activate();     //GANeBu
                    _frame_of_current_part_began = getActiveFrame();
                }
            }
        } else {
            //Słł͖ꍇ
            if (_table.isLast()) {
                //ŏIp[g͎Ȃ̂łȂɂȂ
                _TRACE_(FUNC_NAME<<" ["<<getName()<<"] end() Słł͖AŏIp[gŎ̂łȂɂȂ");
                sayonara(FORMATION_END_DELAY); //0.5j(Op[gcĂ邩mȂߗ]T)
                //sayonara() ɂA{擪 wasDeclaredEnd() ^ƂȂ
            } else {
                //max_delay_offset߂Ύ
                if (getActiveFrame() >= e->_max_delay_offset+_frame_of_current_part_began) {
                    if (_max_perform_frame <  getActiveFrame()) {
                        //܂Ȃƌ킯ŁAȍ~͑SĖꋤI
                        _TRACE_(FUNC_NAME<<" ["<<getName()<<"] end() ܂ȂIQII");
                        sayonara(FORMATION_END_DELAY); //0.5j(Op[gcĂ邩mȂߗ]T)
                        //sayonara() ɂA{擪 wasDeclaredEnd() ^ƂȂ
                    } else {
                        TblElem* n = _table.next(); //ANeBũp[g
                        n->_pFormationActor->activate();
                        _frame_of_current_part_began = getActiveFrame();
                    }

                }
            }
        }
    }
}

FormationTableScene::~FormationTableScene() {
}
