#ifndef GGAF_LIB_SCENEPROGRESS_H_
#define GGAF_LIB_SCENEPROGRESS_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/Progress.h"

#include <map>
namespace GgafLib {

typedef std::map<progress, GgafLib::DefaultScene*> ProgSceneMap;

/**
 * ԑJڐiǗ(V[p)NX .
 * GgafCore::ProgressNXɁAV[ɂ܂֗ȋ@\ǉ
 * V[p̏ԑJڐiǗNXłB
 * @version 1.00
 * @since 2011/07/15
 * @author Masatoshi Tsuge
 */
class SceneProgress : public GgafCore::Progress {

public:
    /** [r]iǗΏۃV[ */
    DefaultScene* _pScene;
    /** [r]iԍ  qV[ */
    ProgSceneMap _mapProg2Scene;

    progress _progress_next_promise;
    frame _count_next_promise;

public:
    /**
     * RXgN^ .
     * @param prm_pScene       iǗΏۃV[
     */
    SceneProgress(DefaultScene* prm_pScene);

    /**
     * iԂƎqV[֘AtA.
     * ̃\bhɂA֘AtsƁAȉ̃\bhgp\iʂjƂȂ܂B<BR>
     * <code>
     * changeWithSceneFlipping(progress)
     * changeWithSceneCrossfading(progress, frame);
     * changeWithSceneOverlapping(progress, frame);
     * </code>
     * @param prm_FirstProgress 擪̐i
     * @param prm_EndProgress ̐i
     * @param prm_FirstChildSceneName 擪̐i(prm_FirstProgress)ɑΉqV[̖
     */
    void relateChildScene(progress prm_FirstProgress, progress prm_EndProgress, const char* prm_FirstChildSceneName);


    /**
     * iԂƎqV[֘AtA.
     * ̃\bhɂA֘AtsƁAȉ̃\bhgp\iʂjƂȂ܂B<BR>
     * <code>
     * changeWithSceneFlipping(progress)
     * changeWithSceneCrossfading(progress, frame);
     * changeWithSceneOverlapping(progress, frame);
     * </code>
     * @param prm_FirstProgress 擪̐i
     * @param prm_EndProgress   ̐i
     * @param prm_pFirstChildScene 擪̐i(prm_FirstProgress)ɑΉqV[
     */
    void relateChildScene(progress prm_FirstProgress, progress prm_EndProgress, DefaultScene* prm_pFirstChildScene);

    /**
     * ViԂ؂ւƓɁA֘AtqV[Ԃɂ .
     * ݂̐iԂɕRtqV[͂̂܂܁i񊈓ɂ܂j .
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     */
    void changeWithSceneFadein(progress prm_progress, frame prm_fade_in = 120);

    /**
     * ViԂ؂ւƓɁA֘AtqV[ɐ؂ւ .
     * ݂̐iԂɕRtqV[͔񊈓ԂɂA̐iԂɕRtqV[Ԃɂ܂B
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     */
    void changeWithSceneFlipping(progress prm_progress);

    /**
     * ViԂ؂ւƓɁA֘AtqV[Ԃɐ؂ւ .
     * ԎqV[͔񊈓ԂɂہAwt[ԓisiI[o[bsOjȂtF[hAEgEtF[hCʂs .
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_cross_fade_frames tF[hC & tF[hAEgs
     */
    void changeWithSceneCrossfading(progress prm_progress, frame prm_cross_fade_frames = 300);

    /**
     * iԂɕRtqV[̓tF[hAEg񊈓ԂɂA
     * ̌㒼Ɏ̐ViԂɕRtqV[AtF[hCԂɂB .
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_fade_out tF[hAEg
     * @param prm_fade_in tF[hC
     */
    void changeWithSceneFadeoutFadein(progress prm_progress, frame prm_fade_out=120, frame prm_fade_in = 120);

    /**
     * ViԂ؂ւƓɁA֘AtqV[Ԃɐ؂ւA
     * ԎqV[͔񊈓ԂɂB̍ہAwt[ԁAisiI[o[bsOj .
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress Vi
     * @param prm_overlapping_frames ist[
     */
    void changeWithSceneOverlapping(progress prm_progress, frame prm_overlapping_frames);

    /**
     * ݂̃ANeBuȐiԂɊ֘AÂĂV[擾 .
     * 擾łȂꍇ nullptr
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @return
     */
    DefaultScene* getGazedScene();

    /**
     * ̐iԂɊ֘AÂĂV[擾 .
     * 擾łȂꍇ nullptr
     * {\bȟʂ𓾂ɂ relateChildScene() \ߎsAV[֘AtKv܂B
     * @param prm_progress i
     * @return
     */
    DefaultScene* getScene(progress prm_progress);

    /**
     * iԍύXAchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     * PROGRESS_NOTHING(-1) ͐ݒsB
     * reset(progress) Ǝg邱ƁB
     * @param prm_progress iԍ(0`)
     */
    virtual void change(progress prm_progress) override;

    /**
     * iԍ𖳂 PROGRESS_NOTHING(-1) ɕύXAchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     */
    virtual void changeNothing() override;

    /**
     * iԍ+1AchangeDelay ͖Ƃɂ .
     * AAɂ͔fꂸ update() ɔfB
     * change(_progress+1) ƓӖłB
     */
    virtual void changeNext() override;

    /**
     * iԍ̕ύX\B .
     * @param prm_progress \iԍ(0`)
     * @param prm_delay xt[
     */
    virtual void changeDelay(progress prm_progress, frame prm_delay);
    virtual void update() override;

    /**
     * fXgN^ .
     */
    virtual ~SceneProgress();
};

}
#endif /*GGAF_LIB_SCENEPROGRESS_H_*/
