#ifndef GGAF_LIB_QUANTITY_HPP_
#define GGAF_LIB_QUANTITY_HPP_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/core/Object.h"

namespace GgafLib {

/**
 *  .
 * Ɏl(VAL)ƂɊւ鐔(QTY)B
 * l𑀍ivZjƁAɔĐʂωB
 * @version 1.00
 * @since 2011/02/02
 * @author Masatoshi Tsuge
 */
template<typename VAL, typename QTY>
class Quantity : public GgafCore::Object {

public:

    /** [r]l̃|C^ */
    VAL* _pVal;
    /** [r]lɊւ鐔 */
    QTY _qty;
    /** lY */
    VAL _offset_val;
    /** [r]lɊւ鐔ʃY */
    QTY _offset_qty;
    /** [r]lƐʂ̑A */
    double _rate_val;

    bool _is_link;

public:
    /**
     * RXgN^ .
     * @return
     */
    Quantity() : GgafCore::Object() {
        _qty = (QTY)0;
        _rate_val = 1.0;
        _pVal = NEW VAL();
        *_pVal = (VAL)0;
        _offset_val = (VAL)0;
        _offset_qty = (QTY)0;
        _is_link = false;
    }

    /**
     * lƐʂƂ̊֌W` .
     * ItZbg͖
     * @param prm_val 1.0(100%) ̏ꍇɎllZbg
     * @param prm_qty 1.0(100%) ̏ꍇɐʂlZbg
     */
    void scale(VAL prm_val, QTY prm_qty) {
        scale(0.0, prm_val, 0.0, prm_qty);
    }

    /**
     * lƐʂƂ̊֌W` .
     * @param prm_min_val lŏlݒ
     * @param prm_max_val lőlݒ
     * @param prm_min_qty lŏlɑΉ鐔ʍŏlݒ
     * @param prm_max_qty lőlɑΉ鐔ʍőlݒ
     */
    inline void scale(VAL prm_min_val, VAL prm_max_val, QTY prm_min_qty, QTY prm_max_qty) {
        _rate_val = 1.0 *  (prm_max_qty - prm_min_qty) / (prm_max_val - prm_min_val);
        _offset_val = prm_min_val;
        _offset_qty = prm_min_qty;
    }

    /**
     * l̕ϐĩ|C^jݒ .
     * @param prm_pInt_target_value [^[lϐ̃|C^(int*)ݒ
     */
    void link(VAL* prm_pVariable) {
        if (_is_link) {
            _pVal = prm_pVariable;
        } else {
            GGAF_DELETE(_pVal);
            _pVal = prm_pVariable;
            _is_link = true;
        }

    }

    /**
     * lݒ .
     * ݒ肷ƁAʂAĂXV
     * @param prm_val l
     */
    inline void setVal(VAL prm_val) {
        *_pVal = prm_val;
        if (!_is_link) {
            _qty = (QTY)((((*_pVal) - _offset_val) * _rate_val ) + _offset_qty);
        }
    }

    /**
     * l𐔗ʂŎw肵Đݒ .
     * ݒ肷ƁAʂAĂXV
     * @param prm_qty 
     */
    inline void setValByQty(QTY prm_qty) {
        setVal(cnvQty2Val(prm_qty));
    }

    /**
     * llŎ擾 .
     */
    inline VAL getVal() {
        return *_pVal;
    }

    /**
     * llɊւ鐔ʂŎ擾 .
     */
    inline QTY getQty() {
        return _is_link ? (QTY)((((*_pVal) - _offset_val) * _rate_val ) + _offset_qty) : _qty;
    }

    /**
     * lɑ΂Ă̐ʂ߂(lʋyѐʂ́Aݒ肳܂) .
     * @param prm_val l
     * @return 
     */
    inline QTY cnvVal2Qty(VAL prm_val) {
        return (QTY)(((prm_val - _offset_val) * _rate_val ) + _offset_qty);
    }

    /**
     * ʂɑ΂Ă̎l߂(lʋyѐʂ́Aݒ肳܂) .
     * @param prm_qty
     * @return
     */
    inline VAL cnvQty2Val(QTY prm_qty) {
        return (VAL)((_offset_val * _rate_val - _offset_qty + prm_qty) / (1.0*_rate_val));
    }

    virtual ~Quantity() {
        if (!_is_link) {
            GGAF_DELETE(_pVal);
        }
    }
};

}
#endif /*GGAF_LIB_QUANTITY_HPP_*/

