#ifndef GGAF_LIB_COLLISIONCHECKER_H_
#define GGAF_LIB_COLLISIONCHECKER_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/dx/actor/supporter/Checker.h"

namespace GgafLib {

/**
 * Փ˃`FbJ[NX.
 * AN^[ɓ蔻`FbN@\ǉNXB
 * P́u蔻̈v́Áu蔻̈vfv`Ă܂B<BR>
 * eu蔻̈vfv́ABOX^Ƌ^̂Qނ̓Iׂ܂B<BR>
 * u蔻̈vu蔻̈vfvƌẗӖʂÂ悤ɂȈӖƒ`B<BR>
 * u蔻̗̈vfvEEEPLN^̓蔻̈B󂩁A邢BOX̕̗̈PwB<BR>
 * u蔻̈v      EEEPȏ̗̔̈vf킳APLN^̓蔻Ŝ\B<BR>
 *
 * @version 1.00
 * @since 2008/09/08
 * @author Masatoshi Tsuge
 */
class CollisionChecker : public GgafDx::Checker {

public:
#ifdef MY_DEBUG
    /** Pt[̓蔻vfm̔ */
    static unsigned int _num_check;
#endif
public:
    /**
     * RXgN^<BR>
     * @param   prm_pActor  蔻@\ǉActor
     */
    explicit CollisionChecker(GgafDx::GeometricActor* prm_pActor);


    void changeColliSphereR(int prm_index, coord r);

    /**
     * 蔻̈vfƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̋̒SXWiActor[JWj
     * @param y 蔻̋̒SYWiActor[JWj
     * @param z 蔻̋̒SZWiActor[JWj
     * @param r 蔻̋̔a
     * @param rot_x 蔻̋AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̋AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̋AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliSphere(int prm_index, coord x, coord y, coord z, coord r, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfƂĒ` .
     * Actořɔē蔻̉]sړ@\͖
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̋̒SXWiActor[JWj
     * @param y 蔻̋̒SYWiActor[JWj
     * @param z 蔻̋̒SZWiActor[JWj
     * @param r 蔻̋̔a
     */
    void setColliSphere(int prm_index, coord x, coord y, coord z, coord r) {
        setColliSphere(prm_index, x, y, z, r, false, false, false);
    }

    /**
     * 蔻̈vfƂĒ` .
     * 蔻̋̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param r 蔻̋̔a
     */
    void setColliSphere(int prm_index, coord r) {
        setColliSphere(prm_index, 0, 0, 0, r, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼̂̍OXWiActor[JWj
     * @param y1 蔻蒼̂̍OYWiActor[JWj
     * @param z1 蔻蒼̂̍OZWiActor[JWj
     * @param x2 蔻蒼̂̉E㉜XWiActor[JWj
     * @param y2 蔻蒼̂̉E㉜YWiActor[JWj
     * @param z2 蔻蒼̂̉E㉜ZWiActor[JWj
     * @param rot_x 蔻̒̂AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̒̂AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̒̂AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliAABox(int prm_index,
                       coord x1, coord y1, coord z1,
                       coord x2, coord y2, coord z2,
                       bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfŝƂĒ` .
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼̂̍OXWiActor[JWj
     * @param y1 蔻蒼̂̍OYWiActor[JWj
     * @param z1 蔻蒼̂̍OZWiActor[JWj
     * @param x2 蔻蒼̂̉E㉜XWiActor[JWj
     * @param y2 蔻蒼̂̉E㉜YWiActor[JWj
     * @param z2 蔻蒼̂̉E㉜ZWiActor[JWj
     */
    void setColliAABox(int prm_index,
                       coord x1, coord y1, coord z1,
                       coord x2, coord y2, coord z2) {
        setColliAABox(prm_index, x1, y1, z1, x2, y2, z2, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻蒼̂̒SWƁAAAsŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻蒼̂̒SXWiActor[JWj
     * @param y 蔻蒼̂̒SYWiActor[JWj
     * @param z 蔻蒼̂̒SZWiActor[JWj
     * @param prm_width 蔻蒼̂̕iX̒j
     * @param prm_height 蔻蒼̂̍iY̒j
     * @param prm_depth 蔻蒼̂̐[isEZ̒j
     * @param rot_x 蔻̒̂AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̒̂AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̒̂AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliAABox_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth, bool rot_x, bool rot_y, bool rot_z) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;
        setColliAABox(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻蒼̂̒SWƁAAAsŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index
     * @param x 蔻蒼̂̒SXWiActor[JWj
     * @param y 蔻蒼̂̒SYWiActor[JWj
     * @param z 蔻蒼̂̒SZWiActor[JWj
     * @param prm_width 蔻蒼̂̕iX̒j
     * @param prm_height 蔻蒼̂̍iY̒j
     * @param prm_depth 蔻蒼̂̐[isEZ̒j
     */
    void setColliAABox_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth) {
        setColliAABox_WHD(prm_index, x, y, z, prm_width, prm_height, prm_depth, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻蒼̂̕AAsŎwB
     * 蔻蒼̂̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width 蔻蒼̂̕iX̒j
     * @param prm_height 蔻蒼̂̍iY̒j
     * @param prm_depth 蔻蒼̂̐[isEZ̒j
     */
    void setColliAABox_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth) {
        setColliAABox_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻藧̂̒SWƁAPӂ̒ŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻藧̂̒SXWiActor[JWj
     * @param y 蔻藧̂̒SYWiActor[JWj
     * @param z 蔻藧̂̒SZWiActor[JWj
     * @param prm_edge 蔻藧̂̂Pӂ̒
     * @param rot_x 蔻̗̂AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̗̂AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̗̂AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliAACube(int prm_index, coord x, coord y, coord z, coord prm_edge, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAABox(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻藧̂̒SWƁAPӂ̒ŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻藧̂̒SXWiActor[JWj
     * @param y 蔻藧̂̒SYWiActor[JWj
     * @param z 蔻藧̂̒SZWiActor[JWj
     * @param prm_edge 蔻藧̂̂Pӂ̒
     */
    void setColliAACube(int prm_index, coord x, coord y, coord z, coord prm_edge) {
        setColliAACube(prm_index, x, y, z, prm_edge, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻藧̂̂Pӂ̒ŎwB
     * 蔻藧̂̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge 蔻藧̂̂Pӂ̒
     */
    void setColliAACube(int prm_index, coord prm_edge) {
        setColliAACube(prm_index, 0, 0, 0, prm_edge);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻vY^̋Ê̍OXWiActor[JWj
     * @param y1 蔻vY^̋Ê̍OYWiActor[JWj
     * @param z1 蔻vY^̋Ê̍OZWiActor[JWj
     * @param x2 蔻vY^̋ỂE㉜XWiActor[JWj
     * @param y2 蔻vY^̋ỂE㉜YWiActor[JWj
     * @param z2 蔻vY^̋ỂE㉜ZWiActor[JWj
     * @param pos_info vYʒuiPOS_PRISM_**_**)
     * @param rot_x 蔻̃vY^AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̃vY^AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̃vY^AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliAAPrism(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, pos_t pos_info, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻vY^̋Ê̍OXWiActor[JWj
     * @param y1 蔻vY^̋Ê̍OYWiActor[JWj
     * @param z1 蔻vY^̋Ê̍OZWiActor[JWj
     * @param x2 蔻vY^̋ỂE㉜XWiActor[JWj
     * @param y2 蔻vY^̋ỂE㉜YWiActor[JWj
     * @param z2 蔻vY^̋ỂE㉜ZWiActor[JWj
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPrism(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, pos_t pos_info) {
        setColliAAPrism(prm_index, x1, y1, z1, x2, y2, z2, pos_info, false, false, false);
    }


    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻vY^̋Ê̒SWƁAAAsŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻vY^̋Ê̒SXWiActor[JWj
     * @param y 蔻vY^̋Ê̒SYWiActor[JWj
     * @param z 蔻vY^̋Ê̒SZWiActor[JWj
     * @param prm_width 蔻vY^̋Ê̕iX̒j
     * @param prm_height 蔻vY^̋Ê̍iY̒j
     * @param prm_depth 蔻vY^̋Ê̐[isEZ̒j
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPrism_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth, pos_t pos_info) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;
        setColliAAPrism(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd, pos_info);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻vY^̋Ê̕AAsŎwB
     * 蔻vY^̋Ê̒SẂAActor[JW̌_ɐݒ肳B
     * (KΖʂActor[JW̌_ɐڂ邱ƂɂȂ)
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width 蔻vY^̋Ê̕iX̒j
     * @param prm_height 蔻vY^̋Ê̍iY̒j
     * @param prm_depth 蔻vY^̋Ê̐[isEZ̒j
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPrism_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth, pos_t pos_info) {
        setColliAAPrism_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth, pos_info);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻vY^̋Ê̒SWƁAPӂ̒ŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻vY^̋Ê̒SXWiActor[JWj
     * @param y 蔻vY^̋Ê̒SYWiActor[JWj
     * @param z 蔻vY^̋Ê̒SZWiActor[JWj
     * @param prm_edge 蔻vY^̋Ê̂Pӂ̒
     * @param rot_x 蔻̃vY^AActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̃vY^AActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̃vY^AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPrism_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, pos_t pos_info, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAAPrism(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_info, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻vY^̋Ê̒SWƁAPӂ̒ŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻vY^̋Ê̒SXWiActor[JWj
     * @param y 蔻vY^̋Ê̒SYWiActor[JWj
     * @param z 蔻vY^̋Ê̒SZWiActor[JWj
     * @param prm_edge 蔻vY^̋Ê̂Pӂ̒
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPrism_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, pos_t pos_info) {
        setColliAAPrism_Cube(prm_index, x, y, z, prm_edge, pos_info, false, false, false);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻vY^̋Ê̂Pӂ̒ŎwB
     * 蔻vY^̋Ê̒SẂAActor[JW̌_ɐݒ肳B
     * (KΖʂActor[JW̌_ɐڂ邱ƂɂȂ)
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge 蔻vY^̋Ê̂Pӂ̒
     * @param pos_info vYʒuiGgafDx::AAPrismActor.h ́AߑRgQ)
     */
    void setColliAAPrism_Cube(int prm_index, coord prm_edge, pos_t pos_info) {
        setColliAAPrism_Cube(prm_index, 0, 0, 0, prm_edge, pos_info);
    }

    /**
     * 蔻̈vfspOpƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼pOp̋Ê̍OXWiActor[JWj
     * @param y1 蔻蒼pOp̋Ê̍OYWiActor[JWj
     * @param z1 蔻蒼pOp̋Ê̍OZWiActor[JWj
     * @param x2 蔻蒼pOp̋ỂE㉜XWiActor[JWj
     * @param y2 蔻蒼pOp̋ỂE㉜YWiActor[JWj
     * @param z2 蔻蒼pOp̋ỂE㉜ZWiActor[JWj
     * @param pos_info s~bhʒuiPOS_PYRAMID_***)
     * @param rot_x 蔻̒pOp̋ÊAActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̒pOp̋ÊAActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̒pOp̋ÊAActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void setColliAAPyramid(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, pos_t pos_info, bool rot_x, bool rot_y, bool rot_z);

    /**
     * 蔻̈vfs̎OpOpƂĒ` .
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼pOp̋Ê̍OXWiActor[JWj
     * @param y1 蔻蒼pOp̋Ê̍OYWiActor[JWj
     * @param z1 蔻蒼pOp̋Ê̍OZWiActor[JWj
     * @param x2 蔻蒼pOp̋ỂE㉜XWiActor[JWj
     * @param y2 蔻蒼pOp̋ỂE㉜YWiActor[JWj
     * @param z2 蔻蒼pOp̋ỂE㉜ZWiActor[JWj
     * @param pos_info s~bhʒuiPOS_PYRAMID_***)
     */
    void setColliAAPyramid(int prm_index, coord x1, coord y1, coord z1, coord x2, coord y2, coord z2, pos_t pos_info) {
        setColliAAPyramid(prm_index, x1, y1, z1, x2, y2, z2, pos_info, false, false, false);
    }

    /**
     * 蔻̈vfs̎OpOpƂĒ` .
     * 蔻OpOp̋Ê̒SWƁAAAsŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x OpOp̋Ê̒SXWiActor[JWj
     * @param y OpOp̋Ê̒SYWiActor[JWj
     * @param z OpOp̋Ê̒SZWiActor[JWj
     * @param prm_width OpOp̋Ê̕iX̒j
     * @param prm_height OpOp̋Ê̍iY̒j
     * @param prm_depth OpOp̋Ê̐[isEZ̒j
     * @param pos_info s~bhʒuiPOS_PYRAMID_***)
     */
    void setColliAAPyramid_WHD(int prm_index, coord x, coord y, coord z, coord prm_width, coord prm_height, coord prm_depth, pos_t pos_info) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        int hd = prm_depth  / 2;
        setColliAAPyramid(prm_index, x-hw, y-hh, z-hd, x+hw, y+hh, z+hd, pos_info);
    }

    /**
     * 蔻̈vfs̎OpOpƂĒ` .
     * OpOp̋Ê̕AAsŎwB
     * OpOp̋Ê̒SẂAActor[JW̌_ɐݒ肳B
     * (KΖʂActor[JW̌_ɐڂ邱ƂɂȂ)
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width OpOp̋Ê̕iX̒j
     * @param prm_height OpOp̋Ê̍iY̒j
     * @param prm_depth OpOp̋Ê̐[isEZ̒j
     * @param pos_info vYʒuiGgafDx::AAPrismActor  #define `Q)
     */
    void setColliAAPyramid_WHD(int prm_index, coord prm_width, coord prm_height, coord prm_depth, pos_t pos_info) {
        setColliAAPyramid_WHD(prm_index, 0, 0, 0, prm_width, prm_height, prm_depth, pos_info);
    }

    /**
     * 蔻̈vfsvY^ƂĒ` .
     * 蔻OpOp̋Ê̒SWƁAPӂ̒ŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻OpOp̋Ê̒SXWiActor[JWj
     * @param y 蔻OpOp̋Ê̒SYWiActor[JWj
     * @param z 蔻OpOp̋Ê̒SZWiActor[JWj
     * @param prm_edge 蔻OpOp̋Ê̂Pӂ̒
     * @param rot_x 蔻̎OpOpAActořɔActor[JX𒆐Sɉ]sړsꍇ true
     * @param rot_y 蔻̎OpOpAActořɔActor[JY𒆐Sɉ]sړsꍇ true
     * @param rot_z 蔻̎OpOpAActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     * @param pos_info s~bhʒuiGgafDx::AAPyramidActor  #define `Q)
     */
    void setColliAAPyramid_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, pos_t pos_info, bool rot_x, bool rot_y, bool rot_z) {
        int h = prm_edge / 2;
        setColliAAPyramid(prm_index, x-h, y-h, z-h, x+h, y+h, z+h, pos_info, rot_x, rot_y, rot_z);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻OpOp̋Ê̒SWƁAPӂ̒ŎwB
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻OpOp̋Ê̒SXWiActor[JWj
     * @param y 蔻OpOp̋Ê̒SYWiActor[JWj
     * @param z 蔻OpOp̋Ê̒SZWiActor[JWj
     * @param prm_edge 蔻OpOp̋Ê̂Pӂ̒
     * @param pos_info s~bhʒuiGgafDx::AAPyramidActor  #define `Q)
     */
    void setColliAAPyramid_Cube(int prm_index, coord x, coord y, coord z, coord prm_edge, pos_t pos_info) {
        setColliAAPyramid_Cube(prm_index, x, y, z, prm_edge, pos_info, false, false, false);
    }

    /**
     * 蔻̈vfŝƂĒ` .
     * 蔻OpOp̋Ê̂Pӂ̒ŎwB
     * 蔻OpOp̋Ê̒SẂAActor[JW̌_ɐݒ肳B
     * (KΖʂActor[JW̌_ɐڂ邱ƂɂȂ)
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge OpOp^̋Ê̂Pӂ̒
     * @param pos_info s~bhʒuiGgafDx::AAPyramidActor.h ́AߑRgQ)
     */
    void setColliAAPyramid_Cube(int prm_index, coord prm_edge, pos_t pos_info) {
        setColliAAPyramid_Cube(prm_index, 0, 0, 0, prm_edge, pos_info);
    }


    void moveColliAABoxPos(int prm_index, coord cx, coord cy, coord cz);

/////////////////////////////////////////////////////////

    /**
     * 蔻̈vf~ƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻̉~̒SXWiActor[JWj
     * @param y 蔻̉~̒SYWiActor[JWj
     * @param r 蔻̉~̔a
     * @param rot_z 蔻̉~AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliCircle(int prm_index, coord x, coord y, coord r, bool rot_z=false) {
        setColliSphere(prm_index, x, y, 0, r, false, false, rot_z);
    }

    /**
     * 蔻̈vf~ƂĒ` .
     * 蔻̉~̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param r 蔻̉~̔a
     */
    void set2DColliCircle(int prm_index, coord r) {
        set2DColliCircle(prm_index, 0, 0, r, false);
    }

    /**
     * 蔻̈vfs`ƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼̂̍XWiActor[JWj
     * @param y1 蔻蒼̂̍YWiActor[JWj
     * @param x2 蔻蒼̂̉EXWiActor[JWj
     * @param y2 蔻蒼̂̉EYWiActor[JWj
     * @param rot_z 蔻̒̂AActořɔActor[J_𒆐Sɉ]sړsꍇ true
     */
    void set2DColliRectangle(int prm_index,
                             coord x1, coord y1,
                             coord x2, coord y2,
                             bool rot_z = false) {
        setColliAABox(prm_index,
                      x1, y1, 0,
                      x2, y2, 0,
                      false, false, rot_z);
    }

    /**
     * 蔻̈vfs`ƂĒ` .
     * 蔻萳`̒SWƁAPӂ̒ŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻萳`̒SXWiActor[JWj
     * @param y 蔻萳`̒SYWiActor[JWj
     * @param prm_edge 蔻萳`̂Pӂ̒
     * @param rot_z 蔻̐`AActořɔActor[J_𒆐Sɉ]sړsꍇ true
     */
    void set2DColliSquare(int prm_index, coord x, coord y, coord prm_edge, bool rot_z = false) {
        coord h = prm_edge / 2;
        set2DColliRectangle(prm_index, x-h, y-h, x+h, y+h, rot_z);
    }

    /**
     * 蔻̈vfs`ƂĒ` .
     * 蔻萳`̂Pӂ̒ŎwB
     * 蔻萳`̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_edge 蔻萳`̂Pӂ̒
     */
    void set2DColliSquare(int prm_index, coord prm_edge) {
        set2DColliSquare(prm_index, 0, 0, prm_edge, false);
    }

    /**
     * 蔻̈vfs`Ē` .
     * 蔻蒷`̒SWƁAAŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻蒷`̒SXWiActor[JWj
     * @param y 蔻蒷`̒SYWiActor[JWj
     * @param prm_width 蔻蒷`̕iX̒j
     * @param prm_height 蔻蒷`̍iY̒j
     * @param rot_z 蔻̒`AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliRectangle_WH(int prm_index, coord x, coord y, coord prm_width, coord prm_height, bool rot_z = false) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        set2DColliRectangle(prm_index, x-hw, y-hh, x+hw, y+hh, rot_z);
    }

    /**
     * 蔻̈vfs`ƂĒ` .
     * 蔻蒷`̕AAsŎwB
     * 蔻蒷`̒SẂAActor[JW̌_ɐݒ肳B
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param prm_width 蔻蒷`̕iX̒j
     * @param prm_height 蔻蒷`̍iY̒j
     */
    void set2DColliRectangle_WH(int prm_index, coord prm_width, coord prm_height) {
        set2DColliRectangle_WH(prm_index, 0, 0, prm_width, prm_height);
    }

    /**
     * 蔻̈vfspOp`ƂĒ` .
     * @param prm_index 蔻̗̈vfԍ
     * @param x1 蔻蒼pOp`̋E`̍XWiActor[JWj
     * @param y1 蔻蒼pOp`̋E`̍YWiActor[JWj
     * @param x2 蔻蒼pOp`̋E`̉EXWiActor[JWj
     * @param y2 蔻蒼pOp`̋E`̉EYWiActor[JWj
     * @param pos_info pʒuiPOS_R_TRIANGLE_**)
     * @param rot_z 蔻̒pOp`AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliRightTriangle(int prm_index, coord x1, coord y1, coord x2, coord y2, pos_t pos_info, bool rot_z=false) {
        setColliAAPrism(prm_index, x1, y1, 0, x2, y2, 0, pos_info, false, false, rot_z);
    }

    /**
     * 蔻̈vfspOp`ƂĒ` .
     * 蔻蒼pOp`̋E`̒SWƁAAAsŎwB
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻蒼pOp`̋E`̒SXWiActor[JWj
     * @param y 蔻蒼pOp`̋E`̒SYWiActor[JWj
     * @param prm_width 蔻蒼pOp`̋E`̕iX̒j
     * @param prm_height 蔻蒼pOp`̋E`̍iY̒j
     * @param pos_info pʒuiPOS_R_TRIANGLE_**)
     * @param rot_z 蔻̒pOp`AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliRightTriangle_WH(int prm_index, coord x, coord y, coord prm_width, coord prm_height, pos_t pos_info, bool rot_z=false) {
        int hw = prm_width  / 2;
        int hh = prm_height / 2;
        set2DColliRightTriangle(prm_index, x-hw, y-hh, x+hw, y+hh, pos_info, rot_z);
    }

    /**
     * 蔻̈vfsp񓙕ӎOp`ƂĒ` .
     * 蔻蒼pOp`̋E`̒SWƁAPӂ̒Ŏw
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻蒼pOp`̋E`̒SXWiActor[JWj
     * @param y 蔻蒼pOp`̋E`̒SYWiActor[JWj
     * @param prm_width 蔻蒼pOp`̋E`̂Pӂ̒iΕӂł͂܂j
     * @param pos_info pʒuiPOS_R_TRIANGLE_**)
     * @param rot_z 蔻̒pOp`AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliIsoRightTriangle(int prm_index, coord x, coord y, coord prm_edge, pos_t pos_info, bool rot_z=false) {
        int h = prm_edge / 2;
        set2DColliRightTriangle(prm_index, x-h, y-h, x+h, y+h, pos_info, rot_z);
    }

    /**
     * 蔻̈vfsp񓙕ӎOp`ƂĒ` .
     * 蔻蒼pOp`̋E`̒SWƁAPӂ̒ŎwB
     * 蔻蒼pOp`̋E`̒SẂAActor[JW̌_ɐݒ肳B
     * (KΕӂActor[JW̌_ɐڂ邱ƂɂȂ)
     * Actořɔē蔻̉]sړ@\͖B
     * @param prm_index 蔻̗̈vfԍ
     * @param x 蔻蒼pOp`̋E`̒SXWiActor[JWj
     * @param y 蔻蒼pOp`̋E`̒SYWiActor[JWj
     * @param prm_width 蔻蒼pOp`̋E`̂Pӂ̒iΕӂł͂܂j
     * @param pos_info pʒuiPOS_R_TRIANGLE_**)
     * @param rot_z 蔻̒pOp`AActořɔActor[JZ𒆐Sɉ]sړsꍇ true
     */
    void set2DColliIsoRightTriangle(int prm_index, coord prm_edge, pos_t pos_info) {
        set2DColliIsoRightTriangle(prm_index, 0, 0, prm_edge, pos_info, false);
    }

    GgafDx::CollisionPart* getLastHitCollisionPart();

    static void drawHitArea(CollisionChecker* prm_pColliChecker);
    static void releaseHitArea();

    virtual ~CollisionChecker();
};

}
#endif /*GGAF_LIB_COLLISIONCHECKER_H_*/

