#ifndef GGAF_LIB_WALLSCENE_H_
#define GGAF_LIB_WALLSCENE_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/lib/scene/DefaultScene.h"

#include "jp/ggaf/core/util/LinkedListRing.hpp"
#include "jp/ggaf/lib/scene/WallSectionScene.h"

namespace GgafLib {

/**
 * XXN[̕ǃubNV[ .
 *  WallScene ́A WallSectionScene q킹̂łB
 * @version 1.00
 * @since 2010/11/05
 * @author Masatoshi Tsuge
 */
class WallScene : public DefaultScene {

public:
    /** ZNVV[̕ێXg */
    GgafCore::LinkedListRing<GgafLib::WallSectionScene> _ringHoldSection;
    /** ZNVV[̕ێXg */
    GgafCore::LinkedListRing<GgafLib::WallSectionScene> _ringLoopEndSection;
    /** ǃubNf|Wg(buildWallScene()Őݒ肳) */
    GgafCore::ActorDepository* _pDepo_wall;
    WallSectionScene* _pLastSectionScene;
    bool _is_all_active_section_scenes;
    bool _is_finished;

public:
    /**
     * RXgN^
     * @param prm_name
     * @return
     */
    WallScene(const char* prm_name, GgafCore::SceneMediator* prm_pSceneMediator = nullptr);

    /**
     * XXN[ WallScene ݒ肷B
     * {NX new  initialize() ܂łɁAKPsKv܂B
     * yӁz
     * prm_pDepo_wallox y prm_pDepo_prism ͏Ŗ{V[initialize() 
     * zɋړ܂BāA}l[WǗ̋ʃf|Wg̏ꍇ́A
     * }l[W̕s|C^̌ɂȂ܂B
     * @param prm_wall_dep      ǃubNPX̕
     * @param prm_wall_width    ǃubNPZ̕
     * @param prm_wall_height   ǃubNPY̕
     * @param prm_wall_start_x  OǏoXWʒu
     * @param prm_papSection    ZNVV[zւ̃|C^
     * @param prm_section_num   ZNVV[
     * @param prm_pDepo_wallox  ǃubN(WallAABActor)f|Wgiinitialize()Azɋړj
     */
    void buildWallScene(
            coord prm_wall_dep, coord prm_wall_width, coord prm_wall_height,
            coord prm_wall_start_x,
            WallSectionScene** prm_papSection, int prm_section_num,
            GgafCore::ActorDepository* prm_pDepo_wallox);

    /**
     * ς݁BʂŃI[o[Chꍇ́Ainitialize()ĂяoĉB
     */
    virtual void initialize() override;

    /**
     * ς݁BʂŃI[o[Chꍇ́AonActive()ĂяoĉB
     */
    virtual void onActive() override;

    /**
     * Ō̃ZNVV[̍Ō̕ǃubN񊈓ɖꍇA
     * R[obNB
     * sayonara() ȂǂĉB
     */
    virtual void onFinishedAllSection() = 0;

    /**
     * ς݁BʂŃI[o[Chꍇ́AprocessBehavior()ĂяoĉB
     */
    virtual void processBehavior() override;

    virtual void processFinal() override;

    /**
     * X̕̕ɃXN[֐ .
     * @param pThat AN^[
     * @param p1 XN[Xs[h(_feature_p1ւ̃|C^)
     * @param p2 nullptr
     * @param p3 nullptr
     */
    static void scrollX(GgafCore::Object* pThat, void* p1, void* p2, void* p3);


    virtual ~WallScene();
};

}
#endif /*GGAF_LIB_WALLSCENE_H_*/
