#ifndef GGAF_LIB_STRAIGHTLASERCHIP_H_
#define GGAF_LIB_STRAIGHTLASERCHIP_H_
#include "GgafLibCommonHeader.h"
#include "jp/ggaf/lib/actor/laserchip/LaserChip.h"

namespace GgafLib {

/**
 * Xg[g[U[p|C̃`bv .
 * Xg[g[U[Ȃǂƕ\Ă邪Amɂ<BR>
 * EˍWCӁAˌWړƁAɂƂȂĕsړiƂ\j<BR>
 * E˕CӁAˌ̊pxωƁAɂƂȂĔˌ𒆐Sɉ]ړiƂ\j<BR>
 * Eړ@͊{Œi<BR>
 * EAS`bvˌIuWFNgWƌ̍ZBƂB<BR>
 * ƌׂAOfBEXC_[\ȃ[U[ƌׂAȊB<BR>
 * o[ _velo_mv ňړ܂Bdispatch() AWƕy _velo_mv ݒ肵ĉB<BR>
 * ˌƘAēꍇ setSource() ݒ肵ĉB̏ꍇAWƕ͎ݒ肳܂B
 * @version 1.00
 * @since 2009/08/25
 * @author Masatoshi Tsuge
 */
class StraightLaserChip : public LaserChip {
    friend class LaserChipDepository;

private:
    int _tmp_source_x;
    int _tmp_source_y;
    int _tmp_source_z;
    angle _tmp_source_rx;
    angle _tmp_source_ry;
    angle _tmp_source_rz;
    /** [r/w]ړx */
    velo _velo_mv;
    dxcoord _view_bound;
public:
    /** [U[̈ʒu𓯊邽߂́AXWϐꏊ */
    int* _pSource_x;
    /** [U[̈ʒu𓯊邽߂́AYWϐꏊ */
    int* _pSource_y;
    /** [U[̈ʒu𓯊邽߂́AZWϐꏊ */
    int* _pSource_z;
    /** [U[̌̂𓯊邽߂́AX]AOlϐꏊ */
    angle* _pSource_rx;
    /** [U[̌̂𓯊邽߂́AY]AOlϐꏊ */
    angle* _pSource_ry;
    /** [U[̌̂𓯊邽߂́AZ]AOlϐꏊ */
    angle* _pSource_rz;

    GgafDx::GeometricActor* _pSourceActor;

public:
    StraightLaserChip(const char* prm_name, const char* prm_model);

    virtual void onCreateModel() override {}

    virtual void initialize() override {}

    virtual void processBehavior() override;

    virtual void processJudgement() override {}

    virtual void onCatchEvent(hashval prm_no, void* prm_pSource) override {}

    /**
     * ˌ̈ړƉ]ɂāAƂ锭˃AN^[ݒ .
     * @param prm_pGeoActor ˌAN^[
     */
    void setSource(GgafDx::GeometricActor* prm_pGeoActor) {
        _pSource_x = &prm_pGeoActor->_x;
        _pSource_y = &prm_pGeoActor->_y;
        _pSource_z = &prm_pGeoActor->_z;
        _pSource_rx = &prm_pGeoActor->_rx;
        _pSource_ry = &prm_pGeoActor->_ry;
        _pSource_rz = &prm_pGeoActor->_rz;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̈ړ݂̂ɂāAƂ锭˃AN^[ݒ .
     * ǂĂĂɔˁB
     * @param prm_pGeoActor ˌAN^[
     */
    void setPositionSource(GgafDx::GeometricActor* prm_pGeoActor) {
        _pSource_x = &prm_pGeoActor->_x;
        _pSource_y = &prm_pGeoActor->_y;
        _pSource_z = &prm_pGeoActor->_z;
        _pSourceActor = prm_pGeoActor;
    }

    /**
     * ˌ̉]݂̂ɂāAƂ锭˃AN^[ݒ .
     * {˂ȂǂɎgp邩ȁEEEB
     * @param prm_pGeoActor ˌAN^[
     */
    void setAngleSource(GgafDx::GeometricActor* prm_pGeoActor) {
        _pSource_rx = &prm_pGeoActor->_rx;
        _pSource_ry = &prm_pGeoActor->_ry;
        _pSource_rz = &prm_pGeoActor->_rz;
        _pSourceActor = prm_pGeoActor;
    }
    virtual int isOutOfView() override;
    void setMvVelo(coord prm_velo);
    coord getMvVelo() {
        return _velo_mv;
    }
    virtual ~StraightLaserChip();
};

}
#endif /*GGAF_LIB_STRAIGHTLASERCHIP_H_*/

