#ifndef GGAF_LIB_PIEGRAPHSPRITEACTOR_H_
#define GGAF_LIB_PIEGRAPHSPRITEACTOR_H_
#include "jp/ggaf/lib/actor/DefaultRegularPolygonSpriteActor.h"
#include "jp/ggaf/lib/util/Quantity.hpp"

namespace GgafLib {


/**
 * ʉ~Ot .
 * @version 1.00
 * @since 2013/09/17
 * @author Masatoshi Tsuge
 */
class PieGraphSpriteActor : public DefaultRegularPolygonSpriteActor {

protected:
    /** [r]RXgN^PxQuantity newꍇ true */
    bool _is_new_Quantity;

public:
    /** [r]ʉ~Otel<ۂ̐, t@̐> */
    Quantity<int, int>* _pFanQty;
    /** [r]ʉ~Otől */
    int _min_val;
    /** [r]ʉ~Otŏl */
    int _max_val;

public:
    /**
     *
     * @param prm_name
     * @param prm_pFanQty configς݂ PxQuantityIuWFNg̎Q
     */
    PieGraphSpriteActor(const char* prm_name, const char* prm_model, Quantity<int, int>* prm_pFanQty);

    PieGraphSpriteActor(const char* prm_name, const char* prm_model);

    /**
     * ̉~Ot̒lێ Quantity u .
     * @param prm_pFanQty
     */
    void linkQty(Quantity<int, int>* prm_pFanQty);

    /**
     * ̉~Ot̒lێ Quantity ̎QƕϐύX .
     * @param prm_pVariable
     */
    void linkVariable(int* prm_pVariable);

    /**
     * ~Ot̒lɑ΂sNZ̖ڐtB
     * @param prm_min_val ~Otl̍ŏlݒiȉ̒l̓ZbgłȂȂj
     * @param prm_max_val ~Otl̍őlݒiȏ̒l̓ZbgłȂȂj
     * @param prm_min_fan_num prm_min_valɑΉFAN̐
     * @param prm_max_fan_num prm_max_valɑΉFAN̐
     */
    inline void scale(int prm_min_val, int prm_max_val, int prm_min_fan_num, int prm_max_fan_num) {
        _min_val = prm_min_val;
        _max_val = prm_max_val;
        _pFanQty->scale(prm_min_val, prm_max_val, prm_min_fan_num, prm_max_fan_num);
    }

    /**
     * ~Ot̒lݒ .
     * linkĂꍇAN̕ϐ̒lύX̂Œ .
     * @param prm_val ~Ot̒l
     */
    inline void setVal(int prm_val) {
        if (_max_val < prm_val) {
            _pFanQty->setVal(_max_val);
        } else if (_min_val > prm_val) {
            _pFanQty->setVal(_min_val);
        } else {
            _pFanQty->setVal(prm_val);
        }
    }

    /**
     * ~Ot̒l擾 .
     * @return ~Ot̒l
     */
    inline int getVal() {
        return _pFanQty->getVal();
    }

    /**
     * ~OťݒlɑΉFAN̖擾
     * @return FAN̖
     */
    inline int getFanNum() {
        return _pFanQty->getQty();
    }

    /**
     * ~Ot̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val ~Ot̉Zl
     */
    inline void incVal(int prm_val) {
        setVal(_pFanQty->getVal() + prm_val);
    }

    /**
     * ~Ot̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val ~OťZl
     */
    inline void decVal(int prm_val) {
        setVal(_pFanQty->getVal() - prm_val);
    }

    void processDraw() override;

    virtual ~PieGraphSpriteActor();
};

}
#endif /*GGAF_LIB_PIEGRAPHSPRITEACTOR_H_*/

