#ifndef GGAF_LIB_GRAPHBARACTOR_H_
#define GGAF_LIB_GRAPHBARACTOR_H_
#include "jp/ggaf/lib/actor/DefaultBoardActor.h"
#include "jp/ggaf/lib/util/Quantity.hpp"

namespace GgafLib {


/**
 * ʃo[iP`j .
 * @version 1.00
 * @since 2013/09/17
 * @author Masatoshi Tsuge
 */
class GraphBarActor : public DefaultBoardActor {

protected:
    /** [r]RXgN^PxQuantity newꍇ true */
    bool _is_new_Quantity;
    /** [r]f`bvsNZ */
    const float _chip_width;
    /** [r] 1.0 / _chip_width ̒lBvZp */
    const float _rate_org_chip_width;
    /** [r]ʃo[el */
    Quantity<int, coord>* _pQty;
    /** [r]ʃo[ől */
    int _min_val;
    /** [r]ʃo[ŏl */
    int _max_val;

public:
    /**
     *
     * @param prm_name
     * @param prm_pQty configς݂ PxQuantityIuWFNg̎Q
     */
    GraphBarActor(const char* prm_name, const char* prm_model, Quantity<int, coord>* prm_pQty);

    GraphBarActor(const char* prm_name, const char* prm_model);

    /**
     * ̃o[̒lێ Quantity u .
     * @param prm_pQty
     */
    void linkQty(Quantity<int, coord>* prm_pQty) {
        if (_pQty) {
            if (_is_new_Quantity) {
                GGAF_DELETE(_pQty);
            }
        }
        _pQty = prm_pQty;
        _is_new_Quantity = false;
    }

    /**
     * ̃o[̒lێ Quantity ̎QƕϐύX .
     * @param prm_pVariable
     */
    void linkVariable(int* prm_pVariable) {
        _pQty->link(prm_pVariable);
    }
    /**
     * o[̒lɑ΂sNZ̖ڐtB
     * @param prm_min_val o[ŏlݒiȉ̒l̓ZbgłȂȂj
     * @param prm_max_val o[őlݒiȏ̒l̓ZbgłȂȂj
     * @param prm_coord_width ŏl`ől̉ʏ̃sNZݒ
     */
    inline void scale(int prm_min_val, int prm_max_val, coord prm_coord_width ) {
        _min_val = prm_min_val;
        _max_val = prm_max_val;
        _pQty->scale(prm_max_val - prm_min_val, prm_coord_width);
    }

    /**
     * o[̒lݒ .
     * linkĂꍇAN̒lύX .
     * @param prm_val [^[l
     */
    inline void setVal(int prm_val) {
        if (_max_val < prm_val) {
            _pQty->setVal(_max_val);
        } else if (_min_val > prm_val) {
            _pQty->setVal(_min_val);
        } else {
            _pQty->setVal(prm_val);
        }
    }

    /**
     * o[̒l擾 .
     * @return o[̒l
     */
    inline int getVal() {
        return _pQty->getVal();
    }

    /**
     * o[̌ݒlɑΉsNZl擾
     * @return sNZl
     */
    inline coord getCoordWidth() {
        return _pQty->getQty();
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̉Zl
     */
    inline void incVal(int prm_val) {
        setVal(_pQty->getVal() + prm_val);
    }

    /**
     * o[̒lZ .
     * linkĂꍇAN̒lύX̂ŒӁB
     * @param prm_val o[̌Zl
     */
    inline void decVal(int prm_val) {
        setVal(_pQty->getVal() - prm_val);
    }

    /**
     * o[̒lɑΉsNZlvZĎ擾iݒ͂Ȃj .
     * @param prm_val ̃o[̒l
     * @return ̃o[̒lɑΉsNZl
     */
    inline coord cnvVal2CoordWidth(int prm_val) {
        return _pQty->cnvVal2Qty(prm_val);
    }

    inline int cnvCoordWidth2Val(coord prm_coord_width) {
        return _pQty->cnvQty2Val(prm_coord_width);
    }

    inline void setValByCoordWidth(coord prm_coord_width) {
        setVal(cnvCoordWidth2Val(prm_coord_width));
    }

    void processDraw() override;

    virtual ~GraphBarActor();
};

}
#endif /*GGAF_LIB_GRAPHBARACTOR_H_*/

