#include "jp/ggaf/dx/util/SkinAniMeshWorldMatStack.h"
#include "jp/ggaf/dx/util/SkinAniMeshAllocHierarchy.h"
#include "jp/ggaf/dx/util/SkinAniMeshFrame.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
using namespace GgafDx;

SkinAniMeshWorldMatStack::SkinAniMeshWorldMatStack() : GgafCore::Object() {
//    _pModel_MapBoneFrameIndex_ActAnimationSetIndexList = nullptr;
    _papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act = nullptr;
    _as0_index = -1;
    _as1_index = -1;
    _prevTransformationMatrixList.clear();
}

SkinAniMeshWorldMatStack::~SkinAniMeshWorldMatStack(void) {
}

void SkinAniMeshWorldMatStack::registerFrameTransformationMatrix(SkinAniMeshFrame* pFrame) {
    _prevTransformationMatrixList.push_back(pFrame->TransformationMatrix);
    if (pFrame->pFrameFirstChild) {
        // qt[L
        registerFrameTransformationMatrix((SkinAniMeshFrame*)pFrame->pFrameFirstChild);
    }
    if (pFrame->pFrameSibling) {
        //Zt[L
        registerFrameTransformationMatrix((SkinAniMeshFrame*)pFrame->pFrameSibling);
    }
}
// [hϊs̐ݒ
void SkinAniMeshWorldMatStack::SetWorldMatrix(D3DXMATRIX* worldmat) {
    _actor_world_trans_matrix = *worldmat;
}

void SkinAniMeshWorldMatStack::UpdateFrame(SkinAniMeshFrame* prm_frame_root, int prm_as0_index, int prm_as1_index, bool** prm_papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act) {
#ifdef MY_DEBUG
    if (_prevTransformationMatrixList.size() == 0) {
        throwCriticalException("SkinAniMeshWorldMatStack::UpdateFrame() sOregisterFrameTransformationMatrix() Ńt[o^ĉB");
    }
#endif
    // X^bN̏
    while (!_stack_matrix.empty()) {
        _stack_matrix.pop();
    }

    // [hϊsX^bNɐς
    _stack_matrix.push(&_actor_world_trans_matrix);
    _as0_index = prm_as0_index;
    _as1_index = prm_as1_index;
    _papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act = prm_papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act;
    // [gt[烏[hϊsAvZ
    if (_papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act) {
        CalcSkinAniMeshFrame(prm_frame_root);
    } else {
        m_DrawFrameList.clear();  //폜\
        CalcSkinAniMeshFrame_old(prm_frame_root);  //폜\
    }
}

void SkinAniMeshWorldMatStack::CalcSkinAniMeshFrame_old(SkinAniMeshFrame* prm_pBoneFrame) {
     //폜\
    // ݂̃X^bN̐擪ɂ郏[hϊsQ
    D3DXMATRIX *pStackMat = _stack_matrix.top();

    D3DXMatrixMultiply(&(prm_pBoneFrame->_world_trans_matrix), &(prm_pBoneFrame->TransformationMatrix), pStackMat);

    if (prm_pBoneFrame->pMeshContainer) {
        //bVReiL
        m_DrawFrameList.push_back(prm_pBoneFrame);
    }

    // qt[΃X^bNςŁAqt[̃[hϊW̌vZ
    if (prm_pBoneFrame->pFrameFirstChild) {
        _stack_matrix.push(&(prm_pBoneFrame->_world_trans_matrix));
        CalcSkinAniMeshFrame_old((SkinAniMeshFrame*)prm_pBoneFrame->pFrameFirstChild);
        _stack_matrix.pop(); // qt[ÎŃX^bN1O
    }

    // Zt[΁ú݂vX^bN𗘗p
    if (prm_pBoneFrame->pFrameSibling) {
        //_TRACE_("Zt[ւ܂");
        CalcSkinAniMeshFrame_old((SkinAniMeshFrame*)prm_pBoneFrame->pFrameSibling);
    }
}

void SkinAniMeshWorldMatStack::CalcSkinAniMeshFrame(SkinAniMeshFrame* prm_pBoneFrame) {
    // ݂̃X^bN̐擪ɂ郏[hϊsQ
    D3DXMATRIX *pStackMat = _stack_matrix.top();

    //̃t[(frame_world)AAj[VΏۂȂ̂
    bool is_target_frame = false;
    LPSTR born_frame_name = prm_pBoneFrame->Name;
    if (born_frame_name) {
        if (_as0_index >= 0 && _papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act[_as0_index][prm_pBoneFrame->_frame_index]) {
            is_target_frame = true; //̃t[́AgbN0̃Aj[VZbg̃Aj[VΏۂł
        } else if (_as1_index >= 0 && _papaBool_Model_AnimationSetIndex_BoneFrameIndex_is_act[_as1_index][prm_pBoneFrame->_frame_index]) {
            is_target_frame = true; //̃t[́AgbN1̃Aj[VZbg̃Aj[VΏۂł
        }
    }

    if (is_target_frame) {
        //Aj[VΏۂ̃t[łꍇA
        //Aj[VRg[[ pAc->AdvanceTime(0, nullptr) ɂ胂f̃t[ TransformationMatrix XVĂ̂ŁA
        //(prm_pBoneFrame->TransformationMatrix) gpă[hϊ
        D3DXMatrixMultiply(&(prm_pBoneFrame->_world_trans_matrix), &(prm_pBoneFrame->TransformationMatrix), pStackMat);
        D3DXMatrixMultiply(&(prm_pBoneFrame->_combined_matrix), &(prm_pBoneFrame->_bone_offset_matrix), &(prm_pBoneFrame->_world_trans_matrix));
        //TransformationMatrix ۑ
        _prevTransformationMatrixList[prm_pBoneFrame->_frame_index]  = prm_pBoneFrame->TransformationMatrix;


    } else {
        //Aj[VΏۂ̃t[łȂ
        //Aj[VRg[[ pAc->AdvanceTime(0, nullptr) łAf̃t[ TransformationMatrix eȂ̂ŁA
        //ȑỎ̃Aj[V̍s񂪎cĂ܂ĂBĂ(prm_pBoneFrame->TransformationMatrix) ͎gpȂB
        //Oۑ TransformationMatrix gpă[hϊB܂肱̃{[͑Oƕς炸~ԁB
        D3DXMATRIX* pMatrix = &(_prevTransformationMatrixList[prm_pBoneFrame->_frame_index]); //Oۑς݂TransformationMatrix
        D3DXMatrixMultiply(&(prm_pBoneFrame->_world_trans_matrix), pMatrix, pStackMat);
        D3DXMatrixMultiply(&(prm_pBoneFrame->_combined_matrix), &(prm_pBoneFrame->_bone_offset_matrix), &(prm_pBoneFrame->_world_trans_matrix));

    }

    // qt[΃X^bNςŁAqt[̃[hϊW̌vZ
    if (prm_pBoneFrame->pFrameFirstChild) {
        _stack_matrix.push(&(prm_pBoneFrame->_world_trans_matrix));
        CalcSkinAniMeshFrame((SkinAniMeshFrame*)prm_pBoneFrame->pFrameFirstChild);
        _stack_matrix.pop(); // qt[ÎŃX^bN1O
    }

    // Zt[΁ú݂vX^bN𗘗p
    if (prm_pBoneFrame->pFrameSibling) {
        CalcSkinAniMeshFrame((SkinAniMeshFrame*)prm_pBoneFrame->pFrameSibling);
    }
}

