#include "jp/ggaf/dx/model/D3DXAniMeshModel.h"

#include "jp/ggaf/dx/God.h"
#include "jp/ggaf/dx/Config.h"
#include "jp/ggaf/dx/actor/D3DXAniMeshActor.h"
#include "jp/ggaf/dx/actor/supporter/Puppeteer_old.h"
#include "jp/ggaf/dx/effect/D3DXAniMeshEffect.h"
#include "jp/ggaf/dx/effect/MeshEffect.h"
#include "jp/ggaf/dx/exception/CriticalException.h"
#include "jp/ggaf/dx/manager/EffectManager.h"
#include "jp/ggaf/dx/manager/ModelManager.h"
#include "jp/ggaf/dx/manager/TextureConnection.h"
#include "jp/ggaf/dx/manager/TextureManager.h"
#include "jp/ggaf/dx/model/MassModel.h"
#include "jp/ggaf/dx/texture/Texture.h"
#include "jp/ggaf/dx/util/BoneAniMeshAllocHierarchy.h"
#include "jp/ggaf/dx/util/BoneAniMeshFrame.h"

using namespace GgafDx;

D3DXAniMeshModel::D3DXAniMeshModel(const char* prm_model_name) : Model(prm_model_name) {
    _pAllocHierarchy = nullptr;
    _pFrameRoot = nullptr;
    _pAniControllerBase = nullptr;
    _num_materials = 0L;
    _anim_ticks_per_second = 4800; //restoreD3DXAniMeshModel ŏ㏑ꍇB

    _obj_model |= Obj_GgafDx_D3DXAniMeshModel;
}

HRESULT D3DXAniMeshModel::draw(FigureActor* prm_pActor_target, int prm_draw_set_num, void* prm_pPrm) {
    _TRACE4_("D3DXAniMeshModel::draw("<<prm_pActor_target->getName()<<")");
    HRESULT hr;
    //ΏۃAN^[
    D3DXAniMeshActor* pTargetActor = (D3DXAniMeshActor*)prm_pActor_target;
    //ΏMeshActor̃GtFNgbp
    D3DXAniMeshEffect* pD3DXAniMeshEffect = (D3DXAniMeshEffect*)(prm_pActor_target->getEffect());
    //ΏۃGtFNg
    ID3DXEffect* pID3DXEffect = pD3DXAniMeshEffect->_pID3DXEffect;
    Model* pModelLastDraw = ModelManager::_pModelLastDraw;
    if (pModelLastDraw != this) {
        if (pModelLastDraw && (pModelLastDraw->_obj_model & Obj_GgafDx_MassModel)) {
            ((MassModel*)pModelLastDraw)->resetStreamSourceFreq();
        }
        God::_pID3DDevice9->SetFVF(D3DXAniMeshActor::FVF);
        hr = pID3DXEffect->SetFloat(pD3DXAniMeshEffect->_h_tex_blink_power, _power_blink);
        checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_power) Ɏs܂B");
        hr = pID3DXEffect->SetFloat(pD3DXAniMeshEffect->_h_tex_blink_threshold, _blink_threshold);
        checkDxException(hr, D3D_OK, "SetFloat(_h_tex_blink_threshold) Ɏs܂B");
    }

    pTargetActor->_pPuppeteer->updateAnimationTrack(); //Aj[Vf
    //f̃[hϊsXV
    pTargetActor->_stackWorldMat.SetWorldMatrix(&(pTargetActor->_matWorld));
    pTargetActor->_stackWorldMat.UpdateFrame(_pFrameRoot);
    std::list< BoneAniMeshFrame* > *pDrawList = pTargetActor->_stackWorldMat.GetDrawList(); // `惊Xg擾
    std::list<BoneAniMeshFrame*>::iterator it = pDrawList->begin();

    IDirect3DDevice9* const pDevice = God::_pID3DDevice9;
    int n = 0;
    //}eAEeNX`̈ꔭڂZbgA
    LPDIRECT3DBASETEXTURE9 pTex = nullptr;
    LPDIRECT3DBASETEXTURE9 pLastTex = nullptr;
    if (_papTextureConnection[n]) {
        pLastTex = _papTextureConnection[n]->peek()->_pIDirect3DBaseTexture9;
        pDevice->SetTexture(0, pLastTex);
    } else {
        //΃eNX`
        pDevice->SetTexture(0, nullptr);
    }
    hr = pID3DXEffect->SetValue(pD3DXAniMeshEffect->_h_colMaterialDiffuse, &(pTargetActor->_paMaterial[n].Diffuse), sizeof(D3DCOLORVALUE) );
    checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");

    for (int i = 0; it != pDrawList->end(); i++, ++it) {
        //`(TODO:Ȃ񂩖ʂȃ[vj
        Effect* pEffect_active = EffectManager::_pEffect_active;
        if ((FigureActor::_hash_technique_last_draw != prm_pActor_target->_hash_technique) && i == 0) {
            if (pEffect_active) {
                _TRACE4_("["<<i<<"],EndPass: /_pEffect_active="<<pEffect_active->_effect_name);
                hr = pEffect_active->_pID3DXEffect->EndPass();
                checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshModel::draw() EndPass() Ɏs܂B");
                hr = pEffect_active->_pID3DXEffect->End();
                checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshModel::draw() End() Ɏs܂B");
#ifdef MY_DEBUG
                if (pEffect_active->_begin == false) {
                    throwCriticalException("begin Ă܂ "<<(pEffect_active==nullptr?"nullptr":pEffect_active->_effect_name)<<"");
                } else {
                    pEffect_active->_begin = false;
                }
#endif
            }
            _TRACE4_("SetTechnique("<<pTargetActor->_technique<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pD3DXAniMeshEffect->_effect_name);
            hr = pID3DXEffect->SetTechnique(pTargetActor->_technique);

            _TRACE4_("BeginPass("<<pID3DXEffect<<"): /actor="<<pTargetActor->getName()<<"/model="<<_model_name<<" effect="<<pD3DXAniMeshEffect->_effect_name<<"("<<pD3DXAniMeshEffect<<")");
            UINT numPass;
            hr = pID3DXEffect->Begin( &numPass, D3DXFX_DONOTSAVESTATE );
            checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshModel::draw() Begin() Ɏs܂B");
            hr = pID3DXEffect->BeginPass(0);
            checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshModel::draw() BeginPass(0) Ɏs܂B");

#ifdef MY_DEBUG
            if (pD3DXAniMeshEffect->_begin) {
                throwCriticalException("End Ă܂ "<<(EffectManager::_pEffect_active==nullptr?"nullptr":EffectManager::_pEffect_active->_effect_name)<<"");
            } else {
                pD3DXAniMeshEffect->_begin = true;
            }
#endif

        }
        hr = pID3DXEffect->SetMatrix(pD3DXAniMeshEffect->_h_matWorld, &((*it)->_world_trans_matrix));
        checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshActor::processDraw() SetMatrix(g_matWorld) Ɏs܂B");
        if ((*it)->pMeshContainer == nullptr) {
            _TRACE4_("["<<i<<"]~SetMatrix FrameName="<<((*it)->Name)<<" ΂I");
            continue;
        } else {
            for (int j = 0; j < (int)((*it)->pMeshContainer->NumMaterials); j++) {
                if (n > 0) {
                    pTex = _papTextureConnection[n]->peek()->_pIDirect3DBaseTexture9;
                    if (pTex != pLastTex) {
                        //eNX`قȂΐݒ
                        pDevice->SetTexture(0, pTex);
                        pLastTex = pTex;
                    }
                    hr = pID3DXEffect->SetValue(pD3DXAniMeshEffect->_h_colMaterialDiffuse, &(pTargetActor->_paMaterial[n].Diffuse), sizeof(D3DCOLORVALUE) );
                    checkDxException(hr, D3D_OK, "SetValue(g_colMaterialDiffuse) Ɏs܂B");
                }
                _TRACE4_("["<<i<<"]["<<j<<"],SetMaterial");
                hr = pID3DXEffect->CommitChanges();
                checkDxException(hr, D3D_OK, "["<<i<<"],D3DXAniMeshModel::draw() CommitChanges() Ɏs܂B");
                (*it)->pMeshContainer->MeshData.pMesh->DrawSubset(j);
                n++;
#ifdef MY_DEBUG
        GgafCore::God::_num_drawing++;
#endif
            }
        }
    }
    //O`惂ff
    ModelManager::_pModelLastDraw = this;
    EffectManager::_pEffect_active = pD3DXAniMeshEffect;
    FigureActor::_hash_technique_last_draw = prm_pActor_target->_hash_technique;
    return D3D_OK;
}

ID3DXAnimationController* D3DXAniMeshModel::getCloneAnimationController() {
    ID3DXAnimationController* _pAc = nullptr;
    HRESULT hr = _pAniControllerBase->CloneAnimationController(
                                _pAniControllerBase->GetMaxNumAnimationOutputs(),
                                _pAniControllerBase->GetMaxNumAnimationSets(),
                                _pAniControllerBase->GetMaxNumTracks(),
                                _pAniControllerBase->GetMaxNumEvents(),
                                        &_pAc);
    checkDxException(hr, D3D_OK, "Aj[VRg[[̃N[Ɏs܂B");
    return _pAc;
}


void D3DXAniMeshModel::restore() {
    _TRACE3_("_model_name=" << _model_name << " start");
    //TODO:쐬HIIIIIIII
    ModelManager* pModelManager = pGOD->_pModelManager;
    //yrestoreD3DXAniMeshModelč\zijTvz
    //1)D3DXLoadMeshFromXgpXt@Cǂݍ
    //2)D3DXAniMeshModel̃oɃZbg
    //Xt@C̃[hĕKvȓeD3DXAniMeshModeloɐݒ肵CX^XƂĊ
//    LPD3DXMESH pID3DXAniMesh; //bV(ID3DXAniMeshC^[tFCXւ̃|C^j
    D3DMATERIAL9* model_paMaterial = nullptr; //}eA(D3DXMATERIAL\̂̔z̐擪vfw|C^j
    TextureConnection** model_papTextureConnection = nullptr; //eNX`z(IDirect3DTexture9C^[tFCXւ̃|C^ێIuWFNgj
//    DWORD _num_materials;
    std::string xfile_name = ModelManager::getMeshFileName(_model_name);
    if (xfile_name == "") {
         throwCriticalException("bVt@C(*.x)܂Bmodel_name="<<(_model_name));
    }
    //AnimTicksPerSecond̒lƎɎo
    std::ifstream ifs(xfile_name.c_str());
    if (ifs.fail()) {
        throwCriticalException("["<<xfile_name<<"] J܂");
    }
    std::string buf;
    bool isdone = false;
    int anim_ticks_per_second = 4800;
    std::string data;
    while (isdone == false && !ifs.eof()) {
        ifs >> data;
        if (data == "AnimTicksPerSecond" || data == "AnimTicksPerSecond{") {
            while (isdone == false) {
                ifs >> data;
                if (data == "{") {
                    continue;
                } else if (data == "}") {
                    isdone = true;
                    break;
                } else {
                    anim_ticks_per_second = atoi(data.c_str()); //"60;"  60𓾂
                    isdone = true;
                    break;
                }
            }
        }
    }
    ifs.close();

//    LPD3DXBUFFER pID3DXBuffer; //󂯎pobt@i}eApj
    HRESULT hr;
    //Xt@C̃t@C[h
    BoneAniMeshAllocHierarchy* pAllocHierarchy = NEW BoneAniMeshAllocHierarchy(); // CAllocHierarchyBase̔hNX
    BoneAniMeshFrame* pFrameRoot; // [hϊstt[\
    ID3DXAnimationController* pAC; // Aj[VRg[
    hr = D3DXLoadMeshHierarchyFromX(
            xfile_name.c_str(),
            D3DXMESH_SYSTEMMEM, //D3DXMESH_MANAGED,
            God::_pID3DDevice9,
            pAllocHierarchy,
            nullptr,
            (D3DXFRAME**)(&pFrameRoot),
            &pAC
         );
    _TRACE_("pAllocHierarchy="<<pAllocHierarchy<<" pFrameRoot="<<pFrameRoot<<" pAC="<<pAC<<" xfile_name.c_str()="<<xfile_name.c_str());
    checkDxException(hr, D3D_OK, xfile_name<<" ǂݍ݂Ɏs܂BΏ="<<xfile_name);
    if (pFrameRoot == nullptr) {
        throwCriticalException(xfile_name<<" ̃t[񂪎擾ł܂I");
    }
    //}eAz쐬
    std::list<BoneAniMeshFrame*> listFrame;
    getDrawFrameList(&listFrame, pFrameRoot); //}eAm肽߁At[AXg
    std::list<BoneAniMeshFrame*>::iterator it = listFrame.begin();
    int model_nMaterials = 0;
    //t[XgāA}eA擾
    for (int i = 0; it != listFrame.end(); i++, ++it) {
        if ((*it)->pMeshContainer == nullptr) {
            continue;
        } else {
            model_nMaterials += (int)((*it)->pMeshContainer->NumMaterials);
        }
    }
    //z񐔂Ɖ̂ō쐬
    model_paMaterial = NEW D3DMATERIAL9[model_nMaterials];
    model_papTextureConnection  = NEW TextureConnection*[model_nMaterials];
    //fێp}eAAeNX`쐬̂߁Ax
    it = listFrame.begin();
    int n = 0;
    char* texture_filename;
    for (int i = 0; it != listFrame.end(); i++, ++it) {
        if ((*it)->pMeshContainer == nullptr) {
            continue;
        } else {
            for (int j = 0; j < (int)((*it)->pMeshContainer->NumMaterials); j++) {
//                (*it)->pMeshContainer->pMaterials[j].MatD3D.Diffuse
                model_paMaterial[n] = (*it)->pMeshContainer->pMaterials[j].MatD3D; //}eARs[

                texture_filename = (*it)->pMeshContainer->pMaterials[j].pTextureFilename;
                if (texture_filename != nullptr && lstrlen(texture_filename) > 0 ) {
                    model_papTextureConnection[n] = (TextureConnection*)(pModelManager->_pModelTextureManager->connect(texture_filename, this));
                } else {
                    //eNX`͐^ȃeNX`ɒu
                    model_papTextureConnection[n] = (TextureConnection*)(pModelManager->_pModelTextureManager->connect(CONFIG::WHITE_TEXTURE.c_str(), this));
                }
                n ++;
            }
        }
    }
    //E
    D3DXVECTOR3 vecCenter;
    FLOAT model_bounding_sphere_radius;
    D3DXFrameCalculateBoundingSphere(pFrameRoot, &vecCenter, &model_bounding_sphere_radius);
    //bVA}eAAeNX`̎QƁA}eAfIuWFNgɕێ

    _pAllocHierarchy = pAllocHierarchy;
    _pFrameRoot = pFrameRoot;
    _pAniControllerBase = pAC;
    _bounding_sphere_radius = model_bounding_sphere_radius;
    _TRACE_("Ea="<<model_bounding_sphere_radius);
//    _advance_time_per_frame0 =  advanceTimePerFrame0; //gbN0ԂP[v̎
//    _TRACE_("Aj[VZbg0_advance_time_per_frame");

//    _pID3DXAniMesh = pID3DXAniMesh;
    _paMaterial_default = model_paMaterial;
    _papTextureConnection = model_papTextureConnection;
    _num_materials = model_nMaterials;
    _anim_ticks_per_second = anim_ticks_per_second;
    _TRACE3_("_model_name=" << _model_name << " end");
}

void D3DXAniMeshModel::getDrawFrameList(std::list<BoneAniMeshFrame*>* pList, BoneAniMeshFrame* pFrame) {
    if (pFrame->pMeshContainer) {
        //bVReiL
        pList->push_back(pFrame); //Xgɒǉ
    }
    if (pFrame->pFrameFirstChild) {
        // qt[L
        getDrawFrameList(pList, (BoneAniMeshFrame*)pFrame->pFrameFirstChild);
    }
    if (pFrame->pFrameSibling) {
        //Zt[L
        getDrawFrameList(pList, (BoneAniMeshFrame*)pFrame->pFrameSibling);
    }
}


void D3DXAniMeshModel::onDeviceLost() {
    _TRACE3_("_model_name=" << _model_name << " start");
    //foCXXg͉܂B
    release();
    _TRACE3_("_model_name=" << _model_name << " end");
}

void D3DXAniMeshModel::release() {
    _TRACE3_("_model_name=" << _model_name << " start");
//    if (_pID3DXAniMesh == nullptr) {
//        throwCriticalException("Error! _pID3DXAniMesh IuWFNgɂȂĂȂ release ł܂I");
//    }
    if (_papTextureConnection) {
        for (int i = 0; i < (int)_num_materials; i++) {
            if (_papTextureConnection[i]) {
                _TRACE3_("close() _papTextureConnection["<<i<<"]->"<<(_papTextureConnection[i]->getIdStr()));
                _papTextureConnection[i]->close();
            }
        }
    }
    GGAF_DELETEARR(_papTextureConnection); //eNX`̔z
//    GGAF_RELEASE(_pID3DXAniMesh);

    //TODO:eNXoDELETÊ͂₫Ȃ
    GGAF_DELETEARR(_paMaterial_default);
    GGAF_DELETEARR_NULLABLE(_pa_texture_filenames);
    GGAF_RELEASE(_pAniControllerBase);
    _pAllocHierarchy->DestroyFrame((D3DXFRAME*)_pFrameRoot);
    GGAF_DELETE(_pAllocHierarchy);
    //TODO:́H
    _TRACE3_("_model_name=" << _model_name << " end");
}

D3DXAniMeshModel::~D3DXAniMeshModel() {
    //release();
    //ModelConnection::processReleaseResource(Model* prm_pResource) ŌĂяo
}
